# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsLambdaPermissionArgs', 'AwsLambdaPermission']

@pulumi.input_type
class AwsLambdaPermissionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 principal: pulumi.Input[str],
                 statement_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 event_source_token: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 source_account: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLambdaPermission resource.
        :param pulumi.Input[str] action: The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        :param pulumi.Input[str] function_name: Name of the Lambda function whose resource policy you are updating.
        :param pulumi.Input[str] principal: The principal who is getting this permission.
        :param pulumi.Input[str] statement_id: A unique statement identifier.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda permission will be created in.
        :param pulumi.Input[str] event_source_token: The Event Source Token to validate.
        :param pulumi.Input[str] qualifier: Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        :param pulumi.Input[str] source_account: This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        :param pulumi.Input[str] source_arn: When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "statement_id", statement_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if event_source_token is not None:
            pulumi.set(__self__, "event_source_token", event_source_token)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if source_account is not None:
            pulumi.set(__self__, "source_account", source_account)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        Name of the Lambda function whose resource policy you are updating.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        The principal who is getting this permission.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Input[str]:
        """
        A unique statement identifier.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "statement_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the lambda permission will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Event Source Token to validate.
        """
        return pulumi.get(self, "event_source_token")

    @event_source_token.setter
    def event_source_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source_token", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        """
        return pulumi.get(self, "source_account")

    @source_account.setter
    def source_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_account", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)


@pulumi.input_type
class _AwsLambdaPermissionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 event_source_token: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 source_account: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 statement_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLambdaPermission resources.
        :param pulumi.Input[str] action: The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        :param pulumi.Input[str] event_source_token: The Event Source Token to validate.
        :param pulumi.Input[str] function_name: Name of the Lambda function whose resource policy you are updating.
        :param pulumi.Input[str] principal: The principal who is getting this permission.
        :param pulumi.Input[str] qualifier: Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        :param pulumi.Input[str] source_account: This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        :param pulumi.Input[str] source_arn: When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        :param pulumi.Input[str] statement_id: A unique statement identifier.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda permission will be created in.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if event_source_token is not None:
            pulumi.set(__self__, "event_source_token", event_source_token)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if source_account is not None:
            pulumi.set(__self__, "source_account", source_account)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if statement_id is not None:
            pulumi.set(__self__, "statement_id", statement_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Event Source Token to validate.
        """
        return pulumi.get(self, "event_source_token")

    @event_source_token.setter
    def event_source_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source_token", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Lambda function whose resource policy you are updating.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[str]]:
        """
        The principal who is getting this permission.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        """
        return pulumi.get(self, "source_account")

    @source_account.setter
    def source_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_account", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique statement identifier.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the lambda permission will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsLambdaPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 event_source_token: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 source_account: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 statement_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLambdaPermission` manages an AWS lambda permissions in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id="mytenant",
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        permission = duplocloud.AwsLambdaPermission("permission",
            statement_id="AllowExecutionFromAPIGateway",
            action="lambda:InvokeFunction",
            function_name=myfunction.fullname,
            principal="apigateway.amazonaws.com",
            source_arn="arn:aws:execute-api:region:accountId:aws_api_gateway_rest_api.api.id/*/*/*",
            tenant_id="mytenant")
        ```

        ## Import

        Example: Importing an existing AWS lambda function permission

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

         - *STATEMENT_ID* is the statement ID of the permission

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaPermission:AwsLambdaPermission permission *TENANT_ID*/*SHORT_NAME*/*STATEMENT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        :param pulumi.Input[str] event_source_token: The Event Source Token to validate.
        :param pulumi.Input[str] function_name: Name of the Lambda function whose resource policy you are updating.
        :param pulumi.Input[str] principal: The principal who is getting this permission.
        :param pulumi.Input[str] qualifier: Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        :param pulumi.Input[str] source_account: This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        :param pulumi.Input[str] source_arn: When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        :param pulumi.Input[str] statement_id: A unique statement identifier.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda permission will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLambdaPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLambdaPermission` manages an AWS lambda permissions in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id="mytenant",
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        permission = duplocloud.AwsLambdaPermission("permission",
            statement_id="AllowExecutionFromAPIGateway",
            action="lambda:InvokeFunction",
            function_name=myfunction.fullname,
            principal="apigateway.amazonaws.com",
            source_arn="arn:aws:execute-api:region:accountId:aws_api_gateway_rest_api.api.id/*/*/*",
            tenant_id="mytenant")
        ```

        ## Import

        Example: Importing an existing AWS lambda function permission

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

         - *STATEMENT_ID* is the statement ID of the permission

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaPermission:AwsLambdaPermission permission *TENANT_ID*/*SHORT_NAME*/*STATEMENT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLambdaPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLambdaPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 event_source_token: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 source_account: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 statement_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLambdaPermissionArgs.__new__(AwsLambdaPermissionArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["event_source_token"] = event_source_token
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["source_account"] = source_account
            __props__.__dict__["source_arn"] = source_arn
            if statement_id is None and not opts.urn:
                raise TypeError("Missing required property 'statement_id'")
            __props__.__dict__["statement_id"] = statement_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsLambdaPermission, __self__).__init__(
            'duplocloud:index/awsLambdaPermission:AwsLambdaPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            event_source_token: Optional[pulumi.Input[str]] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            principal: Optional[pulumi.Input[str]] = None,
            qualifier: Optional[pulumi.Input[str]] = None,
            source_account: Optional[pulumi.Input[str]] = None,
            source_arn: Optional[pulumi.Input[str]] = None,
            statement_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsLambdaPermission':
        """
        Get an existing AwsLambdaPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        :param pulumi.Input[str] event_source_token: The Event Source Token to validate.
        :param pulumi.Input[str] function_name: Name of the Lambda function whose resource policy you are updating.
        :param pulumi.Input[str] principal: The principal who is getting this permission.
        :param pulumi.Input[str] qualifier: Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        :param pulumi.Input[str] source_account: This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        :param pulumi.Input[str] source_arn: When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        :param pulumi.Input[str] statement_id: A unique statement identifier.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda permission will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLambdaPermissionState.__new__(_AwsLambdaPermissionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["event_source_token"] = event_source_token
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["principal"] = principal
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["source_account"] = source_account
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["statement_id"] = statement_id
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsLambdaPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The AWS Lambda action you want to allow in this statement. (e.g. `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> pulumi.Output[Optional[str]]:
        """
        The Event Source Token to validate.
        """
        return pulumi.get(self, "event_source_token")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        Name of the Lambda function whose resource policy you are updating.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[str]:
        """
        The principal who is getting this permission.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[str]]:
        """
        Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
        """
        return pulumi.get(self, "source_account")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[Optional[str]]:
        """
        When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Output[str]:
        """
        A unique statement identifier.
        """
        return pulumi.get(self, "statement_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the lambda permission will be created in.
        """
        return pulumi.get(self, "tenant_id")

