# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsLaunchTemplateArgs', 'AwsLaunchTemplate']

@pulumi.input_type
class AwsLaunchTemplateArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 ami: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLaunchTemplate resource.
        :param pulumi.Input[str] instance_type: Asg instance type to be used to update the version from the current version
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the launch template will be created in.
        :param pulumi.Input[str] version: Any of the existing version of the launch template
        :param pulumi.Input[str] ami: Asg ami to be used to update the version from the current version
        :param pulumi.Input[str] name: The fullname of the asg group
        :param pulumi.Input[str] version_description: The version of the launch template
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "version", version)
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Asg instance type to be used to update the version from the current version
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the launch template will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Any of the existing version of the launch template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[str]]:
        """
        Asg ami to be used to update the version from the current version
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fullname of the asg group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the launch template
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)


@pulumi.input_type
class _AwsLaunchTemplateState:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[str]] = None,
                 default_version: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 version_metadata: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLaunchTemplate resources.
        :param pulumi.Input[str] ami: Asg ami to be used to update the version from the current version
        :param pulumi.Input[str] default_version: The current default version of the launch template.
        :param pulumi.Input[str] instance_type: Asg instance type to be used to update the version from the current version
        :param pulumi.Input[str] latest_version: The latest launch template version
        :param pulumi.Input[str] name: The fullname of the asg group
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the launch template will be created in.
        :param pulumi.Input[str] version: Any of the existing version of the launch template
        :param pulumi.Input[str] version_description: The version of the launch template
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_metadata is not None:
            pulumi.set(__self__, "version_metadata", version_metadata)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[str]]:
        """
        Asg ami to be used to update the version from the current version
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input[str]]:
        """
        The current default version of the launch template.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_version", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Asg instance type to be used to update the version from the current version
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[str]]:
        """
        The latest launch template version
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fullname of the asg group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the launch template will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Any of the existing version of the launch template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the launch template
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)

    @property
    @pulumi.getter(name="versionMetadata")
    def version_metadata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version_metadata")

    @version_metadata.setter
    def version_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_metadata", value)


class AwsLaunchTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        duplocloud_aws_launch_template creates the new version over current launch template version

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        lt = duplocloud.AwsLaunchTemplate("lt",
            tenant_id=myapp.tenant_id,
            name="launch-template-name",
            instance_type="t3a.medium",
            version="1",
            version_description="launch template description",
            ami="ami-123test")
        ```

        ## Import

        Example: Importing an existing AWS launch template

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the AWS launch template

         - *VERSION* available version of launch template

        ```sh
        $ pulumi import duplocloud:index/awsLaunchTemplate:AwsLaunchTemplate lt *TENANT_ID*/launch-template/*NAME*/*VERSION*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami: Asg ami to be used to update the version from the current version
        :param pulumi.Input[str] instance_type: Asg instance type to be used to update the version from the current version
        :param pulumi.Input[str] name: The fullname of the asg group
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the launch template will be created in.
        :param pulumi.Input[str] version: Any of the existing version of the launch template
        :param pulumi.Input[str] version_description: The version of the launch template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLaunchTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        duplocloud_aws_launch_template creates the new version over current launch template version

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        lt = duplocloud.AwsLaunchTemplate("lt",
            tenant_id=myapp.tenant_id,
            name="launch-template-name",
            instance_type="t3a.medium",
            version="1",
            version_description="launch template description",
            ami="ami-123test")
        ```

        ## Import

        Example: Importing an existing AWS launch template

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the AWS launch template

         - *VERSION* available version of launch template

        ```sh
        $ pulumi import duplocloud:index/awsLaunchTemplate:AwsLaunchTemplate lt *TENANT_ID*/launch-template/*NAME*/*VERSION*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLaunchTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLaunchTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLaunchTemplateArgs.__new__(AwsLaunchTemplateArgs)

            __props__.__dict__["ami"] = ami
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["default_version"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["version_metadata"] = None
        super(AwsLaunchTemplate, __self__).__init__(
            'duplocloud:index/awsLaunchTemplate:AwsLaunchTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ami: Optional[pulumi.Input[str]] = None,
            default_version: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            latest_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            version_description: Optional[pulumi.Input[str]] = None,
            version_metadata: Optional[pulumi.Input[str]] = None) -> 'AwsLaunchTemplate':
        """
        Get an existing AwsLaunchTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami: Asg ami to be used to update the version from the current version
        :param pulumi.Input[str] default_version: The current default version of the launch template.
        :param pulumi.Input[str] instance_type: Asg instance type to be used to update the version from the current version
        :param pulumi.Input[str] latest_version: The latest launch template version
        :param pulumi.Input[str] name: The fullname of the asg group
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the launch template will be created in.
        :param pulumi.Input[str] version: Any of the existing version of the launch template
        :param pulumi.Input[str] version_description: The version of the launch template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLaunchTemplateState.__new__(_AwsLaunchTemplateState)

        __props__.__dict__["ami"] = ami
        __props__.__dict__["default_version"] = default_version
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["version"] = version
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["version_metadata"] = version_metadata
        return AwsLaunchTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ami(self) -> pulumi.Output[str]:
        """
        Asg ami to be used to update the version from the current version
        """
        return pulumi.get(self, "ami")

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[str]:
        """
        The current default version of the launch template.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Asg instance type to be used to update the version from the current version
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[str]:
        """
        The latest launch template version
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fullname of the asg group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the launch template will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Any of the existing version of the launch template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[str]:
        """
        The version of the launch template
        """
        return pulumi.get(self, "version_description")

    @property
    @pulumi.getter(name="versionMetadata")
    def version_metadata(self) -> pulumi.Output[str]:
        return pulumi.get(self, "version_metadata")

