# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLbListenerRuleArgs', 'AwsLbListenerRule']

@pulumi.input_type
class AwsLbListenerRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]],
                 conditions: pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]],
                 listener_arn: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]] = None):
        """
        The set of arguments for constructing a AwsLbListenerRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws lb listener rule will be created in.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "listener_arn", listener_arn)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @listener_arn.setter
    def listener_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws lb listener rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AwsLbListenerRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLbListenerRule resources.
        :param pulumi.Input[str] arn: The ARN of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws lb listener rule will be created in.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if listener_arn is not None:
            pulumi.set(__self__, "listener_arn", listener_arn)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the rule.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]]]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @listener_arn.setter
    def listener_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_arn", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLbListenerRuleTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws lb listener rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsLbListenerRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleActionArgs', 'AwsLbListenerRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleConditionArgs', 'AwsLbListenerRuleConditionArgsDict']]]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleTagArgs', 'AwsLbListenerRuleTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLbListenerRule` manages an AWS Listener Rule in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "053a2efa-d03f-4e1d-b3b5-33c04cbed87e"
        vpc_id = "vpc-0ba0667cfc200f060"
        cert_arn = "arn:aws:acm:us-west-2:957282632678:certificate/2e882320-5aa5-4b8d-881f-998050178205"
        alb = duplocloud.AwsLoadBalancer("alb",
            tenant_id=tenant_id,
            name="tst-alb",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        tg = duplocloud.AwsLbTargetGroup("tg",
            tenant_id=tenant_id,
            name="tg1",
            port=80,
            protocol="HTTP",
            vpc_id=vpc_id,
            target_type="instance")
        alb_listener = duplocloud.AwsLoadBalancerListener("alb-listener",
            tenant_id=tenant_id,
            load_balancer_name=alb.name,
            port=8443,
            protocol="HTTPS",
            target_group_arn=tg.arn,
            certificate_arn=cert_arn)
        static = duplocloud.AwsLbListenerRule("static",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=100,
            actions=[{
                "type": "forward",
                "target_group_arn": tg.arn,
            }],
            conditions=[
                {
                    "path_pattern": {
                        "values": ["/static/*"],
                    },
                },
                {
                    "host_header": {
                        "values": ["example.com"],
                    },
                },
            ])
        # Forward action
        host_based_weighted_routing = duplocloud.AwsLbListenerRule("host_based_weighted_routing",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "target_group_arn": tg.arn,
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.terraform.io"],
                },
            }])
        # Redirect action
        redirect_http_to_https = duplocloud.AwsLbListenerRule("redirect_http_to_https",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=98,
            actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }],
            conditions=[{
                "http_header": {
                    "http_header_name": "X-Forwarded-For",
                    "values": ["192.168.1.*"],
                },
            }])
        # Fixed-response action
        health_check = duplocloud.AwsLbListenerRule("health_check",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=97,
            actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "HEALTHY",
                    "status_code": "200",
                },
            }],
            conditions=[{
                "query_strings": [
                    {
                        "key": "health",
                        "value": "check",
                    },
                    {
                        "key": "foo",
                        "value": "bar",
                    },
                ],
            }])
        ```

        ## Import

        Example: Importing an existing AWS AWS LB Listener Rule

         - *TENANT_ID* is the tenant GUID

         - *RULE_ARN* is the ARN of the AWS LB Listener Rule

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLbListenerRule:AwsLbListenerRule listener_rule *TENANT_ID*/*RULE_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleConditionArgs', 'AwsLbListenerRuleConditionArgsDict']]]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws lb listener rule will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLbListenerRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLbListenerRule` manages an AWS Listener Rule in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "053a2efa-d03f-4e1d-b3b5-33c04cbed87e"
        vpc_id = "vpc-0ba0667cfc200f060"
        cert_arn = "arn:aws:acm:us-west-2:957282632678:certificate/2e882320-5aa5-4b8d-881f-998050178205"
        alb = duplocloud.AwsLoadBalancer("alb",
            tenant_id=tenant_id,
            name="tst-alb",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        tg = duplocloud.AwsLbTargetGroup("tg",
            tenant_id=tenant_id,
            name="tg1",
            port=80,
            protocol="HTTP",
            vpc_id=vpc_id,
            target_type="instance")
        alb_listener = duplocloud.AwsLoadBalancerListener("alb-listener",
            tenant_id=tenant_id,
            load_balancer_name=alb.name,
            port=8443,
            protocol="HTTPS",
            target_group_arn=tg.arn,
            certificate_arn=cert_arn)
        static = duplocloud.AwsLbListenerRule("static",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=100,
            actions=[{
                "type": "forward",
                "target_group_arn": tg.arn,
            }],
            conditions=[
                {
                    "path_pattern": {
                        "values": ["/static/*"],
                    },
                },
                {
                    "host_header": {
                        "values": ["example.com"],
                    },
                },
            ])
        # Forward action
        host_based_weighted_routing = duplocloud.AwsLbListenerRule("host_based_weighted_routing",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "target_group_arn": tg.arn,
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.terraform.io"],
                },
            }])
        # Redirect action
        redirect_http_to_https = duplocloud.AwsLbListenerRule("redirect_http_to_https",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=98,
            actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }],
            conditions=[{
                "http_header": {
                    "http_header_name": "X-Forwarded-For",
                    "values": ["192.168.1.*"],
                },
            }])
        # Fixed-response action
        health_check = duplocloud.AwsLbListenerRule("health_check",
            tenant_id=tenant_id,
            listener_arn=alb_listener.arn,
            priority=97,
            actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "HEALTHY",
                    "status_code": "200",
                },
            }],
            conditions=[{
                "query_strings": [
                    {
                        "key": "health",
                        "value": "check",
                    },
                    {
                        "key": "foo",
                        "value": "bar",
                    },
                ],
            }])
        ```

        ## Import

        Example: Importing an existing AWS AWS LB Listener Rule

         - *TENANT_ID* is the tenant GUID

         - *RULE_ARN* is the ARN of the AWS LB Listener Rule

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLbListenerRule:AwsLbListenerRule listener_rule *TENANT_ID*/*RULE_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLbListenerRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLbListenerRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleActionArgs', 'AwsLbListenerRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleConditionArgs', 'AwsLbListenerRuleConditionArgsDict']]]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleTagArgs', 'AwsLbListenerRuleTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLbListenerRuleArgs.__new__(AwsLbListenerRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            if listener_arn is None and not opts.urn:
                raise TypeError("Missing required property 'listener_arn'")
            __props__.__dict__["listener_arn"] = listener_arn
            __props__.__dict__["priority"] = priority
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
        super(AwsLbListenerRule, __self__).__init__(
            'duplocloud:index/awsLbListenerRule:AwsLbListenerRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleActionArgs', 'AwsLbListenerRuleActionArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleConditionArgs', 'AwsLbListenerRuleConditionArgsDict']]]]] = None,
            listener_arn: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleTagArgs', 'AwsLbListenerRuleTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsLbListenerRule':
        """
        Get an existing AwsLbListenerRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsLbListenerRuleConditionArgs', 'AwsLbListenerRuleConditionArgsDict']]]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws lb listener rule will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLbListenerRuleState.__new__(_AwsLbListenerRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["arn"] = arn
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["listener_arn"] = listener_arn
        __props__.__dict__["priority"] = priority
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsLbListenerRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.AwsLbListenerRuleAction']]:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.AwsLbListenerRuleCondition']]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AwsLbListenerRuleTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws lb listener rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

