# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLbTargetGroupArgs', 'AwsLbTargetGroup']

@pulumi.input_type
class AwsLbTargetGroupArgs:
    def __init__(__self__, *,
                 target_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 health_check: Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLbTargetGroup resource.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the target group will be created in.
        :param pulumi.Input['AwsLbTargetGroupHealthCheckArgs'] health_check: Health Check configuration block.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        :param pulumi.Input[str] name: Name of the target group.
        :param pulumi.Input[int] port: Port to use to connect with the target. Valid values are either ports 1-65535.
        :param pulumi.Input[str] protocol: Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        :param pulumi.Input[str] protocol_version: Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        pulumi.set(__self__, "target_type", target_type)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[str]:
        """
        Type of target that you must specify when registering targets with this target group.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the target group will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port to use to connect with the target. Valid values are either ports 1-65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _AwsLbTargetGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLbTargetGroup resources.
        :param pulumi.Input[str] arn: ARN of the Target Group.
        :param pulumi.Input['AwsLbTargetGroupHealthCheckArgs'] health_check: Health Check configuration block.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        :param pulumi.Input[str] name: Name of the target group.
        :param pulumi.Input[int] port: Port to use to connect with the target. Valid values are either ports 1-65535.
        :param pulumi.Input[str] protocol: Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        :param pulumi.Input[str] protocol_version: Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the target group will be created in.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['AwsLbTargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port to use to connect with the target. Valid values are either ports 1-65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of target that you must specify when registering targets with this target group.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the target group will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AwsLbTargetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_check: Optional[pulumi.Input[Union['AwsLbTargetGroupHealthCheckArgs', 'AwsLbTargetGroupHealthCheckArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLbTargetGroup` manages a target group in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "053a2efa-d03f-4e1d-b3b5-33c121342adae"
        vpc_id = "vpc-0ba0667cfc20111122233"
        tg = duplocloud.AwsLbTargetGroup("tg",
            tenant_id=tenant_id,
            name="tg1",
            port=80,
            protocol="HTTP",
            vpc_id=vpc_id,
            target_type="instance",
            health_check={
                "healthy_threshold": 8,
                "interval": 300,
                "path": "/health",
                "port": "9000",
                "protocol": "HTTP",
                "timeout": 60,
                "unhealthy_threshold": 6,
            })
        ```

        ## Import

        Example: Importing an existing AWS target group

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the AWS target group

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLbTargetGroup:AwsLbTargetGroup tg *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsLbTargetGroupHealthCheckArgs', 'AwsLbTargetGroupHealthCheckArgsDict']] health_check: Health Check configuration block.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        :param pulumi.Input[str] name: Name of the target group.
        :param pulumi.Input[int] port: Port to use to connect with the target. Valid values are either ports 1-65535.
        :param pulumi.Input[str] protocol: Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        :param pulumi.Input[str] protocol_version: Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the target group will be created in.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLbTargetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLbTargetGroup` manages a target group in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "053a2efa-d03f-4e1d-b3b5-33c121342adae"
        vpc_id = "vpc-0ba0667cfc20111122233"
        tg = duplocloud.AwsLbTargetGroup("tg",
            tenant_id=tenant_id,
            name="tg1",
            port=80,
            protocol="HTTP",
            vpc_id=vpc_id,
            target_type="instance",
            health_check={
                "healthy_threshold": 8,
                "interval": 300,
                "path": "/health",
                "port": "9000",
                "protocol": "HTTP",
                "timeout": 60,
                "unhealthy_threshold": 6,
            })
        ```

        ## Import

        Example: Importing an existing AWS target group

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the AWS target group

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLbTargetGroup:AwsLbTargetGroup tg *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLbTargetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLbTargetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_check: Optional[pulumi.Input[Union['AwsLbTargetGroupHealthCheckArgs', 'AwsLbTargetGroupHealthCheckArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLbTargetGroupArgs.__new__(AwsLbTargetGroupArgs)

            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_version"] = protocol_version
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
        super(AwsLbTargetGroup, __self__).__init__(
            'duplocloud:index/awsLbTargetGroup:AwsLbTargetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            health_check: Optional[pulumi.Input[Union['AwsLbTargetGroupHealthCheckArgs', 'AwsLbTargetGroupHealthCheckArgsDict']]] = None,
            ip_address_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            protocol_version: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AwsLbTargetGroup':
        """
        Get an existing AwsLbTargetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Target Group.
        :param pulumi.Input[Union['AwsLbTargetGroupHealthCheckArgs', 'AwsLbTargetGroupHealthCheckArgsDict']] health_check: Health Check configuration block.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        :param pulumi.Input[str] name: Name of the target group.
        :param pulumi.Input[int] port: Port to use to connect with the target. Valid values are either ports 1-65535.
        :param pulumi.Input[str] protocol: Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        :param pulumi.Input[str] protocol_version: Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the target group will be created in.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLbTargetGroupState.__new__(_AwsLbTargetGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_version"] = protocol_version
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vpc_id"] = vpc_id
        return AwsLbTargetGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Target Group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.AwsLbTargetGroupHealthCheck']:
        """
        Health Check configuration block.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[str]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the target group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port to use to connect with the target. Valid values are either ports 1-65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Protocol to use to connect with the target. Not applicable when `target_type` is `lambda`. Defaults to `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> pulumi.Output[str]:
        """
        Only applicable when protocol is `HTTP` or `HTTPS`. The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        Type of target that you must specify when registering targets with this target group.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the target group will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

