# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLoadBalancerArgs', 'AwsLoadBalancer']

@pulumi.input_type
class AwsLoadBalancerArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 is_internal: Optional[pulumi.Input[bool]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLoadBalancer resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[bool] enable_access_logs: Whether or not access logs should be enabled.
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[bool] is_internal: Whether or not the load balancer is internal (non internet-facing).
        :param pulumi.Input[str] load_balancer_type: The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        :param pulumi.Input[str] name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] web_acl_id: The ARN of a WAF to attach to the load balancer.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if drop_invalid_headers is not None:
            pulumi.set(__self__, "drop_invalid_headers", drop_invalid_headers)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if http_to_https_redirect is not None:
            pulumi.set(__self__, "http_to_https_redirect", http_to_https_redirect)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if is_internal is not None:
            pulumi.set(__self__, "is_internal", is_internal)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "drop_invalid_headers")

    @drop_invalid_headers.setter
    def drop_invalid_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_invalid_headers", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not access logs should be enabled.
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "http_to_https_redirect")

    @http_to_https_redirect.setter
    def http_to_https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_to_https_redirect", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer is internal (non internet-facing).
        """
        return pulumi.get(self, "is_internal")

    @is_internal.setter
    def is_internal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_internal", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of a WAF to attach to the load balancer.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_acl_id", value)


@pulumi.input_type
class _AwsLoadBalancerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 is_internal: Optional[pulumi.Input[bool]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLoadBalancer resources.
        :param pulumi.Input[str] arn: The ARN of the load balancer.
        :param pulumi.Input[str] dns_name: The DNS name of the load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[bool] enable_access_logs: Whether or not access logs should be enabled.
        :param pulumi.Input[str] fullname: The full name of the load balancer.
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[bool] is_internal: Whether or not the load balancer is internal (non internet-facing).
        :param pulumi.Input[str] load_balancer_type: The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        :param pulumi.Input[str] name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerTagArgs']]] tags: The tags assigned to this load balancer.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        :param pulumi.Input[str] web_acl_id: The ARN of a WAF to attach to the load balancer.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if drop_invalid_headers is not None:
            pulumi.set(__self__, "drop_invalid_headers", drop_invalid_headers)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if http_to_https_redirect is not None:
            pulumi.set(__self__, "http_to_https_redirect", http_to_https_redirect)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if is_internal is not None:
            pulumi.set(__self__, "is_internal", is_internal)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the load balancer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the load balancer.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "drop_invalid_headers")

    @drop_invalid_headers.setter
    def drop_invalid_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_invalid_headers", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not access logs should be enabled.
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the load balancer.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "http_to_https_redirect")

    @http_to_https_redirect.setter
    def http_to_https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_to_https_redirect", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the load balancer is internal (non internet-facing).
        """
        return pulumi.get(self, "is_internal")

    @is_internal.setter
    def is_internal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_internal", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerTagArgs']]]]:
        """
        The tags assigned to this load balancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of a WAF to attach to the load balancer.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_acl_id", value)


class AwsLoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 is_internal: Optional[pulumi.Input[bool]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLoadBalancer` manages an AWS application load balancer in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_aws_load_balancer = duplocloud.AwsLoadBalancer("myapp",
            tenant_id=myapp.tenant_id,
            name="myapp",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        ```

        ## Import

        Example: Importing an existing AWS load balancer

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS load balancer

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLoadBalancer:AwsLoadBalancer myalb *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[bool] enable_access_logs: Whether or not access logs should be enabled.
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[bool] is_internal: Whether or not the load balancer is internal (non internet-facing).
        :param pulumi.Input[str] load_balancer_type: The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        :param pulumi.Input[str] name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        :param pulumi.Input[str] web_acl_id: The ARN of a WAF to attach to the load balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLoadBalancer` manages an AWS application load balancer in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_aws_load_balancer = duplocloud.AwsLoadBalancer("myapp",
            tenant_id=myapp.tenant_id,
            name="myapp",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        ```

        ## Import

        Example: Importing an existing AWS load balancer

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS load balancer

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLoadBalancer:AwsLoadBalancer myalb *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 is_internal: Optional[pulumi.Input[bool]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLoadBalancerArgs.__new__(AwsLoadBalancerArgs)

            __props__.__dict__["drop_invalid_headers"] = drop_invalid_headers
            __props__.__dict__["enable_access_logs"] = enable_access_logs
            __props__.__dict__["http_to_https_redirect"] = http_to_https_redirect
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["is_internal"] = is_internal
            __props__.__dict__["load_balancer_type"] = load_balancer_type
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["web_acl_id"] = web_acl_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["tags"] = None
        super(AwsLoadBalancer, __self__).__init__(
            'duplocloud:index/awsLoadBalancer:AwsLoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
            enable_access_logs: Optional[pulumi.Input[bool]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            is_internal: Optional[pulumi.Input[bool]] = None,
            load_balancer_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLoadBalancerTagArgs', 'AwsLoadBalancerTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            web_acl_id: Optional[pulumi.Input[str]] = None) -> 'AwsLoadBalancer':
        """
        Get an existing AwsLoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the load balancer.
        :param pulumi.Input[str] dns_name: The DNS name of the load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[bool] enable_access_logs: Whether or not access logs should be enabled.
        :param pulumi.Input[str] fullname: The full name of the load balancer.
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[bool] is_internal: Whether or not the load balancer is internal (non internet-facing).
        :param pulumi.Input[str] load_balancer_type: The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        :param pulumi.Input[str] name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsLoadBalancerTagArgs', 'AwsLoadBalancerTagArgsDict']]]] tags: The tags assigned to this load balancer.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        :param pulumi.Input[str] web_acl_id: The ARN of a WAF to attach to the load balancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLoadBalancerState.__new__(_AwsLoadBalancerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["drop_invalid_headers"] = drop_invalid_headers
        __props__.__dict__["enable_access_logs"] = enable_access_logs
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["http_to_https_redirect"] = http_to_https_redirect
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["is_internal"] = is_internal
        __props__.__dict__["load_balancer_type"] = load_balancer_type
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["web_acl_id"] = web_acl_id
        return AwsLoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the load balancer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name of the load balancer.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> pulumi.Output[bool]:
        """
        Whether or not the load balancer should drop invalid HTTP headers. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "drop_invalid_headers")

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> pulumi.Output[bool]:
        """
        Whether or not access logs should be enabled.
        """
        return pulumi.get(self, "enable_access_logs")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the load balancer.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> pulumi.Output[bool]:
        """
        Whether or not the load balancer should redirect HTTP to HTTPS. Only valid for Load Balancers of type `Application`
        """
        return pulumi.get(self, "http_to_https_redirect")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[int]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> pulumi.Output[bool]:
        """
        Whether or not the load balancer is internal (non internet-facing).
        """
        return pulumi.get(self, "is_internal")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of load balancer to create. Possible values are `Application` or `Network`. Defaults to `Application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AwsLoadBalancerTag']]:
        """
        The tags assigned to this load balancer.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> pulumi.Output[str]:
        """
        The ARN of a WAF to attach to the load balancer.
        """
        return pulumi.get(self, "web_acl_id")

