# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLoadBalancerListenerArgs', 'AwsLoadBalancerListener']

@pulumi.input_type
class AwsLoadBalancerListenerArgs:
    def __init__(__self__, *,
                 load_balancer_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 target_group_arn: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 certificate_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLoadBalancerListener resource.
        :param pulumi.Input[str] load_balancer_name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] port: Port on which the load balancer is listening.
        :param pulumi.Input[str] protocol: Protocol for connections from clients to the load balancer.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group to which to route traffic.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        :param pulumi.Input[str] certificate_arn: The ARN of the certificate to attach to the listener.
        """
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_group_arn", target_group_arn)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Input[str]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port on which the load balancer is listening.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol for connections from clients to the load balancer.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Target Group to which to route traffic.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_group_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the certificate to attach to the listener.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)


@pulumi.input_type
class _AwsLoadBalancerListenerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerCertificateArgs']]]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerDefaultActionArgs']]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[str]] = None,
                 load_balancer_fullname: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLoadBalancerListener resources.
        :param pulumi.Input[str] arn: ARN of the listener.
        :param pulumi.Input[str] certificate_arn: The ARN of the certificate to attach to the listener.
        :param pulumi.Input[str] load_balancer_fullname: The full name of the load balancer.
        :param pulumi.Input[str] load_balancer_name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] port: Port on which the load balancer is listening.
        :param pulumi.Input[str] protocol: Protocol for connections from clients to the load balancer.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group to which to route traffic.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if load_balancer_arn is not None:
            pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if load_balancer_fullname is not None:
            pulumi.set(__self__, "load_balancer_fullname", load_balancer_fullname)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the listener.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the certificate to attach to the listener.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerCertificateArgs']]]]:
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerDefaultActionArgs']]]]:
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLoadBalancerListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter(name="loadBalancerFullname")
    def load_balancer_fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the load balancer.
        """
        return pulumi.get(self, "load_balancer_fullname")

    @load_balancer_fullname.setter
    def load_balancer_fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_fullname", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port on which the load balancer is listening.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol for connections from clients to the load balancer.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group to which to route traffic.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsLoadBalancerListener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLoadBalancerListener` manages an AWS application load balancer listener in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_aws_load_balancer = duplocloud.AwsLoadBalancer("myapp",
            tenant_id=myapp.tenant_id,
            name="myapp",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        myapp_listener = duplocloud.AwsLoadBalancerListener("myapp-listener",
            tenant_id=myapp.tenant_id,
            load_balancer_name=myapp_aws_load_balancer.name,
            port=8443,
            protocol="https",
            target_group_arn="arn:aws:elasticloadbalancing:us-west-2:1234567890:targetgroup/duplo2-stage-antcmw-http4000/fc6f818e85fa737a")
        ```

        ## Import

        Example: Importing an existing AWS load balancer listener

         - *TENANT_ID* is the tenant GUID

         - *LB_NAME* is the name of the AWS load balancer

         - *LISTENER_ARN* is the arn of the AWS load balancer listener

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLoadBalancerListener:AwsLoadBalancerListener myalb-listener *TENANT_ID*/*LB_NAME*/*LISTENER_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_arn: The ARN of the certificate to attach to the listener.
        :param pulumi.Input[str] load_balancer_name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] port: Port on which the load balancer is listening.
        :param pulumi.Input[str] protocol: Protocol for connections from clients to the load balancer.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group to which to route traffic.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLoadBalancerListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLoadBalancerListener` manages an AWS application load balancer listener in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_aws_load_balancer = duplocloud.AwsLoadBalancer("myapp",
            tenant_id=myapp.tenant_id,
            name="myapp",
            is_internal=True,
            enable_access_logs=True,
            drop_invalid_headers=True)
        myapp_listener = duplocloud.AwsLoadBalancerListener("myapp-listener",
            tenant_id=myapp.tenant_id,
            load_balancer_name=myapp_aws_load_balancer.name,
            port=8443,
            protocol="https",
            target_group_arn="arn:aws:elasticloadbalancing:us-west-2:1234567890:targetgroup/duplo2-stage-antcmw-http4000/fc6f818e85fa737a")
        ```

        ## Import

        Example: Importing an existing AWS load balancer listener

         - *TENANT_ID* is the tenant GUID

         - *LB_NAME* is the name of the AWS load balancer

         - *LISTENER_ARN* is the arn of the AWS load balancer listener

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLoadBalancerListener:AwsLoadBalancerListener myalb-listener *TENANT_ID*/*LB_NAME*/*LISTENER_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLoadBalancerListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLoadBalancerListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLoadBalancerListenerArgs.__new__(AwsLoadBalancerListenerArgs)

            __props__.__dict__["certificate_arn"] = certificate_arn
            if load_balancer_name is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_name'")
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if target_group_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_group_arn'")
            __props__.__dict__["target_group_arn"] = target_group_arn
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificates"] = None
            __props__.__dict__["default_actions"] = None
            __props__.__dict__["load_balancer_arn"] = None
            __props__.__dict__["load_balancer_fullname"] = None
            __props__.__dict__["ssl_policy"] = None
        super(AwsLoadBalancerListener, __self__).__init__(
            'duplocloud:index/awsLoadBalancerListener:AwsLoadBalancerListener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            certificate_arn: Optional[pulumi.Input[str]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLoadBalancerListenerCertificateArgs', 'AwsLoadBalancerListenerCertificateArgsDict']]]]] = None,
            default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLoadBalancerListenerDefaultActionArgs', 'AwsLoadBalancerListenerDefaultActionArgsDict']]]]] = None,
            load_balancer_arn: Optional[pulumi.Input[str]] = None,
            load_balancer_fullname: Optional[pulumi.Input[str]] = None,
            load_balancer_name: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            ssl_policy: Optional[pulumi.Input[str]] = None,
            target_group_arn: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsLoadBalancerListener':
        """
        Get an existing AwsLoadBalancerListener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the listener.
        :param pulumi.Input[str] certificate_arn: The ARN of the certificate to attach to the listener.
        :param pulumi.Input[str] load_balancer_fullname: The full name of the load balancer.
        :param pulumi.Input[str] load_balancer_name: The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] port: Port on which the load balancer is listening.
        :param pulumi.Input[str] protocol: Protocol for connections from clients to the load balancer.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group to which to route traffic.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the load balancer will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLoadBalancerListenerState.__new__(_AwsLoadBalancerListenerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_arn"] = certificate_arn
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["default_actions"] = default_actions
        __props__.__dict__["load_balancer_arn"] = load_balancer_arn
        __props__.__dict__["load_balancer_fullname"] = load_balancer_fullname
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["ssl_policy"] = ssl_policy
        __props__.__dict__["target_group_arn"] = target_group_arn
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsLoadBalancerListener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the listener.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the certificate to attach to the listener.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.AwsLoadBalancerListenerCertificate']]:
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Output[Sequence['outputs.AwsLoadBalancerListenerDefaultAction']]:
        return pulumi.get(self, "default_actions")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="loadBalancerFullname")
    def load_balancer_fullname(self) -> pulumi.Output[str]:
        """
        The full name of the load balancer.
        """
        return pulumi.get(self, "load_balancer_fullname")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The short name of the load balancer.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port on which the load balancer is listening.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Protocol for connections from clients to the load balancer.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ssl_policy")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> pulumi.Output[str]:
        """
        ARN of the Target Group to which to route traffic.
        """
        return pulumi.get(self, "target_group_arn")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the load balancer will be created in.
        """
        return pulumi.get(self, "tenant_id")

