# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsMwaaEnvironmentArgs', 'AwsMwaaEnvironment']

@pulumi.input_type
class AwsMwaaEnvironmentArgs:
    def __init__(__self__, *,
                 dag_s3_path: pulumi.Input[str],
                 source_bucket_arn: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 airflow_configuration_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 airflow_version: Optional[pulumi.Input[str]] = None,
                 environment_class: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 min_workers: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[str]] = None,
                 schedulers: Optional[pulumi.Input[int]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 webserver_access_mode: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsMwaaEnvironment resource.
        :param pulumi.Input[str] dag_s3_path: The relative path to the DAG folder on your Amazon S3 storage bucket.
        :param pulumi.Input[str] source_bucket_arn: The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_configuration_options: The `airflow_configuration_options` parameter specifies airflow override options
        :param pulumi.Input[str] airflow_version: Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        :param pulumi.Input[str] environment_class: Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        :param pulumi.Input[str] execution_role_arn: The Execution Role ARN of the Amazon MWAA Environment
        :param pulumi.Input[str] kms_key: The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        :param pulumi.Input[int] max_workers: The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        :param pulumi.Input[int] min_workers: The minimum number of workers that you want to run in your environment.
        :param pulumi.Input[str] name: The name of the Apache Airflow Environment.
        :param pulumi.Input[str] plugins_s3_object_version: The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] plugins_s3_path: The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        :param pulumi.Input[str] requirements_s3_object_version: The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] requirements_s3_path: The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        :param pulumi.Input[int] schedulers: The number of schedulers that you want to run in your environment.
        :param pulumi.Input[str] startup_script_s3_object_version: The startup script file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] startup_script_s3_path: The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[str] webserver_access_mode: Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        :param pulumi.Input[str] weekly_maintenance_window_start: Specifies the start date for the weekly maintenance window.
        """
        pulumi.set(__self__, "dag_s3_path", dag_s3_path)
        pulumi.set(__self__, "source_bucket_arn", source_bucket_arn)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if airflow_configuration_options is not None:
            pulumi.set(__self__, "airflow_configuration_options", airflow_configuration_options)
        if airflow_version is not None:
            pulumi.set(__self__, "airflow_version", airflow_version)
        if environment_class is not None:
            pulumi.set(__self__, "environment_class", environment_class)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if min_workers is not None:
            pulumi.set(__self__, "min_workers", min_workers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugins_s3_object_version is not None:
            pulumi.set(__self__, "plugins_s3_object_version", plugins_s3_object_version)
        if plugins_s3_path is not None:
            pulumi.set(__self__, "plugins_s3_path", plugins_s3_path)
        if requirements_s3_object_version is not None:
            pulumi.set(__self__, "requirements_s3_object_version", requirements_s3_object_version)
        if requirements_s3_path is not None:
            pulumi.set(__self__, "requirements_s3_path", requirements_s3_path)
        if schedulers is not None:
            pulumi.set(__self__, "schedulers", schedulers)
        if startup_script_s3_object_version is not None:
            pulumi.set(__self__, "startup_script_s3_object_version", startup_script_s3_object_version)
        if startup_script_s3_path is not None:
            pulumi.set(__self__, "startup_script_s3_path", startup_script_s3_path)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if webserver_access_mode is not None:
            pulumi.set(__self__, "webserver_access_mode", webserver_access_mode)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> pulumi.Input[str]:
        """
        The relative path to the DAG folder on your Amazon S3 storage bucket.
        """
        return pulumi.get(self, "dag_s3_path")

    @dag_s3_path.setter
    def dag_s3_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "dag_s3_path", value)

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        """
        return pulumi.get(self, "source_bucket_arn")

    @source_bucket_arn.setter
    def source_bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_bucket_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The `airflow_configuration_options` parameter specifies airflow override options
        """
        return pulumi.get(self, "airflow_configuration_options")

    @airflow_configuration_options.setter
    def airflow_configuration_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "airflow_configuration_options", value)

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        """
        return pulumi.get(self, "airflow_version")

    @airflow_version.setter
    def airflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "airflow_version", value)

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> Optional[pulumi.Input[str]]:
        """
        Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        """
        return pulumi.get(self, "environment_class")

    @environment_class.setter
    def environment_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_class", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Execution Role ARN of the Amazon MWAA Environment
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']]:
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of workers that you want to run in your environment.
        """
        return pulumi.get(self, "min_workers")

    @min_workers.setter
    def min_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_workers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Apache Airflow Environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @plugins_s3_object_version.setter
    def plugins_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugins_s3_object_version", value)

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        """
        return pulumi.get(self, "plugins_s3_path")

    @plugins_s3_path.setter
    def plugins_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugins_s3_path", value)

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @requirements_s3_object_version.setter
    def requirements_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_s3_object_version", value)

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        """
        return pulumi.get(self, "requirements_s3_path")

    @requirements_s3_path.setter
    def requirements_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_s3_path", value)

    @property
    @pulumi.getter
    def schedulers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of schedulers that you want to run in your environment.
        """
        return pulumi.get(self, "schedulers")

    @schedulers.setter
    def schedulers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "schedulers", value)

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The startup script file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @startup_script_s3_object_version.setter
    def startup_script_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "startup_script_s3_object_version", value)

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        """
        return pulumi.get(self, "startup_script_s3_path")

    @startup_script_s3_path.setter
    def startup_script_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "startup_script_s3_path", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        """
        return pulumi.get(self, "webserver_access_mode")

    @webserver_access_mode.setter
    def webserver_access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webserver_access_mode", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the start date for the weekly maintenance window.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


@pulumi.input_type
class _AwsMwaaEnvironmentState:
    def __init__(__self__, *,
                 airflow_configuration_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 airflow_version: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 dag_s3_path: Optional[pulumi.Input[str]] = None,
                 environment_class: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 last_updateds: Optional[pulumi.Input[Sequence[pulumi.Input['AwsMwaaEnvironmentLastUpdatedArgs']]]] = None,
                 logging_configuration: Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 min_workers: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[str]] = None,
                 schedulers: Optional[pulumi.Input[int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 webserver_access_mode: Optional[pulumi.Input[str]] = None,
                 webserver_url: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsMwaaEnvironment resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_configuration_options: The `airflow_configuration_options` parameter specifies airflow override options
        :param pulumi.Input[str] airflow_version: Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        :param pulumi.Input[str] arn: The ARN of the Managed Workflows Apache Airflow.
        :param pulumi.Input[str] dag_s3_path: The relative path to the DAG folder on your Amazon S3 storage bucket.
        :param pulumi.Input[str] environment_class: Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        :param pulumi.Input[str] execution_role_arn: The Execution Role ARN of the Amazon MWAA Environment
        :param pulumi.Input[str] fullname: The full name provided by duplo for Apache Airflow Environment.
        :param pulumi.Input[str] kms_key: The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        :param pulumi.Input[int] max_workers: The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        :param pulumi.Input[int] min_workers: The minimum number of workers that you want to run in your environment.
        :param pulumi.Input[str] name: The name of the Apache Airflow Environment.
        :param pulumi.Input[str] plugins_s3_object_version: The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] plugins_s3_path: The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        :param pulumi.Input[str] requirements_s3_object_version: The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] requirements_s3_path: The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        :param pulumi.Input[int] schedulers: The number of schedulers that you want to run in your environment.
        :param pulumi.Input[str] source_bucket_arn: The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        :param pulumi.Input[str] startup_script_s3_object_version: The startup script file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] startup_script_s3_path: The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        :param pulumi.Input[str] status: The status of the Amazon MWAA Environment.
        :param pulumi.Input[str] tags: Tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[str] webserver_access_mode: Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        :param pulumi.Input[str] webserver_url: The webserver URL of the MWAA Environment.
        :param pulumi.Input[str] weekly_maintenance_window_start: Specifies the start date for the weekly maintenance window.
        """
        if airflow_configuration_options is not None:
            pulumi.set(__self__, "airflow_configuration_options", airflow_configuration_options)
        if airflow_version is not None:
            pulumi.set(__self__, "airflow_version", airflow_version)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dag_s3_path is not None:
            pulumi.set(__self__, "dag_s3_path", dag_s3_path)
        if environment_class is not None:
            pulumi.set(__self__, "environment_class", environment_class)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if last_updateds is not None:
            pulumi.set(__self__, "last_updateds", last_updateds)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if min_workers is not None:
            pulumi.set(__self__, "min_workers", min_workers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugins_s3_object_version is not None:
            pulumi.set(__self__, "plugins_s3_object_version", plugins_s3_object_version)
        if plugins_s3_path is not None:
            pulumi.set(__self__, "plugins_s3_path", plugins_s3_path)
        if requirements_s3_object_version is not None:
            pulumi.set(__self__, "requirements_s3_object_version", requirements_s3_object_version)
        if requirements_s3_path is not None:
            pulumi.set(__self__, "requirements_s3_path", requirements_s3_path)
        if schedulers is not None:
            pulumi.set(__self__, "schedulers", schedulers)
        if source_bucket_arn is not None:
            pulumi.set(__self__, "source_bucket_arn", source_bucket_arn)
        if startup_script_s3_object_version is not None:
            pulumi.set(__self__, "startup_script_s3_object_version", startup_script_s3_object_version)
        if startup_script_s3_path is not None:
            pulumi.set(__self__, "startup_script_s3_path", startup_script_s3_path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if webserver_access_mode is not None:
            pulumi.set(__self__, "webserver_access_mode", webserver_access_mode)
        if webserver_url is not None:
            pulumi.set(__self__, "webserver_url", webserver_url)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The `airflow_configuration_options` parameter specifies airflow override options
        """
        return pulumi.get(self, "airflow_configuration_options")

    @airflow_configuration_options.setter
    def airflow_configuration_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "airflow_configuration_options", value)

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        """
        return pulumi.get(self, "airflow_version")

    @airflow_version.setter
    def airflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "airflow_version", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Managed Workflows Apache Airflow.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the DAG folder on your Amazon S3 storage bucket.
        """
        return pulumi.get(self, "dag_s3_path")

    @dag_s3_path.setter
    def dag_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dag_s3_path", value)

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> Optional[pulumi.Input[str]]:
        """
        Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        """
        return pulumi.get(self, "environment_class")

    @environment_class.setter
    def environment_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_class", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Execution Role ARN of the Amazon MWAA Environment
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name provided by duplo for Apache Airflow Environment.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="lastUpdateds")
    def last_updateds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsMwaaEnvironmentLastUpdatedArgs']]]]:
        return pulumi.get(self, "last_updateds")

    @last_updateds.setter
    def last_updateds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsMwaaEnvironmentLastUpdatedArgs']]]]):
        pulumi.set(self, "last_updateds", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']]:
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['AwsMwaaEnvironmentLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of workers that you want to run in your environment.
        """
        return pulumi.get(self, "min_workers")

    @min_workers.setter
    def min_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_workers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Apache Airflow Environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @plugins_s3_object_version.setter
    def plugins_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugins_s3_object_version", value)

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        """
        return pulumi.get(self, "plugins_s3_path")

    @plugins_s3_path.setter
    def plugins_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugins_s3_path", value)

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @requirements_s3_object_version.setter
    def requirements_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_s3_object_version", value)

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        """
        return pulumi.get(self, "requirements_s3_path")

    @requirements_s3_path.setter
    def requirements_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_s3_path", value)

    @property
    @pulumi.getter
    def schedulers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of schedulers that you want to run in your environment.
        """
        return pulumi.get(self, "schedulers")

    @schedulers.setter
    def schedulers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "schedulers", value)

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        """
        return pulumi.get(self, "source_bucket_arn")

    @source_bucket_arn.setter
    def source_bucket_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_bucket_arn", value)

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The startup script file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @startup_script_s3_object_version.setter
    def startup_script_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "startup_script_s3_object_version", value)

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        """
        return pulumi.get(self, "startup_script_s3_path")

    @startup_script_s3_path.setter
    def startup_script_s3_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "startup_script_s3_path", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Amazon MWAA Environment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[str]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        """
        return pulumi.get(self, "webserver_access_mode")

    @webserver_access_mode.setter
    def webserver_access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webserver_access_mode", value)

    @property
    @pulumi.getter(name="webserverUrl")
    def webserver_url(self) -> Optional[pulumi.Input[str]]:
        """
        The webserver URL of the MWAA Environment.
        """
        return pulumi.get(self, "webserver_url")

    @webserver_url.setter
    def webserver_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webserver_url", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the start date for the weekly maintenance window.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


class AwsMwaaEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_configuration_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 airflow_version: Optional[pulumi.Input[str]] = None,
                 dag_s3_path: Optional[pulumi.Input[str]] = None,
                 environment_class: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['AwsMwaaEnvironmentLoggingConfigurationArgs', 'AwsMwaaEnvironmentLoggingConfigurationArgsDict']]] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 min_workers: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[str]] = None,
                 schedulers: Optional[pulumi.Input[int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 webserver_access_mode: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsMwaaEnvironment` manages an AWS MWAA Environment resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        tenant_kms_key = duplocloud.get_tenant_aws_kms_key_output(tenant_id=myapp.tenant_id)
        my_mwaa = duplocloud.AwsMwaaEnvironment("my-mwaa",
            tenant_id=myapp.tenant_id,
            name="airflow-test",
            source_bucket_arn="arn:aws:s3:::xxx-xxx-xx-xxxx",
            dag_s3_path="AirflowDags/dag",
            plugins_s3_path="AirflowDags/plugins.zip",
            requirements_s3_path="AirflowDags/requirements.txt",
            startup_script_s3_path="AirflowDags/startup-script.sh",
            kms_key=tenant_kms_key.key_arn,
            schedulers=2,
            max_workers=10,
            min_workers=1,
            airflow_version="2.6.3",
            weekly_maintenance_window_start="SUN:23:30",
            environment_class="mw1.small",
            airflow_configuration_options={
                "core.log_format": "[%%(asctime)s] {{%%(filename)s:%%(lineno)d}} %%(levelname)s - %%(message)s",
            },
            logging_configuration={
                "dag_processing_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "scheduler_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "task_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "webserver_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "worker_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS MWAA Environment resource.

         - *TENANT_ID* is the tenant GUID

         - *FULL_NAME* is the fullname of the AWS MWAA Environment resource

        # 

        ```sh
        $ pulumi import duplocloud:index/awsMwaaEnvironment:AwsMwaaEnvironment my-mwaa *TENANT_ID*/*FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_configuration_options: The `airflow_configuration_options` parameter specifies airflow override options
        :param pulumi.Input[str] airflow_version: Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        :param pulumi.Input[str] dag_s3_path: The relative path to the DAG folder on your Amazon S3 storage bucket.
        :param pulumi.Input[str] environment_class: Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        :param pulumi.Input[str] execution_role_arn: The Execution Role ARN of the Amazon MWAA Environment
        :param pulumi.Input[str] kms_key: The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        :param pulumi.Input[int] max_workers: The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        :param pulumi.Input[int] min_workers: The minimum number of workers that you want to run in your environment.
        :param pulumi.Input[str] name: The name of the Apache Airflow Environment.
        :param pulumi.Input[str] plugins_s3_object_version: The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] plugins_s3_path: The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        :param pulumi.Input[str] requirements_s3_object_version: The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] requirements_s3_path: The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        :param pulumi.Input[int] schedulers: The number of schedulers that you want to run in your environment.
        :param pulumi.Input[str] source_bucket_arn: The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        :param pulumi.Input[str] startup_script_s3_object_version: The startup script file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] startup_script_s3_path: The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[str] webserver_access_mode: Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        :param pulumi.Input[str] weekly_maintenance_window_start: Specifies the start date for the weekly maintenance window.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsMwaaEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsMwaaEnvironment` manages an AWS MWAA Environment resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        tenant_kms_key = duplocloud.get_tenant_aws_kms_key_output(tenant_id=myapp.tenant_id)
        my_mwaa = duplocloud.AwsMwaaEnvironment("my-mwaa",
            tenant_id=myapp.tenant_id,
            name="airflow-test",
            source_bucket_arn="arn:aws:s3:::xxx-xxx-xx-xxxx",
            dag_s3_path="AirflowDags/dag",
            plugins_s3_path="AirflowDags/plugins.zip",
            requirements_s3_path="AirflowDags/requirements.txt",
            startup_script_s3_path="AirflowDags/startup-script.sh",
            kms_key=tenant_kms_key.key_arn,
            schedulers=2,
            max_workers=10,
            min_workers=1,
            airflow_version="2.6.3",
            weekly_maintenance_window_start="SUN:23:30",
            environment_class="mw1.small",
            airflow_configuration_options={
                "core.log_format": "[%%(asctime)s] {{%%(filename)s:%%(lineno)d}} %%(levelname)s - %%(message)s",
            },
            logging_configuration={
                "dag_processing_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "scheduler_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "task_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "webserver_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
                "worker_logs": {
                    "enabled": False,
                    "log_level": "INFO",
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS MWAA Environment resource.

         - *TENANT_ID* is the tenant GUID

         - *FULL_NAME* is the fullname of the AWS MWAA Environment resource

        # 

        ```sh
        $ pulumi import duplocloud:index/awsMwaaEnvironment:AwsMwaaEnvironment my-mwaa *TENANT_ID*/*FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsMwaaEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsMwaaEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_configuration_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 airflow_version: Optional[pulumi.Input[str]] = None,
                 dag_s3_path: Optional[pulumi.Input[str]] = None,
                 environment_class: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['AwsMwaaEnvironmentLoggingConfigurationArgs', 'AwsMwaaEnvironmentLoggingConfigurationArgsDict']]] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 min_workers: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[str]] = None,
                 schedulers: Optional[pulumi.Input[int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 webserver_access_mode: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsMwaaEnvironmentArgs.__new__(AwsMwaaEnvironmentArgs)

            __props__.__dict__["airflow_configuration_options"] = None if airflow_configuration_options is None else pulumi.Output.secret(airflow_configuration_options)
            __props__.__dict__["airflow_version"] = airflow_version
            if dag_s3_path is None and not opts.urn:
                raise TypeError("Missing required property 'dag_s3_path'")
            __props__.__dict__["dag_s3_path"] = dag_s3_path
            __props__.__dict__["environment_class"] = environment_class
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["logging_configuration"] = logging_configuration
            __props__.__dict__["max_workers"] = max_workers
            __props__.__dict__["min_workers"] = min_workers
            __props__.__dict__["name"] = name
            __props__.__dict__["plugins_s3_object_version"] = plugins_s3_object_version
            __props__.__dict__["plugins_s3_path"] = plugins_s3_path
            __props__.__dict__["requirements_s3_object_version"] = requirements_s3_object_version
            __props__.__dict__["requirements_s3_path"] = requirements_s3_path
            __props__.__dict__["schedulers"] = schedulers
            if source_bucket_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_bucket_arn'")
            __props__.__dict__["source_bucket_arn"] = source_bucket_arn
            __props__.__dict__["startup_script_s3_object_version"] = startup_script_s3_object_version
            __props__.__dict__["startup_script_s3_path"] = startup_script_s3_path
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["webserver_access_mode"] = webserver_access_mode
            __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["last_updateds"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["webserver_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["airflowConfigurationOptions"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AwsMwaaEnvironment, __self__).__init__(
            'duplocloud:index/awsMwaaEnvironment:AwsMwaaEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            airflow_configuration_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            airflow_version: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            dag_s3_path: Optional[pulumi.Input[str]] = None,
            environment_class: Optional[pulumi.Input[str]] = None,
            execution_role_arn: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            kms_key: Optional[pulumi.Input[str]] = None,
            last_updateds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsMwaaEnvironmentLastUpdatedArgs', 'AwsMwaaEnvironmentLastUpdatedArgsDict']]]]] = None,
            logging_configuration: Optional[pulumi.Input[Union['AwsMwaaEnvironmentLoggingConfigurationArgs', 'AwsMwaaEnvironmentLoggingConfigurationArgsDict']]] = None,
            max_workers: Optional[pulumi.Input[int]] = None,
            min_workers: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            plugins_s3_object_version: Optional[pulumi.Input[str]] = None,
            plugins_s3_path: Optional[pulumi.Input[str]] = None,
            requirements_s3_object_version: Optional[pulumi.Input[str]] = None,
            requirements_s3_path: Optional[pulumi.Input[str]] = None,
            schedulers: Optional[pulumi.Input[int]] = None,
            source_bucket_arn: Optional[pulumi.Input[str]] = None,
            startup_script_s3_object_version: Optional[pulumi.Input[str]] = None,
            startup_script_s3_path: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None,
            webserver_access_mode: Optional[pulumi.Input[str]] = None,
            webserver_url: Optional[pulumi.Input[str]] = None,
            weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None) -> 'AwsMwaaEnvironment':
        """
        Get an existing AwsMwaaEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_configuration_options: The `airflow_configuration_options` parameter specifies airflow override options
        :param pulumi.Input[str] airflow_version: Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        :param pulumi.Input[str] arn: The ARN of the Managed Workflows Apache Airflow.
        :param pulumi.Input[str] dag_s3_path: The relative path to the DAG folder on your Amazon S3 storage bucket.
        :param pulumi.Input[str] environment_class: Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        :param pulumi.Input[str] execution_role_arn: The Execution Role ARN of the Amazon MWAA Environment
        :param pulumi.Input[str] fullname: The full name provided by duplo for Apache Airflow Environment.
        :param pulumi.Input[str] kms_key: The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        :param pulumi.Input[int] max_workers: The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        :param pulumi.Input[int] min_workers: The minimum number of workers that you want to run in your environment.
        :param pulumi.Input[str] name: The name of the Apache Airflow Environment.
        :param pulumi.Input[str] plugins_s3_object_version: The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] plugins_s3_path: The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        :param pulumi.Input[str] requirements_s3_object_version: The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] requirements_s3_path: The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        :param pulumi.Input[int] schedulers: The number of schedulers that you want to run in your environment.
        :param pulumi.Input[str] source_bucket_arn: The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        :param pulumi.Input[str] startup_script_s3_object_version: The startup script file version you want to use. If not set, latest s3 file version will be used.
        :param pulumi.Input[str] startup_script_s3_path: The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        :param pulumi.Input[str] status: The status of the Amazon MWAA Environment.
        :param pulumi.Input[str] tags: Tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[str] webserver_access_mode: Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        :param pulumi.Input[str] webserver_url: The webserver URL of the MWAA Environment.
        :param pulumi.Input[str] weekly_maintenance_window_start: Specifies the start date for the weekly maintenance window.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsMwaaEnvironmentState.__new__(_AwsMwaaEnvironmentState)

        __props__.__dict__["airflow_configuration_options"] = airflow_configuration_options
        __props__.__dict__["airflow_version"] = airflow_version
        __props__.__dict__["arn"] = arn
        __props__.__dict__["dag_s3_path"] = dag_s3_path
        __props__.__dict__["environment_class"] = environment_class
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["last_updateds"] = last_updateds
        __props__.__dict__["logging_configuration"] = logging_configuration
        __props__.__dict__["max_workers"] = max_workers
        __props__.__dict__["min_workers"] = min_workers
        __props__.__dict__["name"] = name
        __props__.__dict__["plugins_s3_object_version"] = plugins_s3_object_version
        __props__.__dict__["plugins_s3_path"] = plugins_s3_path
        __props__.__dict__["requirements_s3_object_version"] = requirements_s3_object_version
        __props__.__dict__["requirements_s3_path"] = requirements_s3_path
        __props__.__dict__["schedulers"] = schedulers
        __props__.__dict__["source_bucket_arn"] = source_bucket_arn
        __props__.__dict__["startup_script_s3_object_version"] = startup_script_s3_object_version
        __props__.__dict__["startup_script_s3_path"] = startup_script_s3_path
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        __props__.__dict__["webserver_access_mode"] = webserver_access_mode
        __props__.__dict__["webserver_url"] = webserver_url
        __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
        return AwsMwaaEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The `airflow_configuration_options` parameter specifies airflow override options
        """
        return pulumi.get(self, "airflow_configuration_options")

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> pulumi.Output[str]:
        """
        Airflow version of your environment, will be set by default to the latest version that MWAA supports.
        """
        return pulumi.get(self, "airflow_version")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Managed Workflows Apache Airflow.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> pulumi.Output[str]:
        """
        The relative path to the DAG folder on your Amazon S3 storage bucket.
        """
        return pulumi.get(self, "dag_s3_path")

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> pulumi.Output[str]:
        """
        Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, `mw1.2xlarge`.
        """
        return pulumi.get(self, "environment_class")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        """
        The Execution Role ARN of the Amazon MWAA Environment
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name provided by duplo for Apache Airflow Environment.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key aws/airflow by default.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="lastUpdateds")
    def last_updateds(self) -> pulumi.Output[Sequence['outputs.AwsMwaaEnvironmentLastUpdated']]:
        return pulumi.get(self, "last_updateds")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Output['outputs.AwsMwaaEnvironmentLoggingConfiguration']:
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> pulumi.Output[int]:
        """
        The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`.
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> pulumi.Output[int]:
        """
        The minimum number of workers that you want to run in your environment.
        """
        return pulumi.get(self, "min_workers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Apache Airflow Environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> pulumi.Output[str]:
        """
        The plugins.zip file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> pulumi.Output[str]:
        """
        The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then `plugins_s3_object_version` is required.
        """
        return pulumi.get(self, "plugins_s3_path")

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> pulumi.Output[str]:
        """
        The requirements.txt file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> pulumi.Output[str]:
        """
        The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements*s3*object_version is required.
        """
        return pulumi.get(self, "requirements_s3_path")

    @property
    @pulumi.getter
    def schedulers(self) -> pulumi.Output[int]:
        """
        The number of schedulers that you want to run in your environment.
        """
        return pulumi.get(self, "schedulers")

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
        """
        return pulumi.get(self, "source_bucket_arn")

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> pulumi.Output[str]:
        """
        The startup script file version you want to use. If not set, latest s3 file version will be used.
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> pulumi.Output[str]:
        """
        The relative path to the startup script file on your Amazon S3 storage bucket. For example, startup_script.sh.
        """
        return pulumi.get(self, "startup_script_s3_path")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Amazon MWAA Environment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[str]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Managed Workflows Apache Airflow will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Amazon MWAA Environment to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the webserver should be accessible over the internet or via your specified VPC.  Defaults to `PUBLIC_ONLY`.
        """
        return pulumi.get(self, "webserver_access_mode")

    @property
    @pulumi.getter(name="webserverUrl")
    def webserver_url(self) -> pulumi.Output[str]:
        """
        The webserver URL of the MWAA Environment.
        """
        return pulumi.get(self, "webserver_url")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> pulumi.Output[str]:
        """
        Specifies the start date for the weekly maintenance window.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

