# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsRdsTagArgs', 'AwsRdsTag']

@pulumi.input_type
class AwsRdsTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a AwsRdsTag resource.
        :param pulumi.Input[str] key: The tag name.
        :param pulumi.Input[str] resource_id: The ID of the RDS resource to manage the tag for.
        :param pulumi.Input[str] resource_type: The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS tag will be created in.
        :param pulumi.Input[str] value: The value of the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The tag name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The ID of the RDS resource to manage the tag for.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the RDS tag will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _AwsRdsTagState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsRdsTag resources.
        :param pulumi.Input[str] key: The tag name.
        :param pulumi.Input[str] resource_id: The ID of the RDS resource to manage the tag for.
        :param pulumi.Input[str] resource_type: The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS tag will be created in.
        :param pulumi.Input[str] value: The value of the tag.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The tag name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the RDS resource to manage the tag for.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the RDS tag will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class AwsRdsTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsRdsTag` manages an AWS RDS tag in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Generate a random password.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=myapp.tenant_id,
            name="mydb",
            engine=1,
            engine_version="12.5",
            size="db.t3.medium",
            master_username="myuser",
            master_password=mypassword["result"],
            encrypt_storage=True)
        # Create RDS Tag for type "instance".
        tag = duplocloud.AwsRdsTag("tag",
            tenant_id=myapp.tenant_id,
            resource_type="instance",
            resource_id=mydb.identifier,
            key="CreatedBy",
            value="DuploCloud")
        ```

        ## Import

        Example: Importing an existing RDS Tag.

         - *TENANT_ID* is the tenant GUID.

         - *RESOURCE_TYPE* The type of the RDS resource, Valid vaues are - "cluster" and "instance".

         - *RESOURCE_ID* The RDS identifier.

         - *TAG_KEY* The tag name.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsRdsTag:AwsRdsTag tag1 *TENANT_ID*/*RESOURCE_TYPE*/*RESOURCE_ID*/*TAG_KEY*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: The tag name.
        :param pulumi.Input[str] resource_id: The ID of the RDS resource to manage the tag for.
        :param pulumi.Input[str] resource_type: The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS tag will be created in.
        :param pulumi.Input[str] value: The value of the tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsRdsTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsRdsTag` manages an AWS RDS tag in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Generate a random password.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=myapp.tenant_id,
            name="mydb",
            engine=1,
            engine_version="12.5",
            size="db.t3.medium",
            master_username="myuser",
            master_password=mypassword["result"],
            encrypt_storage=True)
        # Create RDS Tag for type "instance".
        tag = duplocloud.AwsRdsTag("tag",
            tenant_id=myapp.tenant_id,
            resource_type="instance",
            resource_id=mydb.identifier,
            key="CreatedBy",
            value="DuploCloud")
        ```

        ## Import

        Example: Importing an existing RDS Tag.

         - *TENANT_ID* is the tenant GUID.

         - *RESOURCE_TYPE* The type of the RDS resource, Valid vaues are - "cluster" and "instance".

         - *RESOURCE_ID* The RDS identifier.

         - *TAG_KEY* The tag name.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsRdsTag:AwsRdsTag tag1 *TENANT_ID*/*RESOURCE_TYPE*/*RESOURCE_ID*/*TAG_KEY*
        ```

        :param str resource_name: The name of the resource.
        :param AwsRdsTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsRdsTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsRdsTagArgs.__new__(AwsRdsTagArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(AwsRdsTag, __self__).__init__(
            'duplocloud:index/awsRdsTag:AwsRdsTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'AwsRdsTag':
        """
        Get an existing AwsRdsTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: The tag name.
        :param pulumi.Input[str] resource_id: The ID of the RDS resource to manage the tag for.
        :param pulumi.Input[str] resource_type: The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS tag will be created in.
        :param pulumi.Input[str] value: The value of the tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsRdsTagState.__new__(_AwsRdsTagState)

        __props__.__dict__["key"] = key
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value"] = value
        return AwsRdsTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The tag name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The ID of the RDS resource to manage the tag for.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        The type of the RDS resource to manage the tag for. Valid values are `cluster` and `instance`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the RDS tag will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value of the tag.
        """
        return pulumi.get(self, "value")

