# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsSnsTopicArgs', 'AwsSnsTopic']

@pulumi.input_type
class AwsSnsTopicArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 fifo_content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsSnsTopic resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SNS topic will be created in.
        :param pulumi.Input[bool] fifo_content_based_deduplication: Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        :param pulumi.Input[bool] fifo_topic: Whether the topic processes messages as fifo or not Defaults to `false`.
        :param pulumi.Input[str] kms_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if fifo_content_based_deduplication is not None:
            pulumi.set(__self__, "fifo_content_based_deduplication", fifo_content_based_deduplication)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the SNS topic will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="fifoContentBasedDeduplication")
    def fifo_content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        """
        return pulumi.get(self, "fifo_content_based_deduplication")

    @fifo_content_based_deduplication.setter
    def fifo_content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_content_based_deduplication", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the topic processes messages as fifo or not Defaults to `false`.
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AwsSnsTopicState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 fifo_content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsSnsTopic resources.
        :param pulumi.Input[str] arn: The ARN of the SNS topic.
        :param pulumi.Input[bool] fifo_content_based_deduplication: Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        :param pulumi.Input[bool] fifo_topic: Whether the topic processes messages as fifo or not Defaults to `false`.
        :param pulumi.Input[str] fullname: The full name of the SNS topic.
        :param pulumi.Input[str] kms_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SNS topic will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if fifo_content_based_deduplication is not None:
            pulumi.set(__self__, "fifo_content_based_deduplication", fifo_content_based_deduplication)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SNS topic.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="fifoContentBasedDeduplication")
    def fifo_content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        """
        return pulumi.get(self, "fifo_content_based_deduplication")

    @fifo_content_based_deduplication.setter
    def fifo_content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_content_based_deduplication", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the topic processes messages as fifo or not Defaults to `false`.
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the SNS topic.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the SNS topic will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsSnsTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fifo_content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsSnsTopic` manages a SNS topic in Duplo.

        ## Import

        Example: Importing an existing AWS SNS Topic

         - *TENANT_ID* is the tenant GUID

         - *ARN* The ARN of the created Amazon SNS Topic.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSnsTopic:AwsSnsTopic sns_topic *TENANT_ID*/*ARN*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] fifo_content_based_deduplication: Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        :param pulumi.Input[bool] fifo_topic: Whether the topic processes messages as fifo or not Defaults to `false`.
        :param pulumi.Input[str] kms_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SNS topic will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsSnsTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsSnsTopic` manages a SNS topic in Duplo.

        ## Import

        Example: Importing an existing AWS SNS Topic

         - *TENANT_ID* is the tenant GUID

         - *ARN* The ARN of the created Amazon SNS Topic.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSnsTopic:AwsSnsTopic sns_topic *TENANT_ID*/*ARN*
        ```

        :param str resource_name: The name of the resource.
        :param AwsSnsTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsSnsTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fifo_content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsSnsTopicArgs.__new__(AwsSnsTopicArgs)

            __props__.__dict__["fifo_content_based_deduplication"] = fifo_content_based_deduplication
            __props__.__dict__["fifo_topic"] = fifo_topic
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
        super(AwsSnsTopic, __self__).__init__(
            'duplocloud:index/awsSnsTopic:AwsSnsTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            fifo_content_based_deduplication: Optional[pulumi.Input[bool]] = None,
            fifo_topic: Optional[pulumi.Input[bool]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsSnsTopic':
        """
        Get an existing AwsSnsTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the SNS topic.
        :param pulumi.Input[bool] fifo_content_based_deduplication: Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        :param pulumi.Input[bool] fifo_topic: Whether the topic processes messages as fifo or not Defaults to `false`.
        :param pulumi.Input[str] fullname: The full name of the SNS topic.
        :param pulumi.Input[str] kms_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SNS topic will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsSnsTopicState.__new__(_AwsSnsTopicState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["fifo_content_based_deduplication"] = fifo_content_based_deduplication
        __props__.__dict__["fifo_topic"] = fifo_topic
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsSnsTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SNS topic.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fifoContentBasedDeduplication")
    def fifo_content_based_deduplication(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable content based deduplication for fifo type SNS topics Defaults to `false`.
        """
        return pulumi.get(self, "fifo_content_based_deduplication")

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the topic processes messages as fifo or not Defaults to `false`.
        """
        return pulumi.get(self, "fifo_topic")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the SNS topic.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the SNS topic will be created in.
        """
        return pulumi.get(self, "tenant_id")

