# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsSqsQueueArgs', 'AwsSqsQueue']

@pulumi.input_type
class AwsSqsQueueArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 dead_letter_queue_configuration: Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 message_retention_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AwsSqsQueue resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SQS queue will be created in.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO queues.
        :param pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs'] dead_letter_queue_configuration: SQS configuration for the SQS resource
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        :param pulumi.Input[int] delay_seconds: Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        :param pulumi.Input[bool] fifo_queue: Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        :param pulumi.Input[int] message_retention_seconds: The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        :param pulumi.Input[str] name: The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        :param pulumi.Input[int] visibility_timeout_seconds: The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if dead_letter_queue_configuration is not None:
            pulumi.set(__self__, "dead_letter_queue_configuration", dead_letter_queue_configuration)
        if deduplication_scope is not None:
            pulumi.set(__self__, "deduplication_scope", deduplication_scope)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if fifo_throughput_limit is not None:
            pulumi.set(__self__, "fifo_throughput_limit", fifo_throughput_limit)
        if message_retention_seconds is not None:
            pulumi.set(__self__, "message_retention_seconds", message_retention_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the SQS queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables content-based deduplication for FIFO queues.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="deadLetterQueueConfiguration")
    def dead_letter_queue_configuration(self) -> Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']]:
        """
        SQS configuration for the SQS resource
        """
        return pulumi.get(self, "dead_letter_queue_configuration")

    @dead_letter_queue_configuration.setter
    def dead_letter_queue_configuration(self, value: Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']]):
        pulumi.set(self, "dead_letter_queue_configuration", value)

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        """
        return pulumi.get(self, "deduplication_scope")

    @deduplication_scope.setter
    def deduplication_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deduplication_scope", value)

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_seconds", value)

    @property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_queue", value)

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @fifo_throughput_limit.setter
    def fifo_throughput_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fifo_throughput_limit", value)

    @property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        """
        return pulumi.get(self, "message_retention_seconds")

    @message_retention_seconds.setter
    def message_retention_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_retention_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


@pulumi.input_type
class _AwsSqsQueueState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 dead_letter_queue_configuration: Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 message_retention_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AwsSqsQueue resources.
        :param pulumi.Input[str] arn: The ARN of the SQS queue.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO queues.
        :param pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs'] dead_letter_queue_configuration: SQS configuration for the SQS resource
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        :param pulumi.Input[int] delay_seconds: Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        :param pulumi.Input[bool] fifo_queue: Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        :param pulumi.Input[str] fullname: The full name of the SQS queue.
        :param pulumi.Input[int] message_retention_seconds: The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        :param pulumi.Input[str] name: The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SQS queue will be created in.
        :param pulumi.Input[str] url: The URL for the created Amazon SQS queue.
        :param pulumi.Input[int] visibility_timeout_seconds: The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if dead_letter_queue_configuration is not None:
            pulumi.set(__self__, "dead_letter_queue_configuration", dead_letter_queue_configuration)
        if deduplication_scope is not None:
            pulumi.set(__self__, "deduplication_scope", deduplication_scope)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if fifo_throughput_limit is not None:
            pulumi.set(__self__, "fifo_throughput_limit", fifo_throughput_limit)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if message_retention_seconds is not None:
            pulumi.set(__self__, "message_retention_seconds", message_retention_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SQS queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables content-based deduplication for FIFO queues.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="deadLetterQueueConfiguration")
    def dead_letter_queue_configuration(self) -> Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']]:
        """
        SQS configuration for the SQS resource
        """
        return pulumi.get(self, "dead_letter_queue_configuration")

    @dead_letter_queue_configuration.setter
    def dead_letter_queue_configuration(self, value: Optional[pulumi.Input['AwsSqsQueueDeadLetterQueueConfigurationArgs']]):
        pulumi.set(self, "dead_letter_queue_configuration", value)

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        """
        return pulumi.get(self, "deduplication_scope")

    @deduplication_scope.setter
    def deduplication_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deduplication_scope", value)

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_seconds", value)

    @property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_queue", value)

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @fifo_throughput_limit.setter
    def fifo_throughput_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fifo_throughput_limit", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the SQS queue.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        """
        return pulumi.get(self, "message_retention_seconds")

    @message_retention_seconds.setter
    def message_retention_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_retention_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the SQS queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL for the created Amazon SQS queue.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


class AwsSqsQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 dead_letter_queue_configuration: Optional[pulumi.Input[Union['AwsSqsQueueDeadLetterQueueConfigurationArgs', 'AwsSqsQueueDeadLetterQueueConfigurationArgsDict']]] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 message_retention_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `AwsSqsQueue` manages a SQS queue in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sqs_queue = duplocloud.AwsSqsQueue("sqs_queue",
            tenant_id=myapp.tenant_id,
            name="duplo_queue",
            fifo_queue=True,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=True,
            delay_seconds=10)
        # SQS queue with dead letter queue configuration
        sqs_queue_with_dlq = duplocloud.AwsSqsQueue("sqs_queue_with_dlq",
            tenant_id=myapp.tenant_id,
            name="duplo_queue",
            fifo_queue=True,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=True,
            delay_seconds=10,
            dead_letter_queue_configuration={
                "target_sqs_dlq_name": sqs_queue.fullname,
                "max_message_receive_attempts": 5,
            })
        ```

        ## Import

        Example: Importing an existing AWS SQS Queue

         - *TENANT_ID* is the tenant GUID

         - *URL* The URL for the created Amazon SQS queue.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSqsQueue:AwsSqsQueue sqs_queue *TENANT_ID*/*URL*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO queues.
        :param pulumi.Input[Union['AwsSqsQueueDeadLetterQueueConfigurationArgs', 'AwsSqsQueueDeadLetterQueueConfigurationArgsDict']] dead_letter_queue_configuration: SQS configuration for the SQS resource
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        :param pulumi.Input[int] delay_seconds: Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        :param pulumi.Input[bool] fifo_queue: Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        :param pulumi.Input[int] message_retention_seconds: The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        :param pulumi.Input[str] name: The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SQS queue will be created in.
        :param pulumi.Input[int] visibility_timeout_seconds: The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsSqsQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsSqsQueue` manages a SQS queue in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sqs_queue = duplocloud.AwsSqsQueue("sqs_queue",
            tenant_id=myapp.tenant_id,
            name="duplo_queue",
            fifo_queue=True,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=True,
            delay_seconds=10)
        # SQS queue with dead letter queue configuration
        sqs_queue_with_dlq = duplocloud.AwsSqsQueue("sqs_queue_with_dlq",
            tenant_id=myapp.tenant_id,
            name="duplo_queue",
            fifo_queue=True,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=True,
            delay_seconds=10,
            dead_letter_queue_configuration={
                "target_sqs_dlq_name": sqs_queue.fullname,
                "max_message_receive_attempts": 5,
            })
        ```

        ## Import

        Example: Importing an existing AWS SQS Queue

         - *TENANT_ID* is the tenant GUID

         - *URL* The URL for the created Amazon SQS queue.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSqsQueue:AwsSqsQueue sqs_queue *TENANT_ID*/*URL*
        ```

        :param str resource_name: The name of the resource.
        :param AwsSqsQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsSqsQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 dead_letter_queue_configuration: Optional[pulumi.Input[Union['AwsSqsQueueDeadLetterQueueConfigurationArgs', 'AwsSqsQueueDeadLetterQueueConfigurationArgsDict']]] = None,
                 deduplication_scope: Optional[pulumi.Input[str]] = None,
                 delay_seconds: Optional[pulumi.Input[int]] = None,
                 fifo_queue: Optional[pulumi.Input[bool]] = None,
                 fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
                 message_retention_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsSqsQueueArgs.__new__(AwsSqsQueueArgs)

            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["dead_letter_queue_configuration"] = dead_letter_queue_configuration
            __props__.__dict__["deduplication_scope"] = deduplication_scope
            __props__.__dict__["delay_seconds"] = delay_seconds
            __props__.__dict__["fifo_queue"] = fifo_queue
            __props__.__dict__["fifo_throughput_limit"] = fifo_throughput_limit
            __props__.__dict__["message_retention_seconds"] = message_retention_seconds
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["url"] = None
        super(AwsSqsQueue, __self__).__init__(
            'duplocloud:index/awsSqsQueue:AwsSqsQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            content_based_deduplication: Optional[pulumi.Input[bool]] = None,
            dead_letter_queue_configuration: Optional[pulumi.Input[Union['AwsSqsQueueDeadLetterQueueConfigurationArgs', 'AwsSqsQueueDeadLetterQueueConfigurationArgsDict']]] = None,
            deduplication_scope: Optional[pulumi.Input[str]] = None,
            delay_seconds: Optional[pulumi.Input[int]] = None,
            fifo_queue: Optional[pulumi.Input[bool]] = None,
            fifo_throughput_limit: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            message_retention_seconds: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            visibility_timeout_seconds: Optional[pulumi.Input[int]] = None) -> 'AwsSqsQueue':
        """
        Get an existing AwsSqsQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the SQS queue.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO queues.
        :param pulumi.Input[Union['AwsSqsQueueDeadLetterQueueConfigurationArgs', 'AwsSqsQueueDeadLetterQueueConfigurationArgsDict']] dead_letter_queue_configuration: SQS configuration for the SQS resource
        :param pulumi.Input[str] deduplication_scope: Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        :param pulumi.Input[int] delay_seconds: Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        :param pulumi.Input[bool] fifo_queue: Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        :param pulumi.Input[str] fifo_throughput_limit: Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        :param pulumi.Input[str] fullname: The full name of the SQS queue.
        :param pulumi.Input[int] message_retention_seconds: The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        :param pulumi.Input[str] name: The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SQS queue will be created in.
        :param pulumi.Input[str] url: The URL for the created Amazon SQS queue.
        :param pulumi.Input[int] visibility_timeout_seconds: The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsSqsQueueState.__new__(_AwsSqsQueueState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["dead_letter_queue_configuration"] = dead_letter_queue_configuration
        __props__.__dict__["deduplication_scope"] = deduplication_scope
        __props__.__dict__["delay_seconds"] = delay_seconds
        __props__.__dict__["fifo_queue"] = fifo_queue
        __props__.__dict__["fifo_throughput_limit"] = fifo_throughput_limit
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["message_retention_seconds"] = message_retention_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["url"] = url
        __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
        return AwsSqsQueue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SQS queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[bool]:
        """
        Enables content-based deduplication for FIFO queues.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="deadLetterQueueConfiguration")
    def dead_letter_queue_configuration(self) -> pulumi.Output[Optional['outputs.AwsSqsQueueDeadLetterQueueConfiguration']]:
        """
        SQS configuration for the SQS resource
        """
        return pulumi.get(self, "dead_letter_queue_configuration")

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> pulumi.Output[str]:
        """
        Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue`.
        """
        return pulumi.get(self, "deduplication_scope")

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> pulumi.Output[int]:
        """
        Postpone the delivery of new messages to consumers for a number of seconds seconds range [0-900]
        """
        return pulumi.get(self, "delay_seconds")

    @property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
        """
        return pulumi.get(self, "fifo_queue")

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> pulumi.Output[str]:
        """
        Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the SQS queue.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="messageRetentionSeconds")
    def message_retention_seconds(self) -> pulumi.Output[int]:
        """
        The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days).
        """
        return pulumi.get(self, "message_retention_seconds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and have up to 80 characters long which is inclusive of duplo prefix (duploservices-{tenant_name}-) appended by the system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the SQS queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL for the created Amazon SQS queue.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> pulumi.Output[int]:
        """
        The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
        """
        return pulumi.get(self, "visibility_timeout_seconds")

