# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsSsmParameterArgs', 'AwsSsmParameter']

@pulumi.input_type
class AwsSsmParameterArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 allowed_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsSsmParameter resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SSM parameter will be created in.
        :param pulumi.Input[str] type: The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        :param pulumi.Input[str] value: The value of the SSM parameter.
        :param pulumi.Input[str] description: The description of the SSM parameter.
        :param pulumi.Input[str] name: The name of the SSM parameter.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if allowed_pattern is not None:
            pulumi.set(__self__, "allowed_pattern", allowed_pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the SSM parameter will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the SSM parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="allowedPattern")
    def allowed_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allowed_pattern")

    @allowed_pattern.setter
    def allowed_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_pattern", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the SSM parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSM parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AwsSsmParameterState:
    def __init__(__self__, *,
                 allowed_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 last_modified_date: Optional[pulumi.Input[str]] = None,
                 last_modified_user: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsSsmParameter resources.
        :param pulumi.Input[str] description: The description of the SSM parameter.
        :param pulumi.Input[str] name: The name of the SSM parameter.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SSM parameter will be created in.
        :param pulumi.Input[str] type: The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        :param pulumi.Input[str] value: The value of the SSM parameter.
        """
        if allowed_pattern is not None:
            pulumi.set(__self__, "allowed_pattern", allowed_pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if last_modified_date is not None:
            pulumi.set(__self__, "last_modified_date", last_modified_date)
        if last_modified_user is not None:
            pulumi.set(__self__, "last_modified_user", last_modified_user)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="allowedPattern")
    def allowed_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allowed_pattern")

    @allowed_pattern.setter
    def allowed_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_pattern", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the SSM parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_modified_date")

    @last_modified_date.setter
    def last_modified_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_date", value)

    @property
    @pulumi.getter(name="lastModifiedUser")
    def last_modified_user(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_modified_user")

    @last_modified_user.setter
    def last_modified_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_user", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSM parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the SSM parameter will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the SSM parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class AwsSsmParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsSsmParameter` manages an AWS SSM parameter in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        ssm_param = duplocloud.AwsSsmParameter("ssm_param",
            tenant_id=myapp.tenant_id,
            name="ssm_param",
            type="String",
            value="ssm_param_value")
        ```

        ## Import

        Example: Importing an existing AWS SSM Parameter

         - *TENANT_ID* is the tenant GUID

         - *NAME* The name for the created Amazon SSM Parameter.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSsmParameter:AwsSsmParameter ssm_param *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the SSM parameter.
        :param pulumi.Input[str] name: The name of the SSM parameter.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SSM parameter will be created in.
        :param pulumi.Input[str] type: The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        :param pulumi.Input[str] value: The value of the SSM parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsSsmParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsSsmParameter` manages an AWS SSM parameter in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        ssm_param = duplocloud.AwsSsmParameter("ssm_param",
            tenant_id=myapp.tenant_id,
            name="ssm_param",
            type="String",
            value="ssm_param_value")
        ```

        ## Import

        Example: Importing an existing AWS SSM Parameter

         - *TENANT_ID* is the tenant GUID

         - *NAME* The name for the created Amazon SSM Parameter.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsSsmParameter:AwsSsmParameter ssm_param *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsSsmParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsSsmParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsSsmParameterArgs.__new__(AwsSsmParameterArgs)

            __props__.__dict__["allowed_pattern"] = allowed_pattern
            __props__.__dict__["description"] = description
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
            __props__.__dict__["last_modified_date"] = None
            __props__.__dict__["last_modified_user"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AwsSsmParameter, __self__).__init__(
            'duplocloud:index/awsSsmParameter:AwsSsmParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_pattern: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            last_modified_date: Optional[pulumi.Input[str]] = None,
            last_modified_user: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'AwsSsmParameter':
        """
        Get an existing AwsSsmParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the SSM parameter.
        :param pulumi.Input[str] name: The name of the SSM parameter.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the SSM parameter will be created in.
        :param pulumi.Input[str] type: The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        :param pulumi.Input[str] value: The value of the SSM parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsSsmParameterState.__new__(_AwsSsmParameterState)

        __props__.__dict__["allowed_pattern"] = allowed_pattern
        __props__.__dict__["description"] = description
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["last_modified_date"] = last_modified_date
        __props__.__dict__["last_modified_user"] = last_modified_user
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return AwsSsmParameter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedPattern")
    def allowed_pattern(self) -> pulumi.Output[str]:
        return pulumi.get(self, "allowed_pattern")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the SSM parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> pulumi.Output[str]:
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter(name="lastModifiedUser")
    def last_modified_user(self) -> pulumi.Output[str]:
        return pulumi.get(self, "last_modified_user")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the SSM parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the SSM parameter will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the SSM parameter. Valid values are `String`, `StringList`, and `SecureString`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value of the SSM parameter.
        """
        return pulumi.get(self, "value")

