# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsTargetGroupAttributesArgs', 'AwsTargetGroupAttributes']

@pulumi.input_type
class AwsTargetGroupAttributesArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]] = None,
                 is_ecs_lb: Optional[pulumi.Input[bool]] = None,
                 is_passthrough_lb: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsTargetGroupAttributes resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws target group attributes will be created in.
        :param pulumi.Input[bool] is_ecs_lb: Whether or not to look up the LB via an ECS service name instead of replication controller name.
        :param pulumi.Input[bool] is_passthrough_lb: Whether or not to look up the LB via the LB name instead of replication controller name.
        :param pulumi.Input[int] port: Port used to connect with the target.
        :param pulumi.Input[str] role_name: Name of the ecs service or replication controller.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if is_ecs_lb is not None:
            pulumi.set(__self__, "is_ecs_lb", is_ecs_lb)
        if is_passthrough_lb is not None:
            pulumi.set(__self__, "is_passthrough_lb", is_passthrough_lb)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws target group attributes will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]]:
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="isEcsLb")
    def is_ecs_lb(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to look up the LB via an ECS service name instead of replication controller name.
        """
        return pulumi.get(self, "is_ecs_lb")

    @is_ecs_lb.setter
    def is_ecs_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ecs_lb", value)

    @property
    @pulumi.getter(name="isPassthroughLb")
    def is_passthrough_lb(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to look up the LB via the LB name instead of replication controller name.
        """
        return pulumi.get(self, "is_passthrough_lb")

    @is_passthrough_lb.setter
    def is_passthrough_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_passthrough_lb", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port used to connect with the target.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ecs service or replication controller.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_arn", value)


@pulumi.input_type
class _AwsTargetGroupAttributesState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]] = None,
                 is_ecs_lb: Optional[pulumi.Input[bool]] = None,
                 is_passthrough_lb: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsTargetGroupAttributes resources.
        :param pulumi.Input[bool] is_ecs_lb: Whether or not to look up the LB via an ECS service name instead of replication controller name.
        :param pulumi.Input[bool] is_passthrough_lb: Whether or not to look up the LB via the LB name instead of replication controller name.
        :param pulumi.Input[int] port: Port used to connect with the target.
        :param pulumi.Input[str] role_name: Name of the ecs service or replication controller.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws target group attributes will be created in.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if is_ecs_lb is not None:
            pulumi.set(__self__, "is_ecs_lb", is_ecs_lb)
        if is_passthrough_lb is not None:
            pulumi.set(__self__, "is_passthrough_lb", is_passthrough_lb)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]]:
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTargetGroupAttributesAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="isEcsLb")
    def is_ecs_lb(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to look up the LB via an ECS service name instead of replication controller name.
        """
        return pulumi.get(self, "is_ecs_lb")

    @is_ecs_lb.setter
    def is_ecs_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ecs_lb", value)

    @property
    @pulumi.getter(name="isPassthroughLb")
    def is_passthrough_lb(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to look up the LB via the LB name instead of replication controller name.
        """
        return pulumi.get(self, "is_passthrough_lb")

    @is_passthrough_lb.setter
    def is_passthrough_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_passthrough_lb", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port used to connect with the target.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ecs service or replication controller.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws target group attributes will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsTargetGroupAttributes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTargetGroupAttributesAttributeArgs', 'AwsTargetGroupAttributesAttributeArgsDict']]]]] = None,
                 is_ecs_lb: Optional[pulumi.Input[bool]] = None,
                 is_passthrough_lb: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsTargetGroupAttributes` manages an aws target group attributes in Duplo.

        ## Import

        Example: Importing an existing AWS target group attributes.

         - *TENANT_ID* is the tenant GUID

         - *TARGET_GROUP_ARN* is the ARN of target group.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTargetGroupAttributes:AwsTargetGroupAttributes tgAttrs *TENANT_ID*/*TARGET_GROUP_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_ecs_lb: Whether or not to look up the LB via an ECS service name instead of replication controller name.
        :param pulumi.Input[bool] is_passthrough_lb: Whether or not to look up the LB via the LB name instead of replication controller name.
        :param pulumi.Input[int] port: Port used to connect with the target.
        :param pulumi.Input[str] role_name: Name of the ecs service or replication controller.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws target group attributes will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsTargetGroupAttributesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsTargetGroupAttributes` manages an aws target group attributes in Duplo.

        ## Import

        Example: Importing an existing AWS target group attributes.

         - *TENANT_ID* is the tenant GUID

         - *TARGET_GROUP_ARN* is the ARN of target group.

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTargetGroupAttributes:AwsTargetGroupAttributes tgAttrs *TENANT_ID*/*TARGET_GROUP_ARN*
        ```

        :param str resource_name: The name of the resource.
        :param AwsTargetGroupAttributesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsTargetGroupAttributesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTargetGroupAttributesAttributeArgs', 'AwsTargetGroupAttributesAttributeArgsDict']]]]] = None,
                 is_ecs_lb: Optional[pulumi.Input[bool]] = None,
                 is_passthrough_lb: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsTargetGroupAttributesArgs.__new__(AwsTargetGroupAttributesArgs)

            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["is_ecs_lb"] = is_ecs_lb
            __props__.__dict__["is_passthrough_lb"] = is_passthrough_lb
            __props__.__dict__["port"] = port
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["target_group_arn"] = target_group_arn
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsTargetGroupAttributes, __self__).__init__(
            'duplocloud:index/awsTargetGroupAttributes:AwsTargetGroupAttributes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTargetGroupAttributesAttributeArgs', 'AwsTargetGroupAttributesAttributeArgsDict']]]]] = None,
            is_ecs_lb: Optional[pulumi.Input[bool]] = None,
            is_passthrough_lb: Optional[pulumi.Input[bool]] = None,
            port: Optional[pulumi.Input[int]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            target_group_arn: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsTargetGroupAttributes':
        """
        Get an existing AwsTargetGroupAttributes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_ecs_lb: Whether or not to look up the LB via an ECS service name instead of replication controller name.
        :param pulumi.Input[bool] is_passthrough_lb: Whether or not to look up the LB via the LB name instead of replication controller name.
        :param pulumi.Input[int] port: Port used to connect with the target.
        :param pulumi.Input[str] role_name: Name of the ecs service or replication controller.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws target group attributes will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsTargetGroupAttributesState.__new__(_AwsTargetGroupAttributesState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["is_ecs_lb"] = is_ecs_lb
        __props__.__dict__["is_passthrough_lb"] = is_passthrough_lb
        __props__.__dict__["port"] = port
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["target_group_arn"] = target_group_arn
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsTargetGroupAttributes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.AwsTargetGroupAttributesAttribute']]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="isEcsLb")
    def is_ecs_lb(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to look up the LB via an ECS service name instead of replication controller name.
        """
        return pulumi.get(self, "is_ecs_lb")

    @property
    @pulumi.getter(name="isPassthroughLb")
    def is_passthrough_lb(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to look up the LB via the LB name instead of replication controller name.
        """
        return pulumi.get(self, "is_passthrough_lb")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        Port used to connect with the target.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the ecs service or replication controller.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the Target Group.
        """
        return pulumi.get(self, "target_group_arn")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws target group attributes will be created in.
        """
        return pulumi.get(self, "tenant_id")

