# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsTimestreamwriteDatabaseArgs', 'AwsTimestreamwriteDatabase']

@pulumi.input_type
class AwsTimestreamwriteDatabaseArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]] = None):
        """
        The set of arguments for constructing a AwsTimestreamwriteDatabase resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Database will be created in.
        :param pulumi.Input[str] kms_key_id: The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        :param pulumi.Input[str] name: The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]] tags: Tags in key-value format.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Timestream Database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AwsTimestreamwriteDatabaseState:
    def __init__(__self__, *,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseAllTagArgs']]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specified_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 table_count: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsTimestreamwriteDatabase resources.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseAllTagArgs']]] all_tags: A complete list of tags for this time stream database, even ones not being managed by this resource.
        :param pulumi.Input[str] arn: The ARN that uniquely identifies this database.
        :param pulumi.Input[str] fullname: The full name of the Timestream Database.
        :param pulumi.Input[str] kms_key_id: The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        :param pulumi.Input[str] name: The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_tags: A list of tags being managed by this resource.
        :param pulumi.Input[int] table_count: The total number of tables found within the Timestream database.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Database will be created in.
        """
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if specified_tags is not None:
            pulumi.set(__self__, "specified_tags", specified_tags)
        if table_count is not None:
            pulumi.set(__self__, "table_count", table_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseAllTagArgs']]]]:
        """
        A complete list of tags for this time stream database, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseAllTagArgs']]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN that uniquely identifies this database.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Timestream Database.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="specifiedTags")
    def specified_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags being managed by this resource.
        """
        return pulumi.get(self, "specified_tags")

    @specified_tags.setter
    def specified_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_tags", value)

    @property
    @pulumi.getter(name="tableCount")
    def table_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of tables found within the Timestream database.
        """
        return pulumi.get(self, "table_count")

    @table_count.setter
    def table_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "table_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteDatabaseTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Timestream Database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsTimestreamwriteDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseTagArgs', 'AwsTimestreamwriteDatabaseTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsTimestreamwriteDatabase` manages an aws Timestream database resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        kms_key = duplocloud.get_tenant_aws_kms_key(tenant_id=tenant_id)
        timestreamwrite_database = duplocloud.AwsTimestreamwriteDatabase("timestreamwrite_database",
            tenant_id=tenant_id,
            name="test",
            kms_key_id=kms_key.key_arn)
        ```

        ## Import

        Example: Importing an existing AWS Timestream Database

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of AWS Timestream Database

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTimestreamwriteDatabase:AwsTimestreamwriteDatabase timestreamwrite_database *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] kms_key_id: The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        :param pulumi.Input[str] name: The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseTagArgs', 'AwsTimestreamwriteDatabaseTagArgsDict']]]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Database will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsTimestreamwriteDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsTimestreamwriteDatabase` manages an aws Timestream database resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        kms_key = duplocloud.get_tenant_aws_kms_key(tenant_id=tenant_id)
        timestreamwrite_database = duplocloud.AwsTimestreamwriteDatabase("timestreamwrite_database",
            tenant_id=tenant_id,
            name="test",
            kms_key_id=kms_key.key_arn)
        ```

        ## Import

        Example: Importing an existing AWS Timestream Database

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of AWS Timestream Database

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTimestreamwriteDatabase:AwsTimestreamwriteDatabase timestreamwrite_database *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsTimestreamwriteDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsTimestreamwriteDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseTagArgs', 'AwsTimestreamwriteDatabaseTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsTimestreamwriteDatabaseArgs.__new__(AwsTimestreamwriteDatabaseArgs)

            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["all_tags"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["specified_tags"] = None
            __props__.__dict__["table_count"] = None
        super(AwsTimestreamwriteDatabase, __self__).__init__(
            'duplocloud:index/awsTimestreamwriteDatabase:AwsTimestreamwriteDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseAllTagArgs', 'AwsTimestreamwriteDatabaseAllTagArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            specified_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            table_count: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseTagArgs', 'AwsTimestreamwriteDatabaseTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsTimestreamwriteDatabase':
        """
        Get an existing AwsTimestreamwriteDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseAllTagArgs', 'AwsTimestreamwriteDatabaseAllTagArgsDict']]]] all_tags: A complete list of tags for this time stream database, even ones not being managed by this resource.
        :param pulumi.Input[str] arn: The ARN that uniquely identifies this database.
        :param pulumi.Input[str] fullname: The full name of the Timestream Database.
        :param pulumi.Input[str] kms_key_id: The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        :param pulumi.Input[str] name: The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_tags: A list of tags being managed by this resource.
        :param pulumi.Input[int] table_count: The total number of tables found within the Timestream database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteDatabaseTagArgs', 'AwsTimestreamwriteDatabaseTagArgsDict']]]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Database will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsTimestreamwriteDatabaseState.__new__(_AwsTimestreamwriteDatabaseState)

        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["arn"] = arn
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["specified_tags"] = specified_tags
        __props__.__dict__["table_count"] = table_count
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsTimestreamwriteDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence['outputs.AwsTimestreamwriteDatabaseAllTag']]:
        """
        A complete list of tags for this time stream database, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN that uniquely identifies this database.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the Timestream Database.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the Timestream Database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="specifiedTags")
    def specified_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of tags being managed by this resource.
        """
        return pulumi.get(self, "specified_tags")

    @property
    @pulumi.getter(name="tableCount")
    def table_count(self) -> pulumi.Output[int]:
        """
        The total number of tables found within the Timestream database.
        """
        return pulumi.get(self, "table_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AwsTimestreamwriteDatabaseTag']]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Timestream Database will be created in.
        """
        return pulumi.get(self, "tenant_id")

