# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsTimestreamwriteTableArgs', 'AwsTimestreamwriteTable']

@pulumi.input_type
class AwsTimestreamwriteTableArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 magnetic_store_write_properties: Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_properties: Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AwsTimestreamwriteTable resource.
        :param pulumi.Input[str] database_name: The full name of the Timestream database.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Table will be created in.
        :param pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs'] magnetic_store_write_properties: Contains properties to set on the table when enabling magnetic store writes.
        :param pulumi.Input[str] name: The short name of the Timestream Table.
        :param pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs'] retention_properties: The retention duration for the memory store and magnetic store.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]] tags: Tags in key-value format.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if magnetic_store_write_properties is not None:
            pulumi.set(__self__, "magnetic_store_write_properties", magnetic_store_write_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_properties is not None:
            pulumi.set(__self__, "retention_properties", retention_properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The full name of the Timestream database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Timestream Table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="magneticStoreWriteProperties")
    def magnetic_store_write_properties(self) -> Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']]:
        """
        Contains properties to set on the table when enabling magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_write_properties")

    @magnetic_store_write_properties.setter
    def magnetic_store_write_properties(self, value: Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']]):
        pulumi.set(self, "magnetic_store_write_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Timestream Table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionProperties")
    def retention_properties(self) -> Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']]:
        """
        The retention duration for the memory store and magnetic store.
        """
        return pulumi.get(self, "retention_properties")

    @retention_properties.setter
    def retention_properties(self, value: Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']]):
        pulumi.set(self, "retention_properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.input_type
class _AwsTimestreamwriteTableState:
    def __init__(__self__, *,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableAllTagArgs']]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 magnetic_store_write_properties: Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_properties: Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']] = None,
                 specified_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AwsTimestreamwriteTable resources.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableAllTagArgs']]] all_tags: A complete list of tags for this time stream database, even ones not being managed by this resource.
        :param pulumi.Input[str] arn: The ARN that uniquely identifies this Table.
        :param pulumi.Input[str] database_name: The full name of the Timestream database.
        :param pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs'] magnetic_store_write_properties: Contains properties to set on the table when enabling magnetic store writes.
        :param pulumi.Input[str] name: The short name of the Timestream Table.
        :param pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs'] retention_properties: The retention duration for the memory store and magnetic store.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_tags: A list of tags being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Table will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if magnetic_store_write_properties is not None:
            pulumi.set(__self__, "magnetic_store_write_properties", magnetic_store_write_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_properties is not None:
            pulumi.set(__self__, "retention_properties", retention_properties)
        if specified_tags is not None:
            pulumi.set(__self__, "specified_tags", specified_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableAllTagArgs']]]]:
        """
        A complete list of tags for this time stream database, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableAllTagArgs']]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN that uniquely identifies this Table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Timestream database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="magneticStoreWriteProperties")
    def magnetic_store_write_properties(self) -> Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']]:
        """
        Contains properties to set on the table when enabling magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_write_properties")

    @magnetic_store_write_properties.setter
    def magnetic_store_write_properties(self, value: Optional[pulumi.Input['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs']]):
        pulumi.set(self, "magnetic_store_write_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Timestream Table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionProperties")
    def retention_properties(self) -> Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']]:
        """
        The retention duration for the memory store and magnetic store.
        """
        return pulumi.get(self, "retention_properties")

    @retention_properties.setter
    def retention_properties(self, value: Optional[pulumi.Input['AwsTimestreamwriteTableRetentionPropertiesArgs']]):
        pulumi.set(self, "retention_properties", value)

    @property
    @pulumi.getter(name="specifiedTags")
    def specified_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags being managed by this resource.
        """
        return pulumi.get(self, "specified_tags")

    @specified_tags.setter
    def specified_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsTimestreamwriteTableTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Timestream Table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


class AwsTimestreamwriteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 magnetic_store_write_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs', 'AwsTimestreamwriteTableMagneticStoreWritePropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableRetentionPropertiesArgs', 'AwsTimestreamwriteTableRetentionPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableTagArgs', 'AwsTimestreamwriteTableTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AwsTimestreamwriteTable` manages an aws Timestream Table resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "2a80c75d-9f58-4572-83b7-157b05bce259"
        kms_key = duplocloud.get_tenant_aws_kms_key(tenant_id=tenant_id)
        timestreamwrite_database = duplocloud.AwsTimestreamwriteDatabase("timestreamwrite_database",
            tenant_id=tenant_id,
            name="test",
            kms_key_id=kms_key.key_arn)
        timestreamwrite_database_tbl = duplocloud.AwsTimestreamwriteTable("timestreamwrite_database_tbl",
            tenant_id=tenant_id,
            database_name=timestreamwrite_database.fullname,
            name="example",
            retention_properties={
                "magnetic_store_retention_period_in_days": 30,
                "memory_store_retention_period_in_hours": 8,
            },
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
                "magnetic_store_rejected_data_location": {
                    "s3_configuration": {
                        "bucket_name": "test",
                        "encryption_option": "SSE_KMS",
                        "kms_key_id": kms_key.key_arn,
                    },
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS Timestream Table

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Timestream Table

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTimestreamwriteTable:AwsTimestreamwriteTable timestreamwrite_table *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The full name of the Timestream database.
        :param pulumi.Input[Union['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs', 'AwsTimestreamwriteTableMagneticStoreWritePropertiesArgsDict']] magnetic_store_write_properties: Contains properties to set on the table when enabling magnetic store writes.
        :param pulumi.Input[str] name: The short name of the Timestream Table.
        :param pulumi.Input[Union['AwsTimestreamwriteTableRetentionPropertiesArgs', 'AwsTimestreamwriteTableRetentionPropertiesArgsDict']] retention_properties: The retention duration for the memory store and magnetic store.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableTagArgs', 'AwsTimestreamwriteTableTagArgsDict']]]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Table will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsTimestreamwriteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsTimestreamwriteTable` manages an aws Timestream Table resource in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "2a80c75d-9f58-4572-83b7-157b05bce259"
        kms_key = duplocloud.get_tenant_aws_kms_key(tenant_id=tenant_id)
        timestreamwrite_database = duplocloud.AwsTimestreamwriteDatabase("timestreamwrite_database",
            tenant_id=tenant_id,
            name="test",
            kms_key_id=kms_key.key_arn)
        timestreamwrite_database_tbl = duplocloud.AwsTimestreamwriteTable("timestreamwrite_database_tbl",
            tenant_id=tenant_id,
            database_name=timestreamwrite_database.fullname,
            name="example",
            retention_properties={
                "magnetic_store_retention_period_in_days": 30,
                "memory_store_retention_period_in_hours": 8,
            },
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
                "magnetic_store_rejected_data_location": {
                    "s3_configuration": {
                        "bucket_name": "test",
                        "encryption_option": "SSE_KMS",
                        "kms_key_id": kms_key.key_arn,
                    },
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS Timestream Table

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Timestream Table

        # 

        ```sh
        $ pulumi import duplocloud:index/awsTimestreamwriteTable:AwsTimestreamwriteTable timestreamwrite_table *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsTimestreamwriteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsTimestreamwriteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 magnetic_store_write_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs', 'AwsTimestreamwriteTableMagneticStoreWritePropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableRetentionPropertiesArgs', 'AwsTimestreamwriteTableRetentionPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableTagArgs', 'AwsTimestreamwriteTableTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsTimestreamwriteTableArgs.__new__(AwsTimestreamwriteTableArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["magnetic_store_write_properties"] = magnetic_store_write_properties
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_properties"] = retention_properties
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["all_tags"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["specified_tags"] = None
        super(AwsTimestreamwriteTable, __self__).__init__(
            'duplocloud:index/awsTimestreamwriteTable:AwsTimestreamwriteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableAllTagArgs', 'AwsTimestreamwriteTableAllTagArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            magnetic_store_write_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs', 'AwsTimestreamwriteTableMagneticStoreWritePropertiesArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            retention_properties: Optional[pulumi.Input[Union['AwsTimestreamwriteTableRetentionPropertiesArgs', 'AwsTimestreamwriteTableRetentionPropertiesArgsDict']]] = None,
            specified_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableTagArgs', 'AwsTimestreamwriteTableTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_for_deployment: Optional[pulumi.Input[bool]] = None) -> 'AwsTimestreamwriteTable':
        """
        Get an existing AwsTimestreamwriteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableAllTagArgs', 'AwsTimestreamwriteTableAllTagArgsDict']]]] all_tags: A complete list of tags for this time stream database, even ones not being managed by this resource.
        :param pulumi.Input[str] arn: The ARN that uniquely identifies this Table.
        :param pulumi.Input[str] database_name: The full name of the Timestream database.
        :param pulumi.Input[Union['AwsTimestreamwriteTableMagneticStoreWritePropertiesArgs', 'AwsTimestreamwriteTableMagneticStoreWritePropertiesArgsDict']] magnetic_store_write_properties: Contains properties to set on the table when enabling magnetic store writes.
        :param pulumi.Input[str] name: The short name of the Timestream Table.
        :param pulumi.Input[Union['AwsTimestreamwriteTableRetentionPropertiesArgs', 'AwsTimestreamwriteTableRetentionPropertiesArgsDict']] retention_properties: The retention duration for the memory store and magnetic store.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_tags: A list of tags being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsTimestreamwriteTableTagArgs', 'AwsTimestreamwriteTableTagArgsDict']]]] tags: Tags in key-value format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Timestream Table will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsTimestreamwriteTableState.__new__(_AwsTimestreamwriteTableState)

        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["arn"] = arn
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["magnetic_store_write_properties"] = magnetic_store_write_properties
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_properties"] = retention_properties
        __props__.__dict__["specified_tags"] = specified_tags
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        return AwsTimestreamwriteTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence['outputs.AwsTimestreamwriteTableAllTag']]:
        """
        A complete list of tags for this time stream database, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN that uniquely identifies this Table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        The full name of the Timestream database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="magneticStoreWriteProperties")
    def magnetic_store_write_properties(self) -> pulumi.Output['outputs.AwsTimestreamwriteTableMagneticStoreWriteProperties']:
        """
        Contains properties to set on the table when enabling magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_write_properties")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the Timestream Table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionProperties")
    def retention_properties(self) -> pulumi.Output['outputs.AwsTimestreamwriteTableRetentionProperties']:
        """
        The retention duration for the memory store and magnetic store.
        """
        return pulumi.get(self, "retention_properties")

    @property
    @pulumi.getter(name="specifiedTags")
    def specified_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of tags being managed by this resource.
        """
        return pulumi.get(self, "specified_tags")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AwsTimestreamwriteTableTag']]]:
        """
        Tags in key-value format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Timestream Table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

