# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureAvailabilitySetArgs', 'AzureAvailabilitySet']

@pulumi.input_type
class AzureAvailabilitySetArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 platform_update_domain_count: Optional[pulumi.Input[int]] = None,
                 use_managed_disk: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureAvailabilitySet resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] name: The name for availability set
        :param pulumi.Input[int] platform_fault_domain_count: Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        :param pulumi.Input[int] platform_update_domain_count: Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        :param pulumi.Input[str] use_managed_disk: Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if platform_update_domain_count is not None:
            pulumi.set(__self__, "platform_update_domain_count", platform_update_domain_count)
        if use_managed_disk is not None:
            pulumi.set(__self__, "use_managed_disk", use_managed_disk)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for availability set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @property
    @pulumi.getter(name="platformUpdateDomainCount")
    def platform_update_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        """
        return pulumi.get(self, "platform_update_domain_count")

    @platform_update_domain_count.setter
    def platform_update_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "platform_update_domain_count", value)

    @property
    @pulumi.getter(name="useManagedDisk")
    def use_managed_disk(self) -> Optional[pulumi.Input[str]]:
        """
        Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        return pulumi.get(self, "use_managed_disk")

    @use_managed_disk.setter
    def use_managed_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_managed_disk", value)


@pulumi.input_type
class _AzureAvailabilitySetState:
    def __init__(__self__, *,
                 availability_set_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 platform_update_domain_count: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_managed_disk: Optional[pulumi.Input[str]] = None,
                 virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input['AzureAvailabilitySetVirtualMachineArgs']]]] = None):
        """
        Input properties used for looking up and filtering AzureAvailabilitySet resources.
        :param pulumi.Input[str] name: The name for availability set
        :param pulumi.Input[int] platform_fault_domain_count: Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        :param pulumi.Input[int] platform_update_domain_count: Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] use_managed_disk: Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        if availability_set_id is not None:
            pulumi.set(__self__, "availability_set_id", availability_set_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if platform_update_domain_count is not None:
            pulumi.set(__self__, "platform_update_domain_count", platform_update_domain_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_managed_disk is not None:
            pulumi.set(__self__, "use_managed_disk", use_managed_disk)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "availability_set_id")

    @availability_set_id.setter
    def availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for availability set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @property
    @pulumi.getter(name="platformUpdateDomainCount")
    def platform_update_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        """
        return pulumi.get(self, "platform_update_domain_count")

    @platform_update_domain_count.setter
    def platform_update_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "platform_update_domain_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="useManagedDisk")
    def use_managed_disk(self) -> Optional[pulumi.Input[str]]:
        """
        Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        return pulumi.get(self, "use_managed_disk")

    @use_managed_disk.setter
    def use_managed_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_managed_disk", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureAvailabilitySetVirtualMachineArgs']]]]:
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureAvailabilitySetVirtualMachineArgs']]]]):
        pulumi.set(self, "virtual_machines", value)


class AzureAvailabilitySet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 platform_update_domain_count: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_managed_disk: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureAvailabilitySet` manages logical groupings of VMs that enhance reliability by placing VMs in different fault domains to minimize correlated failures, offering improved VM-to-VM latency and high availability, with no extra cost beyond the VM instances themselves, though they may still be affected by shared infrastructure failures.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        st = duplocloud.AzureAvailabilitySet("st",
            tenant_id=myapp.tenant_id,
            name="availset",
            use_managed_disk="Aligned",
            platform_update_domain_count=5,
            platform_fault_domain_count=2)
        ```

        ## Import

        Example: Importing an existing Azure Availablitu set

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the  name of the Azure Availability set

        # 

        ```sh
        $ pulumi import duplocloud:index/azureAvailabilitySet:AzureAvailabilitySet this *TENANT_ID*/availability-set/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name for availability set
        :param pulumi.Input[int] platform_fault_domain_count: Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        :param pulumi.Input[int] platform_update_domain_count: Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] use_managed_disk: Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureAvailabilitySetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureAvailabilitySet` manages logical groupings of VMs that enhance reliability by placing VMs in different fault domains to minimize correlated failures, offering improved VM-to-VM latency and high availability, with no extra cost beyond the VM instances themselves, though they may still be affected by shared infrastructure failures.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        st = duplocloud.AzureAvailabilitySet("st",
            tenant_id=myapp.tenant_id,
            name="availset",
            use_managed_disk="Aligned",
            platform_update_domain_count=5,
            platform_fault_domain_count=2)
        ```

        ## Import

        Example: Importing an existing Azure Availablitu set

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the  name of the Azure Availability set

        # 

        ```sh
        $ pulumi import duplocloud:index/azureAvailabilitySet:AzureAvailabilitySet this *TENANT_ID*/availability-set/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureAvailabilitySetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureAvailabilitySetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 platform_update_domain_count: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_managed_disk: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureAvailabilitySetArgs.__new__(AzureAvailabilitySetArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
            __props__.__dict__["platform_update_domain_count"] = platform_update_domain_count
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_managed_disk"] = use_managed_disk
            __props__.__dict__["availability_set_id"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["virtual_machines"] = None
        super(AzureAvailabilitySet, __self__).__init__(
            'duplocloud:index/azureAvailabilitySet:AzureAvailabilitySet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_set_id: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
            platform_update_domain_count: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            use_managed_disk: Optional[pulumi.Input[str]] = None,
            virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureAvailabilitySetVirtualMachineArgs', 'AzureAvailabilitySetVirtualMachineArgsDict']]]]] = None) -> 'AzureAvailabilitySet':
        """
        Get an existing AzureAvailabilitySet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name for availability set
        :param pulumi.Input[int] platform_fault_domain_count: Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        :param pulumi.Input[int] platform_update_domain_count: Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] use_managed_disk: Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureAvailabilitySetState.__new__(_AzureAvailabilitySetState)

        __props__.__dict__["availability_set_id"] = availability_set_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
        __props__.__dict__["platform_update_domain_count"] = platform_update_domain_count
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["use_managed_disk"] = use_managed_disk
        __props__.__dict__["virtual_machines"] = virtual_machines
        return AzureAvailabilitySet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "availability_set_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for availability set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> pulumi.Output[Optional[int]]:
        """
        Specify platform fault domain count betweem 1-3, for availability set. Virtual machines in the same fault domain share a common power source and physical network switch. Defaults to `2`.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @property
    @pulumi.getter(name="platformUpdateDomainCount")
    def platform_update_domain_count(self) -> pulumi.Output[Optional[int]]:
        """
        Specify platform update domain count between 1-20, for availability set. Virtual machines in the same update domain will be restarted together during planned maintenance. Azure never restarts more than one update domain at a time. Defaults to `5`.
        """
        return pulumi.get(self, "platform_update_domain_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useManagedDisk")
    def use_managed_disk(self) -> pulumi.Output[Optional[str]]:
        """
        Set this to `Aligned` if you plan to create virtual machines in this availability set with managed disks. Defaults to `Classic`.
        """
        return pulumi.get(self, "use_managed_disk")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> pulumi.Output[Sequence['outputs.AzureAvailabilitySetVirtualMachine']]:
        return pulumi.get(self, "virtual_machines")

