# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureK8NodePoolArgs', 'AzureK8NodePool']

@pulumi.input_type
class AzureK8NodePoolArgs:
    def __init__(__self__, *,
                 desired_capacity: pulumi.Input[int],
                 max_capacity: pulumi.Input[int],
                 min_capacity: pulumi.Input[int],
                 tenant_id: pulumi.Input[str],
                 vm_size: pulumi.Input[str],
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 scale_priority: Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureK8NodePool resource.
        :param pulumi.Input[int] desired_capacity: The initial number of nodes which should exist within this Node.
        :param pulumi.Input[int] max_capacity: The maximum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[int] min_capacity: The minimum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure node pool will be created in.
        :param pulumi.Input[str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[str] allocation_tag: Allocation tags for this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: availability zones of node pool
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler.
        :param pulumi.Input[int] identifier: Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]] node_labels: Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool.
        :param pulumi.Input[int] os_disk_size_gb: The Agent Operating System disk size in GB.
        :param pulumi.Input[str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        :param pulumi.Input[str] os_type: Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        :param pulumi.Input['AzureK8NodePoolScalePriorityArgs'] scale_priority: specify the priority for scaling operations,supported priority Regular or Spot
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "vm_size", vm_size)
        if allocation_tag is not None:
            pulumi.set(__self__, "allocation_tag", allocation_tag)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if enable_auto_scaling is not None:
            pulumi.set(__self__, "enable_auto_scaling", enable_auto_scaling)
        if identifier is not None:
            warnings.warn("""identifier has been deprecated instead use name""", DeprecationWarning)
            pulumi.log.warn("""identifier is deprecated: identifier has been deprecated instead use name""")
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if scale_priority is not None:
            pulumi.set(__self__, "scale_priority", scale_priority)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Input[int]:
        """
        The initial number of nodes which should exist within this Node.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[int]:
        """
        The maximum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[int]:
        """
        The minimum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[str]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tags for this node pool.
        """
        return pulumi.get(self, "allocation_tag")

    @allocation_tag.setter
    def allocation_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tag", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        availability zones of node pool
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="enableAutoScaling")
    def enable_auto_scaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-scaler.
        """
        return pulumi.get(self, "enable_auto_scaling")

    @enable_auto_scaling.setter
    def enable_auto_scaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_scaling", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""identifier has been deprecated instead use name""")
    def identifier(self) -> Optional[pulumi.Input[int]]:
        """
        Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]]:
        """
        Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The Agent Operating System disk size in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_sku", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="scalePriority")
    def scale_priority(self) -> Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']]:
        """
        specify the priority for scaling operations,supported priority Regular or Spot
        """
        return pulumi.get(self, "scale_priority")

    @scale_priority.setter
    def scale_priority(self, value: Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']]):
        pulumi.set(self, "scale_priority", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureK8NodePoolState:
    def __init__(__self__, *,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[int]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 scale_priority: Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureK8NodePool resources.
        :param pulumi.Input[str] allocation_tag: Allocation tags for this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: availability zones of node pool
        :param pulumi.Input[int] desired_capacity: The initial number of nodes which should exist within this Node.
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler.
        :param pulumi.Input[int] identifier: Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        :param pulumi.Input[int] max_capacity: The maximum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[int] min_capacity: The minimum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]] node_labels: Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool.
        :param pulumi.Input[int] os_disk_size_gb: The Agent Operating System disk size in GB.
        :param pulumi.Input[str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        :param pulumi.Input[str] os_type: Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        :param pulumi.Input['AzureK8NodePoolScalePriorityArgs'] scale_priority: specify the priority for scaling operations,supported priority Regular or Spot
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure node pool will be created in.
        :param pulumi.Input[str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        if allocation_tag is not None:
            pulumi.set(__self__, "allocation_tag", allocation_tag)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if enable_auto_scaling is not None:
            pulumi.set(__self__, "enable_auto_scaling", enable_auto_scaling)
        if identifier is not None:
            warnings.warn("""identifier has been deprecated instead use name""", DeprecationWarning)
            pulumi.log.warn("""identifier is deprecated: identifier has been deprecated instead use name""")
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if scale_priority is not None:
            pulumi.set(__self__, "scale_priority", scale_priority)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tags for this node pool.
        """
        return pulumi.get(self, "allocation_tag")

    @allocation_tag.setter
    def allocation_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tag", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        availability zones of node pool
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of nodes which should exist within this Node.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="enableAutoScaling")
    def enable_auto_scaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-scaler.
        """
        return pulumi.get(self, "enable_auto_scaling")

    @enable_auto_scaling.setter
    def enable_auto_scaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_scaling", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""identifier has been deprecated instead use name""")
    def identifier(self) -> Optional[pulumi.Input[int]]:
        """
        Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]]:
        """
        Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureK8NodePoolNodeLabelArgs']]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The Agent Operating System disk size in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_sku", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="scalePriority")
    def scale_priority(self) -> Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']]:
        """
        specify the priority for scaling operations,supported priority Regular or Spot
        """
        return pulumi.get(self, "scale_priority")

    @scale_priority.setter
    def scale_priority(self, value: Optional[pulumi.Input['AzureK8NodePoolScalePriorityArgs']]):
        pulumi.set(self, "scale_priority", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureK8NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[int]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureK8NodePoolNodeLabelArgs', 'AzureK8NodePoolNodeLabelArgsDict']]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 scale_priority: Optional[pulumi.Input[Union['AzureK8NodePoolScalePriorityArgs', 'AzureK8NodePoolScalePriorityArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureK8NodePool` manages a Node Pool of Kubernetes Cluster in Duplo.

        ## Import

        Example: Importing an existing Azure K8S Node Pool

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duplo generated name of the the Azure K8S Node Pool

        # 

        ```sh
        $ pulumi import duplocloud:index/azureK8NodePool:AzureK8NodePool node_pool *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_tag: Allocation tags for this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: availability zones of node pool
        :param pulumi.Input[int] desired_capacity: The initial number of nodes which should exist within this Node.
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler.
        :param pulumi.Input[int] identifier: Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        :param pulumi.Input[int] max_capacity: The maximum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[int] min_capacity: The minimum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureK8NodePoolNodeLabelArgs', 'AzureK8NodePoolNodeLabelArgsDict']]]] node_labels: Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool.
        :param pulumi.Input[int] os_disk_size_gb: The Agent Operating System disk size in GB.
        :param pulumi.Input[str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        :param pulumi.Input[str] os_type: Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        :param pulumi.Input[Union['AzureK8NodePoolScalePriorityArgs', 'AzureK8NodePoolScalePriorityArgsDict']] scale_priority: specify the priority for scaling operations,supported priority Regular or Spot
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure node pool will be created in.
        :param pulumi.Input[str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureK8NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureK8NodePool` manages a Node Pool of Kubernetes Cluster in Duplo.

        ## Import

        Example: Importing an existing Azure K8S Node Pool

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duplo generated name of the the Azure K8S Node Pool

        # 

        ```sh
        $ pulumi import duplocloud:index/azureK8NodePool:AzureK8NodePool node_pool *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureK8NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureK8NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[int]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureK8NodePoolNodeLabelArgs', 'AzureK8NodePoolNodeLabelArgsDict']]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 scale_priority: Optional[pulumi.Input[Union['AzureK8NodePoolScalePriorityArgs', 'AzureK8NodePoolScalePriorityArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureK8NodePoolArgs.__new__(AzureK8NodePoolArgs)

            __props__.__dict__["allocation_tag"] = allocation_tag
            __props__.__dict__["availability_zones"] = availability_zones
            if desired_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'desired_capacity'")
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["enable_auto_scaling"] = enable_auto_scaling
            __props__.__dict__["identifier"] = identifier
            if max_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'max_capacity'")
            __props__.__dict__["max_capacity"] = max_capacity
            if min_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'min_capacity'")
            __props__.__dict__["min_capacity"] = min_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["node_labels"] = node_labels
            __props__.__dict__["node_taints"] = node_taints
            __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
            __props__.__dict__["os_sku"] = os_sku
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["scale_priority"] = scale_priority
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if vm_size is None and not opts.urn:
                raise TypeError("Missing required property 'vm_size'")
            __props__.__dict__["vm_size"] = vm_size
            __props__.__dict__["wait_until_ready"] = wait_until_ready
        super(AzureK8NodePool, __self__).__init__(
            'duplocloud:index/azureK8NodePool:AzureK8NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_tag: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            desired_capacity: Optional[pulumi.Input[int]] = None,
            enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[int]] = None,
            max_capacity: Optional[pulumi.Input[int]] = None,
            min_capacity: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureK8NodePoolNodeLabelArgs', 'AzureK8NodePoolNodeLabelArgsDict']]]]] = None,
            node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_disk_size_gb: Optional[pulumi.Input[int]] = None,
            os_sku: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            scale_priority: Optional[pulumi.Input[Union['AzureK8NodePoolScalePriorityArgs', 'AzureK8NodePoolScalePriorityArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vm_size: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureK8NodePool':
        """
        Get an existing AzureK8NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_tag: Allocation tags for this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: availability zones of node pool
        :param pulumi.Input[int] desired_capacity: The initial number of nodes which should exist within this Node.
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler.
        :param pulumi.Input[int] identifier: Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        :param pulumi.Input[int] max_capacity: The maximum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[int] min_capacity: The minimum number of nodes which should exist within this Node Pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureK8NodePoolNodeLabelArgs', 'AzureK8NodePoolNodeLabelArgsDict']]]] node_labels: Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool.
        :param pulumi.Input[int] os_disk_size_gb: The Agent Operating System disk size in GB.
        :param pulumi.Input[str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        :param pulumi.Input[str] os_type: Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        :param pulumi.Input[Union['AzureK8NodePoolScalePriorityArgs', 'AzureK8NodePoolScalePriorityArgsDict']] scale_priority: specify the priority for scaling operations,supported priority Regular or Spot
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure node pool will be created in.
        :param pulumi.Input[str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureK8NodePoolState.__new__(_AzureK8NodePoolState)

        __props__.__dict__["allocation_tag"] = allocation_tag
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["enable_auto_scaling"] = enable_auto_scaling
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["min_capacity"] = min_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["node_labels"] = node_labels
        __props__.__dict__["node_taints"] = node_taints
        __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
        __props__.__dict__["os_sku"] = os_sku
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["scale_priority"] = scale_priority
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vm_size"] = vm_size
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureK8NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> pulumi.Output[str]:
        """
        Allocation tags for this node pool.
        """
        return pulumi.get(self, "allocation_tag")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        availability zones of node pool
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[int]:
        """
        The initial number of nodes which should exist within this Node.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="enableAutoScaling")
    def enable_auto_scaling(self) -> pulumi.Output[bool]:
        """
        Whether to enable auto-scaler.
        """
        return pulumi.get(self, "enable_auto_scaling")

    @property
    @pulumi.getter
    @_utilities.deprecated("""identifier has been deprecated instead use name""")
    def identifier(self) -> pulumi.Output[int]:
        """
        Node pool identifier. This field is deprecated, Please use `name` instead. identifier has been deprecated instead use name
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[int]:
        """
        The maximum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Output[int]:
        """
        The minimum number of nodes which should exist within this Node Pool.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> pulumi.Output[Sequence['outputs.AzureK8NodePoolNodeLabel']]:
        """
        Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool.
        """
        return pulumi.get(self, "node_taints")

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> pulumi.Output[int]:
        """
        The Agent Operating System disk size in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> pulumi.Output[str]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `Ubuntu`, `Windows2019` and `Windows2022`
        """
        return pulumi.get(self, "os_sku")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the OS used by the agent pool. Possible values are `Linux`, `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="scalePriority")
    def scale_priority(self) -> pulumi.Output['outputs.AzureK8NodePoolScalePriority']:
        """
        specify the priority for scaling operations,supported priority Regular or Spot
        """
        return pulumi.get(self, "scale_priority")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Output[str]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

