# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureLogAnalyticsWorkspaceArgs', 'AzureLogAnalyticsWorkspace']

@pulumi.input_type
class AzureLogAnalyticsWorkspaceArgs:
    def __init__(__self__, *,
                 infra_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureLogAnalyticsWorkspace resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "infra_name", infra_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureLogAnalyticsWorkspaceState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_network_access_for_ingestion: Optional[pulumi.Input[str]] = None,
                 public_network_access_for_query: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureLogAnalyticsWorkspace resources.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_for_ingestion is not None:
            pulumi.set(__self__, "public_network_access_for_ingestion", public_network_access_for_ingestion)
        if public_network_access_for_query is not None:
            pulumi.set(__self__, "public_network_access_for_query", public_network_access_for_query)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessForIngestion")
    def public_network_access_for_ingestion(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_network_access_for_ingestion")

    @public_network_access_for_ingestion.setter
    def public_network_access_for_ingestion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access_for_ingestion", value)

    @property
    @pulumi.getter(name="publicNetworkAccessForQuery")
    def public_network_access_for_query(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_network_access_for_query")

    @public_network_access_for_query.setter
    def public_network_access_for_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access_for_query", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureLogAnalyticsWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureLogAnalyticsWorkspace` manages an Azure Log Analytics Workspace in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        log_analytics_workspace = duplocloud.AzureLogAnalyticsWorkspace("log_analytics_workspace",
            infra_name="demo",
            resource_group_name="duploinfra-demo",
            name="test")
        ```

        ## Import

        Example: Importing an existing Azure Log Analytics Workspace

         - *INFRA_NAME* is the name of duplo infra.

         - *NAME* is the name of the Log Analytics Workspace

        # 

        ```sh
        $ pulumi import duplocloud:index/azureLogAnalyticsWorkspace:AzureLogAnalyticsWorkspace log_analytics_workspace *INFRA_NAME*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureLogAnalyticsWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureLogAnalyticsWorkspace` manages an Azure Log Analytics Workspace in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        log_analytics_workspace = duplocloud.AzureLogAnalyticsWorkspace("log_analytics_workspace",
            infra_name="demo",
            resource_group_name="duploinfra-demo",
            name="test")
        ```

        ## Import

        Example: Importing an existing Azure Log Analytics Workspace

         - *INFRA_NAME* is the name of duplo infra.

         - *NAME* is the name of the Log Analytics Workspace

        # 

        ```sh
        $ pulumi import duplocloud:index/azureLogAnalyticsWorkspace:AzureLogAnalyticsWorkspace log_analytics_workspace *INFRA_NAME*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureLogAnalyticsWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureLogAnalyticsWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureLogAnalyticsWorkspaceArgs.__new__(AzureLogAnalyticsWorkspaceArgs)

            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["azure_id"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["public_network_access_for_ingestion"] = None
            __props__.__dict__["public_network_access_for_query"] = None
            __props__.__dict__["retention_in_days"] = None
            __props__.__dict__["sku"] = None
        super(AzureLogAnalyticsWorkspace, __self__).__init__(
            'duplocloud:index/azureLogAnalyticsWorkspace:AzureLogAnalyticsWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            public_network_access_for_ingestion: Optional[pulumi.Input[str]] = None,
            public_network_access_for_query: Optional[pulumi.Input[str]] = None,
            resource_group_name: Optional[pulumi.Input[str]] = None,
            retention_in_days: Optional[pulumi.Input[int]] = None,
            sku: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureLogAnalyticsWorkspace':
        """
        Get an existing AzureLogAnalyticsWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureLogAnalyticsWorkspaceState.__new__(_AzureLogAnalyticsWorkspaceState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_for_ingestion"] = public_network_access_for_ingestion
        __props__.__dict__["public_network_access_for_query"] = public_network_access_for_query
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["sku"] = sku
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureLogAnalyticsWorkspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessForIngestion")
    def public_network_access_for_ingestion(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_network_access_for_ingestion")

    @property
    @pulumi.getter(name="publicNetworkAccessForQuery")
    def public_network_access_for_query(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_network_access_for_query")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[str]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[int]:
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[str]:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Log Analytics Workspace to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

