# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureMssqlDatabaseArgs', 'AzureMssqlDatabase']

@pulumi.input_type
class AzureMssqlDatabaseArgs:
    def __init__(__self__, *,
                 server_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 collation: Optional[pulumi.Input[str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']] = None):
        """
        The set of arguments for constructing a AzureMssqlDatabase resource.
        :param pulumi.Input[str] server_name: The name of the MS SQL Server on which to create the database.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql database will be created in.
        :param pulumi.Input[str] collation: Specifies the collation of the database.
        :param pulumi.Input[str] elastic_pool_id: Specifies the id of the elastic pool containing this database.
        :param pulumi.Input[str] name: The name of the MS SQL Database.
        """
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if elastic_pool_id is not None:
            pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the MS SQL Server on which to create the database.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure mssql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the collation of the database.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the id of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @elastic_pool_id.setter
    def elastic_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_pool_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MS SQL Database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class _AzureMssqlDatabaseState:
    def __init__(__self__, *,
                 collation: Optional[pulumi.Input[str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureMssqlDatabase resources.
        :param pulumi.Input[str] collation: Specifies the collation of the database.
        :param pulumi.Input[str] elastic_pool_id: Specifies the id of the elastic pool containing this database.
        :param pulumi.Input[str] name: The name of the MS SQL Database.
        :param pulumi.Input[str] server_name: The name of the MS SQL Server on which to create the database.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql database will be created in.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if elastic_pool_id is not None:
            pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the collation of the database.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the id of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @elastic_pool_id.setter
    def elastic_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_pool_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MS SQL Database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MS SQL Server on which to create the database.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['AzureMssqlDatabaseSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure mssql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AzureMssqlDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[Union['AzureMssqlDatabaseSkuArgs', 'AzureMssqlDatabaseSkuArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureMssqlDatabase` manages an azure mssql database in Duplo.

        ## Import

        Example: Importing an existing Azure MS SQL databse

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the short name of the Azure MS SQL Server

         - *DB_NAME* is the short name of the Azure MS SQL Database

        ```sh
        $ pulumi import duplocloud:index/azureMssqlDatabase:AzureMssqlDatabase myMsSqlDb *TENANT_ID*/*SERVER_NAME*/*DB_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collation: Specifies the collation of the database.
        :param pulumi.Input[str] elastic_pool_id: Specifies the id of the elastic pool containing this database.
        :param pulumi.Input[str] name: The name of the MS SQL Database.
        :param pulumi.Input[str] server_name: The name of the MS SQL Server on which to create the database.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql database will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureMssqlDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureMssqlDatabase` manages an azure mssql database in Duplo.

        ## Import

        Example: Importing an existing Azure MS SQL databse

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the short name of the Azure MS SQL Server

         - *DB_NAME* is the short name of the Azure MS SQL Database

        ```sh
        $ pulumi import duplocloud:index/azureMssqlDatabase:AzureMssqlDatabase myMsSqlDb *TENANT_ID*/*SERVER_NAME*/*DB_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureMssqlDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureMssqlDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[Union['AzureMssqlDatabaseSkuArgs', 'AzureMssqlDatabaseSkuArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureMssqlDatabaseArgs.__new__(AzureMssqlDatabaseArgs)

            __props__.__dict__["collation"] = collation
            __props__.__dict__["elastic_pool_id"] = elastic_pool_id
            __props__.__dict__["name"] = name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["sku"] = sku
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AzureMssqlDatabase, __self__).__init__(
            'duplocloud:index/azureMssqlDatabase:AzureMssqlDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collation: Optional[pulumi.Input[str]] = None,
            elastic_pool_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            server_name: Optional[pulumi.Input[str]] = None,
            sku: Optional[pulumi.Input[Union['AzureMssqlDatabaseSkuArgs', 'AzureMssqlDatabaseSkuArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AzureMssqlDatabase':
        """
        Get an existing AzureMssqlDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collation: Specifies the collation of the database.
        :param pulumi.Input[str] elastic_pool_id: Specifies the id of the elastic pool containing this database.
        :param pulumi.Input[str] name: The name of the MS SQL Database.
        :param pulumi.Input[str] server_name: The name of the MS SQL Server on which to create the database.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql database will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureMssqlDatabaseState.__new__(_AzureMssqlDatabaseState)

        __props__.__dict__["collation"] = collation
        __props__.__dict__["elastic_pool_id"] = elastic_pool_id
        __props__.__dict__["name"] = name
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tenant_id"] = tenant_id
        return AzureMssqlDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def collation(self) -> pulumi.Output[str]:
        """
        Specifies the collation of the database.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the id of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the MS SQL Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The name of the MS SQL Server on which to create the database.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional['outputs.AzureMssqlDatabaseSku']]:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure mssql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

