# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureMssqlElasticpoolArgs', 'AzureMssqlElasticpool']

@pulumi.input_type
class AzureMssqlElasticpoolArgs:
    def __init__(__self__, *,
                 server_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']] = None):
        """
        The set of arguments for constructing a AzureMssqlElasticpool resource.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the elastic pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql elastic pool will be created in.
        :param pulumi.Input[str] name: The name of the MS SQL elastic pool.
        """
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the SQL Server on which to create the elastic pool.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MS SQL elastic pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class _AzureMssqlElasticpoolState:
    def __init__(__self__, *,
                 elastic_pool_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureMssqlElasticpool resources.
        :param pulumi.Input[str] elastic_pool_id: The ID of the MS SQL Elastic Pool.
        :param pulumi.Input[str] name: The name of the MS SQL elastic pool.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the elastic pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        if elastic_pool_id is not None:
            pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the MS SQL Elastic Pool.
        """
        return pulumi.get(self, "elastic_pool_id")

    @elastic_pool_id.setter
    def elastic_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_pool_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MS SQL elastic pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL Server on which to create the elastic pool.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['AzureMssqlElasticpoolSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AzureMssqlElasticpool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[Union['AzureMssqlElasticpoolSkuArgs', 'AzureMssqlElasticpoolSkuArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureMssqlElasticpool` manages an azure mssql elastic pool in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_elasticpool = duplocloud.AzureMssqlElasticpool("mssql_elasticpool",
            tenant_id=myapp.tenant_id,
            name="mssql-ep",
            server_name="mysqlserver",
            sku={
                "name": "StandardPool",
                "capacity": 50,
            })
        ```

        ## Import

        Example: Importing an existing Azure MS SQL databse

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the short name of the Azure MS SQL Server

         - *EP_NAME* is the short name of the Azure MS SQL Elastic Pool

        ```sh
        $ pulumi import duplocloud:index/azureMssqlElasticpool:AzureMssqlElasticpool myMsSqlEP *TENANT_ID*/*SERVER_NAME*/*EP_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the MS SQL elastic pool.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the elastic pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureMssqlElasticpoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureMssqlElasticpool` manages an azure mssql elastic pool in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_elasticpool = duplocloud.AzureMssqlElasticpool("mssql_elasticpool",
            tenant_id=myapp.tenant_id,
            name="mssql-ep",
            server_name="mysqlserver",
            sku={
                "name": "StandardPool",
                "capacity": 50,
            })
        ```

        ## Import

        Example: Importing an existing Azure MS SQL databse

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the short name of the Azure MS SQL Server

         - *EP_NAME* is the short name of the Azure MS SQL Elastic Pool

        ```sh
        $ pulumi import duplocloud:index/azureMssqlElasticpool:AzureMssqlElasticpool myMsSqlEP *TENANT_ID*/*SERVER_NAME*/*EP_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureMssqlElasticpoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureMssqlElasticpoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[Union['AzureMssqlElasticpoolSkuArgs', 'AzureMssqlElasticpoolSkuArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureMssqlElasticpoolArgs.__new__(AzureMssqlElasticpoolArgs)

            __props__.__dict__["name"] = name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["sku"] = sku
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["elastic_pool_id"] = None
        super(AzureMssqlElasticpool, __self__).__init__(
            'duplocloud:index/azureMssqlElasticpool:AzureMssqlElasticpool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elastic_pool_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            server_name: Optional[pulumi.Input[str]] = None,
            sku: Optional[pulumi.Input[Union['AzureMssqlElasticpoolSkuArgs', 'AzureMssqlElasticpoolSkuArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AzureMssqlElasticpool':
        """
        Get an existing AzureMssqlElasticpool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] elastic_pool_id: The ID of the MS SQL Elastic Pool.
        :param pulumi.Input[str] name: The name of the MS SQL elastic pool.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the elastic pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureMssqlElasticpoolState.__new__(_AzureMssqlElasticpoolState)

        __props__.__dict__["elastic_pool_id"] = elastic_pool_id
        __props__.__dict__["name"] = name
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tenant_id"] = tenant_id
        return AzureMssqlElasticpool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> pulumi.Output[str]:
        """
        The ID of the MS SQL Elastic Pool.
        """
        return pulumi.get(self, "elastic_pool_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the MS SQL elastic pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The name of the SQL Server on which to create the elastic pool.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional['outputs.AzureMssqlElasticpoolSku']]:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure mssql elastic pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

