# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureMssqlServerArgs', 'AzureMssqlServer']

@pulumi.input_type
class AzureMssqlServerArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureMssqlServer resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql server will be created in.
        :param pulumi.Input[str] version: The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        :param pulumi.Input[str] administrator_login: The Administrator Login for the  MS sql Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the MS sql Server.
        :param pulumi.Input[str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        :param pulumi.Input[str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        :param pulumi.Input[str] public_network_access: Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "version", version)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure mssql server will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[str]]:
        """
        The Administrator Login for the  MS sql Server.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[str]]:
        """
        The Password associated with the `administrator_login` for the MS sql Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[str]]:
        """
        Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureMssqlServerState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureMssqlServer resources.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the  MS sql Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the MS sql Server.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the Azure SQL Server.
        :param pulumi.Input[str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        :param pulumi.Input[str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        :param pulumi.Input[str] public_network_access: Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql server will be created in.
        :param pulumi.Input[str] version: The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[str]]:
        """
        The Administrator Login for the  MS sql Server.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[str]]:
        """
        The Password associated with the `administrator_login` for the MS sql Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name of the Azure SQL Server.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[str]]:
        """
        Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure mssql server will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureMssqlServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureMssqlServer` manages an azure mssql server in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_server = duplocloud.AzureMssqlServer("mssql_server",
            tenant_id=myapp.tenant_id,
            name="mssql-test",
            administrator_login="testroot",
            administrator_login_password="P@ssword12345",
            version="12.0",
            minimum_tls_version="1.2")
        ```

        ## Import

        Example: Importing an existing Azure MS SQL Server

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure MS SQL Server

        # 

        ```sh
        $ pulumi import duplocloud:index/azureMssqlServer:AzureMssqlServer myMsSqlServer *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the  MS sql Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the MS sql Server.
        :param pulumi.Input[str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        :param pulumi.Input[str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        :param pulumi.Input[str] public_network_access: Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql server will be created in.
        :param pulumi.Input[str] version: The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureMssqlServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureMssqlServer` manages an azure mssql server in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_server = duplocloud.AzureMssqlServer("mssql_server",
            tenant_id=myapp.tenant_id,
            name="mssql-test",
            administrator_login="testroot",
            administrator_login_password="P@ssword12345",
            version="12.0",
            minimum_tls_version="1.2")
        ```

        ## Import

        Example: Importing an existing Azure MS SQL Server

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure MS SQL Server

        # 

        ```sh
        $ pulumi import duplocloud:index/azureMssqlServer:AzureMssqlServer myMsSqlServer *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureMssqlServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureMssqlServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureMssqlServerArgs.__new__(AzureMssqlServerArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["tags"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AzureMssqlServer, __self__).__init__(
            'duplocloud:index/azureMssqlServer:AzureMssqlServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[str]] = None,
            administrator_login_password: Optional[pulumi.Input[str]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            minimum_tls_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            public_network_access: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureMssqlServer':
        """
        Get an existing AzureMssqlServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the  MS sql Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the MS sql Server.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the Azure SQL Server.
        :param pulumi.Input[str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        :param pulumi.Input[str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        :param pulumi.Input[str] public_network_access: Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure mssql server will be created in.
        :param pulumi.Input[str] version: The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureMssqlServerState.__new__(_AzureMssqlServerState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureMssqlServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[str]:
        """
        The Administrator Login for the  MS sql Server.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[Optional[str]]:
        """
        The Password associated with the `administrator_login` for the MS sql Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name of the Azure SQL Server.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[str]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` and `1.2`.
        """
        return pulumi.get(self, "minimum_tls_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[str]:
        """
        Whether public network access is enabled or disabled for this server. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure mssql server will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version for the new server. Valid values are: `2.0` (for v11 server) and `12.0` (for v12 server).
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

