# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureNetworkSecurityRuleArgs', 'AzureNetworkSecurityRule']

@pulumi.input_type
class AzureNetworkSecurityRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[str],
                 destination_rule_type: pulumi.Input[int],
                 direction: pulumi.Input[str],
                 infra_name: pulumi.Input[str],
                 network_security_group_name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 source_rule_type: pulumi.Input[int],
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureNetworkSecurityRule resource.
        :param pulumi.Input[str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[int] destination_rule_type: Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        :param pulumi.Input[str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to.
        :param pulumi.Input[int] priority: Specifies the priority of the rule.
        :param pulumi.Input[str] protocol: Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        :param pulumi.Input[int] source_rule_type: Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        :param pulumi.Input[str] destination_address_prefix: CIDR or destination IP range or * to match any IP.
        :param pulumi.Input[str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[str] name: The name of the security group rule.
        :param pulumi.Input[str] source_address_prefix: CIDR or source IP range or * to match any IP.
        :param pulumi.Input[str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "destination_rule_type", destination_rule_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "infra_name", infra_name)
        pulumi.set(__self__, "network_security_group_name", network_security_group_name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_rule_type", source_rule_type)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[str]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[str]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="destinationRuleType")
    def destination_rule_type(self) -> pulumi.Input[int]:
        """
        Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "destination_rule_type")

    @destination_rule_type.setter
    def destination_rule_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "destination_rule_type", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> pulumi.Input[str]:
        """
        The name of the Network Security Group that we want to attach the rule to.
        """
        return pulumi.get(self, "network_security_group_name")

    @network_security_group_name.setter
    def network_security_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_security_group_name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Specifies the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceRuleType")
    def source_rule_type(self) -> pulumi.Input[int]:
        """
        Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "source_rule_type")

    @source_rule_type.setter
    def source_rule_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "source_rule_type", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR or destination IP range or * to match any IP.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security group rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR or source IP range or * to match any IP.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)


@pulumi.input_type
class _AzureNetworkSecurityRuleState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 destination_rule_type: Optional[pulumi.Input[int]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_group_name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 source_rule_type: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AzureNetworkSecurityRule resources.
        :param pulumi.Input[str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[str] destination_address_prefix: CIDR or destination IP range or * to match any IP.
        :param pulumi.Input[str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] destination_rule_type: Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        :param pulumi.Input[str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[str] fullname: The fullname of the security group rule.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: The name of the security group rule.
        :param pulumi.Input[str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to.
        :param pulumi.Input[int] priority: Specifies the priority of the rule.
        :param pulumi.Input[str] protocol: Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        :param pulumi.Input[str] source_address_prefix: CIDR or source IP range or * to match any IP.
        :param pulumi.Input[str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] source_rule_type: Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_rule_type is not None:
            pulumi.set(__self__, "destination_rule_type", destination_rule_type)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_name is not None:
            pulumi.set(__self__, "network_security_group_name", network_security_group_name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_rule_type is not None:
            pulumi.set(__self__, "source_rule_type", source_rule_type)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR or destination IP range or * to match any IP.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter(name="destinationRuleType")
    def destination_rule_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "destination_rule_type")

    @destination_rule_type.setter
    def destination_rule_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_rule_type", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The fullname of the security group rule.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security group rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Network Security Group that we want to attach the rule to.
        """
        return pulumi.get(self, "network_security_group_name")

    @network_security_group_name.setter
    def network_security_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_security_group_name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR or source IP range or * to match any IP.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="sourceRuleType")
    def source_rule_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "source_rule_type")

    @source_rule_type.setter
    def source_rule_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_rule_type", value)


class AzureNetworkSecurityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 destination_rule_type: Optional[pulumi.Input[int]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_group_name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 source_rule_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `AzureNetworkSecurityRule` manages an Azure security group rule in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        security_rule = duplocloud.AzureNetworkSecurityRule("security_rule",
            infra_name="demo",
            network_security_group_name="duploinfra-sub01",
            name="test-sg-rule",
            source_rule_type=0,
            destination_rule_type=0,
            protocol="tcp",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="49.207.178.47/32",
            destination_address_prefix="*",
            access="Allow",
            priority=200,
            direction="Inbound")
        ```

        ## Import

        Example: Importing an existing Azure Security Group Rule

         - *INFRA_NAME* is the Duplo Infra

         - *SG_FULL_NAME* is the fullname of the Security Group, Example- "duploinfra-<SG_SHORT_NAME>"

         - *RULE_FULL_NAME* is the fullname of the Security Group Rule

        # 

        ```sh
        $ pulumi import duplocloud:index/azureNetworkSecurityRule:AzureNetworkSecurityRule security_rule *INFRA_NAME*/*SG_FULL_NAME*/*RULE_FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[str] destination_address_prefix: CIDR or destination IP range or * to match any IP.
        :param pulumi.Input[str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] destination_rule_type: Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        :param pulumi.Input[str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: The name of the security group rule.
        :param pulumi.Input[str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to.
        :param pulumi.Input[int] priority: Specifies the priority of the rule.
        :param pulumi.Input[str] protocol: Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        :param pulumi.Input[str] source_address_prefix: CIDR or source IP range or * to match any IP.
        :param pulumi.Input[str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] source_rule_type: Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureNetworkSecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureNetworkSecurityRule` manages an Azure security group rule in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        security_rule = duplocloud.AzureNetworkSecurityRule("security_rule",
            infra_name="demo",
            network_security_group_name="duploinfra-sub01",
            name="test-sg-rule",
            source_rule_type=0,
            destination_rule_type=0,
            protocol="tcp",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="49.207.178.47/32",
            destination_address_prefix="*",
            access="Allow",
            priority=200,
            direction="Inbound")
        ```

        ## Import

        Example: Importing an existing Azure Security Group Rule

         - *INFRA_NAME* is the Duplo Infra

         - *SG_FULL_NAME* is the fullname of the Security Group, Example- "duploinfra-<SG_SHORT_NAME>"

         - *RULE_FULL_NAME* is the fullname of the Security Group Rule

        # 

        ```sh
        $ pulumi import duplocloud:index/azureNetworkSecurityRule:AzureNetworkSecurityRule security_rule *INFRA_NAME*/*SG_FULL_NAME*/*RULE_FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureNetworkSecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureNetworkSecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 destination_rule_type: Optional[pulumi.Input[int]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_group_name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 source_rule_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureNetworkSecurityRuleArgs.__new__(AzureNetworkSecurityRuleArgs)

            if access is None and not opts.urn:
                raise TypeError("Missing required property 'access'")
            __props__.__dict__["access"] = access
            __props__.__dict__["destination_address_prefix"] = destination_address_prefix
            __props__.__dict__["destination_port_range"] = destination_port_range
            if destination_rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_rule_type'")
            __props__.__dict__["destination_rule_type"] = destination_rule_type
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["name"] = name
            if network_security_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'network_security_group_name'")
            __props__.__dict__["network_security_group_name"] = network_security_group_name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["source_address_prefix"] = source_address_prefix
            __props__.__dict__["source_port_range"] = source_port_range
            if source_rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_rule_type'")
            __props__.__dict__["source_rule_type"] = source_rule_type
            __props__.__dict__["fullname"] = None
        super(AzureNetworkSecurityRule, __self__).__init__(
            'duplocloud:index/azureNetworkSecurityRule:AzureNetworkSecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            destination_address_prefix: Optional[pulumi.Input[str]] = None,
            destination_port_range: Optional[pulumi.Input[str]] = None,
            destination_rule_type: Optional[pulumi.Input[int]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_security_group_name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            source_address_prefix: Optional[pulumi.Input[str]] = None,
            source_port_range: Optional[pulumi.Input[str]] = None,
            source_rule_type: Optional[pulumi.Input[int]] = None) -> 'AzureNetworkSecurityRule':
        """
        Get an existing AzureNetworkSecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[str] destination_address_prefix: CIDR or destination IP range or * to match any IP.
        :param pulumi.Input[str] destination_port_range: Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] destination_rule_type: Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        :param pulumi.Input[str] direction: The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        :param pulumi.Input[str] fullname: The fullname of the security group rule.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] name: The name of the security group rule.
        :param pulumi.Input[str] network_security_group_name: The name of the Network Security Group that we want to attach the rule to.
        :param pulumi.Input[int] priority: Specifies the priority of the rule.
        :param pulumi.Input[str] protocol: Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        :param pulumi.Input[str] source_address_prefix: CIDR or source IP range or * to match any IP.
        :param pulumi.Input[str] source_port_range: Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        :param pulumi.Input[int] source_rule_type: Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureNetworkSecurityRuleState.__new__(_AzureNetworkSecurityRuleState)

        __props__.__dict__["access"] = access
        __props__.__dict__["destination_address_prefix"] = destination_address_prefix
        __props__.__dict__["destination_port_range"] = destination_port_range
        __props__.__dict__["destination_rule_type"] = destination_rule_type
        __props__.__dict__["direction"] = direction
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_security_group_name"] = network_security_group_name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source_address_prefix"] = source_address_prefix
        __props__.__dict__["source_port_range"] = source_port_range
        __props__.__dict__["source_rule_type"] = source_rule_type
        return AzureNetworkSecurityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[str]:
        """
        Specifies whether network traffic is allowed or denied. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        CIDR or destination IP range or * to match any IP.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> pulumi.Output[Optional[str]]:
        """
        Destination Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter(name="destinationRuleType")
    def destination_rule_type(self) -> pulumi.Output[int]:
        """
        Type of the destination security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "destination_rule_type")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        """
        The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are `Inbound` and `Outbound`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The fullname of the security group rule.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the security group rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroupName")
    def network_security_group_name(self) -> pulumi.Output[str]:
        """
        The name of the Network Security Group that we want to attach the rule to.
        """
        return pulumi.get(self, "network_security_group_name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Specifies the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Network protocol this rule applies to. Possible values include `tcp`, `udp`, `icmp`, `esp`, `ah` or `*` (which matches all).
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        CIDR or source IP range or * to match any IP.
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> pulumi.Output[Optional[str]]:
        """
        Source Port or Range. Integer or range between `0` and `65535` or `*` to match any.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="sourceRuleType")
    def source_rule_type(self) -> pulumi.Output[int]:
        """
        Type of the source security rule. Possible values include `0(IP Address)`, `1(Service Tag)`, `2(Application Security Group)`.
        """
        return pulumi.get(self, "source_rule_type")

