# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzurePostgresqlFlexibleDatabaseArgs', 'AzurePostgresqlFlexibleDatabase']

@pulumi.input_type
class AzurePostgresqlFlexibleDatabaseArgs:
    def __init__(__self__, *,
                 administrator_login: pulumi.Input[str],
                 administrator_login_password: pulumi.Input[str],
                 hardware: pulumi.Input[str],
                 service_tier: pulumi.Input[str],
                 subnet: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 backup_retention_days: Optional[pulumi.Input[int]] = None,
                 geo_redundant_backup: Optional[pulumi.Input[str]] = None,
                 high_availability: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_gb: Optional[pulumi.Input[int]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzurePostgresqlFlexibleDatabase resource.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the PostgreSQL Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[str] hardware: Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        :param pulumi.Input[str] service_tier: Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure postgresql database will be created in.
        :param pulumi.Input[str] version: Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        :param pulumi.Input[int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        :param pulumi.Input[str] geo_redundant_backup: Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        :param pulumi.Input[str] high_availability: High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        :param pulumi.Input[str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        :param pulumi.Input[int] storage_gb: Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "administrator_login", administrator_login)
        pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        pulumi.set(__self__, "hardware", hardware)
        pulumi.set(__self__, "service_tier", service_tier)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "version", version)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if geo_redundant_backup is not None:
            pulumi.set(__self__, "geo_redundant_backup", geo_redundant_backup)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Input[str]:
        """
        The Administrator Login for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: pulumi.Input[str]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Input[str]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter
    def hardware(self) -> pulumi.Input[str]:
        """
        Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        """
        return pulumi.get(self, "hardware")

    @hardware.setter
    def hardware(self, value: pulumi.Input[str]):
        pulumi.set(self, "hardware", value)

    @property
    @pulumi.getter(name="serviceTier")
    def service_tier(self) -> pulumi.Input[str]:
        """
        Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        """
        return pulumi.get(self, "service_tier")

    @service_tier.setter
    def service_tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_tier", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure postgresql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="geoRedundantBackup")
    def geo_redundant_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        """
        return pulumi.get(self, "geo_redundant_backup")

    @geo_redundant_backup.setter
    def geo_redundant_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_redundant_backup", value)

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input[str]]:
        """
        High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "high_availability", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_gb", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzurePostgresqlFlexibleDatabaseState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 backup_retention_days: Optional[pulumi.Input[int]] = None,
                 geo_redundant_backup: Optional[pulumi.Input[str]] = None,
                 hardware: Optional[pulumi.Input[str]] = None,
                 high_availability: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_tier: Optional[pulumi.Input[str]] = None,
                 storage_gb: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzurePostgresqlFlexibleDatabase resources.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the PostgreSQL Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        :param pulumi.Input[str] geo_redundant_backup: Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        :param pulumi.Input[str] hardware: Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        :param pulumi.Input[str] high_availability: High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        :param pulumi.Input[str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        :param pulumi.Input[str] service_tier: Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        :param pulumi.Input[int] storage_gb: Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure postgresql database will be created in.
        :param pulumi.Input[str] version: Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if geo_redundant_backup is not None:
            pulumi.set(__self__, "geo_redundant_backup", geo_redundant_backup)
        if hardware is not None:
            pulumi.set(__self__, "hardware", hardware)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_tier is not None:
            pulumi.set(__self__, "service_tier", service_tier)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[str]]:
        """
        The Administrator Login for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[str]]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_days", value)

    @property
    @pulumi.getter(name="geoRedundantBackup")
    def geo_redundant_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        """
        return pulumi.get(self, "geo_redundant_backup")

    @geo_redundant_backup.setter
    def geo_redundant_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_redundant_backup", value)

    @property
    @pulumi.getter
    def hardware(self) -> Optional[pulumi.Input[str]]:
        """
        Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        """
        return pulumi.get(self, "hardware")

    @hardware.setter
    def hardware(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hardware", value)

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input[str]]:
        """
        High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "high_availability", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceTier")
    def service_tier(self) -> Optional[pulumi.Input[str]]:
        """
        Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        """
        return pulumi.get(self, "service_tier")

    @service_tier.setter
    def service_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_tier", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_gb", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure postgresql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzurePostgresqlFlexibleDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 backup_retention_days: Optional[pulumi.Input[int]] = None,
                 geo_redundant_backup: Optional[pulumi.Input[str]] = None,
                 hardware: Optional[pulumi.Input[str]] = None,
                 high_availability: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_tier: Optional[pulumi.Input[str]] = None,
                 storage_gb: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzurePostgresqlFlexibleDatabase` manages an azure postgresql flexible  database in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        db = duplocloud.AzurePostgresqlFlexibleDatabase("db",
            tenant_id=myapp.tenant_id,
            name="psqlflex",
            service_tier="Burstable",
            hardware="Standard_B2ms",
            high_availability="Disabled",
            storage_gb=64,
            version="16",
            subnet="subnet",
            administrator_login="tftry",
            administrator_login_password="trynew#1",
            backup_retention_days=7,
            geo_redundant_backup="Enabled")
        ```

        ## Import

        Example: Importing an existing Azure PostgreSQL Database

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure PostgreSQL Database

        # 

        ```sh
        $ pulumi import duplocloud:index/azurePostgresqlFlexibleDatabase:AzurePostgresqlFlexibleDatabase myPostgreSQLDatabase *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the PostgreSQL Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        :param pulumi.Input[str] geo_redundant_backup: Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        :param pulumi.Input[str] hardware: Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        :param pulumi.Input[str] high_availability: High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        :param pulumi.Input[str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        :param pulumi.Input[str] service_tier: Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        :param pulumi.Input[int] storage_gb: Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure postgresql database will be created in.
        :param pulumi.Input[str] version: Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzurePostgresqlFlexibleDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzurePostgresqlFlexibleDatabase` manages an azure postgresql flexible  database in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        db = duplocloud.AzurePostgresqlFlexibleDatabase("db",
            tenant_id=myapp.tenant_id,
            name="psqlflex",
            service_tier="Burstable",
            hardware="Standard_B2ms",
            high_availability="Disabled",
            storage_gb=64,
            version="16",
            subnet="subnet",
            administrator_login="tftry",
            administrator_login_password="trynew#1",
            backup_retention_days=7,
            geo_redundant_backup="Enabled")
        ```

        ## Import

        Example: Importing an existing Azure PostgreSQL Database

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure PostgreSQL Database

        # 

        ```sh
        $ pulumi import duplocloud:index/azurePostgresqlFlexibleDatabase:AzurePostgresqlFlexibleDatabase myPostgreSQLDatabase *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzurePostgresqlFlexibleDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzurePostgresqlFlexibleDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[str]] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 backup_retention_days: Optional[pulumi.Input[int]] = None,
                 geo_redundant_backup: Optional[pulumi.Input[str]] = None,
                 hardware: Optional[pulumi.Input[str]] = None,
                 high_availability: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_tier: Optional[pulumi.Input[str]] = None,
                 storage_gb: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzurePostgresqlFlexibleDatabaseArgs.__new__(AzurePostgresqlFlexibleDatabaseArgs)

            if administrator_login is None and not opts.urn:
                raise TypeError("Missing required property 'administrator_login'")
            __props__.__dict__["administrator_login"] = administrator_login
            if administrator_login_password is None and not opts.urn:
                raise TypeError("Missing required property 'administrator_login_password'")
            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["backup_retention_days"] = backup_retention_days
            __props__.__dict__["geo_redundant_backup"] = geo_redundant_backup
            if hardware is None and not opts.urn:
                raise TypeError("Missing required property 'hardware'")
            __props__.__dict__["hardware"] = hardware
            __props__.__dict__["high_availability"] = high_availability
            __props__.__dict__["name"] = name
            if service_tier is None and not opts.urn:
                raise TypeError("Missing required property 'service_tier'")
            __props__.__dict__["service_tier"] = service_tier
            __props__.__dict__["storage_gb"] = storage_gb
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["location"] = None
            __props__.__dict__["tags"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AzurePostgresqlFlexibleDatabase, __self__).__init__(
            'duplocloud:index/azurePostgresqlFlexibleDatabase:AzurePostgresqlFlexibleDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[str]] = None,
            administrator_login_password: Optional[pulumi.Input[str]] = None,
            backup_retention_days: Optional[pulumi.Input[int]] = None,
            geo_redundant_backup: Optional[pulumi.Input[str]] = None,
            hardware: Optional[pulumi.Input[str]] = None,
            high_availability: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_tier: Optional[pulumi.Input[str]] = None,
            storage_gb: Optional[pulumi.Input[int]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzurePostgresqlFlexibleDatabase':
        """
        Get an existing AzurePostgresqlFlexibleDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] administrator_login: The Administrator Login for the PostgreSQL Server.
        :param pulumi.Input[str] administrator_login_password: The Password associated with the `administrator_login` for the PostgreSQL Server.
        :param pulumi.Input[int] backup_retention_days: Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        :param pulumi.Input[str] geo_redundant_backup: Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        :param pulumi.Input[str] hardware: Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        :param pulumi.Input[str] high_availability: High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        :param pulumi.Input[str] name: Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        :param pulumi.Input[str] service_tier: Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        :param pulumi.Input[int] storage_gb: Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure postgresql database will be created in.
        :param pulumi.Input[str] version: Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzurePostgresqlFlexibleDatabaseState.__new__(_AzurePostgresqlFlexibleDatabaseState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["backup_retention_days"] = backup_retention_days
        __props__.__dict__["geo_redundant_backup"] = geo_redundant_backup
        __props__.__dict__["hardware"] = hardware
        __props__.__dict__["high_availability"] = high_availability
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["service_tier"] = service_tier
        __props__.__dict__["storage_gb"] = storage_gb
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzurePostgresqlFlexibleDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[str]:
        """
        The Administrator Login for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[str]:
        """
        The Password associated with the `administrator_login` for the PostgreSQL Server.
        """
        return pulumi.get(self, "administrator_login_password")

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> pulumi.Output[int]:
        """
        Backup retention days for the server, supported values are between `7` and `35` days. Note: Updation allowed on updating with higher retention days value from current
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="geoRedundantBackup")
    def geo_redundant_backup(self) -> pulumi.Output[str]:
        """
        Turn Geo-redundant server backups Enabled/Disabled. To enable or disable geo*redundant*backup resource need to be recreated
        """
        return pulumi.get(self, "geo_redundant_backup")

    @property
    @pulumi.getter
    def hardware(self) -> pulumi.Output[str]:
        """
        Specify compute based on service tier by prepending Standard_ keyword from following document https://azure.microsoft.com/en-in/pricing/details/postgresql/flexible-server
        """
        return pulumi.get(self, "hardware")

    @property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> pulumi.Output[Optional[str]]:
        """
        High availability options— Disabled, SameZone, and ZoneRedundant — are applicable if the service tier is set to GeneralPurpose or MemoryOptimized. Defaults to `Disabled`.
        """
        return pulumi.get(self, "high_availability")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the PostgreSQL Server. Changing this forces a new resource to be created. This needs to be globally unique within Azure.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceTier")
    def service_tier(self) -> pulumi.Output[str]:
        """
        Specify service*tier among `Burstable`, `GeneralPurpose` or `MemoryOptimized`. Note: should disable high*availability before updating to Burstable
        """
        return pulumi.get(self, "service_tier")

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> pulumi.Output[int]:
        """
        Max storage allowed for a server. Possible values are `32`,`64`,`128`,`256`,`512`,`1024`,`2048`,`4096`,`8192`,`16384`,`32768` GB. Note: Updation allowed on updating with higher storage size from current
        """
        return pulumi.get(self, "storage_gb")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure postgresql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the version of PostgreSQL Flexible DB to use. Valid values are `16`,`15`,`14`,`13`,`12`,`11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until PostgreSQL Server instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

