# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzurePrivateEndpointArgs', 'AzurePrivateEndpoint']

@pulumi.input_type
class AzurePrivateEndpointArgs:
    def __init__(__self__, *,
                 private_link_service_connections: pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]],
                 subnet_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzurePrivateEndpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]] private_link_service_connections: Specifies private link service connections.
        :param pulumi.Input[str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure private endpoint will be created in.
        :param pulumi.Input[str] name: Specifies the Name of the Private Endpoint.
        """
        pulumi.set(__self__, "private_link_service_connections", private_link_service_connections)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="privateLinkServiceConnections")
    def private_link_service_connections(self) -> pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]]:
        """
        Specifies private link service connections.
        """
        return pulumi.get(self, "private_link_service_connections")

    @private_link_service_connections.setter
    def private_link_service_connections(self, value: pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]]):
        pulumi.set(self, "private_link_service_connections", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure private endpoint will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Name of the Private Endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AzurePrivateEndpointState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_service_connections: Optional[pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzurePrivateEndpoint resources.
        :param pulumi.Input[str] name: Specifies the Name of the Private Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]] private_link_service_connections: Specifies private link service connections.
        :param pulumi.Input[str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure private endpoint will be created in.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_service_connections is not None:
            pulumi.set(__self__, "private_link_service_connections", private_link_service_connections)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Name of the Private Endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkServiceConnections")
    def private_link_service_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]]]:
        """
        Specifies private link service connections.
        """
        return pulumi.get(self, "private_link_service_connections")

    @private_link_service_connections.setter
    def private_link_service_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzurePrivateEndpointPrivateLinkServiceConnectionArgs']]]]):
        pulumi.set(self, "private_link_service_connections", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure private endpoint will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AzurePrivateEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_service_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzurePrivateEndpointPrivateLinkServiceConnectionArgs', 'AzurePrivateEndpointPrivateLinkServiceConnectionArgsDict']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzurePrivateEndpoint` manages an azure private endpoint in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_server_private_endpoint = duplocloud.AzurePrivateEndpoint("mssql_server_private_endpoint",
            tenant_id=myapp.tenant_id,
            name="pe-duplo-tf",
            subnet_id="/subscriptions/<subscription-id>/resourceGroups/<resource-group>/providers/Microsoft.Network/virtualNetworks/tmerge/subnets/duploinfra-default",
            private_link_service_connections=[{
                "name": "pe-mssql",
                "private_connection_resource_id": "/subscriptions/<subscription-id>/resourceGroups/duploservices-jee556/providers/Microsoft.Sql/servers/thisistotestprivateendpoint",
                "group_ids": ["sqlServer"],
            }])
        storage_server_private_endpoint = duplocloud.AzurePrivateEndpoint("storage_server_private_endpoint",
            tenant_id=myapp.tenant_id,
            name="pe-duplo-tf-storage",
            subnet_id="/subscriptions/<subscription-id>/resourceGroups/<resource-group>/providers/Microsoft.Network/virtualNetworks/tmerge/subnets/duploinfra-default",
            private_link_service_connections=[{
                "name": "pe-storage",
                "private_connection_resource_id": "/subscriptions/<subscription-id>/resourceGroups/duploservices-jee556/providers/Microsoft.Storage/storageAccounts/letsfixprivateendpoint",
                "group_ids": ["Blob"],
            }])
        ```

        ## Import

        Example: Importing an existing Azure Private Endpoint

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the Azure  Private Endpoint

        # 

        ```sh
        $ pulumi import duplocloud:index/azurePrivateEndpoint:AzurePrivateEndpoint private_endpoint *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies the Name of the Private Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzurePrivateEndpointPrivateLinkServiceConnectionArgs', 'AzurePrivateEndpointPrivateLinkServiceConnectionArgsDict']]]] private_link_service_connections: Specifies private link service connections.
        :param pulumi.Input[str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure private endpoint will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzurePrivateEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzurePrivateEndpoint` manages an azure private endpoint in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mssql_server_private_endpoint = duplocloud.AzurePrivateEndpoint("mssql_server_private_endpoint",
            tenant_id=myapp.tenant_id,
            name="pe-duplo-tf",
            subnet_id="/subscriptions/<subscription-id>/resourceGroups/<resource-group>/providers/Microsoft.Network/virtualNetworks/tmerge/subnets/duploinfra-default",
            private_link_service_connections=[{
                "name": "pe-mssql",
                "private_connection_resource_id": "/subscriptions/<subscription-id>/resourceGroups/duploservices-jee556/providers/Microsoft.Sql/servers/thisistotestprivateendpoint",
                "group_ids": ["sqlServer"],
            }])
        storage_server_private_endpoint = duplocloud.AzurePrivateEndpoint("storage_server_private_endpoint",
            tenant_id=myapp.tenant_id,
            name="pe-duplo-tf-storage",
            subnet_id="/subscriptions/<subscription-id>/resourceGroups/<resource-group>/providers/Microsoft.Network/virtualNetworks/tmerge/subnets/duploinfra-default",
            private_link_service_connections=[{
                "name": "pe-storage",
                "private_connection_resource_id": "/subscriptions/<subscription-id>/resourceGroups/duploservices-jee556/providers/Microsoft.Storage/storageAccounts/letsfixprivateendpoint",
                "group_ids": ["Blob"],
            }])
        ```

        ## Import

        Example: Importing an existing Azure Private Endpoint

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the Azure  Private Endpoint

        # 

        ```sh
        $ pulumi import duplocloud:index/azurePrivateEndpoint:AzurePrivateEndpoint private_endpoint *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzurePrivateEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzurePrivateEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_service_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzurePrivateEndpointPrivateLinkServiceConnectionArgs', 'AzurePrivateEndpointPrivateLinkServiceConnectionArgsDict']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzurePrivateEndpointArgs.__new__(AzurePrivateEndpointArgs)

            __props__.__dict__["name"] = name
            if private_link_service_connections is None and not opts.urn:
                raise TypeError("Missing required property 'private_link_service_connections'")
            __props__.__dict__["private_link_service_connections"] = private_link_service_connections
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AzurePrivateEndpoint, __self__).__init__(
            'duplocloud:index/azurePrivateEndpoint:AzurePrivateEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_link_service_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzurePrivateEndpointPrivateLinkServiceConnectionArgs', 'AzurePrivateEndpointPrivateLinkServiceConnectionArgsDict']]]]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AzurePrivateEndpoint':
        """
        Get an existing AzurePrivateEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies the Name of the Private Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzurePrivateEndpointPrivateLinkServiceConnectionArgs', 'AzurePrivateEndpointPrivateLinkServiceConnectionArgsDict']]]] private_link_service_connections: Specifies private link service connections.
        :param pulumi.Input[str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure private endpoint will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzurePrivateEndpointState.__new__(_AzurePrivateEndpointState)

        __props__.__dict__["name"] = name
        __props__.__dict__["private_link_service_connections"] = private_link_service_connections
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tenant_id"] = tenant_id
        return AzurePrivateEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the Name of the Private Endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnections")
    def private_link_service_connections(self) -> pulumi.Output[Sequence['outputs.AzurePrivateEndpointPrivateLinkServiceConnection']]:
        """
        Specifies private link service connections.
        """
        return pulumi.get(self, "private_link_service_connections")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure private endpoint will be created in.
        """
        return pulumi.get(self, "tenant_id")

