# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureRedisCacheArgs', 'AzureRedisCache']

@pulumi.input_type
class AzureRedisCacheArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[int],
                 family: pulumi.Input[str],
                 sku_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 enable_non_ssl_port: Optional[pulumi.Input[bool]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureRedisCache resource.
        :param pulumi.Input[int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        :param pulumi.Input[str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure redis cache will be created in.
        :param pulumi.Input[bool] enable_non_ssl_port: Enable the non-SSL port (6379) Defaults to `false`.
        :param pulumi.Input[str] minimum_tls_version: The minimum TLS version.
        :param pulumi.Input[str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] redis_version: Redis version. Only major version needed. Valid values: `4`, `6`.
        :param pulumi.Input[int] shard_count: Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[str] subnet_id: Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if enable_non_ssl_port is not None:
            pulumi.set(__self__, "enable_non_ssl_port", enable_non_ssl_port)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[int]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> pulumi.Input[str]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[str]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[str]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure redis cache will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="enableNonSslPort")
    def enable_non_ssl_port(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the non-SSL port (6379) Defaults to `false`.
        """
        return pulumi.get(self, "enable_non_ssl_port")

    @enable_non_ssl_port.setter
    def enable_non_ssl_port(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_non_ssl_port", value)

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum TLS version.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[str]]:
        """
        Redis version. Only major version needed. Valid values: `4`, `6`.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redis_version", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureRedisCacheState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 enable_non_ssl_port: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 ssl_port: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureRedisCache resources.
        :param pulumi.Input[int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        :param pulumi.Input[bool] enable_non_ssl_port: Enable the non-SSL port (6379) Defaults to `false`.
        :param pulumi.Input[str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[str] minimum_tls_version: The minimum TLS version.
        :param pulumi.Input[str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] redis_version: Redis version. Only major version needed. Valid values: `4`, `6`.
        :param pulumi.Input[int] shard_count: Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[str] subnet_id: Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure redis cache will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if enable_non_ssl_port is not None:
            pulumi.set(__self__, "enable_non_ssl_port", enable_non_ssl_port)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if ssl_port is not None:
            pulumi.set(__self__, "ssl_port", ssl_port)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="enableNonSslPort")
    def enable_non_ssl_port(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the non-SSL port (6379) Defaults to `false`.
        """
        return pulumi.get(self, "enable_non_ssl_port")

    @enable_non_ssl_port.setter
    def enable_non_ssl_port(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_non_ssl_port", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum TLS version.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[str]]:
        """
        Redis version. Only major version needed. Valid values: `4`, `6`.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redis_version", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="sslPort")
    def ssl_port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "ssl_port")

    @ssl_port.setter
    def ssl_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_port", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure redis cache will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureRedisCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 enable_non_ssl_port: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureRedisCache` manages an Azure redis cache in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        my_cache = duplocloud.AzureRedisCache("myCache",
            tenant_id=myapp.tenant_id,
            name="cache-test",
            capacity=1,
            family="p",
            sku_name="Premium",
            subnet_id="/subscriptions/0c84b91e-95f5-409e-9cff-6c2e60affbb3/resourceGroups/duploinfra-demo/providers/Microsoft.Network/virtualNetworks/demo/subnets/duploinfra-default",
            enable_non_ssl_port=False,
            shard_count=1)
        ```

        ## Import

        Example: Importing an existing Azure Redis Cache

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Redis Cache

        # 

        ```sh
        $ pulumi import duplocloud:index/azureRedisCache:AzureRedisCache myRedisCache *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        :param pulumi.Input[bool] enable_non_ssl_port: Enable the non-SSL port (6379) Defaults to `false`.
        :param pulumi.Input[str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[str] minimum_tls_version: The minimum TLS version.
        :param pulumi.Input[str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] redis_version: Redis version. Only major version needed. Valid values: `4`, `6`.
        :param pulumi.Input[int] shard_count: Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[str] subnet_id: Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure redis cache will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureRedisCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureRedisCache` manages an Azure redis cache in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        my_cache = duplocloud.AzureRedisCache("myCache",
            tenant_id=myapp.tenant_id,
            name="cache-test",
            capacity=1,
            family="p",
            sku_name="Premium",
            subnet_id="/subscriptions/0c84b91e-95f5-409e-9cff-6c2e60affbb3/resourceGroups/duploinfra-demo/providers/Microsoft.Network/virtualNetworks/demo/subnets/duploinfra-default",
            enable_non_ssl_port=False,
            shard_count=1)
        ```

        ## Import

        Example: Importing an existing Azure Redis Cache

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Redis Cache

        # 

        ```sh
        $ pulumi import duplocloud:index/azureRedisCache:AzureRedisCache myRedisCache *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureRedisCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureRedisCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 enable_non_ssl_port: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureRedisCacheArgs.__new__(AzureRedisCacheArgs)

            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["enable_non_ssl_port"] = enable_non_ssl_port
            if family is None and not opts.urn:
                raise TypeError("Missing required property 'family'")
            __props__.__dict__["family"] = family
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["redis_version"] = redis_version
            __props__.__dict__["shard_count"] = shard_count
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["subnet_id"] = subnet_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["hostname"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["ssl_port"] = None
            __props__.__dict__["tags"] = None
        super(AzureRedisCache, __self__).__init__(
            'duplocloud:index/azureRedisCache:AzureRedisCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[int]] = None,
            enable_non_ssl_port: Optional[pulumi.Input[bool]] = None,
            family: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            minimum_tls_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            redis_version: Optional[pulumi.Input[str]] = None,
            shard_count: Optional[pulumi.Input[int]] = None,
            sku_name: Optional[pulumi.Input[str]] = None,
            ssl_port: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureRedisCache':
        """
        Get an existing AzureRedisCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        :param pulumi.Input[bool] enable_non_ssl_port: Enable the non-SSL port (6379) Defaults to `false`.
        :param pulumi.Input[str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[str] minimum_tls_version: The minimum TLS version.
        :param pulumi.Input[str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] redis_version: Redis version. Only major version needed. Valid values: `4`, `6`.
        :param pulumi.Input[int] shard_count: Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[str] subnet_id: Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure redis cache will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureRedisCacheState.__new__(_AzureRedisCacheState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["enable_non_ssl_port"] = enable_non_ssl_port
        __props__.__dict__["family"] = family
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["redis_version"] = redis_version
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["ssl_port"] = ssl_port
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureRedisCache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[int]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4`
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="enableNonSslPort")
    def enable_non_ssl_port(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable the non-SSL port (6379) Defaults to `false`.
        """
        return pulumi.get(self, "enable_non_ssl_port")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[str]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[Optional[str]]:
        """
        The minimum TLS version.
        """
        return pulumi.get(self, "minimum_tls_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> pulumi.Output[str]:
        """
        Redis version. Only major version needed. Valid values: `4`, `6`.
        """
        return pulumi.get(self, "redis_version")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[Optional[int]]:
        """
        Only available when using the Premium SKU The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[str]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="sslPort")
    def ssl_port(self) -> pulumi.Output[int]:
        return pulumi.get(self, "ssl_port")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        Only available when using the Premium SKU The ID of the Subnet within which the Redis Cache should be deployed.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure redis cache will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

