# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureSqlFirewallRuleArgs', 'AzureSqlFirewallRule']

@pulumi.input_type
class AzureSqlFirewallRuleArgs:
    def __init__(__self__, *,
                 end_ip_address: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 start_ip_address: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureSqlFirewallRule resource.
        :param pulumi.Input[str] end_ip_address: The ending IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the Firewall Rule.
        :param pulumi.Input[str] start_ip_address: The starting IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql firewall rule will be created in.
        :param pulumi.Input[str] name: The name of the firewall rule.
        """
        pulumi.set(__self__, "end_ip_address", end_ip_address)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "start_ip_address", start_ip_address)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endIpAddress")
    def end_ip_address(self) -> pulumi.Input[str]:
        """
        The ending IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "end_ip_address")

    @end_ip_address.setter
    def end_ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_ip_address", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the SQL Server on which to create the Firewall Rule.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="startIpAddress")
    def start_ip_address(self) -> pulumi.Input[str]:
        """
        The starting IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "start_ip_address")

    @start_ip_address.setter
    def start_ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_ip_address", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the sql firewall rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the firewall rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AzureSqlFirewallRuleState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 end_ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 start_ip_address: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureSqlFirewallRule resources.
        :param pulumi.Input[str] azure_id: The ID of the SQL firewall rule.
        :param pulumi.Input[str] end_ip_address: The ending IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] name: The name of the firewall rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the Firewall Rule.
        :param pulumi.Input[str] start_ip_address: The starting IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql firewall rule will be created in.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if end_ip_address is not None:
            pulumi.set(__self__, "end_ip_address", end_ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if start_ip_address is not None:
            pulumi.set(__self__, "start_ip_address", start_ip_address)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the SQL firewall rule.
        """
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter(name="endIpAddress")
    def end_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ending IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "end_ip_address")

    @end_ip_address.setter
    def end_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the firewall rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL Server on which to create the Firewall Rule.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="startIpAddress")
    def start_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The starting IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "start_ip_address")

    @start_ip_address.setter
    def start_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_ip_address", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the sql firewall rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AzureSqlFirewallRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 start_ip_address: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureSqlFirewallRule` allows you to manage an Azure SQL Firewall Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sql_firewall_rule = duplocloud.AzureSqlFirewallRule("sql_firewall_rule",
            tenant_id=myapp.tenant_id,
            name="test-rule",
            server_name="test-server",
            start_ip_address="10.0.17.62",
            end_ip_address="10.0.17.62")
        ```

        ## Import

        Example: Importing an existing Azure SQL server Firewall Rule

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the name of the Azure Sql server

         - *RULE_NAME* is the name of the Azure Sql server Firewall Rule

        ```sh
        $ pulumi import duplocloud:index/azureSqlFirewallRule:AzureSqlFirewallRule sql_firewall_rule *TENANT_ID*/*SERVER_NAME*/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] end_ip_address: The ending IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] name: The name of the firewall rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the Firewall Rule.
        :param pulumi.Input[str] start_ip_address: The starting IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql firewall rule will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureSqlFirewallRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureSqlFirewallRule` allows you to manage an Azure SQL Firewall Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sql_firewall_rule = duplocloud.AzureSqlFirewallRule("sql_firewall_rule",
            tenant_id=myapp.tenant_id,
            name="test-rule",
            server_name="test-server",
            start_ip_address="10.0.17.62",
            end_ip_address="10.0.17.62")
        ```

        ## Import

        Example: Importing an existing Azure SQL server Firewall Rule

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the name of the Azure Sql server

         - *RULE_NAME* is the name of the Azure Sql server Firewall Rule

        ```sh
        $ pulumi import duplocloud:index/azureSqlFirewallRule:AzureSqlFirewallRule sql_firewall_rule *TENANT_ID*/*SERVER_NAME*/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureSqlFirewallRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureSqlFirewallRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 start_ip_address: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureSqlFirewallRuleArgs.__new__(AzureSqlFirewallRuleArgs)

            if end_ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'end_ip_address'")
            __props__.__dict__["end_ip_address"] = end_ip_address
            __props__.__dict__["name"] = name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            if start_ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'start_ip_address'")
            __props__.__dict__["start_ip_address"] = start_ip_address
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["azure_id"] = None
        super(AzureSqlFirewallRule, __self__).__init__(
            'duplocloud:index/azureSqlFirewallRule:AzureSqlFirewallRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            end_ip_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            server_name: Optional[pulumi.Input[str]] = None,
            start_ip_address: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AzureSqlFirewallRule':
        """
        Get an existing AzureSqlFirewallRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_id: The ID of the SQL firewall rule.
        :param pulumi.Input[str] end_ip_address: The ending IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] name: The name of the firewall rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server on which to create the Firewall Rule.
        :param pulumi.Input[str] start_ip_address: The starting IP address to allow through the firewall for this rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql firewall rule will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureSqlFirewallRuleState.__new__(_AzureSqlFirewallRuleState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["end_ip_address"] = end_ip_address
        __props__.__dict__["name"] = name
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["start_ip_address"] = start_ip_address
        __props__.__dict__["tenant_id"] = tenant_id
        return AzureSqlFirewallRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        """
        The ID of the SQL firewall rule.
        """
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter(name="endIpAddress")
    def end_ip_address(self) -> pulumi.Output[str]:
        """
        The ending IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "end_ip_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the firewall rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The name of the SQL Server on which to create the Firewall Rule.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="startIpAddress")
    def start_ip_address(self) -> pulumi.Output[str]:
        """
        The starting IP address to allow through the firewall for this rule.
        """
        return pulumi.get(self, "start_ip_address")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the sql firewall rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

