# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureSqlVirtualNetworkRuleArgs', 'AzureSqlVirtualNetworkRule']

@pulumi.input_type
class AzureSqlVirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 server_name: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureSqlVirtualNetworkRule resource.
        :param pulumi.Input[str] server_name: The name of the SQL Server to which this SQL virtual network rule will be applied to.
        :param pulumi.Input[str] subnet_id: The ID of the subnet that the SQL server will be connected to.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql virtual network rule will be created in.
        :param pulumi.Input[bool] ignore_missing_vnet_service_endpoint: Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        :param pulumi.Input[str] name: The name of the SQL virtual network rule.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the SQL Server to which this SQL virtual network rule will be applied to.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of the subnet that the SQL server will be connected to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the sql virtual network rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL virtual network rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureSqlVirtualNetworkRuleState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureSqlVirtualNetworkRule resources.
        :param pulumi.Input[str] azure_id: The ID of the SQL virtual network rule.
        :param pulumi.Input[bool] ignore_missing_vnet_service_endpoint: Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        :param pulumi.Input[str] name: The name of the SQL virtual network rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server to which this SQL virtual network rule will be applied to.
        :param pulumi.Input[str] subnet_id: The ID of the subnet that the SQL server will be connected to.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql virtual network rule will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the SQL virtual network rule.
        """
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL virtual network rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL Server to which this SQL virtual network rule will be applied to.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnet that the SQL server will be connected to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the sql virtual network rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureSqlVirtualNetworkRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureSqlVirtualNetworkRule` allows you to add, update, or remove an Azure SQL server to a subnet of a virtual network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sql_vnet_rule = duplocloud.AzureSqlVirtualNetworkRule("sql_vnet_rule",
            tenant_id=myapp.tenant_id,
            name="test-rule",
            server_name="test-server",
            subnet_id="/subscriptions/0c84b91e-95f5-409e-9cff-6c2e60affbb3/resourceGroups/duploinfra-demo/providers/Microsoft.Network/virtualNetworks/demo/subnets/duploinfra-default",
            ignore_missing_vnet_service_endpoint=False)
        ```

        ## Import

        Example: Importing an existing Azure SQL server Vnet Rule

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the name of the Azure Sql server

         - *RULE_NAME* is the name of the Azure Sql server Vnet Rule

        ```sh
        $ pulumi import duplocloud:index/azureSqlVirtualNetworkRule:AzureSqlVirtualNetworkRule sql_vnet_rule *TENANT_ID*/*SERVER_NAME*/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] ignore_missing_vnet_service_endpoint: Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        :param pulumi.Input[str] name: The name of the SQL virtual network rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server to which this SQL virtual network rule will be applied to.
        :param pulumi.Input[str] subnet_id: The ID of the subnet that the SQL server will be connected to.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql virtual network rule will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureSqlVirtualNetworkRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureSqlVirtualNetworkRule` allows you to add, update, or remove an Azure SQL server to a subnet of a virtual network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        sql_vnet_rule = duplocloud.AzureSqlVirtualNetworkRule("sql_vnet_rule",
            tenant_id=myapp.tenant_id,
            name="test-rule",
            server_name="test-server",
            subnet_id="/subscriptions/0c84b91e-95f5-409e-9cff-6c2e60affbb3/resourceGroups/duploinfra-demo/providers/Microsoft.Network/virtualNetworks/demo/subnets/duploinfra-default",
            ignore_missing_vnet_service_endpoint=False)
        ```

        ## Import

        Example: Importing an existing Azure SQL server Vnet Rule

         - *TENANT_ID* is the tenant GUID

         - *SERVER_NAME* is the name of the Azure Sql server

         - *RULE_NAME* is the name of the Azure Sql server Vnet Rule

        ```sh
        $ pulumi import duplocloud:index/azureSqlVirtualNetworkRule:AzureSqlVirtualNetworkRule sql_vnet_rule *TENANT_ID*/*SERVER_NAME*/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureSqlVirtualNetworkRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureSqlVirtualNetworkRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureSqlVirtualNetworkRuleArgs.__new__(AzureSqlVirtualNetworkRuleArgs)

            __props__.__dict__["ignore_missing_vnet_service_endpoint"] = ignore_missing_vnet_service_endpoint
            __props__.__dict__["name"] = name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["azure_id"] = None
        super(AzureSqlVirtualNetworkRule, __self__).__init__(
            'duplocloud:index/azureSqlVirtualNetworkRule:AzureSqlVirtualNetworkRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            server_name: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureSqlVirtualNetworkRule':
        """
        Get an existing AzureSqlVirtualNetworkRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_id: The ID of the SQL virtual network rule.
        :param pulumi.Input[bool] ignore_missing_vnet_service_endpoint: Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        :param pulumi.Input[str] name: The name of the SQL virtual network rule.
        :param pulumi.Input[str] server_name: The name of the SQL Server to which this SQL virtual network rule will be applied to.
        :param pulumi.Input[str] subnet_id: The ID of the subnet that the SQL server will be connected to.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the sql virtual network rule will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureSqlVirtualNetworkRuleState.__new__(_AzureSqlVirtualNetworkRuleState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["ignore_missing_vnet_service_endpoint"] = ignore_missing_vnet_service_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureSqlVirtualNetworkRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        """
        The ID of the SQL virtual network rule.
        """
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> pulumi.Output[bool]:
        """
        Create the virtual network rule before the subnet has the virtual network service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the SQL virtual network rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The name of the SQL Server to which this SQL virtual network rule will be applied to.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the subnet that the SQL server will be connected to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the sql virtual network rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Redis cache instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

