# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureTenantKeyVaultArgs', 'AzureTenantKeyVault']

@pulumi.input_type
class AzureTenantKeyVaultArgs:
    def __init__(__self__, *,
                 sku_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AzureTenantKeyVault resource.
        :param pulumi.Input[str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault will be created in.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault.
        :param pulumi.Input[bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault?
        :param pulumi.Input[int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        """
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[str]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the DuploCloud tenant that the key vault will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Key Vault.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is Purge Protection enabled for this Key Vault?
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "soft_delete_retention_days", value)


@pulumi.input_type
class _AzureTenantKeyVaultState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vault_uri: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureTenantKeyVault resources.
        :param pulumi.Input[str] azure_id: The azure ID of the Key Vault.
        :param pulumi.Input[bool] enabled_for_disk_encryption: Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault.
        :param pulumi.Input[bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault?
        :param pulumi.Input[str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault will be created in.
        :param pulumi.Input[str] vault_uri: The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if enabled_for_disk_encryption is not None:
            pulumi.set(__self__, "enabled_for_disk_encryption", enabled_for_disk_encryption)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The azure ID of the Key Vault.
        """
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @enabled_for_disk_encryption.setter
    def enabled_for_disk_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_for_disk_encryption", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Key Vault.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is Purge Protection enabled for this Key Vault?
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the DuploCloud tenant that the key vault will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_uri", value)


class AzureTenantKeyVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureTenantKeyVault` manages a azure Key Vault in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.Tenant("tenant",
            account_name="test",
            plan_id="test")
        kv = duplocloud.AzureTenantKeyVault("kv",
            tenant_id=tenant.tenant_id,
            name="tst-kv001",
            sku_name="standard",
            purge_protection_enabled=True,
            soft_delete_retention_days=90)
        ```

        ## Import

        Example: Importing an existing Azure Tenant Key Vault

         - *TENANT_ID* is the tenant GUID

         - *VAULT_NAME* is the short name of the Azure Tenant Key Vault

        # 

        ```sh
        $ pulumi import duplocloud:index/azureTenantKeyVault:AzureTenantKeyVault kv *TENANT_ID*/*VAULT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault.
        :param pulumi.Input[bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault?
        :param pulumi.Input[str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureTenantKeyVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureTenantKeyVault` manages a azure Key Vault in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.Tenant("tenant",
            account_name="test",
            plan_id="test")
        kv = duplocloud.AzureTenantKeyVault("kv",
            tenant_id=tenant.tenant_id,
            name="tst-kv001",
            sku_name="standard",
            purge_protection_enabled=True,
            soft_delete_retention_days=90)
        ```

        ## Import

        Example: Importing an existing Azure Tenant Key Vault

         - *TENANT_ID* is the tenant GUID

         - *VAULT_NAME* is the short name of the Azure Tenant Key Vault

        # 

        ```sh
        $ pulumi import duplocloud:index/azureTenantKeyVault:AzureTenantKeyVault kv *TENANT_ID*/*VAULT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureTenantKeyVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureTenantKeyVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureTenantKeyVaultArgs.__new__(AzureTenantKeyVaultArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["azure_id"] = None
            __props__.__dict__["enabled_for_disk_encryption"] = None
            __props__.__dict__["vault_uri"] = None
        super(AzureTenantKeyVault, __self__).__init__(
            'duplocloud:index/azureTenantKeyVault:AzureTenantKeyVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            enabled_for_disk_encryption: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            purge_protection_enabled: Optional[pulumi.Input[bool]] = None,
            sku_name: Optional[pulumi.Input[str]] = None,
            soft_delete_retention_days: Optional[pulumi.Input[int]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vault_uri: Optional[pulumi.Input[str]] = None) -> 'AzureTenantKeyVault':
        """
        Get an existing AzureTenantKeyVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_id: The azure ID of the Key Vault.
        :param pulumi.Input[bool] enabled_for_disk_encryption: Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault.
        :param pulumi.Input[bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault?
        :param pulumi.Input[str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault will be created in.
        :param pulumi.Input[str] vault_uri: The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureTenantKeyVaultState.__new__(_AzureTenantKeyVaultState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["enabled_for_disk_encryption"] = enabled_for_disk_encryption
        __props__.__dict__["name"] = name
        __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vault_uri"] = vault_uri
        return AzureTenantKeyVault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        """
        The azure ID of the Key Vault.
        """
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> pulumi.Output[bool]:
        """
        Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the Key Vault.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> pulumi.Output[bool]:
        """
        Is Purge Protection enabled for this Key Vault?
        """
        return pulumi.get(self, "purge_protection_enabled")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[str]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days. Defaults to `90`.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the DuploCloud tenant that the key vault will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> pulumi.Output[str]:
        """
        The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        return pulumi.get(self, "vault_uri")

