# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureTenantKeyVaultSecretArgs', 'AzureTenantKeyVaultSecret']

@pulumi.input_type
class AzureTenantKeyVaultSecretArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 value: pulumi.Input[str],
                 vault_name: pulumi.Input[str],
                 content_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureTenantKeyVaultSecret resource.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault secret will be created in.
        :param pulumi.Input[str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[str] vault_name: Name of the Key Vault where the Secret should be created.
        :param pulumi.Input[str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault Secret.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_name", vault_name)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the DuploCloud tenant that the key vault secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Input[str]:
        """
        Name of the Key Vault where the Secret should be created.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_name", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Key Vault Secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AzureTenantKeyVaultSecretState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recovery_level: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vault_base_url: Optional[pulumi.Input[str]] = None,
                 vault_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureTenantKeyVaultSecret resources.
        :param pulumi.Input[str] azure_id: The azure ID of the Key Vault secret.
        :param pulumi.Input[str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault Secret.
        :param pulumi.Input[str] recovery_level: Reflects the deletion recovery level currently in effect for secrets in the current vault.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault secret will be created in.
        :param pulumi.Input[str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[str] vault_base_url: Base URL of the Azure Key Vault
        :param pulumi.Input[str] vault_name: Name of the Key Vault where the Secret should be created.
        :param pulumi.Input[str] version: The current version of the Key Vault Secret.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_level is not None:
            pulumi.set(__self__, "recovery_level", recovery_level)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_base_url is not None:
            pulumi.set(__self__, "vault_base_url", vault_base_url)
        if vault_name is not None:
            pulumi.set(__self__, "vault_name", vault_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The azure ID of the Key Vault secret.
        """
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Key Vault Secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recoveryLevel")
    def recovery_level(self) -> Optional[pulumi.Input[str]]:
        """
        Reflects the deletion recovery level currently in effect for secrets in the current vault.
        """
        return pulumi.get(self, "recovery_level")

    @recovery_level.setter
    def recovery_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_level", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the DuploCloud tenant that the key vault secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultBaseUrl")
    def vault_base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL of the Azure Key Vault
        """
        return pulumi.get(self, "vault_base_url")

    @vault_base_url.setter
    def vault_base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_base_url", value)

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Key Vault where the Secret should be created.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The current version of the Key Vault Secret.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class AzureTenantKeyVaultSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vault_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureTenantKeyVaultSecret` manages a azure Key Vault secret in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.Tenant("tenant",
            account_name="test",
            plan_id="test")
        kv = duplocloud.AzureTenantKeyVault("kv",
            tenant_id=tenant.tenant_id,
            name="tst-kv001",
            sku_name="standard",
            purge_protection_enabled=True,
            soft_delete_retention_days=90)
        kv_secret = duplocloud.AzureTenantKeyVaultSecret("kv_secret",
            tenant_id=tenant.tenant_id,
            vault_name=kv.name,
            name="Sec001",
            value="SecVal001")
        ```

        ## Import

        Example: Importing an existing Azure Key Vault Secret

         - *TENANT_ID* is the tenant GUID

         - *VAULT_NAME* is the name of the Azure Key Vault

         - *SECRET_NAME* is the name of the Azure Key Vault Secret

        ```sh
        $ pulumi import duplocloud:index/azureTenantKeyVaultSecret:AzureTenantKeyVaultSecret kv_secret *TENANT_ID*/*VAULT_NAME*/*SECRET_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault Secret.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault secret will be created in.
        :param pulumi.Input[str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[str] vault_name: Name of the Key Vault where the Secret should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureTenantKeyVaultSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureTenantKeyVaultSecret` manages a azure Key Vault secret in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.Tenant("tenant",
            account_name="test",
            plan_id="test")
        kv = duplocloud.AzureTenantKeyVault("kv",
            tenant_id=tenant.tenant_id,
            name="tst-kv001",
            sku_name="standard",
            purge_protection_enabled=True,
            soft_delete_retention_days=90)
        kv_secret = duplocloud.AzureTenantKeyVaultSecret("kv_secret",
            tenant_id=tenant.tenant_id,
            vault_name=kv.name,
            name="Sec001",
            value="SecVal001")
        ```

        ## Import

        Example: Importing an existing Azure Key Vault Secret

         - *TENANT_ID* is the tenant GUID

         - *VAULT_NAME* is the name of the Azure Key Vault

         - *SECRET_NAME* is the name of the Azure Key Vault Secret

        ```sh
        $ pulumi import duplocloud:index/azureTenantKeyVaultSecret:AzureTenantKeyVaultSecret kv_secret *TENANT_ID*/*VAULT_NAME*/*SECRET_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureTenantKeyVaultSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureTenantKeyVaultSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vault_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureTenantKeyVaultSecretArgs.__new__(AzureTenantKeyVaultSecretArgs)

            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            if vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'vault_name'")
            __props__.__dict__["vault_name"] = vault_name
            __props__.__dict__["azure_id"] = None
            __props__.__dict__["recovery_level"] = None
            __props__.__dict__["vault_base_url"] = None
            __props__.__dict__["version"] = None
        super(AzureTenantKeyVaultSecret, __self__).__init__(
            'duplocloud:index/azureTenantKeyVaultSecret:AzureTenantKeyVaultSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recovery_level: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None,
            vault_base_url: Optional[pulumi.Input[str]] = None,
            vault_name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'AzureTenantKeyVaultSecret':
        """
        Get an existing AzureTenantKeyVaultSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_id: The azure ID of the Key Vault secret.
        :param pulumi.Input[str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[str] name: Specifies the name of the Key Vault Secret.
        :param pulumi.Input[str] recovery_level: Reflects the deletion recovery level currently in effect for secrets in the current vault.
        :param pulumi.Input[str] tenant_id: The GUID of the DuploCloud tenant that the key vault secret will be created in.
        :param pulumi.Input[str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[str] vault_base_url: Base URL of the Azure Key Vault
        :param pulumi.Input[str] vault_name: Name of the Key Vault where the Secret should be created.
        :param pulumi.Input[str] version: The current version of the Key Vault Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureTenantKeyVaultSecretState.__new__(_AzureTenantKeyVaultSecretState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_level"] = recovery_level
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value"] = value
        __props__.__dict__["vault_base_url"] = vault_base_url
        __props__.__dict__["vault_name"] = vault_name
        __props__.__dict__["version"] = version
        return AzureTenantKeyVaultSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        """
        The azure ID of the Key Vault secret.
        """
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the Key Vault Secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recoveryLevel")
    def recovery_level(self) -> pulumi.Output[str]:
        """
        Reflects the deletion recovery level currently in effect for secrets in the current vault.
        """
        return pulumi.get(self, "recovery_level")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the DuploCloud tenant that the key vault secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultBaseUrl")
    def vault_base_url(self) -> pulumi.Output[str]:
        """
        Base URL of the Azure Key Vault
        """
        return pulumi.get(self, "vault_base_url")

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Output[str]:
        """
        Name of the Key Vault where the Secret should be created.
        """
        return pulumi.get(self, "vault_name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The current version of the Key Vault Secret.
        """
        return pulumi.get(self, "version")

