# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureVaultBackupPolicyArgs', 'AzureVaultBackupPolicy']

@pulumi.input_type
class AzureVaultBackupPolicyArgs:
    def __init__(__self__, *,
                 backup: pulumi.Input['AzureVaultBackupPolicyBackupArgs'],
                 infra_name: pulumi.Input[str],
                 instant_restore_retention_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 retention_daily: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']] = None,
                 retention_monthly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']] = None,
                 retention_weekly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']] = None,
                 retention_yearly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureVaultBackupPolicy resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[int] instant_restore_retention_days: Specifies the instant restore retention range in days.
        :param pulumi.Input[str] name: Specifies the name of the vault backup policy.
        :param pulumi.Input[str] policy_type: Type of the Backup Policy. Defaults to `V1`.
        :param pulumi.Input[str] timezone: Specifies the timezone. Defaults to `UTC`.
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "infra_name", infra_name)
        if instant_restore_retention_days is not None:
            pulumi.set(__self__, "instant_restore_retention_days", instant_restore_retention_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Input['AzureVaultBackupPolicyBackupArgs']:
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: pulumi.Input['AzureVaultBackupPolicyBackupArgs']):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the instant restore retention range in days.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @instant_restore_retention_days.setter
    def instant_restore_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instant_restore_retention_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the vault backup policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Backup Policy. Defaults to `V1`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']]:
        return pulumi.get(self, "retention_daily")

    @retention_daily.setter
    def retention_daily(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']]):
        pulumi.set(self, "retention_daily", value)

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']]:
        return pulumi.get(self, "retention_monthly")

    @retention_monthly.setter
    def retention_monthly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']]):
        pulumi.set(self, "retention_monthly", value)

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']]:
        return pulumi.get(self, "retention_weekly")

    @retention_weekly.setter
    def retention_weekly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']]):
        pulumi.set(self, "retention_weekly", value)

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']]:
        return pulumi.get(self, "retention_yearly")

    @retention_yearly.setter
    def retention_yearly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']]):
        pulumi.set(self, "retention_yearly", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the timezone. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _AzureVaultBackupPolicyState:
    def __init__(__self__, *,
                 azure_id: Optional[pulumi.Input[str]] = None,
                 backup: Optional[pulumi.Input['AzureVaultBackupPolicyBackupArgs']] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 retention_daily: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']] = None,
                 retention_monthly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']] = None,
                 retention_weekly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']] = None,
                 retention_yearly: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureVaultBackupPolicy resources.
        :param pulumi.Input[str] azure_id: Azure id for vault backup policy.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[int] instant_restore_retention_days: Specifies the instant restore retention range in days.
        :param pulumi.Input[str] name: Specifies the name of the vault backup policy.
        :param pulumi.Input[str] policy_type: Type of the Backup Policy. Defaults to `V1`.
        :param pulumi.Input[str] timezone: Specifies the timezone. Defaults to `UTC`.
        """
        if azure_id is not None:
            pulumi.set(__self__, "azure_id", azure_id)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if instant_restore_retention_days is not None:
            pulumi.set(__self__, "instant_restore_retention_days", instant_restore_retention_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure id for vault backup policy.
        """
        return pulumi.get(self, "azure_id")

    @azure_id.setter
    def azure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_id", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyBackupArgs']]:
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the instant restore retention range in days.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @instant_restore_retention_days.setter
    def instant_restore_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instant_restore_retention_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the vault backup policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Backup Policy. Defaults to `V1`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']]:
        return pulumi.get(self, "retention_daily")

    @retention_daily.setter
    def retention_daily(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionDailyArgs']]):
        pulumi.set(self, "retention_daily", value)

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']]:
        return pulumi.get(self, "retention_monthly")

    @retention_monthly.setter
    def retention_monthly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionMonthlyArgs']]):
        pulumi.set(self, "retention_monthly", value)

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']]:
        return pulumi.get(self, "retention_weekly")

    @retention_weekly.setter
    def retention_weekly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionWeeklyArgs']]):
        pulumi.set(self, "retention_weekly", value)

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']]:
        return pulumi.get(self, "retention_yearly")

    @retention_yearly.setter
    def retention_yearly(self, value: Optional[pulumi.Input['AzureVaultBackupPolicyRetentionYearlyArgs']]):
        pulumi.set(self, "retention_yearly", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the timezone. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


class AzureVaultBackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[Union['AzureVaultBackupPolicyBackupArgs', 'AzureVaultBackupPolicyBackupArgsDict']]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 retention_daily: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionDailyArgs', 'AzureVaultBackupPolicyRetentionDailyArgsDict']]] = None,
                 retention_monthly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionMonthlyArgs', 'AzureVaultBackupPolicyRetentionMonthlyArgsDict']]] = None,
                 retention_weekly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionWeeklyArgs', 'AzureVaultBackupPolicyRetentionWeeklyArgsDict']]] = None,
                 retention_yearly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionYearlyArgs', 'AzureVaultBackupPolicyRetentionYearlyArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureVaultBackupPolicy` manages a Vault Backup Policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        backup_policy = duplocloud.AzureVaultBackupPolicy("backup_policy",
            infra_name="test-infra",
            name="rt01",
            timezone="UTC",
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            },
            retention_weekly={
                "count": 42,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                    "Friday",
                    "Saturday",
                ],
            },
            retention_monthly={
                "count": 7,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                ],
                "weeks": [
                    "First",
                    "Last",
                ],
            },
            retention_yearly={
                "count": 77,
                "weekdays": ["Sunday"],
                "weeks": ["Last"],
                "months": ["January"],
            })
        ```

        ## Import

        Example: Importing an existing Azure Vault Backup Policy

         - *INFRA_NAME* is the Duplo infra name.

         - *NAME* is the name of the Azure Vault Backup Policy

        ```sh
        $ pulumi import duplocloud:index/azureVaultBackupPolicy:AzureVaultBackupPolicy backup_policy *INFRA_NAME*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[int] instant_restore_retention_days: Specifies the instant restore retention range in days.
        :param pulumi.Input[str] name: Specifies the name of the vault backup policy.
        :param pulumi.Input[str] policy_type: Type of the Backup Policy. Defaults to `V1`.
        :param pulumi.Input[str] timezone: Specifies the timezone. Defaults to `UTC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVaultBackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureVaultBackupPolicy` manages a Vault Backup Policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        backup_policy = duplocloud.AzureVaultBackupPolicy("backup_policy",
            infra_name="test-infra",
            name="rt01",
            timezone="UTC",
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            },
            retention_weekly={
                "count": 42,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                    "Friday",
                    "Saturday",
                ],
            },
            retention_monthly={
                "count": 7,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                ],
                "weeks": [
                    "First",
                    "Last",
                ],
            },
            retention_yearly={
                "count": 77,
                "weekdays": ["Sunday"],
                "weeks": ["Last"],
                "months": ["January"],
            })
        ```

        ## Import

        Example: Importing an existing Azure Vault Backup Policy

         - *INFRA_NAME* is the Duplo infra name.

         - *NAME* is the name of the Azure Vault Backup Policy

        ```sh
        $ pulumi import duplocloud:index/azureVaultBackupPolicy:AzureVaultBackupPolicy backup_policy *INFRA_NAME*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureVaultBackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVaultBackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[Union['AzureVaultBackupPolicyBackupArgs', 'AzureVaultBackupPolicyBackupArgsDict']]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 retention_daily: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionDailyArgs', 'AzureVaultBackupPolicyRetentionDailyArgsDict']]] = None,
                 retention_monthly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionMonthlyArgs', 'AzureVaultBackupPolicyRetentionMonthlyArgsDict']]] = None,
                 retention_weekly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionWeeklyArgs', 'AzureVaultBackupPolicyRetentionWeeklyArgsDict']]] = None,
                 retention_yearly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionYearlyArgs', 'AzureVaultBackupPolicyRetentionYearlyArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVaultBackupPolicyArgs.__new__(AzureVaultBackupPolicyArgs)

            if backup is None and not opts.urn:
                raise TypeError("Missing required property 'backup'")
            __props__.__dict__["backup"] = backup
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["instant_restore_retention_days"] = instant_restore_retention_days
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["retention_daily"] = retention_daily
            __props__.__dict__["retention_monthly"] = retention_monthly
            __props__.__dict__["retention_weekly"] = retention_weekly
            __props__.__dict__["retention_yearly"] = retention_yearly
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["azure_id"] = None
        super(AzureVaultBackupPolicy, __self__).__init__(
            'duplocloud:index/azureVaultBackupPolicy:AzureVaultBackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_id: Optional[pulumi.Input[str]] = None,
            backup: Optional[pulumi.Input[Union['AzureVaultBackupPolicyBackupArgs', 'AzureVaultBackupPolicyBackupArgsDict']]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            instant_restore_retention_days: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_type: Optional[pulumi.Input[str]] = None,
            retention_daily: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionDailyArgs', 'AzureVaultBackupPolicyRetentionDailyArgsDict']]] = None,
            retention_monthly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionMonthlyArgs', 'AzureVaultBackupPolicyRetentionMonthlyArgsDict']]] = None,
            retention_weekly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionWeeklyArgs', 'AzureVaultBackupPolicyRetentionWeeklyArgsDict']]] = None,
            retention_yearly: Optional[pulumi.Input[Union['AzureVaultBackupPolicyRetentionYearlyArgs', 'AzureVaultBackupPolicyRetentionYearlyArgsDict']]] = None,
            timezone: Optional[pulumi.Input[str]] = None) -> 'AzureVaultBackupPolicy':
        """
        Get an existing AzureVaultBackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_id: Azure id for vault backup policy.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[int] instant_restore_retention_days: Specifies the instant restore retention range in days.
        :param pulumi.Input[str] name: Specifies the name of the vault backup policy.
        :param pulumi.Input[str] policy_type: Type of the Backup Policy. Defaults to `V1`.
        :param pulumi.Input[str] timezone: Specifies the timezone. Defaults to `UTC`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVaultBackupPolicyState.__new__(_AzureVaultBackupPolicyState)

        __props__.__dict__["azure_id"] = azure_id
        __props__.__dict__["backup"] = backup
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["instant_restore_retention_days"] = instant_restore_retention_days
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["retention_daily"] = retention_daily
        __props__.__dict__["retention_monthly"] = retention_monthly
        __props__.__dict__["retention_weekly"] = retention_weekly
        __props__.__dict__["retention_yearly"] = retention_yearly
        __props__.__dict__["timezone"] = timezone
        return AzureVaultBackupPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureId")
    def azure_id(self) -> pulumi.Output[str]:
        """
        Azure id for vault backup policy.
        """
        return pulumi.get(self, "azure_id")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output['outputs.AzureVaultBackupPolicyBackup']:
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> pulumi.Output[int]:
        """
        Specifies the instant restore retention range in days.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the vault backup policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of the Backup Policy. Defaults to `V1`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> pulumi.Output[Optional['outputs.AzureVaultBackupPolicyRetentionDaily']]:
        return pulumi.get(self, "retention_daily")

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> pulumi.Output[Optional['outputs.AzureVaultBackupPolicyRetentionMonthly']]:
        return pulumi.get(self, "retention_monthly")

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> pulumi.Output[Optional['outputs.AzureVaultBackupPolicyRetentionWeekly']]:
        return pulumi.get(self, "retention_weekly")

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> pulumi.Output[Optional['outputs.AzureVaultBackupPolicyRetentionYearly']]:
        return pulumi.get(self, "retention_yearly")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the timezone. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone")

