# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureVirtualMachineArgs', 'AzureVirtualMachine']

@pulumi.input_type
class AzureVirtualMachineArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 capacity: pulumi.Input[str],
                 friendly_name: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 ad_domain_type: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 availability_set_id: Optional[pulumi.Input[str]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 disk_control_type: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 enable_encrypt_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_log_analytics: Optional[pulumi.Input[bool]] = None,
                 enable_security_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 join_domain: Optional[pulumi.Input[bool]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AzureVirtualMachine resource.
        :param pulumi.Input[str] admin_username: Specifies the name of the local administrator account.
        :param pulumi.Input[str] capacity: Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        :param pulumi.Input[str] subnet_id: Subnet ID which should be associated with the Virtual Machine.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] ad_domain_type: Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        :param pulumi.Input[str] admin_password: The password associated with the local administrator account.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] availability_set_id: Specify availability set id to which virtual machine should be added to
        :param pulumi.Input[str] base64_user_data: Base64 encoded user data to associated with the host.
        :param pulumi.Input[str] disk_control_type: disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        :param pulumi.Input[bool] enable_encrypt_at_host: Defaults to `false`.
        :param pulumi.Input[bool] enable_log_analytics: Enable log analytics on virtual machine. Defaults to `false`.
        :param pulumi.Input[bool] enable_security_boot: Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] enable_vtpm: Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] encrypt_disk: Defaults to `false`.
        :param pulumi.Input[bool] join_domain: Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[str] os_disk_type: Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        :param pulumi.Input[str] security_type: Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
               		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
               		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
               		 Defaults to `Standard`.
        :param pulumi.Input[str] timezone: Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if ad_domain_type is not None:
            pulumi.set(__self__, "ad_domain_type", ad_domain_type)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if availability_set_id is not None:
            pulumi.set(__self__, "availability_set_id", availability_set_id)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if disk_control_type is not None:
            pulumi.set(__self__, "disk_control_type", disk_control_type)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if enable_encrypt_at_host is not None:
            pulumi.set(__self__, "enable_encrypt_at_host", enable_encrypt_at_host)
        if enable_log_analytics is not None:
            pulumi.set(__self__, "enable_log_analytics", enable_log_analytics)
        if enable_security_boot is not None:
            pulumi.set(__self__, "enable_security_boot", enable_security_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)
        if encrypt_disk is not None:
            pulumi.set(__self__, "encrypt_disk", encrypt_disk)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        Specifies the name of the local administrator account.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[str]:
        """
        Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Input[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet ID which should be associated with the Virtual Machine.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="adDomainType")
    def ad_domain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        """
        return pulumi.get(self, "ad_domain_type")

    @ad_domain_type.setter
    def ad_domain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_type", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password associated with the local administrator account.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specify availability set id to which virtual machine should be added to
        """
        return pulumi.get(self, "availability_set_id")

    @availability_set_id.setter
    def availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_id", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter(name="diskControlType")
    def disk_control_type(self) -> Optional[pulumi.Input[str]]:
        """
        disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        """
        return pulumi.get(self, "disk_control_type")

    @disk_control_type.setter
    def disk_control_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_control_type", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="enableEncryptAtHost")
    def enable_encrypt_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "enable_encrypt_at_host")

    @enable_encrypt_at_host.setter
    def enable_encrypt_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_at_host", value)

    @property
    @pulumi.getter(name="enableLogAnalytics")
    def enable_log_analytics(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable log analytics on virtual machine. Defaults to `false`.
        """
        return pulumi.get(self, "enable_log_analytics")

    @enable_log_analytics.setter
    def enable_log_analytics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_log_analytics", value)

    @property
    @pulumi.getter(name="enableSecurityBoot")
    def enable_security_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_security_boot")

    @enable_security_boot.setter
    def enable_security_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_security_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "encrypt_disk")

    @encrypt_disk.setter
    def encrypt_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_disk", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        """
        return pulumi.get(self, "join_domain")

    @join_domain.setter
    def join_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "join_domain", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
        		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
        		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
        		 Defaults to `Standard`.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]]:
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AzureVirtualMachineState:
    def __init__(__self__, *,
                 ad_domain_type: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 availability_set_id: Optional[pulumi.Input[str]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 disk_control_type: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 enable_encrypt_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_log_analytics: Optional[pulumi.Input[bool]] = None,
                 enable_security_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 join_domain: Optional[pulumi.Input[bool]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AzureVirtualMachine resources.
        :param pulumi.Input[str] ad_domain_type: Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        :param pulumi.Input[str] admin_password: The password associated with the local administrator account.
        :param pulumi.Input[str] admin_username: Specifies the name of the local administrator account.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] availability_set_id: Specify availability set id to which virtual machine should be added to
        :param pulumi.Input[str] base64_user_data: Base64 encoded user data to associated with the host.
        :param pulumi.Input[str] capacity: Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        :param pulumi.Input[str] disk_control_type: disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        :param pulumi.Input[bool] enable_encrypt_at_host: Defaults to `false`.
        :param pulumi.Input[bool] enable_log_analytics: Enable log analytics on virtual machine. Defaults to `false`.
        :param pulumi.Input[bool] enable_security_boot: Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] enable_vtpm: Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] encrypt_disk: Defaults to `false`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] fullname: The full name of the host.
        :param pulumi.Input[str] image_id: The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        :param pulumi.Input[str] instance_id: The Azure Virtual Machine ID of the host.
        :param pulumi.Input[bool] join_domain: Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[str] os_disk_type: Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        :param pulumi.Input[str] security_type: Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
               		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
               		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
               		 Defaults to `Standard`.
        :param pulumi.Input[str] status: The current status of the host.
        :param pulumi.Input[str] subnet_id: Subnet ID which should be associated with the Virtual Machine.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] timezone: Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        if ad_domain_type is not None:
            pulumi.set(__self__, "ad_domain_type", ad_domain_type)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if availability_set_id is not None:
            pulumi.set(__self__, "availability_set_id", availability_set_id)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if disk_control_type is not None:
            pulumi.set(__self__, "disk_control_type", disk_control_type)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if enable_encrypt_at_host is not None:
            pulumi.set(__self__, "enable_encrypt_at_host", enable_encrypt_at_host)
        if enable_log_analytics is not None:
            pulumi.set(__self__, "enable_log_analytics", enable_log_analytics)
        if enable_security_boot is not None:
            pulumi.set(__self__, "enable_security_boot", enable_security_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)
        if encrypt_disk is not None:
            pulumi.set(__self__, "encrypt_disk", encrypt_disk)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="adDomainType")
    def ad_domain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        """
        return pulumi.get(self, "ad_domain_type")

    @ad_domain_type.setter
    def ad_domain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_type", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password associated with the local administrator account.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the local administrator account.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specify availability set id to which virtual machine should be added to
        """
        return pulumi.get(self, "availability_set_id")

    @availability_set_id.setter
    def availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_id", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="diskControlType")
    def disk_control_type(self) -> Optional[pulumi.Input[str]]:
        """
        disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        """
        return pulumi.get(self, "disk_control_type")

    @disk_control_type.setter
    def disk_control_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_control_type", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="enableEncryptAtHost")
    def enable_encrypt_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "enable_encrypt_at_host")

    @enable_encrypt_at_host.setter
    def enable_encrypt_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_at_host", value)

    @property
    @pulumi.getter(name="enableLogAnalytics")
    def enable_log_analytics(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable log analytics on virtual machine. Defaults to `false`.
        """
        return pulumi.get(self, "enable_log_analytics")

    @enable_log_analytics.setter
    def enable_log_analytics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_log_analytics", value)

    @property
    @pulumi.getter(name="enableSecurityBoot")
    def enable_security_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_security_boot")

    @enable_security_boot.setter
    def enable_security_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_security_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "encrypt_disk")

    @encrypt_disk.setter
    def encrypt_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_disk", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the host.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Virtual Machine ID of the host.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        """
        return pulumi.get(self, "join_domain")

    @join_domain.setter
    def join_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "join_domain", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
        		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
        		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
        		 Defaults to `Standard`.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the host.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID which should be associated with the Virtual Machine.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]]:
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AzureVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_domain_type: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 availability_set_id: Optional[pulumi.Input[str]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 disk_control_type: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 enable_encrypt_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_log_analytics: Optional[pulumi.Input[bool]] = None,
                 enable_security_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 join_domain: Optional[pulumi.Input[bool]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineMinionTagArgs', 'AzureVirtualMachineMinionTagArgsDict']]]]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineTagArgs', 'AzureVirtualMachineTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineVolumeArgs', 'AzureVirtualMachineVolumeArgsDict']]]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AzureVirtualMachine` manages an Azure virtual machine in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        az_vm = duplocloud.AzureVirtualMachine("az_vm",
            tenant_id=myapp.tenant_id,
            friendly_name="test-vm",
            image_id="16.04-LTS;Canonical;UbuntuServer",
            capacity="Standard_D2s_v3",
            agent_platform=0,
            admin_username="azureuser",
            admin_password="Root!12345",
            disk_size_gb=50,
            subnet_id="duploinfra-default",
            minion_tags=[{
                "key": "AllocationTags",
                "value": "test-host",
            }],
            tags=[
                {
                    "key": "CreatedBy",
                    "value": "duplo",
                },
                {
                    "key": "Owner",
                    "value": "duplo",
                },
            ])
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Virtual Machine

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVirtualMachine:AzureVirtualMachine myvm *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ad_domain_type: Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        :param pulumi.Input[str] admin_password: The password associated with the local administrator account.
        :param pulumi.Input[str] admin_username: Specifies the name of the local administrator account.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] availability_set_id: Specify availability set id to which virtual machine should be added to
        :param pulumi.Input[str] base64_user_data: Base64 encoded user data to associated with the host.
        :param pulumi.Input[str] capacity: Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        :param pulumi.Input[str] disk_control_type: disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        :param pulumi.Input[bool] enable_encrypt_at_host: Defaults to `false`.
        :param pulumi.Input[bool] enable_log_analytics: Enable log analytics on virtual machine. Defaults to `false`.
        :param pulumi.Input[bool] enable_security_boot: Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] enable_vtpm: Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] encrypt_disk: Defaults to `false`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        :param pulumi.Input[bool] join_domain: Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineMinionTagArgs', 'AzureVirtualMachineMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[str] os_disk_type: Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        :param pulumi.Input[str] security_type: Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
               		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
               		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
               		 Defaults to `Standard`.
        :param pulumi.Input[str] subnet_id: Subnet ID which should be associated with the Virtual Machine.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] timezone: Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureVirtualMachine` manages an Azure virtual machine in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        az_vm = duplocloud.AzureVirtualMachine("az_vm",
            tenant_id=myapp.tenant_id,
            friendly_name="test-vm",
            image_id="16.04-LTS;Canonical;UbuntuServer",
            capacity="Standard_D2s_v3",
            agent_platform=0,
            admin_username="azureuser",
            admin_password="Root!12345",
            disk_size_gb=50,
            subnet_id="duploinfra-default",
            minion_tags=[{
                "key": "AllocationTags",
                "value": "test-host",
            }],
            tags=[
                {
                    "key": "CreatedBy",
                    "value": "duplo",
                },
                {
                    "key": "Owner",
                    "value": "duplo",
                },
            ])
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Virtual Machine

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVirtualMachine:AzureVirtualMachine myvm *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_domain_type: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 availability_set_id: Optional[pulumi.Input[str]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 disk_control_type: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 enable_encrypt_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_log_analytics: Optional[pulumi.Input[bool]] = None,
                 enable_security_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 join_domain: Optional[pulumi.Input[bool]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineMinionTagArgs', 'AzureVirtualMachineMinionTagArgsDict']]]]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineTagArgs', 'AzureVirtualMachineTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineVolumeArgs', 'AzureVirtualMachineVolumeArgsDict']]]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVirtualMachineArgs.__new__(AzureVirtualMachineArgs)

            __props__.__dict__["ad_domain_type"] = ad_domain_type
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            if admin_username is None and not opts.urn:
                raise TypeError("Missing required property 'admin_username'")
            __props__.__dict__["admin_username"] = admin_username
            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocated_public_ip"] = allocated_public_ip
            __props__.__dict__["availability_set_id"] = availability_set_id
            __props__.__dict__["base64_user_data"] = base64_user_data
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["disk_control_type"] = disk_control_type
            __props__.__dict__["disk_size_gb"] = disk_size_gb
            __props__.__dict__["enable_encrypt_at_host"] = enable_encrypt_at_host
            __props__.__dict__["enable_log_analytics"] = enable_log_analytics
            __props__.__dict__["enable_security_boot"] = enable_security_boot
            __props__.__dict__["enable_vtpm"] = enable_vtpm
            __props__.__dict__["encrypt_disk"] = encrypt_disk
            if friendly_name is None and not opts.urn:
                raise TypeError("Missing required property 'friendly_name'")
            __props__.__dict__["friendly_name"] = friendly_name
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["is_minion"] = is_minion
            __props__.__dict__["join_domain"] = join_domain
            __props__.__dict__["minion_tags"] = minion_tags
            __props__.__dict__["os_disk_type"] = os_disk_type
            __props__.__dict__["security_type"] = security_type
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["fullname"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user_account"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AzureVirtualMachine, __self__).__init__(
            'duplocloud:index/azureVirtualMachine:AzureVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ad_domain_type: Optional[pulumi.Input[str]] = None,
            admin_password: Optional[pulumi.Input[str]] = None,
            admin_username: Optional[pulumi.Input[str]] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocated_public_ip: Optional[pulumi.Input[bool]] = None,
            availability_set_id: Optional[pulumi.Input[str]] = None,
            base64_user_data: Optional[pulumi.Input[str]] = None,
            capacity: Optional[pulumi.Input[str]] = None,
            disk_control_type: Optional[pulumi.Input[str]] = None,
            disk_size_gb: Optional[pulumi.Input[int]] = None,
            enable_encrypt_at_host: Optional[pulumi.Input[bool]] = None,
            enable_log_analytics: Optional[pulumi.Input[bool]] = None,
            enable_security_boot: Optional[pulumi.Input[bool]] = None,
            enable_vtpm: Optional[pulumi.Input[bool]] = None,
            encrypt_disk: Optional[pulumi.Input[bool]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            is_minion: Optional[pulumi.Input[bool]] = None,
            join_domain: Optional[pulumi.Input[bool]] = None,
            minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineMinionTagArgs', 'AzureVirtualMachineMinionTagArgsDict']]]]] = None,
            os_disk_type: Optional[pulumi.Input[str]] = None,
            security_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineTagArgs', 'AzureVirtualMachineTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            user_account: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineVolumeArgs', 'AzureVirtualMachineVolumeArgsDict']]]]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AzureVirtualMachine':
        """
        Get an existing AzureVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ad_domain_type: Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        :param pulumi.Input[str] admin_password: The password associated with the local administrator account.
        :param pulumi.Input[str] admin_username: Specifies the name of the local administrator account.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] availability_set_id: Specify availability set id to which virtual machine should be added to
        :param pulumi.Input[str] base64_user_data: Base64 encoded user data to associated with the host.
        :param pulumi.Input[str] capacity: Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        :param pulumi.Input[str] disk_control_type: disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        :param pulumi.Input[bool] enable_encrypt_at_host: Defaults to `false`.
        :param pulumi.Input[bool] enable_log_analytics: Enable log analytics on virtual machine. Defaults to `false`.
        :param pulumi.Input[bool] enable_security_boot: Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] enable_vtpm: Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        :param pulumi.Input[bool] encrypt_disk: Defaults to `false`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] fullname: The full name of the host.
        :param pulumi.Input[str] image_id: The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        :param pulumi.Input[str] instance_id: The Azure Virtual Machine ID of the host.
        :param pulumi.Input[bool] join_domain: Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineMinionTagArgs', 'AzureVirtualMachineMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[str] os_disk_type: Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        :param pulumi.Input[str] security_type: Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
               		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
               		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
               		 Defaults to `Standard`.
        :param pulumi.Input[str] status: The current status of the host.
        :param pulumi.Input[str] subnet_id: Subnet ID which should be associated with the Virtual Machine.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] timezone: Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVirtualMachineState.__new__(_AzureVirtualMachineState)

        __props__.__dict__["ad_domain_type"] = ad_domain_type
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocated_public_ip"] = allocated_public_ip
        __props__.__dict__["availability_set_id"] = availability_set_id
        __props__.__dict__["base64_user_data"] = base64_user_data
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["disk_control_type"] = disk_control_type
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["enable_encrypt_at_host"] = enable_encrypt_at_host
        __props__.__dict__["enable_log_analytics"] = enable_log_analytics
        __props__.__dict__["enable_security_boot"] = enable_security_boot
        __props__.__dict__["enable_vtpm"] = enable_vtpm
        __props__.__dict__["encrypt_disk"] = encrypt_disk
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_minion"] = is_minion
        __props__.__dict__["join_domain"] = join_domain
        __props__.__dict__["minion_tags"] = minion_tags
        __props__.__dict__["os_disk_type"] = os_disk_type
        __props__.__dict__["security_type"] = security_type
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_account"] = user_account
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AzureVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adDomainType")
    def ad_domain_type(self) -> pulumi.Output[str]:
        """
        Specify domain service provided by Microsoft Azure for managing identities and access in the cloud. Valid values are `aadjoin` or `addsjoin`.
        """
        return pulumi.get(self, "ad_domain_type")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password associated with the local administrator account.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[str]:
        """
        Specifies the name of the local administrator account.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> pulumi.Output[str]:
        """
        Specify availability set id to which virtual machine should be added to
        """
        return pulumi.get(self, "availability_set_id")

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> pulumi.Output[str]:
        """
        Base64 encoded user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[str]:
        """
        Specifies the [size of the Virtual Machine](https://docs.microsoft.com/azure/virtual-machines/sizes-general). See also [Azure VM Naming Conventions](https://docs.microsoft.com/azure/virtual-machines/vm-naming-conventions).
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="diskControlType")
    def disk_control_type(self) -> pulumi.Output[str]:
        """
        disk control types refer to the different levels of management and performance control provided for disks attached to virtual machines (VMs)
        """
        return pulumi.get(self, "disk_control_type")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the size of the OS Disk in gigabytes Defaults to `128`.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="enableEncryptAtHost")
    def enable_encrypt_at_host(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "enable_encrypt_at_host")

    @property
    @pulumi.getter(name="enableLogAnalytics")
    def enable_log_analytics(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable log analytics on virtual machine. Defaults to `false`.
        """
        return pulumi.get(self, "enable_log_analytics")

    @property
    @pulumi.getter(name="enableSecurityBoot")
    def enable_security_boot(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify to enable Secure Boot for your VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_security_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify to enable virtual Trusted Platform Module (vTPM) for Azure VM. Used with security_type=TrustedLaunch Defaults to `true`.
        """
        return pulumi.get(self, "enable_vtpm")

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "encrypt_disk")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the host.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The Image ID to use to create virtual machine. Provide id as semicolon separated string with sequence of sku, publisher and offer. For example, 16.04-LTS;Canonical;UbuntuServe
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The Azure Virtual Machine ID of the host.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_minion")

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> pulumi.Output[Optional[bool]]:
        """
        Join a Windows Server virtual machine to an Azure Active Directory Domain Services. Defaults to `false`.
        """
        return pulumi.get(self, "join_domain")

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> pulumi.Output[Sequence['outputs.AzureVirtualMachineMinionTag']]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_ZRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "os_disk_type")

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specify "Standard" or "TrustedLaunch" security type. Defaults to "Standard".
        		Use TrustedLaunch for the security of "Generation 2" virtual machines (VMs).
        		[Supported Sizes](https://learn.microsoft.com/en-us/azure/virtual-machines/trusted-launch#virtual-machines-sizes)
        		 Defaults to `Standard`.
        """
        return pulumi.get(self, "security_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the host.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Subnet ID which should be associated with the Virtual Machine.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AzureVirtualMachineTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> pulumi.Output[str]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.AzureVirtualMachineVolume']]]:
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until azure virtual machine to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

