# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureVirtualMachineScaleSetArgs', 'AzureVirtualMachineScaleSet']

@pulumi.input_type
class AzureVirtualMachineScaleSetArgs:
    def __init__(__self__, *,
                 network_profiles: pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]],
                 os_profile: pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs'],
                 sku: pulumi.Input['AzureVirtualMachineScaleSetSkuArgs'],
                 tenant_id: pulumi.Input[str],
                 upgrade_policy_mode: pulumi.Input[str],
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_profile_linux_config: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']] = None,
                 storage_profile_os_disk: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AzureVirtualMachineScaleSet resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure virtual machine scale set will be created in.
        :param pulumi.Input[str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        :param pulumi.Input[bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set.
        :param pulumi.Input[str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        :param pulumi.Input[bool] is_minion: Defaults to `false`.
        :param pulumi.Input[str] license_type: Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[str] name: Specifies the name of the virtual machine scale set resource.
        :param pulumi.Input[bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        :param pulumi.Input[str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        :param pulumi.Input[bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "network_profiles", network_profiles)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "upgrade_policy_mode", upgrade_policy_mode)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if automatic_os_upgrade is not None:
            pulumi.set(__self__, "automatic_os_upgrade", automatic_os_upgrade)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_profile_linux_config is not None:
            pulumi.set(__self__, "os_profile_linux_config", os_profile_linux_config)
        if os_profile_secrets is not None:
            pulumi.set(__self__, "os_profile_secrets", os_profile_secrets)
        if os_profile_windows_config is not None:
            pulumi.set(__self__, "os_profile_windows_config", os_profile_windows_config)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if storage_profile_data_disks is not None:
            pulumi.set(__self__, "storage_profile_data_disks", storage_profile_data_disks)
        if storage_profile_image_reference is not None:
            pulumi.set(__self__, "storage_profile_image_reference", storage_profile_image_reference)
        if storage_profile_os_disk is not None:
            pulumi.set(__self__, "storage_profile_os_disk", storage_profile_os_disk)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]]:
        return pulumi.get(self, "network_profiles")

    @network_profiles.setter
    def network_profiles(self, value: pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]]):
        pulumi.set(self, "network_profiles", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs']:
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs']):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['AzureVirtualMachineScaleSetSkuArgs']:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['AzureVirtualMachineScaleSetSkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure virtual machine scale set will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> pulumi.Input[str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @upgrade_policy_mode.setter
    def upgrade_policy_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_policy_mode", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @automatic_os_upgrade.setter
    def automatic_os_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_os_upgrade", value)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']]:
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eviction_policy", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]]:
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_probe_id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']]:
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the virtual machine scale set resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']]:
        return pulumi.get(self, "os_profile_linux_config")

    @os_profile_linux_config.setter
    def os_profile_linux_config(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']]):
        pulumi.set(self, "os_profile_linux_config", value)

    @property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]]:
        return pulumi.get(self, "os_profile_secrets")

    @os_profile_secrets.setter
    def os_profile_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]]):
        pulumi.set(self, "os_profile_secrets", value)

    @property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']]:
        return pulumi.get(self, "os_profile_windows_config")

    @os_profile_windows_config.setter
    def os_profile_windows_config(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']]):
        pulumi.set(self, "os_profile_windows_config", value)

    @property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overprovision", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']]:
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_placement_group", value)

    @property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]]:
        return pulumi.get(self, "storage_profile_data_disks")

    @storage_profile_data_disks.setter
    def storage_profile_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]]):
        pulumi.set(self, "storage_profile_data_disks", value)

    @property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']]:
        return pulumi.get(self, "storage_profile_image_reference")

    @storage_profile_image_reference.setter
    def storage_profile_image_reference(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']]):
        pulumi.set(self, "storage_profile_image_reference", value)

    @property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']]:
        return pulumi.get(self, "storage_profile_os_disk")

    @storage_profile_os_disk.setter
    def storage_profile_os_disk(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']]):
        pulumi.set(self, "storage_profile_os_disk", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _AzureVirtualMachineScaleSetState:
    def __init__(__self__, *,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]]] = None,
                 os_profile: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs']] = None,
                 os_profile_linux_config: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input['AzureVirtualMachineScaleSetSkuArgs']] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']] = None,
                 storage_profile_os_disk: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AzureVirtualMachineScaleSet resources.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        :param pulumi.Input[bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set.
        :param pulumi.Input[str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        :param pulumi.Input[bool] is_minion: Defaults to `false`.
        :param pulumi.Input[str] license_type: Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[str] name: Specifies the name of the virtual machine scale set resource.
        :param pulumi.Input[bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        :param pulumi.Input[str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        :param pulumi.Input[bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure virtual machine scale set will be created in.
        :param pulumi.Input[str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if automatic_os_upgrade is not None:
            pulumi.set(__self__, "automatic_os_upgrade", automatic_os_upgrade)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profiles is not None:
            pulumi.set(__self__, "network_profiles", network_profiles)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if os_profile_linux_config is not None:
            pulumi.set(__self__, "os_profile_linux_config", os_profile_linux_config)
        if os_profile_secrets is not None:
            pulumi.set(__self__, "os_profile_secrets", os_profile_secrets)
        if os_profile_windows_config is not None:
            pulumi.set(__self__, "os_profile_windows_config", os_profile_windows_config)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_profile_data_disks is not None:
            pulumi.set(__self__, "storage_profile_data_disks", storage_profile_data_disks)
        if storage_profile_image_reference is not None:
            pulumi.set(__self__, "storage_profile_image_reference", storage_profile_image_reference)
        if storage_profile_os_disk is not None:
            pulumi.set(__self__, "storage_profile_os_disk", storage_profile_os_disk)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if upgrade_policy_mode is not None:
            pulumi.set(__self__, "upgrade_policy_mode", upgrade_policy_mode)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @automatic_os_upgrade.setter
    def automatic_os_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_os_upgrade", value)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']]:
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eviction_policy", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]]:
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_probe_id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']]:
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the virtual machine scale set resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]]]:
        return pulumi.get(self, "network_profiles")

    @network_profiles.setter
    def network_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetNetworkProfileArgs']]]]):
        pulumi.set(self, "network_profiles", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs']]:
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']]:
        return pulumi.get(self, "os_profile_linux_config")

    @os_profile_linux_config.setter
    def os_profile_linux_config(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs']]):
        pulumi.set(self, "os_profile_linux_config", value)

    @property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]]:
        return pulumi.get(self, "os_profile_secrets")

    @os_profile_secrets.setter
    def os_profile_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetOsProfileSecretArgs']]]]):
        pulumi.set(self, "os_profile_secrets", value)

    @property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']]:
        return pulumi.get(self, "os_profile_windows_config")

    @os_profile_windows_config.setter
    def os_profile_windows_config(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs']]):
        pulumi.set(self, "os_profile_windows_config", value)

    @property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overprovision", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']]:
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_placement_group", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetSkuArgs']]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]]:
        return pulumi.get(self, "storage_profile_data_disks")

    @storage_profile_data_disks.setter
    def storage_profile_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs']]]]):
        pulumi.set(self, "storage_profile_data_disks", value)

    @property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']]:
        return pulumi.get(self, "storage_profile_image_reference")

    @storage_profile_image_reference.setter
    def storage_profile_image_reference(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs']]):
        pulumi.set(self, "storage_profile_image_reference", value)

    @property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']]:
        return pulumi.get(self, "storage_profile_os_disk")

    @storage_profile_os_disk.setter
    def storage_profile_os_disk(self, value: Optional[pulumi.Input['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs']]):
        pulumi.set(self, "storage_profile_os_disk", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure virtual machine scale set will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @upgrade_policy_mode.setter
    def upgrade_policy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_policy_mode", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class AzureVirtualMachineScaleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetBootDiagnosticsArgs', 'AzureVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetExtensionArgs', 'AzureVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetIdentityArgs', 'AzureVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetNetworkProfileArgs', 'AzureVirtualMachineScaleSetNetworkProfileArgsDict']]]]] = None,
                 os_profile: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileArgs', 'AzureVirtualMachineScaleSetOsProfileArgsDict']]] = None,
                 os_profile_linux_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs', 'AzureVirtualMachineScaleSetOsProfileLinuxConfigArgsDict']]] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileSecretArgs', 'AzureVirtualMachineScaleSetOsProfileSecretArgsDict']]]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs', 'AzureVirtualMachineScaleSetOsProfileWindowsConfigArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetPlanArgs', 'AzureVirtualMachineScaleSetPlanArgsDict']]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs', 'AzureVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetSkuArgs', 'AzureVirtualMachineScaleSetSkuArgsDict']]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs', 'AzureVirtualMachineScaleSetStorageProfileImageReferenceArgsDict']]] = None,
                 storage_profile_os_disk: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileOsDiskArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        `AzureVirtualMachineScaleSet` manages an azure virtual machine scale set in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        vmss = duplocloud.AzureVirtualMachineScaleSet("vmss",
            tenant_id=myapp.tenant_id,
            name="tstvmss",
            sku={
                "tier": "Standard",
                "name": "Standard_D1_v2",
                "capacity": 2,
            },
            os_profile={
                "admin_password": "DuploTest007",
                "admin_username": "duploadmin",
                "computer_name_prefix": "tst",
            },
            storage_profile_image_reference={
                "sku": "2016-Datacenter",
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "version": "latest",
            },
            network_profiles=[{
                "name": "tstvmss",
                "primary": True,
                "ip_configurations": [{
                    "name": "tstvmss",
                    "subnet_id": "/subscriptions/143ffc59-9394-4ec6-8f5a-c408a238be62/resourceGroups/duploinfra-testdb/providers/Microsoft.Network/virtualNetworks/testdb/subnets/duploinfra-sub01",
                }],
                "ip_forwarding": True,
            }],
            upgrade_policy_mode="Manual",
            overprovision=True,
            single_placement_group=True)
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Scale Set

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Virtual Machine Scale Set

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVirtualMachineScaleSet:AzureVirtualMachineScaleSet myvmss *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        :param pulumi.Input[bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set.
        :param pulumi.Input[str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        :param pulumi.Input[bool] is_minion: Defaults to `false`.
        :param pulumi.Input[str] license_type: Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[str] name: Specifies the name of the virtual machine scale set resource.
        :param pulumi.Input[bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        :param pulumi.Input[str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        :param pulumi.Input[bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure virtual machine scale set will be created in.
        :param pulumi.Input[str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVirtualMachineScaleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureVirtualMachineScaleSet` manages an azure virtual machine scale set in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        vmss = duplocloud.AzureVirtualMachineScaleSet("vmss",
            tenant_id=myapp.tenant_id,
            name="tstvmss",
            sku={
                "tier": "Standard",
                "name": "Standard_D1_v2",
                "capacity": 2,
            },
            os_profile={
                "admin_password": "DuploTest007",
                "admin_username": "duploadmin",
                "computer_name_prefix": "tst",
            },
            storage_profile_image_reference={
                "sku": "2016-Datacenter",
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "version": "latest",
            },
            network_profiles=[{
                "name": "tstvmss",
                "primary": True,
                "ip_configurations": [{
                    "name": "tstvmss",
                    "subnet_id": "/subscriptions/143ffc59-9394-4ec6-8f5a-c408a238be62/resourceGroups/duploinfra-testdb/providers/Microsoft.Network/virtualNetworks/testdb/subnets/duploinfra-sub01",
                }],
                "ip_forwarding": True,
            }],
            upgrade_policy_mode="Manual",
            overprovision=True,
            single_placement_group=True)
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Scale Set

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the Azure Virtual Machine Scale Set

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVirtualMachineScaleSet:AzureVirtualMachineScaleSet myvmss *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureVirtualMachineScaleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVirtualMachineScaleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetBootDiagnosticsArgs', 'AzureVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetExtensionArgs', 'AzureVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetIdentityArgs', 'AzureVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetNetworkProfileArgs', 'AzureVirtualMachineScaleSetNetworkProfileArgsDict']]]]] = None,
                 os_profile: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileArgs', 'AzureVirtualMachineScaleSetOsProfileArgsDict']]] = None,
                 os_profile_linux_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs', 'AzureVirtualMachineScaleSetOsProfileLinuxConfigArgsDict']]] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileSecretArgs', 'AzureVirtualMachineScaleSetOsProfileSecretArgsDict']]]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs', 'AzureVirtualMachineScaleSetOsProfileWindowsConfigArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetPlanArgs', 'AzureVirtualMachineScaleSetPlanArgsDict']]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs', 'AzureVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetSkuArgs', 'AzureVirtualMachineScaleSetSkuArgsDict']]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs', 'AzureVirtualMachineScaleSetStorageProfileImageReferenceArgsDict']]] = None,
                 storage_profile_os_disk: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileOsDiskArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVirtualMachineScaleSetArgs.__new__(AzureVirtualMachineScaleSetArgs)

            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocation_tags"] = allocation_tags
            __props__.__dict__["automatic_os_upgrade"] = automatic_os_upgrade
            __props__.__dict__["boot_diagnostics"] = boot_diagnostics
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["health_probe_id"] = health_probe_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["is_minion"] = is_minion
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["name"] = name
            if network_profiles is None and not opts.urn:
                raise TypeError("Missing required property 'network_profiles'")
            __props__.__dict__["network_profiles"] = network_profiles
            if os_profile is None and not opts.urn:
                raise TypeError("Missing required property 'os_profile'")
            __props__.__dict__["os_profile"] = os_profile
            __props__.__dict__["os_profile_linux_config"] = os_profile_linux_config
            __props__.__dict__["os_profile_secrets"] = os_profile_secrets
            __props__.__dict__["os_profile_windows_config"] = os_profile_windows_config
            __props__.__dict__["overprovision"] = overprovision
            __props__.__dict__["plan"] = plan
            __props__.__dict__["priority"] = priority
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
            __props__.__dict__["single_placement_group"] = single_placement_group
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["storage_profile_data_disks"] = storage_profile_data_disks
            __props__.__dict__["storage_profile_image_reference"] = storage_profile_image_reference
            __props__.__dict__["storage_profile_os_disk"] = storage_profile_os_disk
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if upgrade_policy_mode is None and not opts.urn:
                raise TypeError("Missing required property 'upgrade_policy_mode'")
            __props__.__dict__["upgrade_policy_mode"] = upgrade_policy_mode
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["zones"] = zones
            __props__.__dict__["location"] = None
        super(AzureVirtualMachineScaleSet, __self__).__init__(
            'duplocloud:index/azureVirtualMachineScaleSet:AzureVirtualMachineScaleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocation_tags: Optional[pulumi.Input[str]] = None,
            automatic_os_upgrade: Optional[pulumi.Input[bool]] = None,
            boot_diagnostics: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetBootDiagnosticsArgs', 'AzureVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
            eviction_policy: Optional[pulumi.Input[str]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetExtensionArgs', 'AzureVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
            health_probe_id: Optional[pulumi.Input[str]] = None,
            identity: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetIdentityArgs', 'AzureVirtualMachineScaleSetIdentityArgsDict']]] = None,
            is_minion: Optional[pulumi.Input[bool]] = None,
            license_type: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetNetworkProfileArgs', 'AzureVirtualMachineScaleSetNetworkProfileArgsDict']]]]] = None,
            os_profile: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileArgs', 'AzureVirtualMachineScaleSetOsProfileArgsDict']]] = None,
            os_profile_linux_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileLinuxConfigArgs', 'AzureVirtualMachineScaleSetOsProfileLinuxConfigArgsDict']]] = None,
            os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileSecretArgs', 'AzureVirtualMachineScaleSetOsProfileSecretArgsDict']]]]] = None,
            os_profile_windows_config: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetOsProfileWindowsConfigArgs', 'AzureVirtualMachineScaleSetOsProfileWindowsConfigArgsDict']]] = None,
            overprovision: Optional[pulumi.Input[bool]] = None,
            plan: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetPlanArgs', 'AzureVirtualMachineScaleSetPlanArgsDict']]] = None,
            priority: Optional[pulumi.Input[str]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
            rolling_upgrade_policy: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetRollingUpgradePolicyArgs', 'AzureVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
            single_placement_group: Optional[pulumi.Input[bool]] = None,
            sku: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetSkuArgs', 'AzureVirtualMachineScaleSetSkuArgsDict']]] = None,
            storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileDataDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
            storage_profile_image_reference: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileImageReferenceArgs', 'AzureVirtualMachineScaleSetStorageProfileImageReferenceArgsDict']]] = None,
            storage_profile_os_disk: Optional[pulumi.Input[Union['AzureVirtualMachineScaleSetStorageProfileOsDiskArgs', 'AzureVirtualMachineScaleSetStorageProfileOsDiskArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            upgrade_policy_mode: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AzureVirtualMachineScaleSet':
        """
        Get an existing AzureVirtualMachineScaleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        :param pulumi.Input[bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set.
        :param pulumi.Input[str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        :param pulumi.Input[bool] is_minion: Defaults to `false`.
        :param pulumi.Input[str] license_type: Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[str] name: Specifies the name of the virtual machine scale set resource.
        :param pulumi.Input[bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        :param pulumi.Input[str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        :param pulumi.Input[bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure virtual machine scale set will be created in.
        :param pulumi.Input[str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVirtualMachineScaleSetState.__new__(_AzureVirtualMachineScaleSetState)

        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocation_tags"] = allocation_tags
        __props__.__dict__["automatic_os_upgrade"] = automatic_os_upgrade
        __props__.__dict__["boot_diagnostics"] = boot_diagnostics
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["health_probe_id"] = health_probe_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["is_minion"] = is_minion
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profiles"] = network_profiles
        __props__.__dict__["os_profile"] = os_profile
        __props__.__dict__["os_profile_linux_config"] = os_profile_linux_config
        __props__.__dict__["os_profile_secrets"] = os_profile_secrets
        __props__.__dict__["os_profile_windows_config"] = os_profile_windows_config
        __props__.__dict__["overprovision"] = overprovision
        __props__.__dict__["plan"] = plan
        __props__.__dict__["priority"] = priority
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
        __props__.__dict__["single_placement_group"] = single_placement_group
        __props__.__dict__["sku"] = sku
        __props__.__dict__["storage_profile_data_disks"] = storage_profile_data_disks
        __props__.__dict__["storage_profile_image_reference"] = storage_profile_image_reference
        __props__.__dict__["storage_profile_os_disk"] = storage_profile_os_disk
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["upgrade_policy_mode"] = upgrade_policy_mode
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        __props__.__dict__["zones"] = zones
        return AzureVirtualMachineScaleSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this VM is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "allocation_tags")

    @property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> pulumi.Output[Optional['outputs.AzureVirtualMachineScaleSetBootDiagnostics']]:
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set.
        """
        return pulumi.get(self, "eviction_policy")

    @property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence['outputs.AzureVirtualMachineScaleSetExtension']]]:
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`
        """
        return pulumi.get(self, "health_probe_id")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetIdentity']:
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_minion")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[str]:
        """
        Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the virtual machine scale set resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> pulumi.Output[Sequence['outputs.AzureVirtualMachineScaleSetNetworkProfile']]:
        return pulumi.get(self, "network_profiles")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetOsProfile']:
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetOsProfileLinuxConfig']:
        return pulumi.get(self, "os_profile_linux_config")

    @property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> pulumi.Output[Optional[Sequence['outputs.AzureVirtualMachineScaleSetOsProfileSecret']]]:
        return pulumi.get(self, "os_profile_secrets")

    @property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetOsProfileWindowsConfig']:
        return pulumi.get(self, "os_profile_windows_config")

    @property
    @pulumi.getter
    def overprovision(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.AzureVirtualMachineScaleSetPlan']]:
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Defaults to `Regular`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> pulumi.Output[Optional['outputs.AzureVirtualMachineScaleSetRollingUpgradePolicy']]:
        return pulumi.get(self, "rolling_upgrade_policy")

    @property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetSku']:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.AzureVirtualMachineScaleSetStorageProfileDataDisk']]]:
        return pulumi.get(self, "storage_profile_data_disks")

    @property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetStorageProfileImageReference']:
        return pulumi.get(self, "storage_profile_image_reference")

    @property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> pulumi.Output['outputs.AzureVirtualMachineScaleSetStorageProfileOsDisk']:
        return pulumi.get(self, "storage_profile_os_disk")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure virtual machine scale set will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> pulumi.Output[str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing Rolling, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until virtual machine scale set to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "zones")

