# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureVmFeatureArgs', 'AzureVmFeature']

@pulumi.input_type
class AzureVmFeatureArgs:
    def __init__(__self__, *,
                 component_id: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 feature_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AzureVmFeature resource.
        :param pulumi.Input[str] component_id: Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] enabled: The status of the VM feature. By default, this is set to false.
        :param pulumi.Input[str] feature_name: The name of the VM feature to be enabled.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        """
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "feature_name", feature_name)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Input[str]:
        """
        Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The status of the VM feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> pulumi.Input[str]:
        """
        The name of the VM feature to be enabled.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _AzureVmFeatureState:
    def __init__(__self__, *,
                 component_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureVmFeature resources.
        :param pulumi.Input[str] component_id: Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] enabled: The status of the VM feature. By default, this is set to false.
        :param pulumi.Input[str] feature_name: The name of the VM feature to be enabled.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        """
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the VM feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VM feature to be enabled.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AzureVmFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AzureVmFeature` manages an Azure VM Feature in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # supported feature names are "loganalytics", "publicip", "addsjoin", and "aadjoin"
        vm_feature = duplocloud.AzureVmFeature("vm_feature",
            tenant_id=myapp.tenant_id,
            component_id="p01-host01",
            feature_name="aadjoin",
            enabled=True)
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Feature

         - *TENANT_ID* is the tenant GUID

         - *VM_NAME* is the short name of the Azure Virtual Machine

         - *FEATURE_NAME* is the short name of the Azure Virtual Machine Feature

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVmFeature:AzureVmFeature vm_feature *TENANT_ID*/*VM_NAME*/*FEATURE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] component_id: Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] enabled: The status of the VM feature. By default, this is set to false.
        :param pulumi.Input[str] feature_name: The name of the VM feature to be enabled.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVmFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureVmFeature` manages an Azure VM Feature in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # supported feature names are "loganalytics", "publicip", "addsjoin", and "aadjoin"
        vm_feature = duplocloud.AzureVmFeature("vm_feature",
            tenant_id=myapp.tenant_id,
            component_id="p01-host01",
            feature_name="aadjoin",
            enabled=True)
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Feature

         - *TENANT_ID* is the tenant GUID

         - *VM_NAME* is the short name of the Azure Virtual Machine

         - *FEATURE_NAME* is the short name of the Azure Virtual Machine Feature

        # 

        ```sh
        $ pulumi import duplocloud:index/azureVmFeature:AzureVmFeature vm_feature *TENANT_ID*/*VM_NAME*/*FEATURE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AzureVmFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVmFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVmFeatureArgs.__new__(AzureVmFeatureArgs)

            if component_id is None and not opts.urn:
                raise TypeError("Missing required property 'component_id'")
            __props__.__dict__["component_id"] = component_id
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'feature_name'")
            __props__.__dict__["feature_name"] = feature_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AzureVmFeature, __self__).__init__(
            'duplocloud:index/azureVmFeature:AzureVmFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            component_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            feature_name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AzureVmFeature':
        """
        Get an existing AzureVmFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] component_id: Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        :param pulumi.Input[bool] enabled: The status of the VM feature. By default, this is set to false.
        :param pulumi.Input[str] feature_name: The name of the VM feature to be enabled.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVmFeatureState.__new__(_AzureVmFeatureState)

        __props__.__dict__["component_id"] = component_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["feature_name"] = feature_name
        __props__.__dict__["tenant_id"] = tenant_id
        return AzureVmFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Output[str]:
        """
        Specifies the name of the VM created in duplo. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        The status of the VM feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> pulumi.Output[str]:
        """
        The name of the VM feature to be enabled.
        """
        return pulumi.get(self, "feature_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

