# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureVmMaintenanceConfigurationArgs', 'AzureVmMaintenanceConfiguration']

@pulumi.input_type
class AzureVmMaintenanceConfigurationArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 vm_name: pulumi.Input[str],
                 visiblity: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']] = None):
        """
        The set of arguments for constructing a AzureVmMaintenanceConfiguration resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        :param pulumi.Input[str] vm_name: The name of the virtual machine where maintenance configuration need to be configured.
        :param pulumi.Input[str] visiblity: The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        :param pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs'] window: Block to configure maintenance window
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "vm_name", vm_name)
        if visiblity is not None:
            pulumi.set(__self__, "visiblity", visiblity)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> pulumi.Input[str]:
        """
        The name of the virtual machine where maintenance configuration need to be configured.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_name", value)

    @property
    @pulumi.getter
    def visiblity(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        """
        return pulumi.get(self, "visiblity")

    @visiblity.setter
    def visiblity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visiblity", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']]:
        """
        Block to configure maintenance window
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class _AzureVmMaintenanceConfigurationState:
    def __init__(__self__, *,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 visiblity: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']] = None):
        """
        Input properties used for looking up and filtering AzureVmMaintenanceConfiguration resources.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        :param pulumi.Input[str] visiblity: The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        :param pulumi.Input[str] vm_name: The name of the virtual machine where maintenance configuration need to be configured.
        :param pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs'] window: Block to configure maintenance window
        """
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if visiblity is not None:
            pulumi.set(__self__, "visiblity", visiblity)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def visiblity(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        """
        return pulumi.get(self, "visiblity")

    @visiblity.setter
    def visiblity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visiblity", value)

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine where maintenance configuration need to be configured.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_name", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']]:
        """
        Block to configure maintenance window
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['AzureVmMaintenanceConfigurationWindowArgs']]):
        pulumi.set(self, "window", value)


class AzureVmMaintenanceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 visiblity: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input[Union['AzureVmMaintenanceConfigurationWindowArgs', 'AzureVmMaintenanceConfigurationWindowArgsDict']]] = None,
                 __props__=None):
        """
        `AzureVmMaintenanceConfiguration` manages maintenance window to an azure vm

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mt = duplocloud.AzureVmMaintenanceConfiguration("mt",
            tenant_id=myapp.tenant_id,
            vm_name="schedl",
            window={
                "start_time": "2024-11-12 00:00",
                "expiration_time": "2024-11-19 00:00",
                "duration": "06:00",
                "recur_every": "1Month day1,day2,day3,day4,day5,day6,day7,day8,day9,day10,day11,day12,day13,day14,day15,day16,day17,day18,day19,day20,day21,day22,day23,day24,day25,day26,day27,day28,day29,day30,day31,day-1",
                "time_zone": "India Standard Time",
            })
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Feature

         - *TENANT_ID* is the tenant GUID

         - *VM_NAME* is the short name of the Azure Virtual Machine

        ```sh
        $ pulumi import duplocloud:index/azureVmMaintenanceConfiguration:AzureVmMaintenanceConfiguration maintenance *TENANT_ID*/*VM_NAME*/maintenance-configuration
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        :param pulumi.Input[str] visiblity: The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        :param pulumi.Input[str] vm_name: The name of the virtual machine where maintenance configuration need to be configured.
        :param pulumi.Input[Union['AzureVmMaintenanceConfigurationWindowArgs', 'AzureVmMaintenanceConfigurationWindowArgsDict']] window: Block to configure maintenance window
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVmMaintenanceConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AzureVmMaintenanceConfiguration` manages maintenance window to an azure vm

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mt = duplocloud.AzureVmMaintenanceConfiguration("mt",
            tenant_id=myapp.tenant_id,
            vm_name="schedl",
            window={
                "start_time": "2024-11-12 00:00",
                "expiration_time": "2024-11-19 00:00",
                "duration": "06:00",
                "recur_every": "1Month day1,day2,day3,day4,day5,day6,day7,day8,day9,day10,day11,day12,day13,day14,day15,day16,day17,day18,day19,day20,day21,day22,day23,day24,day25,day26,day27,day28,day29,day30,day31,day-1",
                "time_zone": "India Standard Time",
            })
        ```

        ## Import

        Example: Importing an existing Azure Virtual Machine Feature

         - *TENANT_ID* is the tenant GUID

         - *VM_NAME* is the short name of the Azure Virtual Machine

        ```sh
        $ pulumi import duplocloud:index/azureVmMaintenanceConfiguration:AzureVmMaintenanceConfiguration maintenance *TENANT_ID*/*VM_NAME*/maintenance-configuration
        ```

        :param str resource_name: The name of the resource.
        :param AzureVmMaintenanceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVmMaintenanceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 visiblity: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input[Union['AzureVmMaintenanceConfigurationWindowArgs', 'AzureVmMaintenanceConfigurationWindowArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVmMaintenanceConfigurationArgs.__new__(AzureVmMaintenanceConfigurationArgs)

            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["visiblity"] = visiblity
            if vm_name is None and not opts.urn:
                raise TypeError("Missing required property 'vm_name'")
            __props__.__dict__["vm_name"] = vm_name
            __props__.__dict__["window"] = window
        super(AzureVmMaintenanceConfiguration, __self__).__init__(
            'duplocloud:index/azureVmMaintenanceConfiguration:AzureVmMaintenanceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            visiblity: Optional[pulumi.Input[str]] = None,
            vm_name: Optional[pulumi.Input[str]] = None,
            window: Optional[pulumi.Input[Union['AzureVmMaintenanceConfigurationWindowArgs', 'AzureVmMaintenanceConfigurationWindowArgsDict']]] = None) -> 'AzureVmMaintenanceConfiguration':
        """
        Get an existing AzureVmMaintenanceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the azure vm feature will be created in.
        :param pulumi.Input[str] visiblity: The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        :param pulumi.Input[str] vm_name: The name of the virtual machine where maintenance configuration need to be configured.
        :param pulumi.Input[Union['AzureVmMaintenanceConfigurationWindowArgs', 'AzureVmMaintenanceConfigurationWindowArgsDict']] window: Block to configure maintenance window
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVmMaintenanceConfigurationState.__new__(_AzureVmMaintenanceConfigurationState)

        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["visiblity"] = visiblity
        __props__.__dict__["vm_name"] = vm_name
        __props__.__dict__["window"] = window
        return AzureVmMaintenanceConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the azure vm feature will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def visiblity(self) -> pulumi.Output[Optional[str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is Custom. Defaults to `Custom`.
        """
        return pulumi.get(self, "visiblity")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> pulumi.Output[str]:
        """
        The name of the virtual machine where maintenance configuration need to be configured.
        """
        return pulumi.get(self, "vm_name")

    @property
    @pulumi.getter
    def window(self) -> pulumi.Output['outputs.AzureVmMaintenanceConfigurationWindow']:
        """
        Block to configure maintenance window
        """
        return pulumi.get(self, "window")

