# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ByohArgs', 'Byoh']

@pulumi.input_type
class ByohArgs:
    def __init__(__self__, *,
                 direct_address: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Byoh resource.
        :param pulumi.Input[str] direct_address: IP address of the BYOH instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the BYHO will be created in.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        :param pulumi.Input[str] allocation_tag: Allocation tag for BYOH instance.
        :param pulumi.Input[str] name: The name of the BYOH instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] password: Password of the BYOH instance.
        :param pulumi.Input[str] private_key: Private key for BYOH instance.
        :param pulumi.Input[str] username: Username of the BYOH instance.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        pulumi.set(__self__, "direct_address", direct_address)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tag is not None:
            pulumi.set(__self__, "allocation_tag", allocation_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="directAddress")
    def direct_address(self) -> pulumi.Input[str]:
        """
        IP address of the BYOH instance.
        """
        return pulumi.get(self, "direct_address")

    @direct_address.setter
    def direct_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "direct_address", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the BYHO will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tag for BYOH instance.
        """
        return pulumi.get(self, "allocation_tag")

    @allocation_tag.setter
    def allocation_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the BYOH instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the BYOH instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private key for BYOH instance.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the BYOH instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _ByohState:
    def __init__(__self__, *,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 connection_url: Optional[pulumi.Input[str]] = None,
                 direct_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_agent_url: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ByohTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Byoh resources.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        :param pulumi.Input[str] allocation_tag: Allocation tag for BYOH instance.
        :param pulumi.Input[str] direct_address: IP address of the BYOH instance.
        :param pulumi.Input[str] name: The name of the BYOH instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] password: Password of the BYOH instance.
        :param pulumi.Input[str] private_key: Private key for BYOH instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the BYHO will be created in.
        :param pulumi.Input[str] username: Username of the BYOH instance.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tag is not None:
            pulumi.set(__self__, "allocation_tag", allocation_tag)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if direct_address is not None:
            pulumi.set(__self__, "direct_address", direct_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_agent_url is not None:
            pulumi.set(__self__, "network_agent_url", network_agent_url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tag for BYOH instance.
        """
        return pulumi.get(self, "allocation_tag")

    @allocation_tag.setter
    def allocation_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tag", value)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "connection_url")

    @connection_url.setter
    def connection_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_url", value)

    @property
    @pulumi.getter(name="directAddress")
    def direct_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the BYOH instance.
        """
        return pulumi.get(self, "direct_address")

    @direct_address.setter
    def direct_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the BYOH instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkAgentUrl")
    def network_agent_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_agent_url")

    @network_agent_url.setter
    def network_agent_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_agent_url", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the BYOH instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private key for BYOH instance.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ByohTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ByohTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the BYHO will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the BYOH instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class Byoh(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 direct_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `Byoh` manages BYOH in Duplo.

        ## Import

        Example: Importing an existing BYOH Instance.

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of BYOH Instance.

        # 

        ```sh
        $ pulumi import duplocloud:index/byoh:Byoh byoh *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        :param pulumi.Input[str] allocation_tag: Allocation tag for BYOH instance.
        :param pulumi.Input[str] direct_address: IP address of the BYOH instance.
        :param pulumi.Input[str] name: The name of the BYOH instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] password: Password of the BYOH instance.
        :param pulumi.Input[str] private_key: Private key for BYOH instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the BYHO will be created in.
        :param pulumi.Input[str] username: Username of the BYOH instance.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ByohArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Byoh` manages BYOH in Duplo.

        ## Import

        Example: Importing an existing BYOH Instance.

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of BYOH Instance.

        # 

        ```sh
        $ pulumi import duplocloud:index/byoh:Byoh byoh *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param ByohArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ByohArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tag: Optional[pulumi.Input[str]] = None,
                 direct_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ByohArgs.__new__(ByohArgs)

            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocation_tag"] = allocation_tag
            if direct_address is None and not opts.urn:
                raise TypeError("Missing required property 'direct_address'")
            __props__.__dict__["direct_address"] = direct_address
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["username"] = username
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["connection_url"] = None
            __props__.__dict__["network_agent_url"] = None
            __props__.__dict__["tags"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Byoh, __self__).__init__(
            'duplocloud:index/byoh:Byoh',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocation_tag: Optional[pulumi.Input[str]] = None,
            connection_url: Optional[pulumi.Input[str]] = None,
            direct_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_agent_url: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ByohTagArgs', 'ByohTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'Byoh':
        """
        Get an existing Byoh resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        :param pulumi.Input[str] allocation_tag: Allocation tag for BYOH instance.
        :param pulumi.Input[str] direct_address: IP address of the BYOH instance.
        :param pulumi.Input[str] name: The name of the BYOH instance. Changing this forces a new resource to be created.
        :param pulumi.Input[str] password: Password of the BYOH instance.
        :param pulumi.Input[str] private_key: Private key for BYOH instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the BYHO will be created in.
        :param pulumi.Input[str] username: Username of the BYOH instance.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ByohState.__new__(_ByohState)

        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocation_tag"] = allocation_tag
        __props__.__dict__["connection_url"] = connection_url
        __props__.__dict__["direct_address"] = direct_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_agent_url"] = network_agent_url
        __props__.__dict__["password"] = password
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["username"] = username
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return Byoh(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this instance is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocationTag")
    def allocation_tag(self) -> pulumi.Output[str]:
        """
        Allocation tag for BYOH instance.
        """
        return pulumi.get(self, "allocation_tag")

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="directAddress")
    def direct_address(self) -> pulumi.Output[str]:
        """
        IP address of the BYOH instance.
        """
        return pulumi.get(self, "direct_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the BYOH instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAgentUrl")
    def network_agent_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "network_agent_url")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password of the BYOH instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[str]]:
        """
        Private key for BYOH instance.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.ByohTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the BYHO will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Username of the BYOH instance.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until BYOH instance to be connected to the fleet, after creation. Defaults to `false`.
        """
        return pulumi.get(self, "wait_until_ready")

