# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DuploServiceArgs', 'DuploService']

@pulumi.input_type
class DuploServiceArgs:
    def __init__(__self__, *,
                 docker_image: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cloud_creds_from_k8s_service_account: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[str]] = None,
                 extra_config: Optional[pulumi.Input[str]] = None,
                 force_recreate_on_volumes_change: Optional[pulumi.Input[bool]] = None,
                 force_stateful_set: Optional[pulumi.Input[bool]] = None,
                 hpa_specs: Optional[pulumi.Input[str]] = None,
                 is_daemonset: Optional[pulumi.Input[bool]] = None,
                 is_unique_k8s_node_required: Optional[pulumi.Input[bool]] = None,
                 lb_synced_deployment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 other_docker_config: Optional[pulumi.Input[str]] = None,
                 other_docker_host_config: Optional[pulumi.Input[str]] = None,
                 replica_collocation_allowed: Optional[pulumi.Input[bool]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 replicas_matching_asg_name: Optional[pulumi.Input[str]] = None,
                 should_spread_across_zones: Optional[pulumi.Input[bool]] = None,
                 volumes: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DuploService resource.
        :param pulumi.Input[str] docker_image: The docker image to use for the launched container(s).
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
               `7` : Linux container agent for Kubernetes
        :param pulumi.Input[bool] any_host_allowed: Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
               `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        :param pulumi.Input[bool] cloud_creds_from_k8s_service_account: Whether or not the service gets it's cloud credentials from Kubernetes service account.
        :param pulumi.Input[bool] force_recreate_on_volumes_change: if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
               the resource.
        :param pulumi.Input[bool] force_stateful_set: Whether or not to force a StatefulSet to be created.
        :param pulumi.Input[bool] is_daemonset: Whether or not to enable DaemonSet.
        :param pulumi.Input[bool] is_unique_k8s_node_required: Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[bool] replica_collocation_allowed: Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        :param pulumi.Input[int] replicas: The number of container replicas to deploy.
        :param pulumi.Input[bool] should_spread_across_zones: Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        :param pulumi.Input[str] volumes: Volumes to be attached to pod.
        """
        pulumi.set(__self__, "docker_image", docker_image)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if any_host_allowed is not None:
            pulumi.set(__self__, "any_host_allowed", any_host_allowed)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_creds_from_k8s_service_account is not None:
            pulumi.set(__self__, "cloud_creds_from_k8s_service_account", cloud_creds_from_k8s_service_account)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if extra_config is not None:
            pulumi.set(__self__, "extra_config", extra_config)
        if force_recreate_on_volumes_change is not None:
            pulumi.set(__self__, "force_recreate_on_volumes_change", force_recreate_on_volumes_change)
        if force_stateful_set is not None:
            pulumi.set(__self__, "force_stateful_set", force_stateful_set)
        if hpa_specs is not None:
            pulumi.set(__self__, "hpa_specs", hpa_specs)
        if is_daemonset is not None:
            pulumi.set(__self__, "is_daemonset", is_daemonset)
        if is_unique_k8s_node_required is not None:
            pulumi.set(__self__, "is_unique_k8s_node_required", is_unique_k8s_node_required)
        if lb_synced_deployment is not None:
            pulumi.set(__self__, "lb_synced_deployment", lb_synced_deployment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if other_docker_config is not None:
            pulumi.set(__self__, "other_docker_config", other_docker_config)
        if other_docker_host_config is not None:
            pulumi.set(__self__, "other_docker_host_config", other_docker_host_config)
        if replica_collocation_allowed is not None:
            pulumi.set(__self__, "replica_collocation_allowed", replica_collocation_allowed)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if replicas_matching_asg_name is not None:
            pulumi.set(__self__, "replicas_matching_asg_name", replicas_matching_asg_name)
        if should_spread_across_zones is not None:
            pulumi.set(__self__, "should_spread_across_zones", should_spread_across_zones)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> pulumi.Input[str]:
        """
        The docker image to use for the launched container(s).
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
        `7` : Linux container agent for Kubernetes
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="anyHostAllowed")
    def any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        """
        return pulumi.get(self, "any_host_allowed")

    @any_host_allowed.setter
    def any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "any_host_allowed", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
        `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="cloudCredsFromK8sServiceAccount")
    def cloud_creds_from_k8s_service_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service gets it's cloud credentials from Kubernetes service account.
        """
        return pulumi.get(self, "cloud_creds_from_k8s_service_account")

    @cloud_creds_from_k8s_service_account.setter
    def cloud_creds_from_k8s_service_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_creds_from_k8s_service_account", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "extra_config")

    @extra_config.setter
    def extra_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_config", value)

    @property
    @pulumi.getter(name="forceRecreateOnVolumesChange")
    def force_recreate_on_volumes_change(self) -> Optional[pulumi.Input[bool]]:
        """
        if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
        the resource.
        """
        return pulumi.get(self, "force_recreate_on_volumes_change")

    @force_recreate_on_volumes_change.setter
    def force_recreate_on_volumes_change(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_recreate_on_volumes_change", value)

    @property
    @pulumi.getter(name="forceStatefulSet")
    def force_stateful_set(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to force a StatefulSet to be created.
        """
        return pulumi.get(self, "force_stateful_set")

    @force_stateful_set.setter
    def force_stateful_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stateful_set", value)

    @property
    @pulumi.getter(name="hpaSpecs")
    def hpa_specs(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hpa_specs")

    @hpa_specs.setter
    def hpa_specs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpa_specs", value)

    @property
    @pulumi.getter(name="isDaemonset")
    def is_daemonset(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable DaemonSet.
        """
        return pulumi.get(self, "is_daemonset")

    @is_daemonset.setter
    def is_daemonset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_daemonset", value)

    @property
    @pulumi.getter(name="isUniqueK8sNodeRequired")
    def is_unique_k8s_node_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        """
        return pulumi.get(self, "is_unique_k8s_node_required")

    @is_unique_k8s_node_required.setter
    def is_unique_k8s_node_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unique_k8s_node_required", value)

    @property
    @pulumi.getter(name="lbSyncedDeployment")
    def lb_synced_deployment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "lb_synced_deployment")

    @lb_synced_deployment.setter
    def lb_synced_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lb_synced_deployment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="otherDockerConfig")
    def other_docker_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "other_docker_config")

    @other_docker_config.setter
    def other_docker_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_docker_config", value)

    @property
    @pulumi.getter(name="otherDockerHostConfig")
    def other_docker_host_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "other_docker_host_config")

    @other_docker_host_config.setter
    def other_docker_host_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_docker_host_config", value)

    @property
    @pulumi.getter(name="replicaCollocationAllowed")
    def replica_collocation_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        """
        return pulumi.get(self, "replica_collocation_allowed")

    @replica_collocation_allowed.setter
    def replica_collocation_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replica_collocation_allowed", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of container replicas to deploy.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="replicasMatchingAsgName")
    def replicas_matching_asg_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "replicas_matching_asg_name")

    @replicas_matching_asg_name.setter
    def replicas_matching_asg_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicas_matching_asg_name", value)

    @property
    @pulumi.getter(name="shouldSpreadAcrossZones")
    def should_spread_across_zones(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        """
        return pulumi.get(self, "should_spread_across_zones")

    @should_spread_across_zones.setter
    def should_spread_across_zones(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_spread_across_zones", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[str]]:
        """
        Volumes to be attached to pod.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _DuploServiceState:
    def __init__(__self__, *,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cloud_creds_from_k8s_service_account: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 extra_config: Optional[pulumi.Input[str]] = None,
                 force_recreate_on_volumes_change: Optional[pulumi.Input[bool]] = None,
                 force_stateful_set: Optional[pulumi.Input[bool]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 fqdn_ex: Optional[pulumi.Input[str]] = None,
                 hpa_specs: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 is_daemonset: Optional[pulumi.Input[bool]] = None,
                 is_unique_k8s_node_required: Optional[pulumi.Input[bool]] = None,
                 lb_synced_deployment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 other_docker_config: Optional[pulumi.Input[str]] = None,
                 other_docker_host_config: Optional[pulumi.Input[str]] = None,
                 parent_domain: Optional[pulumi.Input[str]] = None,
                 replica_collocation_allowed: Optional[pulumi.Input[bool]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 replicas_matching_asg_name: Optional[pulumi.Input[str]] = None,
                 should_spread_across_zones: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DuploService resources.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
               `7` : Linux container agent for Kubernetes
        :param pulumi.Input[bool] any_host_allowed: Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
               `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        :param pulumi.Input[bool] cloud_creds_from_k8s_service_account: Whether or not the service gets it's cloud credentials from Kubernetes service account.
        :param pulumi.Input[str] docker_image: The docker image to use for the launched container(s).
        :param pulumi.Input[str] domain: The service domain (whichever fqdn_ex or fqdn which is non empty)
        :param pulumi.Input[bool] force_recreate_on_volumes_change: if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
               the resource.
        :param pulumi.Input[bool] force_stateful_set: Whether or not to force a StatefulSet to be created.
        :param pulumi.Input[str] fqdn: The fully qualified domain associated with the service
        :param pulumi.Input[str] fqdn_ex: External fully qualified domain associated with the service
        :param pulumi.Input[int] index: The index of the service.
        :param pulumi.Input[bool] is_daemonset: Whether or not to enable DaemonSet.
        :param pulumi.Input[bool] is_unique_k8s_node_required: Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[str] parent_domain: The service's parent domain
        :param pulumi.Input[bool] replica_collocation_allowed: Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        :param pulumi.Input[int] replicas: The number of container replicas to deploy.
        :param pulumi.Input[bool] should_spread_across_zones: Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[str] volumes: Volumes to be attached to pod.
        """
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if any_host_allowed is not None:
            pulumi.set(__self__, "any_host_allowed", any_host_allowed)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_creds_from_k8s_service_account is not None:
            pulumi.set(__self__, "cloud_creds_from_k8s_service_account", cloud_creds_from_k8s_service_account)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if extra_config is not None:
            pulumi.set(__self__, "extra_config", extra_config)
        if force_recreate_on_volumes_change is not None:
            pulumi.set(__self__, "force_recreate_on_volumes_change", force_recreate_on_volumes_change)
        if force_stateful_set is not None:
            pulumi.set(__self__, "force_stateful_set", force_stateful_set)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if fqdn_ex is not None:
            pulumi.set(__self__, "fqdn_ex", fqdn_ex)
        if hpa_specs is not None:
            pulumi.set(__self__, "hpa_specs", hpa_specs)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if is_daemonset is not None:
            pulumi.set(__self__, "is_daemonset", is_daemonset)
        if is_unique_k8s_node_required is not None:
            pulumi.set(__self__, "is_unique_k8s_node_required", is_unique_k8s_node_required)
        if lb_synced_deployment is not None:
            pulumi.set(__self__, "lb_synced_deployment", lb_synced_deployment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if other_docker_config is not None:
            pulumi.set(__self__, "other_docker_config", other_docker_config)
        if other_docker_host_config is not None:
            pulumi.set(__self__, "other_docker_host_config", other_docker_host_config)
        if parent_domain is not None:
            pulumi.set(__self__, "parent_domain", parent_domain)
        if replica_collocation_allowed is not None:
            pulumi.set(__self__, "replica_collocation_allowed", replica_collocation_allowed)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if replicas_matching_asg_name is not None:
            pulumi.set(__self__, "replicas_matching_asg_name", replicas_matching_asg_name)
        if should_spread_across_zones is not None:
            pulumi.set(__self__, "should_spread_across_zones", should_spread_across_zones)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
        `7` : Linux container agent for Kubernetes
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="anyHostAllowed")
    def any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        """
        return pulumi.get(self, "any_host_allowed")

    @any_host_allowed.setter
    def any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "any_host_allowed", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
        `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="cloudCredsFromK8sServiceAccount")
    def cloud_creds_from_k8s_service_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service gets it's cloud credentials from Kubernetes service account.
        """
        return pulumi.get(self, "cloud_creds_from_k8s_service_account")

    @cloud_creds_from_k8s_service_account.setter
    def cloud_creds_from_k8s_service_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_creds_from_k8s_service_account", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        The docker image to use for the launched container(s).
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The service domain (whichever fqdn_ex or fqdn which is non empty)
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "extra_config")

    @extra_config.setter
    def extra_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_config", value)

    @property
    @pulumi.getter(name="forceRecreateOnVolumesChange")
    def force_recreate_on_volumes_change(self) -> Optional[pulumi.Input[bool]]:
        """
        if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
        the resource.
        """
        return pulumi.get(self, "force_recreate_on_volumes_change")

    @force_recreate_on_volumes_change.setter
    def force_recreate_on_volumes_change(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_recreate_on_volumes_change", value)

    @property
    @pulumi.getter(name="forceStatefulSet")
    def force_stateful_set(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to force a StatefulSet to be created.
        """
        return pulumi.get(self, "force_stateful_set")

    @force_stateful_set.setter
    def force_stateful_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stateful_set", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain associated with the service
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="fqdnEx")
    def fqdn_ex(self) -> Optional[pulumi.Input[str]]:
        """
        External fully qualified domain associated with the service
        """
        return pulumi.get(self, "fqdn_ex")

    @fqdn_ex.setter
    def fqdn_ex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_ex", value)

    @property
    @pulumi.getter(name="hpaSpecs")
    def hpa_specs(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hpa_specs")

    @hpa_specs.setter
    def hpa_specs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpa_specs", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the service.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="isDaemonset")
    def is_daemonset(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable DaemonSet.
        """
        return pulumi.get(self, "is_daemonset")

    @is_daemonset.setter
    def is_daemonset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_daemonset", value)

    @property
    @pulumi.getter(name="isUniqueK8sNodeRequired")
    def is_unique_k8s_node_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        """
        return pulumi.get(self, "is_unique_k8s_node_required")

    @is_unique_k8s_node_required.setter
    def is_unique_k8s_node_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unique_k8s_node_required", value)

    @property
    @pulumi.getter(name="lbSyncedDeployment")
    def lb_synced_deployment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "lb_synced_deployment")

    @lb_synced_deployment.setter
    def lb_synced_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lb_synced_deployment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="otherDockerConfig")
    def other_docker_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "other_docker_config")

    @other_docker_config.setter
    def other_docker_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_docker_config", value)

    @property
    @pulumi.getter(name="otherDockerHostConfig")
    def other_docker_host_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "other_docker_host_config")

    @other_docker_host_config.setter
    def other_docker_host_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_docker_host_config", value)

    @property
    @pulumi.getter(name="parentDomain")
    def parent_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The service's parent domain
        """
        return pulumi.get(self, "parent_domain")

    @parent_domain.setter
    def parent_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_domain", value)

    @property
    @pulumi.getter(name="replicaCollocationAllowed")
    def replica_collocation_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        """
        return pulumi.get(self, "replica_collocation_allowed")

    @replica_collocation_allowed.setter
    def replica_collocation_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replica_collocation_allowed", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of container replicas to deploy.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="replicasMatchingAsgName")
    def replicas_matching_asg_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "replicas_matching_asg_name")

    @replicas_matching_asg_name.setter
    def replicas_matching_asg_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicas_matching_asg_name", value)

    @property
    @pulumi.getter(name="shouldSpreadAcrossZones")
    def should_spread_across_zones(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        """
        return pulumi.get(self, "should_spread_across_zones")

    @should_spread_across_zones.setter
    def should_spread_across_zones(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_spread_across_zones", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[str]]:
        """
        Volumes to be attached to pod.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volumes", value)


class DuploService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cloud_creds_from_k8s_service_account: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 extra_config: Optional[pulumi.Input[str]] = None,
                 force_recreate_on_volumes_change: Optional[pulumi.Input[bool]] = None,
                 force_stateful_set: Optional[pulumi.Input[bool]] = None,
                 hpa_specs: Optional[pulumi.Input[str]] = None,
                 is_daemonset: Optional[pulumi.Input[bool]] = None,
                 is_unique_k8s_node_required: Optional[pulumi.Input[bool]] = None,
                 lb_synced_deployment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 other_docker_config: Optional[pulumi.Input[str]] = None,
                 other_docker_host_config: Optional[pulumi.Input[str]] = None,
                 replica_collocation_allowed: Optional[pulumi.Input[bool]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 replicas_matching_asg_name: Optional[pulumi.Input[str]] = None,
                 should_spread_across_zones: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Deploy NGINX service using DuploCloud Platform's native container agent.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating an NGINX service, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # You will need a DuploCloud host to launch the Duplo service, so create a host using following resource configuration.
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=False)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.tenant_id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=0,
            zone=0,
            user_account=tenant.account_name,
            keypair_type=1)
        myservice = duplocloud.DuploService("myservice",
            tenant_id=tenant.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        ```

        ### Deploy NGINX service inside the 'nonprod' tenant using DuploCloud Platform's native container agent with host networking and the environment variables - NGINX_HOST and NGINX_PORT

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'nonprod' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="nonprod")
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image(tenant_id=tenant.id,
            is_kubernetes=False)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=0,
            zone=0,
            user_account=tenant.name,
            keypair_type=1)
        # Create the DuploCloud service
        myservice = duplocloud.DuploService("myservice",
            tenant_id=tenant.id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1,
            extra_config=json.dumps({
                "NGINX_HOST": "foo",
                "NGINX_PORT": "8080",
            }),
            other_docker_host_config=json.dumps({
                "NetworkMode": "host",
                "CapAdd": ["NET_ADMIN"],
            }))
        ```

        ### Deploy NGINX service named nginx inside the 'dev' tenant and set the resource requests and limits. Set cpu requests and limits to 200m and 300m respectively and set memory requests and limits to 100Mi and 300Mi respectively

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Assuming that a host already exists in the tenant, create a service
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=json.dumps({
                "Resources": {
                    "requests": {
                        "cpu": "200m",
                        "memory": "100Mi",
                    },
                    "limits": {
                        "cpu": "300m",
                        "memory": "300Mi",
                    },
                },
            }))
        ```

        ### Deploy an Nginx service named nginx inside the prod tenant and mount these environment variables from the kubernetes secrets - 1. FOO: bar 2. PING: pong

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'prod' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="prod")
        # Create a secret with the env vars values 1. FOO: bar 2. PING: pong if it does not exist
        nginx = duplocloud.K8Secret("nginx",
            tenant_id=tenant.id,
            secret_name="nginx-secret",
            secret_type="Opaque",
            secret_data=json.dumps({
                "FOO": "bar",
                "PING": "pong",
            }))
        # Assuming that a host exists in the tenant.
        nginx_duplo_service = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=pulumi.Output.json_dumps({
                "EnvFrom": [{
                    "secretRef": {
                        "name": nginx.secret_name,
                    },
                }],
            }))
        ```

        ### Deploy an Nginx service named nginx inside the dev tenant, and mount these environment variables from the kubernetes configmap - 1. FOO: bar 2. PING: pong

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Create a configmap with the env vars values 1. FOO: bar 2. PING: pong if it does not exists
        nginx = duplocloud.K8ConfigMap("nginx",
            tenant_id=tenant.id,
            name="nginx-cm",
            data=json.dumps({
                "FOO": "bar",
                "PING": "pong",
            }))
        # Ensure that the host is also created in the tenant.
        nginx_duplo_service = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=pulumi.Output.json_dumps({
                "EnvFrom": [{
                    "configMapRef": {
                        "name": nginx.name,
                    },
                }],
            }))
        ```

        ### Deploy an Nginx service named nginx inside the dev tenant, and set the replica count to 5

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Ensure that the host is also created in the tenant.
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=5)
        ```

        ### Deploy an Nginx service named nginx with liveliness probe. Create it inside the dev tenant which already exists.

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Assuming a host already exists in the tenant, create the duplo service
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=json.dumps({
                "LivenessProbe": {
                    "initialDelaySeconds": 10,
                    "periodSeconds": 30,
                    "successThreshold": 1,
                    "httpGet": {
                        "path": "/health",
                        "port": 80,
                    },
                },
            }))
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploService:DuploService myservice v2/subscriptions/*TENANT_ID*/ReplicationControllerApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
               `7` : Linux container agent for Kubernetes
        :param pulumi.Input[bool] any_host_allowed: Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
               `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        :param pulumi.Input[bool] cloud_creds_from_k8s_service_account: Whether or not the service gets it's cloud credentials from Kubernetes service account.
        :param pulumi.Input[str] docker_image: The docker image to use for the launched container(s).
        :param pulumi.Input[bool] force_recreate_on_volumes_change: if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
               the resource.
        :param pulumi.Input[bool] force_stateful_set: Whether or not to force a StatefulSet to be created.
        :param pulumi.Input[bool] is_daemonset: Whether or not to enable DaemonSet.
        :param pulumi.Input[bool] is_unique_k8s_node_required: Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[bool] replica_collocation_allowed: Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        :param pulumi.Input[int] replicas: The number of container replicas to deploy.
        :param pulumi.Input[bool] should_spread_across_zones: Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[str] volumes: Volumes to be attached to pod.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DuploServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Deploy NGINX service using DuploCloud Platform's native container agent.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating an NGINX service, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # You will need a DuploCloud host to launch the Duplo service, so create a host using following resource configuration.
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=False)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.tenant_id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=0,
            zone=0,
            user_account=tenant.account_name,
            keypair_type=1)
        myservice = duplocloud.DuploService("myservice",
            tenant_id=tenant.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        ```

        ### Deploy NGINX service inside the 'nonprod' tenant using DuploCloud Platform's native container agent with host networking and the environment variables - NGINX_HOST and NGINX_PORT

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'nonprod' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="nonprod")
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image(tenant_id=tenant.id,
            is_kubernetes=False)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=0,
            zone=0,
            user_account=tenant.name,
            keypair_type=1)
        # Create the DuploCloud service
        myservice = duplocloud.DuploService("myservice",
            tenant_id=tenant.id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1,
            extra_config=json.dumps({
                "NGINX_HOST": "foo",
                "NGINX_PORT": "8080",
            }),
            other_docker_host_config=json.dumps({
                "NetworkMode": "host",
                "CapAdd": ["NET_ADMIN"],
            }))
        ```

        ### Deploy NGINX service named nginx inside the 'dev' tenant and set the resource requests and limits. Set cpu requests and limits to 200m and 300m respectively and set memory requests and limits to 100Mi and 300Mi respectively

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Assuming that a host already exists in the tenant, create a service
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=json.dumps({
                "Resources": {
                    "requests": {
                        "cpu": "200m",
                        "memory": "100Mi",
                    },
                    "limits": {
                        "cpu": "300m",
                        "memory": "300Mi",
                    },
                },
            }))
        ```

        ### Deploy an Nginx service named nginx inside the prod tenant and mount these environment variables from the kubernetes secrets - 1. FOO: bar 2. PING: pong

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'prod' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="prod")
        # Create a secret with the env vars values 1. FOO: bar 2. PING: pong if it does not exist
        nginx = duplocloud.K8Secret("nginx",
            tenant_id=tenant.id,
            secret_name="nginx-secret",
            secret_type="Opaque",
            secret_data=json.dumps({
                "FOO": "bar",
                "PING": "pong",
            }))
        # Assuming that a host exists in the tenant.
        nginx_duplo_service = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=pulumi.Output.json_dumps({
                "EnvFrom": [{
                    "secretRef": {
                        "name": nginx.secret_name,
                    },
                }],
            }))
        ```

        ### Deploy an Nginx service named nginx inside the dev tenant, and mount these environment variables from the kubernetes configmap - 1. FOO: bar 2. PING: pong

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Create a configmap with the env vars values 1. FOO: bar 2. PING: pong if it does not exists
        nginx = duplocloud.K8ConfigMap("nginx",
            tenant_id=tenant.id,
            name="nginx-cm",
            data=json.dumps({
                "FOO": "bar",
                "PING": "pong",
            }))
        # Ensure that the host is also created in the tenant.
        nginx_duplo_service = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=pulumi.Output.json_dumps({
                "EnvFrom": [{
                    "configMapRef": {
                        "name": nginx.name,
                    },
                }],
            }))
        ```

        ### Deploy an Nginx service named nginx inside the dev tenant, and set the replica count to 5

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Ensure that the host is also created in the tenant.
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=5)
        ```

        ### Deploy an Nginx service named nginx with liveliness probe. Create it inside the dev tenant which already exists.

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before deploying the Nginx duplo service.
        tenant = duplocloud.get_tenant(name="dev")
        # Assuming a host already exists in the tenant, create the duplo service
        nginx = duplocloud.DuploService("nginx",
            tenant_id=tenant.id,
            name="nginx",
            agent_platform=7,
            docker_image="nginx:latest",
            replicas=1,
            other_docker_config=json.dumps({
                "LivenessProbe": {
                    "initialDelaySeconds": 10,
                    "periodSeconds": 30,
                    "successThreshold": 1,
                    "httpGet": {
                        "path": "/health",
                        "port": 80,
                    },
                },
            }))
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploService:DuploService myservice v2/subscriptions/*TENANT_ID*/ReplicationControllerApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param DuploServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DuploServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cloud_creds_from_k8s_service_account: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 extra_config: Optional[pulumi.Input[str]] = None,
                 force_recreate_on_volumes_change: Optional[pulumi.Input[bool]] = None,
                 force_stateful_set: Optional[pulumi.Input[bool]] = None,
                 hpa_specs: Optional[pulumi.Input[str]] = None,
                 is_daemonset: Optional[pulumi.Input[bool]] = None,
                 is_unique_k8s_node_required: Optional[pulumi.Input[bool]] = None,
                 lb_synced_deployment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 other_docker_config: Optional[pulumi.Input[str]] = None,
                 other_docker_host_config: Optional[pulumi.Input[str]] = None,
                 replica_collocation_allowed: Optional[pulumi.Input[bool]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 replicas_matching_asg_name: Optional[pulumi.Input[str]] = None,
                 should_spread_across_zones: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DuploServiceArgs.__new__(DuploServiceArgs)

            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocation_tags"] = allocation_tags
            __props__.__dict__["any_host_allowed"] = any_host_allowed
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["cloud_creds_from_k8s_service_account"] = cloud_creds_from_k8s_service_account
            __props__.__dict__["commands"] = commands
            if docker_image is None and not opts.urn:
                raise TypeError("Missing required property 'docker_image'")
            __props__.__dict__["docker_image"] = docker_image
            __props__.__dict__["extra_config"] = extra_config
            __props__.__dict__["force_recreate_on_volumes_change"] = force_recreate_on_volumes_change
            __props__.__dict__["force_stateful_set"] = force_stateful_set
            __props__.__dict__["hpa_specs"] = hpa_specs
            __props__.__dict__["is_daemonset"] = is_daemonset
            __props__.__dict__["is_unique_k8s_node_required"] = is_unique_k8s_node_required
            __props__.__dict__["lb_synced_deployment"] = lb_synced_deployment
            __props__.__dict__["name"] = name
            __props__.__dict__["other_docker_config"] = other_docker_config
            __props__.__dict__["other_docker_host_config"] = other_docker_host_config
            __props__.__dict__["replica_collocation_allowed"] = replica_collocation_allowed
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["replicas_matching_asg_name"] = replicas_matching_asg_name
            __props__.__dict__["should_spread_across_zones"] = should_spread_across_zones
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["domain"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["fqdn_ex"] = None
            __props__.__dict__["index"] = None
            __props__.__dict__["parent_domain"] = None
            __props__.__dict__["tags"] = None
        super(DuploService, __self__).__init__(
            'duplocloud:index/duploService:DuploService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocation_tags: Optional[pulumi.Input[str]] = None,
            any_host_allowed: Optional[pulumi.Input[bool]] = None,
            cloud: Optional[pulumi.Input[int]] = None,
            cloud_creds_from_k8s_service_account: Optional[pulumi.Input[bool]] = None,
            commands: Optional[pulumi.Input[str]] = None,
            docker_image: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            extra_config: Optional[pulumi.Input[str]] = None,
            force_recreate_on_volumes_change: Optional[pulumi.Input[bool]] = None,
            force_stateful_set: Optional[pulumi.Input[bool]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            fqdn_ex: Optional[pulumi.Input[str]] = None,
            hpa_specs: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[int]] = None,
            is_daemonset: Optional[pulumi.Input[bool]] = None,
            is_unique_k8s_node_required: Optional[pulumi.Input[bool]] = None,
            lb_synced_deployment: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            other_docker_config: Optional[pulumi.Input[str]] = None,
            other_docker_host_config: Optional[pulumi.Input[str]] = None,
            parent_domain: Optional[pulumi.Input[str]] = None,
            replica_collocation_allowed: Optional[pulumi.Input[bool]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            replicas_matching_asg_name: Optional[pulumi.Input[str]] = None,
            should_spread_across_zones: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DuploServiceTagArgs', 'DuploServiceTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[str]] = None) -> 'DuploService':
        """
        Get an existing DuploService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
               `7` : Linux container agent for Kubernetes
        :param pulumi.Input[bool] any_host_allowed: Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
               `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        :param pulumi.Input[bool] cloud_creds_from_k8s_service_account: Whether or not the service gets it's cloud credentials from Kubernetes service account.
        :param pulumi.Input[str] docker_image: The docker image to use for the launched container(s).
        :param pulumi.Input[str] domain: The service domain (whichever fqdn_ex or fqdn which is non empty)
        :param pulumi.Input[bool] force_recreate_on_volumes_change: if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
               the resource.
        :param pulumi.Input[bool] force_stateful_set: Whether or not to force a StatefulSet to be created.
        :param pulumi.Input[str] fqdn: The fully qualified domain associated with the service
        :param pulumi.Input[str] fqdn_ex: External fully qualified domain associated with the service
        :param pulumi.Input[int] index: The index of the service.
        :param pulumi.Input[bool] is_daemonset: Whether or not to enable DaemonSet.
        :param pulumi.Input[bool] is_unique_k8s_node_required: Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[str] parent_domain: The service's parent domain
        :param pulumi.Input[bool] replica_collocation_allowed: Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        :param pulumi.Input[int] replicas: The number of container replicas to deploy.
        :param pulumi.Input[bool] should_spread_across_zones: Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[str] volumes: Volumes to be attached to pod.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DuploServiceState.__new__(_DuploServiceState)

        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocation_tags"] = allocation_tags
        __props__.__dict__["any_host_allowed"] = any_host_allowed
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["cloud_creds_from_k8s_service_account"] = cloud_creds_from_k8s_service_account
        __props__.__dict__["commands"] = commands
        __props__.__dict__["docker_image"] = docker_image
        __props__.__dict__["domain"] = domain
        __props__.__dict__["extra_config"] = extra_config
        __props__.__dict__["force_recreate_on_volumes_change"] = force_recreate_on_volumes_change
        __props__.__dict__["force_stateful_set"] = force_stateful_set
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["fqdn_ex"] = fqdn_ex
        __props__.__dict__["hpa_specs"] = hpa_specs
        __props__.__dict__["index"] = index
        __props__.__dict__["is_daemonset"] = is_daemonset
        __props__.__dict__["is_unique_k8s_node_required"] = is_unique_k8s_node_required
        __props__.__dict__["lb_synced_deployment"] = lb_synced_deployment
        __props__.__dict__["name"] = name
        __props__.__dict__["other_docker_config"] = other_docker_config
        __props__.__dict__["other_docker_host_config"] = other_docker_host_config
        __props__.__dict__["parent_domain"] = parent_domain
        __props__.__dict__["replica_collocation_allowed"] = replica_collocation_allowed
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["replicas_matching_asg_name"] = replicas_matching_asg_name
        __props__.__dict__["should_spread_across_zones"] = should_spread_across_zones
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["volumes"] = volumes
        return DuploService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent to use for deployment. Should be one of: - `0` : Duplo Native container agent -
        `7` : Linux container agent for Kubernetes
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "allocation_tags")

    @property
    @pulumi.getter(name="anyHostAllowed")
    def any_host_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the service can run on hosts in other tenants (within the the same plan as the current tenant).
        """
        return pulumi.get(self, "any_host_allowed")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the cloud provider to launch the service in. Should be one of: - `0` : AWS (Default) - `1` : Oracle -
        `2` : Azure - `3` : Google - `4` : Byoh - `5` : Unknown - `6` : DigitalOcean - `10` : OnPrem
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="cloudCredsFromK8sServiceAccount")
    def cloud_creds_from_k8s_service_account(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the service gets it's cloud credentials from Kubernetes service account.
        """
        return pulumi.get(self, "cloud_creds_from_k8s_service_account")

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> pulumi.Output[str]:
        """
        The docker image to use for the launched container(s).
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The service domain (whichever fqdn_ex or fqdn which is non empty)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "extra_config")

    @property
    @pulumi.getter(name="forceRecreateOnVolumesChange")
    def force_recreate_on_volumes_change(self) -> pulumi.Output[Optional[bool]]:
        """
        if 'force_recreate_on_volumes_change=true' and any changing to Volumes, will results in forceNew and hence recreating
        the resource.
        """
        return pulumi.get(self, "force_recreate_on_volumes_change")

    @property
    @pulumi.getter(name="forceStatefulSet")
    def force_stateful_set(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to force a StatefulSet to be created.
        """
        return pulumi.get(self, "force_stateful_set")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain associated with the service
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="fqdnEx")
    def fqdn_ex(self) -> pulumi.Output[str]:
        """
        External fully qualified domain associated with the service
        """
        return pulumi.get(self, "fqdn_ex")

    @property
    @pulumi.getter(name="hpaSpecs")
    def hpa_specs(self) -> pulumi.Output[str]:
        return pulumi.get(self, "hpa_specs")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[int]:
        """
        The index of the service.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="isDaemonset")
    def is_daemonset(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to enable DaemonSet.
        """
        return pulumi.get(self, "is_daemonset")

    @property
    @pulumi.getter(name="isUniqueK8sNodeRequired")
    def is_unique_k8s_node_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the replicas must be scheduled on separate Kubernetes nodes. Only supported on Kubernetes.
        """
        return pulumi.get(self, "is_unique_k8s_node_required")

    @property
    @pulumi.getter(name="lbSyncedDeployment")
    def lb_synced_deployment(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "lb_synced_deployment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="otherDockerConfig")
    def other_docker_config(self) -> pulumi.Output[str]:
        return pulumi.get(self, "other_docker_config")

    @property
    @pulumi.getter(name="otherDockerHostConfig")
    def other_docker_host_config(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "other_docker_host_config")

    @property
    @pulumi.getter(name="parentDomain")
    def parent_domain(self) -> pulumi.Output[str]:
        """
        The service's parent domain
        """
        return pulumi.get(self, "parent_domain")

    @property
    @pulumi.getter(name="replicaCollocationAllowed")
    def replica_collocation_allowed(self) -> pulumi.Output[bool]:
        """
        Allow replica collocation for the service. If this is set then 2 replicas can be on the same host.
        """
        return pulumi.get(self, "replica_collocation_allowed")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Optional[int]]:
        """
        The number of container replicas to deploy.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="replicasMatchingAsgName")
    def replicas_matching_asg_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "replicas_matching_asg_name")

    @property
    @pulumi.getter(name="shouldSpreadAcrossZones")
    def should_spread_across_zones(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the replicas must be spread across availability zones. Only supported on Kubernetes.
        """
        return pulumi.get(self, "should_spread_across_zones")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DuploServiceTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[str]]:
        """
        Volumes to be attached to pod.
        """
        return pulumi.get(self, "volumes")

