# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DuploServiceLbconfigsArgs', 'DuploServiceLbconfigs']

@pulumi.input_type
class DuploServiceLbconfigsArgs:
    def __init__(__self__, *,
                 lbconfigs: pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]],
                 replication_controller_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DuploServiceLbconfigs resource.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Duplo considers all of the load balancers ready
        """
        pulumi.set(__self__, "lbconfigs", lbconfigs)
        pulumi.set(__self__, "replication_controller_name", replication_controller_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def lbconfigs(self) -> pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]]:
        return pulumi.get(self, "lbconfigs")

    @lbconfigs.setter
    def lbconfigs(self, value: pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]]):
        pulumi.set(self, "lbconfigs", value)

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> pulumi.Input[str]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @replication_controller_name.setter
    def replication_controller_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_controller_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo considers all of the load balancers ready
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _DuploServiceLbconfigsState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 lbconfigs: Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DuploServiceLbconfigs resources.
        :param pulumi.Input[str] arn: The load balancer ARN.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] status: The load balancer's current status.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Duplo considers all of the load balancers ready
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if lbconfigs is not None:
            pulumi.set(__self__, "lbconfigs", lbconfigs)
        if replication_controller_name is not None:
            pulumi.set(__self__, "replication_controller_name", replication_controller_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def lbconfigs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]]]:
        return pulumi.get(self, "lbconfigs")

    @lbconfigs.setter
    def lbconfigs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DuploServiceLbconfigsLbconfigArgs']]]]):
        pulumi.set(self, "lbconfigs", value)

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @replication_controller_name.setter
    def replication_controller_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_controller_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer's current status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo considers all of the load balancers ready
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class DuploServiceLbconfigs(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lbconfigs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DuploServiceLbconfigsLbconfigArgs', 'DuploServiceLbconfigsLbconfigArgsDict']]]]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `DuploServiceLbconfigs` manages load balancer configuration(s) for a container-based service in Duplo.

        NOTE: For Amazon ECS services, see the `EcsService` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Deploy NGINX using Duplo's native container agent, and configure a load balancer.
        myservice = duplocloud.DuploService("myservice",
            tenant_id=myapp.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        myservice_duplo_service_lbconfigs = duplocloud.DuploServiceLbconfigs("myservice",
            tenant_id=myservice.tenant_id,
            replication_controller_name=myservice.name,
            lbconfigs=[{
                "external_port": 80,
                "health_check_url": "/",
                "is_native": False,
                "lb_type": 1,
                "port": "80",
                "protocol": "http",
                "health_check": {
                    "healthy_threshold": 4,
                    "unhealthy_threshold": 4,
                    "timeout": 50,
                    "interval": 30,
                    "http_success_codes": "200-399",
                },
            }])
        ```

        ## Import

        Example: Importing an existing service's load balancer configurations

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploServiceLbconfigs:DuploServiceLbconfigs myservice v2/subscriptions/*TENANT_ID*/ServiceLBConfigsV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Duplo considers all of the load balancers ready
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DuploServiceLbconfigsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `DuploServiceLbconfigs` manages load balancer configuration(s) for a container-based service in Duplo.

        NOTE: For Amazon ECS services, see the `EcsService` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Deploy NGINX using Duplo's native container agent, and configure a load balancer.
        myservice = duplocloud.DuploService("myservice",
            tenant_id=myapp.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        myservice_duplo_service_lbconfigs = duplocloud.DuploServiceLbconfigs("myservice",
            tenant_id=myservice.tenant_id,
            replication_controller_name=myservice.name,
            lbconfigs=[{
                "external_port": 80,
                "health_check_url": "/",
                "is_native": False,
                "lb_type": 1,
                "port": "80",
                "protocol": "http",
                "health_check": {
                    "healthy_threshold": 4,
                    "unhealthy_threshold": 4,
                    "timeout": 50,
                    "interval": 30,
                    "http_success_codes": "200-399",
                },
            }])
        ```

        ## Import

        Example: Importing an existing service's load balancer configurations

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploServiceLbconfigs:DuploServiceLbconfigs myservice v2/subscriptions/*TENANT_ID*/ServiceLBConfigsV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param DuploServiceLbconfigsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DuploServiceLbconfigsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lbconfigs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DuploServiceLbconfigsLbconfigArgs', 'DuploServiceLbconfigsLbconfigArgsDict']]]]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DuploServiceLbconfigsArgs.__new__(DuploServiceLbconfigsArgs)

            if lbconfigs is None and not opts.urn:
                raise TypeError("Missing required property 'lbconfigs'")
            __props__.__dict__["lbconfigs"] = lbconfigs
            if replication_controller_name is None and not opts.urn:
                raise TypeError("Missing required property 'replication_controller_name'")
            __props__.__dict__["replication_controller_name"] = replication_controller_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["arn"] = None
            __props__.__dict__["status"] = None
        super(DuploServiceLbconfigs, __self__).__init__(
            'duplocloud:index/duploServiceLbconfigs:DuploServiceLbconfigs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            lbconfigs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DuploServiceLbconfigsLbconfigArgs', 'DuploServiceLbconfigsLbconfigArgsDict']]]]] = None,
            replication_controller_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'DuploServiceLbconfigs':
        """
        Get an existing DuploServiceLbconfigs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The load balancer ARN.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] status: The load balancer's current status.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until Duplo considers all of the load balancers ready
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DuploServiceLbconfigsState.__new__(_DuploServiceLbconfigsState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["lbconfigs"] = lbconfigs
        __props__.__dict__["replication_controller_name"] = replication_controller_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return DuploServiceLbconfigs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The load balancer ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def lbconfigs(self) -> pulumi.Output[Sequence['outputs.DuploServiceLbconfigsLbconfig']]:
        return pulumi.get(self, "lbconfigs")

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> pulumi.Output[str]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The load balancer's current status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Duplo considers all of the load balancers ready
        """
        return pulumi.get(self, "wait_until_ready")

