# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DuploServiceParamsArgs', 'DuploServiceParams']

@pulumi.input_type
class DuploServiceParamsArgs:
    def __init__(__self__, *,
                 replication_controller_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 webaclid: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DuploServiceParams resource.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not to drop invalid HTTP headers received by the load balancer.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not to enable http to https redirection.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[str] webaclid: The ARN of a web application firewall to associate this load balancer.
        """
        pulumi.set(__self__, "replication_controller_name", replication_controller_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if dns_prfx is not None:
            pulumi.set(__self__, "dns_prfx", dns_prfx)
        if drop_invalid_headers is not None:
            pulumi.set(__self__, "drop_invalid_headers", drop_invalid_headers)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if http_to_https_redirect is not None:
            pulumi.set(__self__, "http_to_https_redirect", http_to_https_redirect)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if webaclid is not None:
            pulumi.set(__self__, "webaclid", webaclid)

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> pulumi.Input[str]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @replication_controller_name.setter
    def replication_controller_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_controller_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @dns_prfx.setter
    def dns_prfx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_prfx", value)

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to drop invalid HTTP headers received by the load balancer.
        """
        return pulumi.get(self, "drop_invalid_headers")

    @drop_invalid_headers.setter
    def drop_invalid_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_invalid_headers", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable http to https redirection.
        """
        return pulumi.get(self, "http_to_https_redirect")

    @http_to_https_redirect.setter
    def http_to_https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_to_https_redirect", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def webaclid(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of a web application firewall to associate this load balancer.
        """
        return pulumi.get(self, "webaclid")

    @webaclid.setter
    def webaclid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webaclid", value)


@pulumi.input_type
class _DuploServiceParamsState:
    def __init__(__self__, *,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 load_balancer_arn: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 webaclid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DuploServiceParams resources.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not to drop invalid HTTP headers received by the load balancer.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not to enable http to https redirection.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[str] load_balancer_arn: The load balancer ARN.
        :param pulumi.Input[str] load_balancer_name: The load balancer name.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[str] webaclid: The ARN of a web application firewall to associate this load balancer.
        """
        if dns_prfx is not None:
            pulumi.set(__self__, "dns_prfx", dns_prfx)
        if drop_invalid_headers is not None:
            pulumi.set(__self__, "drop_invalid_headers", drop_invalid_headers)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if http_to_https_redirect is not None:
            pulumi.set(__self__, "http_to_https_redirect", http_to_https_redirect)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if load_balancer_arn is not None:
            pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if replication_controller_name is not None:
            pulumi.set(__self__, "replication_controller_name", replication_controller_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if webaclid is not None:
            pulumi.set(__self__, "webaclid", webaclid)

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @dns_prfx.setter
    def dns_prfx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_prfx", value)

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to drop invalid HTTP headers received by the load balancer.
        """
        return pulumi.get(self, "drop_invalid_headers")

    @drop_invalid_headers.setter
    def drop_invalid_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_invalid_headers", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable http to https redirection.
        """
        return pulumi.get(self, "http_to_https_redirect")

    @http_to_https_redirect.setter
    def http_to_https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_to_https_redirect", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer ARN.
        """
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer name.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @replication_controller_name.setter
    def replication_controller_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_controller_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def webaclid(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of a web application firewall to associate this load balancer.
        """
        return pulumi.get(self, "webaclid")

    @webaclid.setter
    def webaclid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webaclid", value)


class DuploServiceParams(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 webaclid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `DuploServiceLbconfigs` manages additional configuration for a container-based service in Duplo.

        NOTE: For Amazon ECS services, see the `EcsService` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Deploy NGINX using Duplo's native container agent, and configure additional load balancer settings.
        myservice = duplocloud.DuploService("myservice",
            tenant_id=myapp.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        myservice_duplo_service_lbconfigs = duplocloud.DuploServiceLbconfigs("myservice",
            tenant_id=myservice.tenant_id,
            replication_controller_name=myservice.name,
            lbconfigs=[{
                "external_port": 80,
                "health_check_url": "/",
                "is_native": False,
                "lb_type": 1,
                "port": "80",
                "protocol": "http",
            }])
        myservice_duplo_service_params = duplocloud.DuploServiceParams("myservice",
            tenant_id=myservice_duplo_service_lbconfigs.tenant_id,
            replication_controller_name=myservice_duplo_service_lbconfigs.replication_controller_name,
            dns_prfx="myservice",
            drop_invalid_headers=True,
            enable_access_logs=True)
        ```

        ## Import

        Example: Importing an existing service's parameters

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploServiceParams:DuploServiceParams myservice v2/subscriptions/*TENANT_ID*/ReplicationControllerParamsV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not to drop invalid HTTP headers received by the load balancer.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not to enable http to https redirection.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[str] webaclid: The ARN of a web application firewall to associate this load balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DuploServiceParamsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `DuploServiceLbconfigs` manages additional configuration for a container-based service in Duplo.

        NOTE: For Amazon ECS services, see the `EcsService` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Deploy NGINX using Duplo's native container agent, and configure additional load balancer settings.
        myservice = duplocloud.DuploService("myservice",
            tenant_id=myapp.tenant_id,
            name="myservice",
            agent_platform=0,
            docker_image="nginx:latest",
            replicas=1)
        myservice_duplo_service_lbconfigs = duplocloud.DuploServiceLbconfigs("myservice",
            tenant_id=myservice.tenant_id,
            replication_controller_name=myservice.name,
            lbconfigs=[{
                "external_port": 80,
                "health_check_url": "/",
                "is_native": False,
                "lb_type": 1,
                "port": "80",
                "protocol": "http",
            }])
        myservice_duplo_service_params = duplocloud.DuploServiceParams("myservice",
            tenant_id=myservice_duplo_service_lbconfigs.tenant_id,
            replication_controller_name=myservice_duplo_service_lbconfigs.replication_controller_name,
            dns_prfx="myservice",
            drop_invalid_headers=True,
            enable_access_logs=True)
        ```

        ## Import

        Example: Importing an existing service's parameters

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/duploServiceParams:DuploServiceParams myservice v2/subscriptions/*TENANT_ID*/ReplicationControllerParamsV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param DuploServiceParamsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DuploServiceParamsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 replication_controller_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 webaclid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DuploServiceParamsArgs.__new__(DuploServiceParamsArgs)

            __props__.__dict__["dns_prfx"] = dns_prfx
            __props__.__dict__["drop_invalid_headers"] = drop_invalid_headers
            __props__.__dict__["enable_access_logs"] = enable_access_logs
            __props__.__dict__["http_to_https_redirect"] = http_to_https_redirect
            __props__.__dict__["idle_timeout"] = idle_timeout
            if replication_controller_name is None and not opts.urn:
                raise TypeError("Missing required property 'replication_controller_name'")
            __props__.__dict__["replication_controller_name"] = replication_controller_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["webaclid"] = webaclid
            __props__.__dict__["load_balancer_arn"] = None
            __props__.__dict__["load_balancer_name"] = None
        super(DuploServiceParams, __self__).__init__(
            'duplocloud:index/duploServiceParams:DuploServiceParams',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_prfx: Optional[pulumi.Input[str]] = None,
            drop_invalid_headers: Optional[pulumi.Input[bool]] = None,
            enable_access_logs: Optional[pulumi.Input[bool]] = None,
            http_to_https_redirect: Optional[pulumi.Input[bool]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            load_balancer_arn: Optional[pulumi.Input[str]] = None,
            load_balancer_name: Optional[pulumi.Input[str]] = None,
            replication_controller_name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            webaclid: Optional[pulumi.Input[str]] = None) -> 'DuploServiceParams':
        """
        Get an existing DuploServiceParams resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[bool] drop_invalid_headers: Whether or not to drop invalid HTTP headers received by the load balancer.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        :param pulumi.Input[bool] http_to_https_redirect: Whether or not to enable http to https redirection.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[str] load_balancer_arn: The load balancer ARN.
        :param pulumi.Input[str] load_balancer_name: The load balancer name.
        :param pulumi.Input[str] replication_controller_name: The name of the duplo service.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that hosts the duplo service.
        :param pulumi.Input[str] webaclid: The ARN of a web application firewall to associate this load balancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DuploServiceParamsState.__new__(_DuploServiceParamsState)

        __props__.__dict__["dns_prfx"] = dns_prfx
        __props__.__dict__["drop_invalid_headers"] = drop_invalid_headers
        __props__.__dict__["enable_access_logs"] = enable_access_logs
        __props__.__dict__["http_to_https_redirect"] = http_to_https_redirect
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["load_balancer_arn"] = load_balancer_arn
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["replication_controller_name"] = replication_controller_name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["webaclid"] = webaclid
        return DuploServiceParams(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> pulumi.Output[str]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @property
    @pulumi.getter(name="dropInvalidHeaders")
    def drop_invalid_headers(self) -> pulumi.Output[bool]:
        """
        Whether or not to drop invalid HTTP headers received by the load balancer.
        """
        return pulumi.get(self, "drop_invalid_headers")

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable access logs.  When enabled, Duplo will send access logs to a centralized S3 bucket per plan
        """
        return pulumi.get(self, "enable_access_logs")

    @property
    @pulumi.getter(name="httpToHttpsRedirect")
    def http_to_https_redirect(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable http to https redirection.
        """
        return pulumi.get(self, "http_to_https_redirect")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[int]:
        """
        The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Output[str]:
        """
        The load balancer ARN.
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The load balancer name.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="replicationControllerName")
    def replication_controller_name(self) -> pulumi.Output[str]:
        """
        The name of the duplo service.
        """
        return pulumi.get(self, "replication_controller_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that hosts the duplo service.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def webaclid(self) -> pulumi.Output[str]:
        """
        The ARN of a web application firewall to associate this load balancer.
        """
        return pulumi.get(self, "webaclid")

