# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EcacheInstanceArgs', 'EcacheInstance']

@pulumi.input_type
class EcacheInstanceArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 auth_token: Optional[pulumi.Input[str]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_type: Optional[pulumi.Input[int]] = None,
                 enable_cluster_mode: Optional[pulumi.Input[bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[bool]] = None,
                 encryption_in_transit: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EcacheInstance resource.
        :param pulumi.Input[str] size: The instance type of the elasticache instance.
               See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the elasticache instance will be created in.
        :param pulumi.Input[str] auth_token: Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        :param pulumi.Input[bool] automatic_failover_enabled: Enables automatic failover.
        :param pulumi.Input[int] cache_type: The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        :param pulumi.Input[bool] enable_cluster_mode: Flag to enable/disable redis cluster mode.
        :param pulumi.Input[bool] encryption_at_rest: Enables encryption-at-rest.
        :param pulumi.Input[bool] encryption_in_transit: Enables encryption-in-transit.
        :param pulumi.Input[str] engine_version: The engine version of the elastic instance. See AWS documentation for the [available Redis instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
               Memcached instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] name: The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[int] number_of_shards: The number of shards to create. Applicable only if enable_cluster_mode is set to true
        :param pulumi.Input[str] parameter_group_name: The REDIS parameter group to supply.
        :param pulumi.Input[int] replicas: The number of replicas to create. Supported number of replicas is 1 to 6
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns: Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
               bucket. One can find steps to provide access to export snapshot to s3 on following link
               https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        :param pulumi.Input[str] snapshot_name: Select the snapshot/backup you want to use for creating redis.
        :param pulumi.Input[int] snapshot_retention_limit: Specify retention limit in days. Accepted values - 1-35.
        :param pulumi.Input[str] snapshot_window: Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
               your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
               an appropriate time range.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if cache_type is not None:
            pulumi.set(__self__, "cache_type", cache_type)
        if enable_cluster_mode is not None:
            pulumi.set(__self__, "enable_cluster_mode", enable_cluster_mode)
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The instance type of the elasticache instance.
        See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the elasticache instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic failover.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="enableClusterMode")
    def enable_cluster_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable redis cluster mode.
        """
        return pulumi.get(self, "enable_cluster_mode")

    @enable_cluster_mode.setter
    def enable_cluster_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cluster_mode", value)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables encryption-at-rest.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_at_rest", value)

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables encryption-in-transit.
        """
        return pulumi.get(self, "encryption_in_transit")

    @encryption_in_transit.setter
    def encryption_in_transit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_in_transit", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version of the elastic instance. See AWS documentation for the [available Redis instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
        Memcached instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]]:
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards to create. Applicable only if enable_cluster_mode is set to true
        """
        return pulumi.get(self, "number_of_shards")

    @number_of_shards.setter
    def number_of_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_shards", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The REDIS parameter group to supply.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas to create. Supported number of replicas is 1 to 6
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
        bucket. One can find steps to provide access to export snapshot to s3 on following link
        https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Select the snapshot/backup you want to use for creating redis.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Specify retention limit in days. Accepted values - 1-35.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[str]]:
        """
        Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
        your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
        an appropriate time range.
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_window", value)


@pulumi.input_type
class _EcacheInstanceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_type: Optional[pulumi.Input[int]] = None,
                 enable_cluster_mode: Optional[pulumi.Input[bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[bool]] = None,
                 encryption_in_transit: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 instance_status: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EcacheInstance resources.
        :param pulumi.Input[str] arn: The ARN of the elasticache instance.
        :param pulumi.Input[str] auth_token: Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        :param pulumi.Input[bool] automatic_failover_enabled: Enables automatic failover.
        :param pulumi.Input[int] cache_type: The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        :param pulumi.Input[bool] enable_cluster_mode: Flag to enable/disable redis cluster mode.
        :param pulumi.Input[bool] encryption_at_rest: Enables encryption-at-rest.
        :param pulumi.Input[bool] encryption_in_transit: Enables encryption-in-transit.
        :param pulumi.Input[str] endpoint: The endpoint of the elasticache instance.
        :param pulumi.Input[str] engine_version: The engine version of the elastic instance. See AWS documentation for the [available Redis instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
               Memcached instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        :param pulumi.Input[str] host: The DNS hostname of the elasticache instance.
        :param pulumi.Input[str] identifier: The full name of the elasticache instance.
        :param pulumi.Input[str] instance_status: The status of the elasticache instance.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] name: The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[int] number_of_shards: The number of shards to create. Applicable only if enable_cluster_mode is set to true
        :param pulumi.Input[str] parameter_group_name: The REDIS parameter group to supply.
        :param pulumi.Input[int] port: The listening port of the elasticache instance.
        :param pulumi.Input[int] replicas: The number of replicas to create. Supported number of replicas is 1 to 6
        :param pulumi.Input[str] size: The instance type of the elasticache instance.
               See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns: Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
               bucket. One can find steps to provide access to export snapshot to s3 on following link
               https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        :param pulumi.Input[str] snapshot_name: Select the snapshot/backup you want to use for creating redis.
        :param pulumi.Input[int] snapshot_retention_limit: Specify retention limit in days. Accepted values - 1-35.
        :param pulumi.Input[str] snapshot_window: Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
               your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
               an appropriate time range.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the elasticache instance will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if cache_type is not None:
            pulumi.set(__self__, "cache_type", cache_type)
        if enable_cluster_mode is not None:
            pulumi.set(__self__, "enable_cluster_mode", enable_cluster_mode)
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if instance_status is not None:
            pulumi.set(__self__, "instance_status", instance_status)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the elasticache instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic failover.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="enableClusterMode")
    def enable_cluster_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable redis cluster mode.
        """
        return pulumi.get(self, "enable_cluster_mode")

    @enable_cluster_mode.setter
    def enable_cluster_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cluster_mode", value)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables encryption-at-rest.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_at_rest", value)

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables encryption-in-transit.
        """
        return pulumi.get(self, "encryption_in_transit")

    @encryption_in_transit.setter
    def encryption_in_transit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_in_transit", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the elasticache instance.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version of the elastic instance. See AWS documentation for the [available Redis instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
        Memcached instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS hostname of the elasticache instance.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the elasticache instance.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the elasticache instance.
        """
        return pulumi.get(self, "instance_status")

    @instance_status.setter
    def instance_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_status", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]]:
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcacheInstanceLogDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards to create. Applicable only if enable_cluster_mode is set to true
        """
        return pulumi.get(self, "number_of_shards")

    @number_of_shards.setter
    def number_of_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_shards", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The REDIS parameter group to supply.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The listening port of the elasticache instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas to create. Supported number of replicas is 1 to 6
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the elasticache instance.
        See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
        bucket. One can find steps to provide access to export snapshot to s3 on following link
        https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Select the snapshot/backup you want to use for creating redis.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Specify retention limit in days. Accepted values - 1-35.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[str]]:
        """
        Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
        your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
        an appropriate time range.
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_window", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the elasticache instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class EcacheInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_type: Optional[pulumi.Input[int]] = None,
                 enable_cluster_mode: Optional[pulumi.Input[bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[bool]] = None,
                 encryption_in_transit: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcacheInstanceLogDeliveryConfigurationArgs', 'EcacheInstanceLogDeliveryConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Create an Amazon ElastiCache cluster of type Redis.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a ElastiCache cluster, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=False,
            address_prefix="10.11.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="prod",
            plan_id=infra.infra_name)
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.tenant_id,
            name="mycache",
            cache_type=0,
            replicas=1,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=1)
        ```

        ### Create an Amazon ElastiCache cluster of type Redis with 2 replicas of type cache.t2.small in dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=1)
        ```

        ### Create an Amazon ElastiCache of type Redis with log delivery configuration and automatic failover enabled in dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            automatic_failover_enabled=True,
            log_delivery_configurations=[
                {
                    "log_group": "/elasticache/redis",
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "log_group": "/elasticache/redis",
                    "destination_type": "cloudwatch-logs",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        ### Set up an ElastiCache Redis cluster with 2 shards and 2 cache.t2.small replicas in the dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=2)
        ```

        ### Create an Amazon ElastiCache cluster of type Memcached.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant data source, which will be populated after the tenant data source is created, when setting up the Memcached ElastiCache cluster.
        mem_cache = duplocloud.EcacheInstance("mem_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=1,
            replicas=1,
            size="cache.t2.small")
        ```

        ### Create an Amazon ElastiCache with snapshot window
        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mycaches = duplocloud.EcacheInstance("mycaches",
            tenant_id=tenant["id"],
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t3.small",
            engine_version="7.1",
            snapshot_window="04:00-13:00")
        ```

        ## Import

        Example: Importing an existing AWS ElastiCache cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS ElastiCache cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/ecacheInstance:EcacheInstance mycluster v2/subscriptions/*TENANT_ID*/ECacheDBInstance/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_token: Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        :param pulumi.Input[bool] automatic_failover_enabled: Enables automatic failover.
        :param pulumi.Input[int] cache_type: The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        :param pulumi.Input[bool] enable_cluster_mode: Flag to enable/disable redis cluster mode.
        :param pulumi.Input[bool] encryption_at_rest: Enables encryption-at-rest.
        :param pulumi.Input[bool] encryption_in_transit: Enables encryption-in-transit.
        :param pulumi.Input[str] engine_version: The engine version of the elastic instance. See AWS documentation for the [available Redis instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
               Memcached instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] name: The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[int] number_of_shards: The number of shards to create. Applicable only if enable_cluster_mode is set to true
        :param pulumi.Input[str] parameter_group_name: The REDIS parameter group to supply.
        :param pulumi.Input[int] replicas: The number of replicas to create. Supported number of replicas is 1 to 6
        :param pulumi.Input[str] size: The instance type of the elasticache instance.
               See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns: Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
               bucket. One can find steps to provide access to export snapshot to s3 on following link
               https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        :param pulumi.Input[str] snapshot_name: Select the snapshot/backup you want to use for creating redis.
        :param pulumi.Input[int] snapshot_retention_limit: Specify retention limit in days. Accepted values - 1-35.
        :param pulumi.Input[str] snapshot_window: Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
               your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
               an appropriate time range.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the elasticache instance will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcacheInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Create an Amazon ElastiCache cluster of type Redis.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a ElastiCache cluster, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=False,
            address_prefix="10.11.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="prod",
            plan_id=infra.infra_name)
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.tenant_id,
            name="mycache",
            cache_type=0,
            replicas=1,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=1)
        ```

        ### Create an Amazon ElastiCache cluster of type Redis with 2 replicas of type cache.t2.small in dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=1)
        ```

        ### Create an Amazon ElastiCache of type Redis with log delivery configuration and automatic failover enabled in dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            automatic_failover_enabled=True,
            log_delivery_configurations=[
                {
                    "log_group": "/elasticache/redis",
                    "destination_type": "cloudwatch-logs",
                    "log_format": "text",
                    "log_type": "slow-log",
                },
                {
                    "log_group": "/elasticache/redis",
                    "destination_type": "cloudwatch-logs",
                    "log_format": "json",
                    "log_type": "engine-log",
                },
            ])
        ```

        ### Set up an ElastiCache Redis cluster with 2 shards and 2 cache.t2.small replicas in the dev tenant.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the Redis ElastiCache cluster.
        redis_cache = duplocloud.EcacheInstance("redis_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t2.small",
            enable_cluster_mode=True,
            number_of_shards=2)
        ```

        ### Create an Amazon ElastiCache cluster of type Memcached.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Assuming the 'dev' tenant is already created, use a data source to fetch the tenant ID.
        tenant = duplocloud.get_tenant(name="dev")
        # Use the tenant_id from the duplocloud_tenant data source, which will be populated after the tenant data source is created, when setting up the Memcached ElastiCache cluster.
        mem_cache = duplocloud.EcacheInstance("mem_cache",
            tenant_id=tenant.id,
            name="mycache",
            cache_type=1,
            replicas=1,
            size="cache.t2.small")
        ```

        ### Create an Amazon ElastiCache with snapshot window
        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mycaches = duplocloud.EcacheInstance("mycaches",
            tenant_id=tenant["id"],
            name="mycache",
            cache_type=0,
            replicas=2,
            size="cache.t3.small",
            engine_version="7.1",
            snapshot_window="04:00-13:00")
        ```

        ## Import

        Example: Importing an existing AWS ElastiCache cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS ElastiCache cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/ecacheInstance:EcacheInstance mycluster v2/subscriptions/*TENANT_ID*/ECacheDBInstance/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param EcacheInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcacheInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_type: Optional[pulumi.Input[int]] = None,
                 enable_cluster_mode: Optional[pulumi.Input[bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[bool]] = None,
                 encryption_in_transit: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcacheInstanceLogDeliveryConfigurationArgs', 'EcacheInstanceLogDeliveryConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcacheInstanceArgs.__new__(EcacheInstanceArgs)

            __props__.__dict__["auth_token"] = auth_token
            __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
            __props__.__dict__["cache_type"] = cache_type
            __props__.__dict__["enable_cluster_mode"] = enable_cluster_mode
            __props__.__dict__["encryption_at_rest"] = encryption_at_rest
            __props__.__dict__["encryption_in_transit"] = encryption_in_transit
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_shards"] = number_of_shards
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["replicas"] = replicas
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_arns"] = snapshot_arns
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["snapshot_window"] = snapshot_window
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["instance_status"] = None
            __props__.__dict__["port"] = None
        super(EcacheInstance, __self__).__init__(
            'duplocloud:index/ecacheInstance:EcacheInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auth_token: Optional[pulumi.Input[str]] = None,
            automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
            cache_type: Optional[pulumi.Input[int]] = None,
            enable_cluster_mode: Optional[pulumi.Input[bool]] = None,
            encryption_at_rest: Optional[pulumi.Input[bool]] = None,
            encryption_in_transit: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            host: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            instance_status: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcacheInstanceLogDeliveryConfigurationArgs', 'EcacheInstanceLogDeliveryConfigurationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_shards: Optional[pulumi.Input[int]] = None,
            parameter_group_name: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            size: Optional[pulumi.Input[str]] = None,
            snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            snapshot_name: Optional[pulumi.Input[str]] = None,
            snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
            snapshot_window: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'EcacheInstance':
        """
        Get an existing EcacheInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the elasticache instance.
        :param pulumi.Input[str] auth_token: Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        :param pulumi.Input[bool] automatic_failover_enabled: Enables automatic failover.
        :param pulumi.Input[int] cache_type: The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        :param pulumi.Input[bool] enable_cluster_mode: Flag to enable/disable redis cluster mode.
        :param pulumi.Input[bool] encryption_at_rest: Enables encryption-at-rest.
        :param pulumi.Input[bool] encryption_in_transit: Enables encryption-in-transit.
        :param pulumi.Input[str] endpoint: The endpoint of the elasticache instance.
        :param pulumi.Input[str] engine_version: The engine version of the elastic instance. See AWS documentation for the [available Redis instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
               Memcached instance
               types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        :param pulumi.Input[str] host: The DNS hostname of the elasticache instance.
        :param pulumi.Input[str] identifier: The full name of the elasticache instance.
        :param pulumi.Input[str] instance_status: The status of the elasticache instance.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] name: The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[int] number_of_shards: The number of shards to create. Applicable only if enable_cluster_mode is set to true
        :param pulumi.Input[str] parameter_group_name: The REDIS parameter group to supply.
        :param pulumi.Input[int] port: The listening port of the elasticache instance.
        :param pulumi.Input[int] replicas: The number of replicas to create. Supported number of replicas is 1 to 6
        :param pulumi.Input[str] size: The instance type of the elasticache instance.
               See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns: Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
               bucket. One can find steps to provide access to export snapshot to s3 on following link
               https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        :param pulumi.Input[str] snapshot_name: Select the snapshot/backup you want to use for creating redis.
        :param pulumi.Input[int] snapshot_retention_limit: Specify retention limit in days. Accepted values - 1-35.
        :param pulumi.Input[str] snapshot_window: Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
               your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
               an appropriate time range.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the elasticache instance will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcacheInstanceState.__new__(_EcacheInstanceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
        __props__.__dict__["cache_type"] = cache_type
        __props__.__dict__["enable_cluster_mode"] = enable_cluster_mode
        __props__.__dict__["encryption_at_rest"] = encryption_at_rest
        __props__.__dict__["encryption_in_transit"] = encryption_in_transit
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["host"] = host
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["instance_status"] = instance_status
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_shards"] = number_of_shards
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["port"] = port
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_arns"] = snapshot_arns
        __props__.__dict__["snapshot_name"] = snapshot_name
        __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
        __props__.__dict__["snapshot_window"] = snapshot_window
        __props__.__dict__["tenant_id"] = tenant_id
        return EcacheInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the elasticache instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[str]]:
        """
        Set a password for authenticating to the ElastiCache instance.  Only supported if `encryption_in_transit` is to to `true`.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables automatic failover.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> pulumi.Output[Optional[int]]:
        """
        The numerical index of elasticache instance type. Should be one of: - `0` : Redis - `1` : Memcache
        """
        return pulumi.get(self, "cache_type")

    @property
    @pulumi.getter(name="enableClusterMode")
    def enable_cluster_mode(self) -> pulumi.Output[bool]:
        """
        Flag to enable/disable redis cluster mode.
        """
        return pulumi.get(self, "enable_cluster_mode")

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables encryption-at-rest.
        """
        return pulumi.get(self, "encryption_at_rest")

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables encryption-in-transit.
        """
        return pulumi.get(self, "encryption_in_transit")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint of the elasticache instance.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        The engine version of the elastic instance. See AWS documentation for the [available Redis instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/supported-engine-versions.html) or the [available
        Memcached instance
        types](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/supported-engine-versions-mc.html).
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The DNS hostname of the elasticache instance.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The full name of the elasticache instance.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> pulumi.Output[str]:
        """
        The status of the elasticache instance.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.EcacheInstanceLogDeliveryConfiguration']]]:
        return pulumi.get(self, "log_delivery_configurations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the elasticache instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> pulumi.Output[int]:
        """
        The number of shards to create. Applicable only if enable_cluster_mode is set to true
        """
        return pulumi.get(self, "number_of_shards")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[str]:
        """
        The REDIS parameter group to supply.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The listening port of the elasticache instance.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Optional[int]]:
        """
        The number of replicas to create. Supported number of replicas is 1 to 6
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The instance type of the elasticache instance.
        See AWS documentation for the [available instance types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        Specify the ARN of a Redis RDB snapshot file stored in Amazon S3. User should have the access to export snapshot to s3
        bucket. One can find steps to provide access to export snapshot to s3 on following link
        https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html
        """
        return pulumi.get(self, "snapshot_arns")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[str]:
        """
        Select the snapshot/backup you want to use for creating redis.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[int]:
        """
        Specify retention limit in days. Accepted values - 1-35.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> pulumi.Output[str]:
        """
        Specify snapshot window limit The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of
        your node group (shard). Example: 05:00-09:00. If you do not specify this parameter, ElastiCache automatically chooses
        an appropriate time range.
        """
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the elasticache instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

