# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EcsServiceArgs', 'EcsService']

@pulumi.input_type
class EcsServiceArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[int],
                 task_definition: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 is_target_group_only: Optional[pulumi.Input[bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 old_task_definition_buffer_size: Optional[pulumi.Input[int]] = None,
                 wait_until_targets_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EcsService resource.
        :param pulumi.Input[int] replicas: The number of container replicas to create.
        :param pulumi.Input[str] task_definition: The ARN of the task definition to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]] load_balancers: Zero or more load balancer configurations to associate with this service.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[int] old_task_definition_buffer_size: The number of older task definitions to retain in AWS.
        :param pulumi.Input[bool] wait_until_targets_ready: Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "task_definition", task_definition)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if dns_prfx is not None:
            pulumi.set(__self__, "dns_prfx", dns_prfx)
        if health_check_grace_period_seconds is not None:
            pulumi.set(__self__, "health_check_grace_period_seconds", health_check_grace_period_seconds)
        if is_target_group_only is not None:
            pulumi.set(__self__, "is_target_group_only", is_target_group_only)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if old_task_definition_buffer_size is not None:
            pulumi.set(__self__, "old_task_definition_buffer_size", old_task_definition_buffer_size)
        if wait_until_targets_ready is not None:
            pulumi.set(__self__, "wait_until_targets_ready", wait_until_targets_ready)

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[int]:
        """
        The number of container replicas to create.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Input[str]:
        """
        The ARN of the task definition to use.
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_definition", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]]:
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @dns_prfx.setter
    def dns_prfx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_prfx", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "health_check_grace_period_seconds")

    @health_check_grace_period_seconds.setter
    def health_check_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period_seconds", value)

    @property
    @pulumi.getter(name="isTargetGroupOnly")
    def is_target_group_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_target_group_only")

    @is_target_group_only.setter
    def is_target_group_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_target_group_only", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]]:
        """
        Zero or more load balancer configurations to associate with this service.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oldTaskDefinitionBufferSize")
    def old_task_definition_buffer_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of older task definitions to retain in AWS.
        """
        return pulumi.get(self, "old_task_definition_buffer_size")

    @old_task_definition_buffer_size.setter
    def old_task_definition_buffer_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "old_task_definition_buffer_size", value)

    @property
    @pulumi.getter(name="waitUntilTargetsReady")
    def wait_until_targets_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        return pulumi.get(self, "wait_until_targets_ready")

    @wait_until_targets_ready.setter
    def wait_until_targets_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_targets_ready", value)


@pulumi.input_type
class _EcsServiceState:
    def __init__(__self__, *,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 is_target_group_only: Optional[pulumi.Input[bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 old_task_definition_buffer_size: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_targets_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering EcsService resources.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[int] index: The index of the ecs service.
        :param pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]] load_balancers: Zero or more load balancer configurations to associate with this service.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[int] old_task_definition_buffer_size: The number of older task definitions to retain in AWS.
        :param pulumi.Input[int] replicas: The number of container replicas to create.
        :param pulumi.Input[str] task_definition: The ARN of the task definition to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[bool] wait_until_targets_ready: Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if dns_prfx is not None:
            pulumi.set(__self__, "dns_prfx", dns_prfx)
        if health_check_grace_period_seconds is not None:
            pulumi.set(__self__, "health_check_grace_period_seconds", health_check_grace_period_seconds)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if is_target_group_only is not None:
            pulumi.set(__self__, "is_target_group_only", is_target_group_only)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if old_task_definition_buffer_size is not None:
            pulumi.set(__self__, "old_task_definition_buffer_size", old_task_definition_buffer_size)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if task_definition is not None:
            pulumi.set(__self__, "task_definition", task_definition)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_targets_ready is not None:
            pulumi.set(__self__, "wait_until_targets_ready", wait_until_targets_ready)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]]:
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @dns_prfx.setter
    def dns_prfx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_prfx", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "health_check_grace_period_seconds")

    @health_check_grace_period_seconds.setter
    def health_check_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period_seconds", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the ecs service.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="isTargetGroupOnly")
    def is_target_group_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_target_group_only")

    @is_target_group_only.setter
    def is_target_group_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_target_group_only", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]]:
        """
        Zero or more load balancer configurations to associate with this service.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsServiceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oldTaskDefinitionBufferSize")
    def old_task_definition_buffer_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of older task definitions to retain in AWS.
        """
        return pulumi.get(self, "old_task_definition_buffer_size")

    @old_task_definition_buffer_size.setter
    def old_task_definition_buffer_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "old_task_definition_buffer_size", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The number of container replicas to create.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the task definition to use.
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_definition", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilTargetsReady")
    def wait_until_targets_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        return pulumi.get(self, "wait_until_targets_ready")

    @wait_until_targets_ready.setter
    def wait_until_targets_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_targets_ready", value)


class EcsService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceCapacityProviderStrategyArgs', 'EcsServiceCapacityProviderStrategyArgsDict']]]]] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 is_target_group_only: Optional[pulumi.Input[bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceLoadBalancerArgs', 'EcsServiceLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 old_task_definition_buffer_size: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_targets_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `EcsService` manages a Amazon ECS service in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myservice = duplocloud.EcsTaskDefinition("myservice")
        # Deploy NGINX using ECS
        myservice_ecs_service = duplocloud.EcsService("myservice",
            tenant_id=myapp.tenant_id,
            task_definition=myservice.arn,
            replicas=2,
            load_balancers=[{
                "lb_type": 1,
                "port": "8080",
                "external_port": 80,
                "protocol": "HTTP",
                "enable_access_logs": False,
                "drop_invalid_headers": True,
                "health_check_url": "https://example.healthcheckurl.com/healthcheck",
            }])
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/ecsService:EcsService myservice v2/subscriptions/*TENANT_ID*/EcsServiceApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceLoadBalancerArgs', 'EcsServiceLoadBalancerArgsDict']]]] load_balancers: Zero or more load balancer configurations to associate with this service.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[int] old_task_definition_buffer_size: The number of older task definitions to retain in AWS.
        :param pulumi.Input[int] replicas: The number of container replicas to create.
        :param pulumi.Input[str] task_definition: The ARN of the task definition to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[bool] wait_until_targets_ready: Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `EcsService` manages a Amazon ECS service in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myservice = duplocloud.EcsTaskDefinition("myservice")
        # Deploy NGINX using ECS
        myservice_ecs_service = duplocloud.EcsService("myservice",
            tenant_id=myapp.tenant_id,
            task_definition=myservice.arn,
            replicas=2,
            load_balancers=[{
                "lb_type": 1,
                "port": "8080",
                "external_port": 80,
                "protocol": "HTTP",
                "enable_access_logs": False,
                "drop_invalid_headers": True,
                "health_check_url": "https://example.healthcheckurl.com/healthcheck",
            }])
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of the service

        # 

        ```sh
        $ pulumi import duplocloud:index/ecsService:EcsService myservice v2/subscriptions/*TENANT_ID*/EcsServiceApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param EcsServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceCapacityProviderStrategyArgs', 'EcsServiceCapacityProviderStrategyArgsDict']]]]] = None,
                 dns_prfx: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 is_target_group_only: Optional[pulumi.Input[bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceLoadBalancerArgs', 'EcsServiceLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 old_task_definition_buffer_size: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_targets_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsServiceArgs.__new__(EcsServiceArgs)

            __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
            __props__.__dict__["dns_prfx"] = dns_prfx
            __props__.__dict__["health_check_grace_period_seconds"] = health_check_grace_period_seconds
            __props__.__dict__["is_target_group_only"] = is_target_group_only
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["name"] = name
            __props__.__dict__["old_task_definition_buffer_size"] = old_task_definition_buffer_size
            if replicas is None and not opts.urn:
                raise TypeError("Missing required property 'replicas'")
            __props__.__dict__["replicas"] = replicas
            if task_definition is None and not opts.urn:
                raise TypeError("Missing required property 'task_definition'")
            __props__.__dict__["task_definition"] = task_definition
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_targets_ready"] = wait_until_targets_ready
            __props__.__dict__["index"] = None
            __props__.__dict__["target_group_arns"] = None
        super(EcsService, __self__).__init__(
            'duplocloud:index/ecsService:EcsService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceCapacityProviderStrategyArgs', 'EcsServiceCapacityProviderStrategyArgsDict']]]]] = None,
            dns_prfx: Optional[pulumi.Input[str]] = None,
            health_check_grace_period_seconds: Optional[pulumi.Input[int]] = None,
            index: Optional[pulumi.Input[int]] = None,
            is_target_group_only: Optional[pulumi.Input[bool]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceLoadBalancerArgs', 'EcsServiceLoadBalancerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            old_task_definition_buffer_size: Optional[pulumi.Input[int]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            task_definition: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_targets_ready: Optional[pulumi.Input[bool]] = None) -> 'EcsService':
        """
        Get an existing EcsService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_prfx: The DNS prefix to assign to this service's load balancer.
        :param pulumi.Input[int] index: The index of the ecs service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcsServiceLoadBalancerArgs', 'EcsServiceLoadBalancerArgsDict']]]] load_balancers: Zero or more load balancer configurations to associate with this service.
        :param pulumi.Input[str] name: The name of the service to create.
        :param pulumi.Input[int] old_task_definition_buffer_size: The number of older task definitions to retain in AWS.
        :param pulumi.Input[int] replicas: The number of container replicas to create.
        :param pulumi.Input[str] task_definition: The ARN of the task definition to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the service will be created in.
        :param pulumi.Input[bool] wait_until_targets_ready: Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsServiceState.__new__(_EcsServiceState)

        __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
        __props__.__dict__["dns_prfx"] = dns_prfx
        __props__.__dict__["health_check_grace_period_seconds"] = health_check_grace_period_seconds
        __props__.__dict__["index"] = index
        __props__.__dict__["is_target_group_only"] = is_target_group_only
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["old_task_definition_buffer_size"] = old_task_definition_buffer_size
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["target_group_arns"] = target_group_arns
        __props__.__dict__["task_definition"] = task_definition
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_targets_ready"] = wait_until_targets_ready
        return EcsService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> pulumi.Output[Sequence['outputs.EcsServiceCapacityProviderStrategy']]:
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> pulumi.Output[Optional[str]]:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "health_check_grace_period_seconds")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[int]:
        """
        The index of the ecs service.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="isTargetGroupOnly")
    def is_target_group_only(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_target_group_only")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.EcsServiceLoadBalancer']]]:
        """
        Zero or more load balancer configurations to associate with this service.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oldTaskDefinitionBufferSize")
    def old_task_definition_buffer_size(self) -> pulumi.Output[Optional[int]]:
        """
        The number of older task definitions to retain in AWS.
        """
        return pulumi.get(self, "old_task_definition_buffer_size")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[int]:
        """
        The number of container replicas to create.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Output[str]:
        """
        The ARN of the task definition to use.
        """
        return pulumi.get(self, "task_definition")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilTargetsReady")
    def wait_until_targets_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        return pulumi.get(self, "wait_until_targets_ready")

