# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EcsTaskDefinitionArgs', 'EcsTaskDefinition']

@pulumi.input_type
class EcsTaskDefinitionArgs:
    def __init__(__self__, *,
                 container_definitions: pulumi.Input[str],
                 family: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 cpu: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]] = None,
                 prevent_tf_destroy: Optional[pulumi.Input[bool]] = None,
                 proxy_configuration: Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']] = None,
                 requires_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_platform: Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']] = None,
                 volumes: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EcsTaskDefinition resource.
        :param pulumi.Input[str] family: The name of the task definition to create.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the task definition will be created in.
        :param pulumi.Input[str] network_mode: Defaults to `awsvpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requires_compatibilities: Requires compatibilities for running jobs. Valid values are [FARGATE]
        :param pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        :param pulumi.Input[str] volumes: Defaults to `[]`.
        """
        pulumi.set(__self__, "container_definitions", container_definitions)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if inference_accelerators is not None:
            pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if prevent_tf_destroy is not None:
            pulumi.set(__self__, "prevent_tf_destroy", prevent_tf_destroy)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if requires_attributes is not None:
            pulumi.set(__self__, "requires_attributes", requires_attributes)
        if requires_compatibilities is not None:
            pulumi.set(__self__, "requires_compatibilities", requires_compatibilities)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> pulumi.Input[str]:
        return pulumi.get(self, "container_definitions")

    @container_definitions.setter
    def container_definitions(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_definitions", value)

    @property
    @pulumi.getter
    def family(self) -> pulumi.Input[str]:
        """
        The name of the task definition to create.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[str]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the task definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]]:
        return pulumi.get(self, "inference_accelerators")

    @inference_accelerators.setter
    def inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "inference_accelerators", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Defaults to `awsvpc`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]]:
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="preventTfDestroy")
    def prevent_tf_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "prevent_tf_destroy")

    @prevent_tf_destroy.setter
    def prevent_tf_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_tf_destroy", value)

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']]:
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @property
    @pulumi.getter(name="requiresAttributes")
    def requires_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]]:
        return pulumi.get(self, "requires_attributes")

    @requires_attributes.setter
    def requires_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]]):
        pulumi.set(self, "requires_attributes", value)

    @property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requires compatibilities for running jobs. Valid values are [FARGATE]
        """
        return pulumi.get(self, "requires_compatibilities")

    @requires_compatibilities.setter
    def requires_compatibilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requires_compatibilities", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[str]]:
        """
        Defaults to `[]`.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _EcsTaskDefinitionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 container_definitions: Optional[pulumi.Input[str]] = None,
                 container_definitions_updates: Optional[pulumi.Input[str]] = None,
                 cpu: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 full_family_name: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]] = None,
                 prevent_tf_destroy: Optional[pulumi.Input[bool]] = None,
                 proxy_configuration: Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']] = None,
                 requires_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 runtime_platform: Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionTagArgs']]]] = None,
                 task_role_arn: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EcsTaskDefinition resources.
        :param pulumi.Input[str] arn: The ARN of the task definition.
        :param pulumi.Input[str] container_definitions_updates: container_definitions updates in backend
        :param pulumi.Input[str] family: The name of the task definition to create.
        :param pulumi.Input[str] full_family_name: The name of the task definition to create.
        :param pulumi.Input[str] network_mode: Defaults to `awsvpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requires_compatibilities: Requires compatibilities for running jobs. Valid values are [FARGATE]
        :param pulumi.Input[int] revision: The current revision of the task definition.
        :param pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        :param pulumi.Input[str] status: The status of the task definition.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the task definition will be created in.
        :param pulumi.Input[str] volumes: Defaults to `[]`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if container_definitions is not None:
            pulumi.set(__self__, "container_definitions", container_definitions)
        if container_definitions_updates is not None:
            pulumi.set(__self__, "container_definitions_updates", container_definitions_updates)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if full_family_name is not None:
            pulumi.set(__self__, "full_family_name", full_family_name)
        if inference_accelerators is not None:
            pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if prevent_tf_destroy is not None:
            pulumi.set(__self__, "prevent_tf_destroy", prevent_tf_destroy)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if requires_attributes is not None:
            pulumi.set(__self__, "requires_attributes", requires_attributes)
        if requires_compatibilities is not None:
            pulumi.set(__self__, "requires_compatibilities", requires_compatibilities)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the task definition.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_definitions")

    @container_definitions.setter
    def container_definitions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_definitions", value)

    @property
    @pulumi.getter(name="containerDefinitionsUpdates")
    def container_definitions_updates(self) -> Optional[pulumi.Input[str]]:
        """
        container_definitions updates in backend
        """
        return pulumi.get(self, "container_definitions_updates")

    @container_definitions_updates.setter
    def container_definitions_updates(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_definitions_updates", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the task definition to create.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="fullFamilyName")
    def full_family_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the task definition to create.
        """
        return pulumi.get(self, "full_family_name")

    @full_family_name.setter
    def full_family_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_family_name", value)

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]]:
        return pulumi.get(self, "inference_accelerators")

    @inference_accelerators.setter
    def inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "inference_accelerators", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Defaults to `awsvpc`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]]:
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="preventTfDestroy")
    def prevent_tf_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "prevent_tf_destroy")

    @prevent_tf_destroy.setter
    def prevent_tf_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_tf_destroy", value)

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']]:
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['EcsTaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @property
    @pulumi.getter(name="requiresAttributes")
    def requires_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]]:
        return pulumi.get(self, "requires_attributes")

    @requires_attributes.setter
    def requires_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionRequiresAttributeArgs']]]]):
        pulumi.set(self, "requires_attributes", value)

    @property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requires compatibilities for running jobs. Valid values are [FARGATE]
        """
        return pulumi.get(self, "requires_compatibilities")

    @requires_compatibilities.setter
    def requires_compatibilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requires_compatibilities", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The current revision of the task definition.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['EcsTaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the task definition.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsTaskDefinitionTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "task_role_arn")

    @task_role_arn.setter
    def task_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_role_arn", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the task definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[str]]:
        """
        Defaults to `[]`.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volumes", value)


class EcsTaskDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_definitions: Optional[pulumi.Input[str]] = None,
                 cpu: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionInferenceAcceleratorArgs', 'EcsTaskDefinitionInferenceAcceleratorArgsDict']]]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionPlacementConstraintArgs', 'EcsTaskDefinitionPlacementConstraintArgsDict']]]]] = None,
                 prevent_tf_destroy: Optional[pulumi.Input[bool]] = None,
                 proxy_configuration: Optional[pulumi.Input[Union['EcsTaskDefinitionProxyConfigurationArgs', 'EcsTaskDefinitionProxyConfigurationArgsDict']]] = None,
                 requires_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionRequiresAttributeArgs', 'EcsTaskDefinitionRequiresAttributeArgsDict']]]]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_platform: Optional[pulumi.Input[Union['EcsTaskDefinitionRuntimePlatformArgs', 'EcsTaskDefinitionRuntimePlatformArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `EcsTaskDefinition` manages a Amazon ECS task definition in Duplo.

        ## Import

        Example: Importing an existing ECS task definition

         - *TENANT_ID* is the tenant GUID

         - *ARN* is the full ARN of the task definition

        # 

        ```sh
        $ pulumi import duplocloud:index/ecsTaskDefinition:EcsTaskDefinition myservice subscriptions/*TENANT_ID*/EcsTaskDefinition/*ARN*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] family: The name of the task definition to create.
        :param pulumi.Input[str] network_mode: Defaults to `awsvpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requires_compatibilities: Requires compatibilities for running jobs. Valid values are [FARGATE]
        :param pulumi.Input[Union['EcsTaskDefinitionRuntimePlatformArgs', 'EcsTaskDefinitionRuntimePlatformArgsDict']] runtime_platform: Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the task definition will be created in.
        :param pulumi.Input[str] volumes: Defaults to `[]`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsTaskDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `EcsTaskDefinition` manages a Amazon ECS task definition in Duplo.

        ## Import

        Example: Importing an existing ECS task definition

         - *TENANT_ID* is the tenant GUID

         - *ARN* is the full ARN of the task definition

        # 

        ```sh
        $ pulumi import duplocloud:index/ecsTaskDefinition:EcsTaskDefinition myservice subscriptions/*TENANT_ID*/EcsTaskDefinition/*ARN*
        ```

        :param str resource_name: The name of the resource.
        :param EcsTaskDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsTaskDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_definitions: Optional[pulumi.Input[str]] = None,
                 cpu: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionInferenceAcceleratorArgs', 'EcsTaskDefinitionInferenceAcceleratorArgsDict']]]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionPlacementConstraintArgs', 'EcsTaskDefinitionPlacementConstraintArgsDict']]]]] = None,
                 prevent_tf_destroy: Optional[pulumi.Input[bool]] = None,
                 proxy_configuration: Optional[pulumi.Input[Union['EcsTaskDefinitionProxyConfigurationArgs', 'EcsTaskDefinitionProxyConfigurationArgsDict']]] = None,
                 requires_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionRequiresAttributeArgs', 'EcsTaskDefinitionRequiresAttributeArgsDict']]]]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_platform: Optional[pulumi.Input[Union['EcsTaskDefinitionRuntimePlatformArgs', 'EcsTaskDefinitionRuntimePlatformArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsTaskDefinitionArgs.__new__(EcsTaskDefinitionArgs)

            if container_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'container_definitions'")
            __props__.__dict__["container_definitions"] = container_definitions
            __props__.__dict__["cpu"] = cpu
            if family is None and not opts.urn:
                raise TypeError("Missing required property 'family'")
            __props__.__dict__["family"] = family
            __props__.__dict__["inference_accelerators"] = inference_accelerators
            __props__.__dict__["ipc_mode"] = ipc_mode
            __props__.__dict__["memory"] = memory
            __props__.__dict__["network_mode"] = network_mode
            __props__.__dict__["pid_mode"] = pid_mode
            __props__.__dict__["placement_constraints"] = placement_constraints
            __props__.__dict__["prevent_tf_destroy"] = prevent_tf_destroy
            __props__.__dict__["proxy_configuration"] = proxy_configuration
            __props__.__dict__["requires_attributes"] = requires_attributes
            __props__.__dict__["requires_compatibilities"] = requires_compatibilities
            __props__.__dict__["runtime_platform"] = runtime_platform
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["arn"] = None
            __props__.__dict__["container_definitions_updates"] = None
            __props__.__dict__["execution_role_arn"] = None
            __props__.__dict__["full_family_name"] = None
            __props__.__dict__["revision"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["task_role_arn"] = None
        super(EcsTaskDefinition, __self__).__init__(
            'duplocloud:index/ecsTaskDefinition:EcsTaskDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            container_definitions: Optional[pulumi.Input[str]] = None,
            container_definitions_updates: Optional[pulumi.Input[str]] = None,
            cpu: Optional[pulumi.Input[str]] = None,
            execution_role_arn: Optional[pulumi.Input[str]] = None,
            family: Optional[pulumi.Input[str]] = None,
            full_family_name: Optional[pulumi.Input[str]] = None,
            inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionInferenceAcceleratorArgs', 'EcsTaskDefinitionInferenceAcceleratorArgsDict']]]]] = None,
            ipc_mode: Optional[pulumi.Input[str]] = None,
            memory: Optional[pulumi.Input[str]] = None,
            network_mode: Optional[pulumi.Input[str]] = None,
            pid_mode: Optional[pulumi.Input[str]] = None,
            placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionPlacementConstraintArgs', 'EcsTaskDefinitionPlacementConstraintArgsDict']]]]] = None,
            prevent_tf_destroy: Optional[pulumi.Input[bool]] = None,
            proxy_configuration: Optional[pulumi.Input[Union['EcsTaskDefinitionProxyConfigurationArgs', 'EcsTaskDefinitionProxyConfigurationArgsDict']]] = None,
            requires_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionRequiresAttributeArgs', 'EcsTaskDefinitionRequiresAttributeArgsDict']]]]] = None,
            requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            revision: Optional[pulumi.Input[int]] = None,
            runtime_platform: Optional[pulumi.Input[Union['EcsTaskDefinitionRuntimePlatformArgs', 'EcsTaskDefinitionRuntimePlatformArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcsTaskDefinitionTagArgs', 'EcsTaskDefinitionTagArgsDict']]]]] = None,
            task_role_arn: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[str]] = None) -> 'EcsTaskDefinition':
        """
        Get an existing EcsTaskDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the task definition.
        :param pulumi.Input[str] container_definitions_updates: container_definitions updates in backend
        :param pulumi.Input[str] family: The name of the task definition to create.
        :param pulumi.Input[str] full_family_name: The name of the task definition to create.
        :param pulumi.Input[str] network_mode: Defaults to `awsvpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requires_compatibilities: Requires compatibilities for running jobs. Valid values are [FARGATE]
        :param pulumi.Input[int] revision: The current revision of the task definition.
        :param pulumi.Input[Union['EcsTaskDefinitionRuntimePlatformArgs', 'EcsTaskDefinitionRuntimePlatformArgsDict']] runtime_platform: Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        :param pulumi.Input[str] status: The status of the task definition.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the task definition will be created in.
        :param pulumi.Input[str] volumes: Defaults to `[]`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsTaskDefinitionState.__new__(_EcsTaskDefinitionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["container_definitions"] = container_definitions
        __props__.__dict__["container_definitions_updates"] = container_definitions_updates
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["family"] = family
        __props__.__dict__["full_family_name"] = full_family_name
        __props__.__dict__["inference_accelerators"] = inference_accelerators
        __props__.__dict__["ipc_mode"] = ipc_mode
        __props__.__dict__["memory"] = memory
        __props__.__dict__["network_mode"] = network_mode
        __props__.__dict__["pid_mode"] = pid_mode
        __props__.__dict__["placement_constraints"] = placement_constraints
        __props__.__dict__["prevent_tf_destroy"] = prevent_tf_destroy
        __props__.__dict__["proxy_configuration"] = proxy_configuration
        __props__.__dict__["requires_attributes"] = requires_attributes
        __props__.__dict__["requires_compatibilities"] = requires_compatibilities
        __props__.__dict__["revision"] = revision
        __props__.__dict__["runtime_platform"] = runtime_platform
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["task_role_arn"] = task_role_arn
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["volumes"] = volumes
        return EcsTaskDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the task definition.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> pulumi.Output[str]:
        return pulumi.get(self, "container_definitions")

    @property
    @pulumi.getter(name="containerDefinitionsUpdates")
    def container_definitions_updates(self) -> pulumi.Output[str]:
        """
        container_definitions updates in backend
        """
        return pulumi.get(self, "container_definitions_updates")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[str]:
        """
        The name of the task definition to create.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="fullFamilyName")
    def full_family_name(self) -> pulumi.Output[str]:
        """
        The name of the task definition to create.
        """
        return pulumi.get(self, "full_family_name")

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.EcsTaskDefinitionInferenceAccelerator']]]:
        return pulumi.get(self, "inference_accelerators")

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "ipc_mode")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Defaults to `awsvpc`.
        """
        return pulumi.get(self, "network_mode")

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "pid_mode")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> pulumi.Output[Optional[Sequence['outputs.EcsTaskDefinitionPlacementConstraint']]]:
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="preventTfDestroy")
    def prevent_tf_destroy(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "prevent_tf_destroy")

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> pulumi.Output[Optional['outputs.EcsTaskDefinitionProxyConfiguration']]:
        return pulumi.get(self, "proxy_configuration")

    @property
    @pulumi.getter(name="requiresAttributes")
    def requires_attributes(self) -> pulumi.Output[Sequence['outputs.EcsTaskDefinitionRequiresAttribute']]:
        return pulumi.get(self, "requires_attributes")

    @property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> pulumi.Output[Sequence[str]]:
        """
        Requires compatibilities for running jobs. Valid values are [FARGATE]
        """
        return pulumi.get(self, "requires_compatibilities")

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Output[int]:
        """
        The current revision of the task definition.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> pulumi.Output['outputs.EcsTaskDefinitionRuntimePlatform']:
        """
        Configuration block for runtime*platform that containers in your task may use. Required on ecs tasks that are hosted on Fargate.
        """
        return pulumi.get(self, "runtime_platform")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the task definition.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.EcsTaskDefinitionTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "task_role_arn")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the task definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[str]]:
        """
        Defaults to `[]`.
        """
        return pulumi.get(self, "volumes")

