# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmrClusterArgs', 'EmrCluster']

@pulumi.input_type
class EmrClusterArgs:
    def __init__(__self__, *,
                 release_label: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_fleets: Optional[pulumi.Input[str]] = None,
                 instance_groups: Optional[pulumi.Input[str]] = None,
                 job_flow_id: Optional[pulumi.Input[str]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 managed_scaling_policy: Optional[pulumi.Input[str]] = None,
                 master_instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 slave_instance_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EmrCluster resource.
        :param pulumi.Input[str] release_label: EMR ReleaseLabel.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the emrCluster will be created in.
        :param pulumi.Input[str] additional_info: Emr - additional_info.
        :param pulumi.Input[str] applications: Emr - list of applications to be installed.
        :param pulumi.Input[str] arn: The ARN of the emrCluster.
        :param pulumi.Input[str] bootstrap_actions: Emr - list of bootstrap_actions to be installed.
        :param pulumi.Input[str] configurations: Emr - list of application configurations to be updated.
        :param pulumi.Input[str] custom_ami_id: EMR CustomAmiId.
        :param pulumi.Input[int] ebs_root_volume_size: Emr Cluster Ec2 ebs*root*volume_size settings.
        :param pulumi.Input[str] full_name: full_name - Duplo will add a prefix to the name.
        :param pulumi.Input[int] instance_count: Emr Instance Count.
        :param pulumi.Input[str] instance_fleets: Emr - instance_fleets.
        :param pulumi.Input[str] instance_groups: Emr - instance_groups.
        :param pulumi.Input[str] job_flow_id: job flow id.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        :param pulumi.Input[str] log_uri: S3 bucket path for logs.
        :param pulumi.Input[str] managed_scaling_policy: Emr - managed*scaling*policy.
        :param pulumi.Input[str] master_instance_type: Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] name: The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] scale_down_behavior: Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        :param pulumi.Input[str] slave_instance_type: Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] status: The status of the emrCluster.
        :param pulumi.Input[int] step_concurrency_level: Emr Cluster step*concurrency*level settings. Defaults to `1`.
        :param pulumi.Input[str] steps: Emr - list of steps to be run after cluster is ready.
        :param pulumi.Input[bool] termination_protection: Emr termination protection setting.
        :param pulumi.Input[bool] visible_to_all_users: Emr Cluster visible to all users settings.
        """
        pulumi.set(__self__, "release_label", release_label)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_fleets is not None:
            pulumi.set(__self__, "instance_fleets", instance_fleets)
        if instance_groups is not None:
            pulumi.set(__self__, "instance_groups", instance_groups)
        if job_flow_id is not None:
            pulumi.set(__self__, "job_flow_id", job_flow_id)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if managed_scaling_policy is not None:
            pulumi.set(__self__, "managed_scaling_policy", managed_scaling_policy)
        if master_instance_type is not None:
            pulumi.set(__self__, "master_instance_type", master_instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if slave_instance_type is not None:
            pulumi.set(__self__, "slave_instance_type", slave_instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Input[str]:
        """
        EMR ReleaseLabel.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the emrCluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - additional_info.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of applications to be installed.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the emrCluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of bootstrap_actions to be installed.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_actions", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of application configurations to be updated.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        EMR CustomAmiId.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_ami_id", value)

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Cluster Ec2 ebs*root*volume_size settings.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        full_name - Duplo will add a prefix to the name.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Instance Count.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceFleets")
    def instance_fleets(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - instance_fleets.
        """
        return pulumi.get(self, "instance_fleets")

    @instance_fleets.setter
    def instance_fleets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_fleets", value)

    @property
    @pulumi.getter(name="instanceGroups")
    def instance_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - instance_groups.
        """
        return pulumi.get(self, "instance_groups")

    @instance_groups.setter
    def instance_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_groups", value)

    @property
    @pulumi.getter(name="jobFlowId")
    def job_flow_id(self) -> Optional[pulumi.Input[str]]:
        """
        job flow id.
        """
        return pulumi.get(self, "job_flow_id")

    @job_flow_id.setter
    def job_flow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_flow_id", value)

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[bool]]:
        """
        Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket path for logs.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_uri", value)

    @property
    @pulumi.getter(name="managedScalingPolicy")
    def managed_scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - managed*scaling*policy.
        """
        return pulumi.get(self, "managed_scaling_policy")

    @managed_scaling_policy.setter
    def managed_scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_scaling_policy", value)

    @property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "master_instance_type")

    @master_instance_type.setter
    def master_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @property
    @pulumi.getter(name="slaveInstanceType")
    def slave_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "slave_instance_type")

    @slave_instance_type.setter
    def slave_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slave_instance_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the emrCluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Cluster step*concurrency*level settings. Defaults to `1`.
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of steps to be run after cluster is ready.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Emr termination protection setting.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Emr Cluster visible to all users settings.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "visible_to_all_users", value)


@pulumi.input_type
class _EmrClusterState:
    def __init__(__self__, *,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 additional_info_hash: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[str]] = None,
                 applications_hash: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions_hash: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 configurations_hash: Optional[pulumi.Input[str]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_fleets: Optional[pulumi.Input[str]] = None,
                 instance_fleets_hash: Optional[pulumi.Input[str]] = None,
                 instance_groups: Optional[pulumi.Input[str]] = None,
                 instance_groups_hash: Optional[pulumi.Input[str]] = None,
                 job_flow_id: Optional[pulumi.Input[str]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 managed_scaling_policy: Optional[pulumi.Input[str]] = None,
                 managed_scaling_policy_hash: Optional[pulumi.Input[str]] = None,
                 master_instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 slave_instance_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 steps_hash: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering EmrCluster resources.
        :param pulumi.Input[str] additional_info: Emr - additional_info.
        :param pulumi.Input[str] applications: Emr - list of applications to be installed.
        :param pulumi.Input[str] arn: The ARN of the emrCluster.
        :param pulumi.Input[str] bootstrap_actions: Emr - list of bootstrap_actions to be installed.
        :param pulumi.Input[str] configurations: Emr - list of application configurations to be updated.
        :param pulumi.Input[str] custom_ami_id: EMR CustomAmiId.
        :param pulumi.Input[int] ebs_root_volume_size: Emr Cluster Ec2 ebs*root*volume_size settings.
        :param pulumi.Input[str] full_name: full_name - Duplo will add a prefix to the name.
        :param pulumi.Input[int] instance_count: Emr Instance Count.
        :param pulumi.Input[str] instance_fleets: Emr - instance_fleets.
        :param pulumi.Input[str] instance_groups: Emr - instance_groups.
        :param pulumi.Input[str] job_flow_id: job flow id.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        :param pulumi.Input[str] log_uri: S3 bucket path for logs.
        :param pulumi.Input[str] managed_scaling_policy: Emr - managed*scaling*policy.
        :param pulumi.Input[str] master_instance_type: Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] name: The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] release_label: EMR ReleaseLabel.
        :param pulumi.Input[str] scale_down_behavior: Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        :param pulumi.Input[str] slave_instance_type: Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] status: The status of the emrCluster.
        :param pulumi.Input[int] step_concurrency_level: Emr Cluster step*concurrency*level settings. Defaults to `1`.
        :param pulumi.Input[str] steps: Emr - list of steps to be run after cluster is ready.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the emrCluster will be created in.
        :param pulumi.Input[bool] termination_protection: Emr termination protection setting.
        :param pulumi.Input[bool] visible_to_all_users: Emr Cluster visible to all users settings.
        """
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if additional_info_hash is not None:
            pulumi.set(__self__, "additional_info_hash", additional_info_hash)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if applications_hash is not None:
            pulumi.set(__self__, "applications_hash", applications_hash)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if bootstrap_actions_hash is not None:
            pulumi.set(__self__, "bootstrap_actions_hash", bootstrap_actions_hash)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if configurations_hash is not None:
            pulumi.set(__self__, "configurations_hash", configurations_hash)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_fleets is not None:
            pulumi.set(__self__, "instance_fleets", instance_fleets)
        if instance_fleets_hash is not None:
            pulumi.set(__self__, "instance_fleets_hash", instance_fleets_hash)
        if instance_groups is not None:
            pulumi.set(__self__, "instance_groups", instance_groups)
        if instance_groups_hash is not None:
            pulumi.set(__self__, "instance_groups_hash", instance_groups_hash)
        if job_flow_id is not None:
            pulumi.set(__self__, "job_flow_id", job_flow_id)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if managed_scaling_policy is not None:
            pulumi.set(__self__, "managed_scaling_policy", managed_scaling_policy)
        if managed_scaling_policy_hash is not None:
            pulumi.set(__self__, "managed_scaling_policy_hash", managed_scaling_policy_hash)
        if master_instance_type is not None:
            pulumi.set(__self__, "master_instance_type", master_instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_label is not None:
            pulumi.set(__self__, "release_label", release_label)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if slave_instance_type is not None:
            pulumi.set(__self__, "slave_instance_type", slave_instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if steps_hash is not None:
            pulumi.set(__self__, "steps_hash", steps_hash)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - additional_info.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info", value)

    @property
    @pulumi.getter(name="additionalInfoHash")
    def additional_info_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "additional_info_hash")

    @additional_info_hash.setter
    def additional_info_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info_hash", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of applications to be installed.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter(name="applicationsHash")
    def applications_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "applications_hash")

    @applications_hash.setter
    def applications_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "applications_hash", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the emrCluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of bootstrap_actions to be installed.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_actions", value)

    @property
    @pulumi.getter(name="bootstrapActionsHash")
    def bootstrap_actions_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bootstrap_actions_hash")

    @bootstrap_actions_hash.setter
    def bootstrap_actions_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_actions_hash", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of application configurations to be updated.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="configurationsHash")
    def configurations_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "configurations_hash")

    @configurations_hash.setter
    def configurations_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations_hash", value)

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        EMR CustomAmiId.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_ami_id", value)

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Cluster Ec2 ebs*root*volume_size settings.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        full_name - Duplo will add a prefix to the name.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Instance Count.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceFleets")
    def instance_fleets(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - instance_fleets.
        """
        return pulumi.get(self, "instance_fleets")

    @instance_fleets.setter
    def instance_fleets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_fleets", value)

    @property
    @pulumi.getter(name="instanceFleetsHash")
    def instance_fleets_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_fleets_hash")

    @instance_fleets_hash.setter
    def instance_fleets_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_fleets_hash", value)

    @property
    @pulumi.getter(name="instanceGroups")
    def instance_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - instance_groups.
        """
        return pulumi.get(self, "instance_groups")

    @instance_groups.setter
    def instance_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_groups", value)

    @property
    @pulumi.getter(name="instanceGroupsHash")
    def instance_groups_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_groups_hash")

    @instance_groups_hash.setter
    def instance_groups_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_groups_hash", value)

    @property
    @pulumi.getter(name="jobFlowId")
    def job_flow_id(self) -> Optional[pulumi.Input[str]]:
        """
        job flow id.
        """
        return pulumi.get(self, "job_flow_id")

    @job_flow_id.setter
    def job_flow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_flow_id", value)

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[bool]]:
        """
        Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket path for logs.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_uri", value)

    @property
    @pulumi.getter(name="managedScalingPolicy")
    def managed_scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - managed*scaling*policy.
        """
        return pulumi.get(self, "managed_scaling_policy")

    @managed_scaling_policy.setter
    def managed_scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_scaling_policy", value)

    @property
    @pulumi.getter(name="managedScalingPolicyHash")
    def managed_scaling_policy_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "managed_scaling_policy_hash")

    @managed_scaling_policy_hash.setter
    def managed_scaling_policy_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_scaling_policy_hash", value)

    @property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "master_instance_type")

    @master_instance_type.setter
    def master_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[pulumi.Input[str]]:
        """
        EMR ReleaseLabel.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @property
    @pulumi.getter(name="slaveInstanceType")
    def slave_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "slave_instance_type")

    @slave_instance_type.setter
    def slave_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slave_instance_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the emrCluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Emr Cluster step*concurrency*level settings. Defaults to `1`.
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[str]]:
        """
        Emr - list of steps to be run after cluster is ready.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter(name="stepsHash")
    def steps_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "steps_hash")

    @steps_hash.setter
    def steps_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steps_hash", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the emrCluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Emr termination protection setting.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Emr Cluster visible to all users settings.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "visible_to_all_users", value)


class EmrCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_fleets: Optional[pulumi.Input[str]] = None,
                 instance_groups: Optional[pulumi.Input[str]] = None,
                 job_flow_id: Optional[pulumi.Input[str]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 managed_scaling_policy: Optional[pulumi.Input[str]] = None,
                 master_instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 slave_instance_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `EmrCluster` manages an AWS emrCluster in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Example 1:  EMR cluster with auto-scaling.
        test = duplocloud.EmrCluster("test",
            tenant_id=myapp.tenant_id,
            name="emrp1",
            release_label="emr-6.2.0",
            log_uri="s3://name-of-my-bucket",
            visible_to_all_users=True,
            master_instance_type="m4.large",
            slave_instance_type="m4.large",
            instance_count=3,
            keep_job_flow_alive_when_no_steps=True,
            applications=json.dumps([
                {
                    "Name": "Hadoop",
                },
                {
                    "Name": "JupyterHub",
                },
                {
                    "Name": "Spark",
                },
                {
                    "Name": "Hive",
                },
            ]),
            managed_scaling_policy=json.dumps({
                "ComputeLimits": {
                    "UnitType": "Instances",
                    "MinimumCapacityUnits": 2,
                    "MaximumCapacityUnits": 5,
                    "MaximumOnDemandCapacityUnits": 5,
                    "MaximumCoreCapacityUnits": 3,
                },
            }),
            configurations=json.dumps([{
                "Classification": "hive-site",
                "Properties": {
                    "hive.metastore.client.factory.class": "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory",
                    "spark.sql.catalog.my_catalog": "org.apache.iceberg.spark.SparkCatalog",
                    "spark.sql.catalog.my_catalog.catalog-impl": "org.apache.iceberg.aws.glue.GlueCatalog",
                    "spark.sql.catalog.my_catalog.io-impl": "org.apache.iceberg.aws.s3.S3FileIO",
                    "spark.sql.catalog.my_catalog.lock-impl": "org.apache.iceberg.aws.glue.DynamoLockManager",
                    "spark.sql.catalog.my_catalog.lock.table": "myGlueLockTable",
                    "spark.sql.catalog.sampledb.warehouse": "s3://name-of-my-bucket/parquet5",
                },
            }]),
            bootstrap_actions=json.dumps([{
                "Name": "InstallApacheIceberg",
                "ScriptBootstrapAction": {
                    "Args": [
                        "name",
                        "value",
                    ],
                    "Path": "s3://name-of-my-bucket/bootstrap-iceberg.sh",
                },
            }]))
        ```

        ## Import

        Example: Importing an existing EMR cluster

         - *TENANT_ID* is the tenant GUID

         - *JOB_FLOW_ID* is the EMR cluster job flow ID

        # 

        ```sh
        $ pulumi import duplocloud:index/emrCluster:EmrCluster mycluster *TENANT_ID*/*JOB_FLOW_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_info: Emr - additional_info.
        :param pulumi.Input[str] applications: Emr - list of applications to be installed.
        :param pulumi.Input[str] arn: The ARN of the emrCluster.
        :param pulumi.Input[str] bootstrap_actions: Emr - list of bootstrap_actions to be installed.
        :param pulumi.Input[str] configurations: Emr - list of application configurations to be updated.
        :param pulumi.Input[str] custom_ami_id: EMR CustomAmiId.
        :param pulumi.Input[int] ebs_root_volume_size: Emr Cluster Ec2 ebs*root*volume_size settings.
        :param pulumi.Input[str] full_name: full_name - Duplo will add a prefix to the name.
        :param pulumi.Input[int] instance_count: Emr Instance Count.
        :param pulumi.Input[str] instance_fleets: Emr - instance_fleets.
        :param pulumi.Input[str] instance_groups: Emr - instance_groups.
        :param pulumi.Input[str] job_flow_id: job flow id.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        :param pulumi.Input[str] log_uri: S3 bucket path for logs.
        :param pulumi.Input[str] managed_scaling_policy: Emr - managed*scaling*policy.
        :param pulumi.Input[str] master_instance_type: Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] name: The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] release_label: EMR ReleaseLabel.
        :param pulumi.Input[str] scale_down_behavior: Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        :param pulumi.Input[str] slave_instance_type: Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] status: The status of the emrCluster.
        :param pulumi.Input[int] step_concurrency_level: Emr Cluster step*concurrency*level settings. Defaults to `1`.
        :param pulumi.Input[str] steps: Emr - list of steps to be run after cluster is ready.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the emrCluster will be created in.
        :param pulumi.Input[bool] termination_protection: Emr termination protection setting.
        :param pulumi.Input[bool] visible_to_all_users: Emr Cluster visible to all users settings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmrClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `EmrCluster` manages an AWS emrCluster in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Example 1:  EMR cluster with auto-scaling.
        test = duplocloud.EmrCluster("test",
            tenant_id=myapp.tenant_id,
            name="emrp1",
            release_label="emr-6.2.0",
            log_uri="s3://name-of-my-bucket",
            visible_to_all_users=True,
            master_instance_type="m4.large",
            slave_instance_type="m4.large",
            instance_count=3,
            keep_job_flow_alive_when_no_steps=True,
            applications=json.dumps([
                {
                    "Name": "Hadoop",
                },
                {
                    "Name": "JupyterHub",
                },
                {
                    "Name": "Spark",
                },
                {
                    "Name": "Hive",
                },
            ]),
            managed_scaling_policy=json.dumps({
                "ComputeLimits": {
                    "UnitType": "Instances",
                    "MinimumCapacityUnits": 2,
                    "MaximumCapacityUnits": 5,
                    "MaximumOnDemandCapacityUnits": 5,
                    "MaximumCoreCapacityUnits": 3,
                },
            }),
            configurations=json.dumps([{
                "Classification": "hive-site",
                "Properties": {
                    "hive.metastore.client.factory.class": "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory",
                    "spark.sql.catalog.my_catalog": "org.apache.iceberg.spark.SparkCatalog",
                    "spark.sql.catalog.my_catalog.catalog-impl": "org.apache.iceberg.aws.glue.GlueCatalog",
                    "spark.sql.catalog.my_catalog.io-impl": "org.apache.iceberg.aws.s3.S3FileIO",
                    "spark.sql.catalog.my_catalog.lock-impl": "org.apache.iceberg.aws.glue.DynamoLockManager",
                    "spark.sql.catalog.my_catalog.lock.table": "myGlueLockTable",
                    "spark.sql.catalog.sampledb.warehouse": "s3://name-of-my-bucket/parquet5",
                },
            }]),
            bootstrap_actions=json.dumps([{
                "Name": "InstallApacheIceberg",
                "ScriptBootstrapAction": {
                    "Args": [
                        "name",
                        "value",
                    ],
                    "Path": "s3://name-of-my-bucket/bootstrap-iceberg.sh",
                },
            }]))
        ```

        ## Import

        Example: Importing an existing EMR cluster

         - *TENANT_ID* is the tenant GUID

         - *JOB_FLOW_ID* is the EMR cluster job flow ID

        # 

        ```sh
        $ pulumi import duplocloud:index/emrCluster:EmrCluster mycluster *TENANT_ID*/*JOB_FLOW_ID*
        ```

        :param str resource_name: The name of the resource.
        :param EmrClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmrClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_fleets: Optional[pulumi.Input[str]] = None,
                 instance_groups: Optional[pulumi.Input[str]] = None,
                 job_flow_id: Optional[pulumi.Input[str]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 managed_scaling_policy: Optional[pulumi.Input[str]] = None,
                 master_instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 slave_instance_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmrClusterArgs.__new__(EmrClusterArgs)

            __props__.__dict__["additional_info"] = additional_info
            __props__.__dict__["applications"] = applications
            __props__.__dict__["arn"] = arn
            __props__.__dict__["bootstrap_actions"] = bootstrap_actions
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["custom_ami_id"] = custom_ami_id
            __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
            __props__.__dict__["full_name"] = full_name
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["instance_fleets"] = instance_fleets
            __props__.__dict__["instance_groups"] = instance_groups
            __props__.__dict__["job_flow_id"] = job_flow_id
            __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
            __props__.__dict__["log_uri"] = log_uri
            __props__.__dict__["managed_scaling_policy"] = managed_scaling_policy
            __props__.__dict__["master_instance_type"] = master_instance_type
            __props__.__dict__["name"] = name
            if release_label is None and not opts.urn:
                raise TypeError("Missing required property 'release_label'")
            __props__.__dict__["release_label"] = release_label
            __props__.__dict__["scale_down_behavior"] = scale_down_behavior
            __props__.__dict__["slave_instance_type"] = slave_instance_type
            __props__.__dict__["status"] = status
            __props__.__dict__["step_concurrency_level"] = step_concurrency_level
            __props__.__dict__["steps"] = steps
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["visible_to_all_users"] = visible_to_all_users
            __props__.__dict__["additional_info_hash"] = None
            __props__.__dict__["applications_hash"] = None
            __props__.__dict__["bootstrap_actions_hash"] = None
            __props__.__dict__["configurations_hash"] = None
            __props__.__dict__["instance_fleets_hash"] = None
            __props__.__dict__["instance_groups_hash"] = None
            __props__.__dict__["managed_scaling_policy_hash"] = None
            __props__.__dict__["steps_hash"] = None
        super(EmrCluster, __self__).__init__(
            'duplocloud:index/emrCluster:EmrCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_info: Optional[pulumi.Input[str]] = None,
            additional_info_hash: Optional[pulumi.Input[str]] = None,
            applications: Optional[pulumi.Input[str]] = None,
            applications_hash: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            bootstrap_actions: Optional[pulumi.Input[str]] = None,
            bootstrap_actions_hash: Optional[pulumi.Input[str]] = None,
            configurations: Optional[pulumi.Input[str]] = None,
            configurations_hash: Optional[pulumi.Input[str]] = None,
            custom_ami_id: Optional[pulumi.Input[str]] = None,
            ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            instance_count: Optional[pulumi.Input[int]] = None,
            instance_fleets: Optional[pulumi.Input[str]] = None,
            instance_fleets_hash: Optional[pulumi.Input[str]] = None,
            instance_groups: Optional[pulumi.Input[str]] = None,
            instance_groups_hash: Optional[pulumi.Input[str]] = None,
            job_flow_id: Optional[pulumi.Input[str]] = None,
            keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
            log_uri: Optional[pulumi.Input[str]] = None,
            managed_scaling_policy: Optional[pulumi.Input[str]] = None,
            managed_scaling_policy_hash: Optional[pulumi.Input[str]] = None,
            master_instance_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            release_label: Optional[pulumi.Input[str]] = None,
            scale_down_behavior: Optional[pulumi.Input[str]] = None,
            slave_instance_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            step_concurrency_level: Optional[pulumi.Input[int]] = None,
            steps: Optional[pulumi.Input[str]] = None,
            steps_hash: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None,
            visible_to_all_users: Optional[pulumi.Input[bool]] = None) -> 'EmrCluster':
        """
        Get an existing EmrCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_info: Emr - additional_info.
        :param pulumi.Input[str] applications: Emr - list of applications to be installed.
        :param pulumi.Input[str] arn: The ARN of the emrCluster.
        :param pulumi.Input[str] bootstrap_actions: Emr - list of bootstrap_actions to be installed.
        :param pulumi.Input[str] configurations: Emr - list of application configurations to be updated.
        :param pulumi.Input[str] custom_ami_id: EMR CustomAmiId.
        :param pulumi.Input[int] ebs_root_volume_size: Emr Cluster Ec2 ebs*root*volume_size settings.
        :param pulumi.Input[str] full_name: full_name - Duplo will add a prefix to the name.
        :param pulumi.Input[int] instance_count: Emr Instance Count.
        :param pulumi.Input[str] instance_fleets: Emr - instance_fleets.
        :param pulumi.Input[str] instance_groups: Emr - instance_groups.
        :param pulumi.Input[str] job_flow_id: job flow id.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        :param pulumi.Input[str] log_uri: S3 bucket path for logs.
        :param pulumi.Input[str] managed_scaling_policy: Emr - managed*scaling*policy.
        :param pulumi.Input[str] master_instance_type: Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] name: The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] release_label: EMR ReleaseLabel.
        :param pulumi.Input[str] scale_down_behavior: Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        :param pulumi.Input[str] slave_instance_type: Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        :param pulumi.Input[str] status: The status of the emrCluster.
        :param pulumi.Input[int] step_concurrency_level: Emr Cluster step*concurrency*level settings. Defaults to `1`.
        :param pulumi.Input[str] steps: Emr - list of steps to be run after cluster is ready.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the emrCluster will be created in.
        :param pulumi.Input[bool] termination_protection: Emr termination protection setting.
        :param pulumi.Input[bool] visible_to_all_users: Emr Cluster visible to all users settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmrClusterState.__new__(_EmrClusterState)

        __props__.__dict__["additional_info"] = additional_info
        __props__.__dict__["additional_info_hash"] = additional_info_hash
        __props__.__dict__["applications"] = applications
        __props__.__dict__["applications_hash"] = applications_hash
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bootstrap_actions"] = bootstrap_actions
        __props__.__dict__["bootstrap_actions_hash"] = bootstrap_actions_hash
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["configurations_hash"] = configurations_hash
        __props__.__dict__["custom_ami_id"] = custom_ami_id
        __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["instance_fleets"] = instance_fleets
        __props__.__dict__["instance_fleets_hash"] = instance_fleets_hash
        __props__.__dict__["instance_groups"] = instance_groups
        __props__.__dict__["instance_groups_hash"] = instance_groups_hash
        __props__.__dict__["job_flow_id"] = job_flow_id
        __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
        __props__.__dict__["log_uri"] = log_uri
        __props__.__dict__["managed_scaling_policy"] = managed_scaling_policy
        __props__.__dict__["managed_scaling_policy_hash"] = managed_scaling_policy_hash
        __props__.__dict__["master_instance_type"] = master_instance_type
        __props__.__dict__["name"] = name
        __props__.__dict__["release_label"] = release_label
        __props__.__dict__["scale_down_behavior"] = scale_down_behavior
        __props__.__dict__["slave_instance_type"] = slave_instance_type
        __props__.__dict__["status"] = status
        __props__.__dict__["step_concurrency_level"] = step_concurrency_level
        __props__.__dict__["steps"] = steps
        __props__.__dict__["steps_hash"] = steps_hash
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["termination_protection"] = termination_protection
        __props__.__dict__["visible_to_all_users"] = visible_to_all_users
        return EmrCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - additional_info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter(name="additionalInfoHash")
    def additional_info_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "additional_info_hash")

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - list of applications to be installed.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="applicationsHash")
    def applications_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "applications_hash")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the emrCluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - list of bootstrap_actions to be installed.
        """
        return pulumi.get(self, "bootstrap_actions")

    @property
    @pulumi.getter(name="bootstrapActionsHash")
    def bootstrap_actions_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bootstrap_actions_hash")

    @property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - list of application configurations to be updated.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="configurationsHash")
    def configurations_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "configurations_hash")

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> pulumi.Output[Optional[str]]:
        """
        EMR CustomAmiId.
        """
        return pulumi.get(self, "custom_ami_id")

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> pulumi.Output[Optional[int]]:
        """
        Emr Cluster Ec2 ebs*root*volume_size settings.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[str]:
        """
        full_name - Duplo will add a prefix to the name.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[int]]:
        """
        Emr Instance Count.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceFleets")
    def instance_fleets(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - instance_fleets.
        """
        return pulumi.get(self, "instance_fleets")

    @property
    @pulumi.getter(name="instanceFleetsHash")
    def instance_fleets_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_fleets_hash")

    @property
    @pulumi.getter(name="instanceGroups")
    def instance_groups(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - instance_groups.
        """
        return pulumi.get(self, "instance_groups")

    @property
    @pulumi.getter(name="instanceGroupsHash")
    def instance_groups_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_groups_hash")

    @property
    @pulumi.getter(name="jobFlowId")
    def job_flow_id(self) -> pulumi.Output[str]:
        """
        job flow id.
        """
        return pulumi.get(self, "job_flow_id")

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> pulumi.Output[Optional[bool]]:
        """
        Keep Job Flow Alive When No Steps. Emr Cluster will be terminated if true. Defaults to `true`.
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> pulumi.Output[Optional[str]]:
        """
        S3 bucket path for logs.
        """
        return pulumi.get(self, "log_uri")

    @property
    @pulumi.getter(name="managedScalingPolicy")
    def managed_scaling_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - managed*scaling*policy.
        """
        return pulumi.get(self, "managed_scaling_policy")

    @property
    @pulumi.getter(name="managedScalingPolicyHash")
    def managed_scaling_policy_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "managed_scaling_policy_hash")

    @property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        Emr MasterInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "master_instance_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the emrCluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Output[str]:
        """
        EMR ReleaseLabel.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Emr scale*down*behavior. Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @property
    @pulumi.getter(name="slaveInstanceType")
    def slave_instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        Emr SlaveInstanceType. Supported InstanceTypes e.g. m4.large
        """
        return pulumi.get(self, "slave_instance_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the emrCluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> pulumi.Output[Optional[int]]:
        """
        Emr Cluster step*concurrency*level settings. Defaults to `1`.
        """
        return pulumi.get(self, "step_concurrency_level")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Optional[str]]:
        """
        Emr - list of steps to be run after cluster is ready.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="stepsHash")
    def steps_hash(self) -> pulumi.Output[str]:
        return pulumi.get(self, "steps_hash")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the emrCluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Emr termination protection setting.
        """
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Emr Cluster visible to all users settings.
        """
        return pulumi.get(self, "visible_to_all_users")

