# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpCloudFunctionArgs', 'GcpCloudFunction']

@pulumi.input_type
class GcpCloudFunctionArgs:
    def __init__(__self__, *,
                 entrypoint: pulumi.Input[str],
                 runtime: pulumi.Input[str],
                 source_archive_url: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 allow_unauthenticated: Optional[pulumi.Input[bool]] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']] = None,
                 https_trigger: Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']] = None,
                 ingress_type: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vpc_networking_type: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a GcpCloudFunction resource.
        :param pulumi.Input[str] entrypoint: The entry point of the cloud function.
        :param pulumi.Input[str] runtime: The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
               Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
               Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
               Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        :param pulumi.Input[str] source_archive_url: The cloud storage URL where the cloud function package is located.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloud function will be created in.
        :param pulumi.Input[bool] allow_unauthenticated: Whether or not to allow unauthenticated invocations.
        :param pulumi.Input[int] available_memory_mb: The amount of memory available to the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: The build environment variables for this cloud function.
        :param pulumi.Input[str] description: The description of the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables for this cloud function.
        :param pulumi.Input['GcpCloudFunctionEventTriggerArgs'] event_trigger: Specifies an event trigger for the cloud function.
        :param pulumi.Input['GcpCloudFunctionHttpsTriggerArgs'] https_trigger: Specifies an HTTPS trigger for the cloud function.
        :param pulumi.Input[int] ingress_type: The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
               internal traffic - `3` : Allow internal traffic and GCP load balancing
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels assigned to this cloud function.
        :param pulumi.Input[str] name: The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
               `fullname` attribute.
        :param pulumi.Input[bool] require_https: Whether or not to require HTTPS.
        :param pulumi.Input[int] timeout: The execution time limit for the cloud function.
        :param pulumi.Input[int] vpc_networking_type: The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
               through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "source_archive_url", source_archive_url)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if allow_unauthenticated is not None:
            pulumi.set(__self__, "allow_unauthenticated", allow_unauthenticated)
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger is not None:
            pulumi.set(__self__, "https_trigger", https_trigger)
        if ingress_type is not None:
            pulumi.set(__self__, "ingress_type", ingress_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require_https is not None:
            pulumi.set(__self__, "require_https", require_https)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_networking_type is not None:
            pulumi.set(__self__, "vpc_networking_type", vpc_networking_type)

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Input[str]:
        """
        The entry point of the cloud function.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
        Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
        Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
        Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="sourceArchiveUrl")
    def source_archive_url(self) -> pulumi.Input[str]:
        """
        The cloud storage URL where the cloud function package is located.
        """
        return pulumi.get(self, "source_archive_url")

    @source_archive_url.setter
    def source_archive_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_archive_url", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the cloud function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="allowUnauthenticated")
    def allow_unauthenticated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow unauthenticated invocations.
        """
        return pulumi.get(self, "allow_unauthenticated")

    @allow_unauthenticated.setter
    def allow_unauthenticated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_unauthenticated", value)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory available to the cloud function.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_memory_mb", value)

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The build environment variables for this cloud function.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_environment_variables", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cloud function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables for this cloud function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']]:
        """
        Specifies an event trigger for the cloud function.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="httpsTrigger")
    def https_trigger(self) -> Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']]:
        """
        Specifies an HTTPS trigger for the cloud function.
        """
        return pulumi.get(self, "https_trigger")

    @https_trigger.setter
    def https_trigger(self, value: Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']]):
        pulumi.set(self, "https_trigger", value)

    @property
    @pulumi.getter(name="ingressType")
    def ingress_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
        internal traffic - `3` : Allow internal traffic and GCP load balancing
        """
        return pulumi.get(self, "ingress_type")

    @ingress_type.setter
    def ingress_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingress_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels assigned to this cloud function.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
        `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to require HTTPS.
        """
        return pulumi.get(self, "require_https")

    @require_https.setter
    def require_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_https", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The execution time limit for the cloud function.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="vpcNetworkingType")
    def vpc_networking_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
        through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        return pulumi.get(self, "vpc_networking_type")

    @vpc_networking_type.setter
    def vpc_networking_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vpc_networking_type", value)


@pulumi.input_type
class _GcpCloudFunctionState:
    def __init__(__self__, *,
                 allow_unauthenticated: Optional[pulumi.Input[bool]] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 https_trigger: Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']] = None,
                 ingress_type: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 version_id: Optional[pulumi.Input[int]] = None,
                 vpc_networking_type: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering GcpCloudFunction resources.
        :param pulumi.Input[bool] allow_unauthenticated: Whether or not to allow unauthenticated invocations.
        :param pulumi.Input[int] available_memory_mb: The amount of memory available to the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: The build environment variables for this cloud function.
        :param pulumi.Input[str] build_id: The ID of the cloud build that built the cloud function.
        :param pulumi.Input[str] description: The description of the cloud function.
        :param pulumi.Input[str] entrypoint: The entry point of the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables for this cloud function.
        :param pulumi.Input['GcpCloudFunctionEventTriggerArgs'] event_trigger: Specifies an event trigger for the cloud function.
        :param pulumi.Input[str] fullname: The full name of the cloud function.
        :param pulumi.Input['GcpCloudFunctionHttpsTriggerArgs'] https_trigger: Specifies an HTTPS trigger for the cloud function.
        :param pulumi.Input[int] ingress_type: The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
               internal traffic - `3` : Allow internal traffic and GCP load balancing
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels assigned to this cloud function.
        :param pulumi.Input[str] name: The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
               `fullname` attribute.
        :param pulumi.Input[bool] require_https: Whether or not to require HTTPS.
        :param pulumi.Input[str] runtime: The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
               Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
               Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
               Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        :param pulumi.Input[str] self_link: The SelfLink of the cloud function.
        :param pulumi.Input[str] source_archive_url: The cloud storage URL where the cloud function package is located.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloud function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the cloud function.
        :param pulumi.Input[int] version_id: The current version of the cloud function.
        :param pulumi.Input[int] vpc_networking_type: The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
               through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        if allow_unauthenticated is not None:
            pulumi.set(__self__, "allow_unauthenticated", allow_unauthenticated)
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if https_trigger is not None:
            pulumi.set(__self__, "https_trigger", https_trigger)
        if ingress_type is not None:
            pulumi.set(__self__, "ingress_type", ingress_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require_https is not None:
            pulumi.set(__self__, "require_https", require_https)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if source_archive_url is not None:
            pulumi.set(__self__, "source_archive_url", source_archive_url)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_networking_type is not None:
            pulumi.set(__self__, "vpc_networking_type", vpc_networking_type)

    @property
    @pulumi.getter(name="allowUnauthenticated")
    def allow_unauthenticated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow unauthenticated invocations.
        """
        return pulumi.get(self, "allow_unauthenticated")

    @allow_unauthenticated.setter
    def allow_unauthenticated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_unauthenticated", value)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory available to the cloud function.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_memory_mb", value)

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The build environment variables for this cloud function.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_environment_variables", value)

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cloud build that built the cloud function.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cloud function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        The entry point of the cloud function.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables for this cloud function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']]:
        """
        Specifies an event trigger for the cloud function.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['GcpCloudFunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the cloud function.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="httpsTrigger")
    def https_trigger(self) -> Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']]:
        """
        Specifies an HTTPS trigger for the cloud function.
        """
        return pulumi.get(self, "https_trigger")

    @https_trigger.setter
    def https_trigger(self, value: Optional[pulumi.Input['GcpCloudFunctionHttpsTriggerArgs']]):
        pulumi.set(self, "https_trigger", value)

    @property
    @pulumi.getter(name="ingressType")
    def ingress_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
        internal traffic - `3` : Allow internal traffic and GCP load balancing
        """
        return pulumi.get(self, "ingress_type")

    @ingress_type.setter
    def ingress_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingress_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels assigned to this cloud function.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
        `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to require HTTPS.
        """
        return pulumi.get(self, "require_https")

    @require_https.setter
    def require_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_https", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
        Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
        Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
        Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The SelfLink of the cloud function.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sourceArchiveUrl")
    def source_archive_url(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud storage URL where the cloud function package is located.
        """
        return pulumi.get(self, "source_archive_url")

    @source_archive_url.setter
    def source_archive_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_url", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the cloud function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The execution time limit for the cloud function.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[int]]:
        """
        The current version of the cloud function.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="vpcNetworkingType")
    def vpc_networking_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
        through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        return pulumi.get(self, "vpc_networking_type")

    @vpc_networking_type.setter
    def vpc_networking_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vpc_networking_type", value)


class GcpCloudFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_unauthenticated: Optional[pulumi.Input[bool]] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionEventTriggerArgs', 'GcpCloudFunctionEventTriggerArgsDict']]] = None,
                 https_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionHttpsTriggerArgs', 'GcpCloudFunctionHttpsTriggerArgsDict']]] = None,
                 ingress_type: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vpc_networking_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `GcpCloudFunction` manages a GCP cloud function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # A simple cloud function with an HTTPS trigger
        myfunc = duplocloud.GcpCloudFunction("myfunc",
            tenant_id=myapp.tenant_id,
            name="myfunc",
            source_archive_url="gs://my-function-code-bucket/myfunc.zip",
            entrypoint="my_entrypoint",
            runtime="nodejs10",
            available_memory_mb=256,
            ingress_type=1,
            timeout=60,
            environment_variables={
                "foo": "bar",
            },
            https_trigger={})
        ```

        ## Import

        Example: Importing an existing GCP cloud function

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the GCP cloud function

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpCloudFunction:GcpCloudFunction myfunc *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_unauthenticated: Whether or not to allow unauthenticated invocations.
        :param pulumi.Input[int] available_memory_mb: The amount of memory available to the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: The build environment variables for this cloud function.
        :param pulumi.Input[str] description: The description of the cloud function.
        :param pulumi.Input[str] entrypoint: The entry point of the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables for this cloud function.
        :param pulumi.Input[Union['GcpCloudFunctionEventTriggerArgs', 'GcpCloudFunctionEventTriggerArgsDict']] event_trigger: Specifies an event trigger for the cloud function.
        :param pulumi.Input[Union['GcpCloudFunctionHttpsTriggerArgs', 'GcpCloudFunctionHttpsTriggerArgsDict']] https_trigger: Specifies an HTTPS trigger for the cloud function.
        :param pulumi.Input[int] ingress_type: The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
               internal traffic - `3` : Allow internal traffic and GCP load balancing
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels assigned to this cloud function.
        :param pulumi.Input[str] name: The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
               `fullname` attribute.
        :param pulumi.Input[bool] require_https: Whether or not to require HTTPS.
        :param pulumi.Input[str] runtime: The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
               Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
               Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
               Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        :param pulumi.Input[str] source_archive_url: The cloud storage URL where the cloud function package is located.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloud function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the cloud function.
        :param pulumi.Input[int] vpc_networking_type: The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
               through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpCloudFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `GcpCloudFunction` manages a GCP cloud function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # A simple cloud function with an HTTPS trigger
        myfunc = duplocloud.GcpCloudFunction("myfunc",
            tenant_id=myapp.tenant_id,
            name="myfunc",
            source_archive_url="gs://my-function-code-bucket/myfunc.zip",
            entrypoint="my_entrypoint",
            runtime="nodejs10",
            available_memory_mb=256,
            ingress_type=1,
            timeout=60,
            environment_variables={
                "foo": "bar",
            },
            https_trigger={})
        ```

        ## Import

        Example: Importing an existing GCP cloud function

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the GCP cloud function

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpCloudFunction:GcpCloudFunction myfunc *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpCloudFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpCloudFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_unauthenticated: Optional[pulumi.Input[bool]] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionEventTriggerArgs', 'GcpCloudFunctionEventTriggerArgsDict']]] = None,
                 https_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionHttpsTriggerArgs', 'GcpCloudFunctionHttpsTriggerArgsDict']]] = None,
                 ingress_type: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vpc_networking_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpCloudFunctionArgs.__new__(GcpCloudFunctionArgs)

            __props__.__dict__["allow_unauthenticated"] = allow_unauthenticated
            __props__.__dict__["available_memory_mb"] = available_memory_mb
            __props__.__dict__["build_environment_variables"] = build_environment_variables
            __props__.__dict__["description"] = description
            if entrypoint is None and not opts.urn:
                raise TypeError("Missing required property 'entrypoint'")
            __props__.__dict__["entrypoint"] = entrypoint
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["https_trigger"] = https_trigger
            __props__.__dict__["ingress_type"] = ingress_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["require_https"] = require_https
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            if source_archive_url is None and not opts.urn:
                raise TypeError("Missing required property 'source_archive_url'")
            __props__.__dict__["source_archive_url"] = source_archive_url
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["vpc_networking_type"] = vpc_networking_type
            __props__.__dict__["build_id"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["version_id"] = None
        super(GcpCloudFunction, __self__).__init__(
            'duplocloud:index/gcpCloudFunction:GcpCloudFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_unauthenticated: Optional[pulumi.Input[bool]] = None,
            available_memory_mb: Optional[pulumi.Input[int]] = None,
            build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            build_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entrypoint: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            event_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionEventTriggerArgs', 'GcpCloudFunctionEventTriggerArgsDict']]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            https_trigger: Optional[pulumi.Input[Union['GcpCloudFunctionHttpsTriggerArgs', 'GcpCloudFunctionHttpsTriggerArgsDict']]] = None,
            ingress_type: Optional[pulumi.Input[int]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            require_https: Optional[pulumi.Input[bool]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            source_archive_url: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            version_id: Optional[pulumi.Input[int]] = None,
            vpc_networking_type: Optional[pulumi.Input[int]] = None) -> 'GcpCloudFunction':
        """
        Get an existing GcpCloudFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_unauthenticated: Whether or not to allow unauthenticated invocations.
        :param pulumi.Input[int] available_memory_mb: The amount of memory available to the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: The build environment variables for this cloud function.
        :param pulumi.Input[str] build_id: The ID of the cloud build that built the cloud function.
        :param pulumi.Input[str] description: The description of the cloud function.
        :param pulumi.Input[str] entrypoint: The entry point of the cloud function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables for this cloud function.
        :param pulumi.Input[Union['GcpCloudFunctionEventTriggerArgs', 'GcpCloudFunctionEventTriggerArgsDict']] event_trigger: Specifies an event trigger for the cloud function.
        :param pulumi.Input[str] fullname: The full name of the cloud function.
        :param pulumi.Input[Union['GcpCloudFunctionHttpsTriggerArgs', 'GcpCloudFunctionHttpsTriggerArgsDict']] https_trigger: Specifies an HTTPS trigger for the cloud function.
        :param pulumi.Input[int] ingress_type: The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
               internal traffic - `3` : Allow internal traffic and GCP load balancing
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels assigned to this cloud function.
        :param pulumi.Input[str] name: The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
               `fullname` attribute.
        :param pulumi.Input[bool] require_https: Whether or not to require HTTPS.
        :param pulumi.Input[str] runtime: The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
               Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
               Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
               Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        :param pulumi.Input[str] self_link: The SelfLink of the cloud function.
        :param pulumi.Input[str] source_archive_url: The cloud storage URL where the cloud function package is located.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloud function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the cloud function.
        :param pulumi.Input[int] version_id: The current version of the cloud function.
        :param pulumi.Input[int] vpc_networking_type: The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
               through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpCloudFunctionState.__new__(_GcpCloudFunctionState)

        __props__.__dict__["allow_unauthenticated"] = allow_unauthenticated
        __props__.__dict__["available_memory_mb"] = available_memory_mb
        __props__.__dict__["build_environment_variables"] = build_environment_variables
        __props__.__dict__["build_id"] = build_id
        __props__.__dict__["description"] = description
        __props__.__dict__["entrypoint"] = entrypoint
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["event_trigger"] = event_trigger
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["https_trigger"] = https_trigger
        __props__.__dict__["ingress_type"] = ingress_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["require_https"] = require_https
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["source_archive_url"] = source_archive_url
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["vpc_networking_type"] = vpc_networking_type
        return GcpCloudFunction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowUnauthenticated")
    def allow_unauthenticated(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allow unauthenticated invocations.
        """
        return pulumi.get(self, "allow_unauthenticated")

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of memory available to the cloud function.
        """
        return pulumi.get(self, "available_memory_mb")

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The build environment variables for this cloud function.
        """
        return pulumi.get(self, "build_environment_variables")

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Output[str]:
        """
        The ID of the cloud build that built the cloud function.
        """
        return pulumi.get(self, "build_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the cloud function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Output[str]:
        """
        The entry point of the cloud function.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The environment variables for this cloud function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output[Optional['outputs.GcpCloudFunctionEventTrigger']]:
        """
        Specifies an event trigger for the cloud function.
        """
        return pulumi.get(self, "event_trigger")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the cloud function.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="httpsTrigger")
    def https_trigger(self) -> pulumi.Output[Optional['outputs.GcpCloudFunctionHttpsTrigger']]:
        """
        Specifies an HTTPS trigger for the cloud function.
        """
        return pulumi.get(self, "https_trigger")

    @property
    @pulumi.getter(name="ingressType")
    def ingress_type(self) -> pulumi.Output[Optional[int]]:
        """
        The numerical index of ingress type to use for this cloud function. Should be one of: - `1` : Allow all - `2` : Allow
        internal traffic - `3` : Allow internal traffic and GCP load balancing
        """
        return pulumi.get(self, "ingress_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The labels assigned to this cloud function.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the cloud function. Duplo will add a prefix to the name. You can retrieve the full name from the
        `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to require HTTPS.
        """
        return pulumi.get(self, "require_https")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        The runtime of the cloud function. Should be one of: - `nodejs10` : Node.js 10 - `nodejs12` : Node.js 12 - `nodejs14` :
        Node.js 14 - `python37` : Python 3.7 - `python38` : Python 3.8 - `python39` : Python 3.9 - `go111` : Go 1.11 - `go113` :
        Go 1.13 - `java11` : Java 11 - `dotnet3` : .NET Framework 3 - `ruby26` : Ruby 2.6 - `ruby27` : Ruby 2.7 - `nodejs6` :
        Node.js 6 (deprecated) - `nodejs8` : Node.js 8 (deprecated)
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The SelfLink of the cloud function.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sourceArchiveUrl")
    def source_archive_url(self) -> pulumi.Output[str]:
        """
        The cloud storage URL where the cloud function package is located.
        """
        return pulumi.get(self, "source_archive_url")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the cloud function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The execution time limit for the cloud function.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[int]:
        """
        The current version of the cloud function.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="vpcNetworkingType")
    def vpc_networking_type(self) -> pulumi.Output[Optional[int]]:
        """
        The numerical index of the VPC networking type to use for this cloud function. Should be one of: - `0` : All traffic
        through the VPC - `1` : Only private traffic through the VPC - `2` : No VPC networking
        """
        return pulumi.get(self, "vpc_networking_type")

