# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GcpFirestoreArgs', 'GcpFirestore']

@pulumi.input_type
class GcpFirestoreArgs:
    def __init__(__self__, *,
                 location_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 enable_delete_protection: Optional[pulumi.Input[bool]] = None,
                 enable_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GcpFirestore resource.
        :param pulumi.Input[str] location_id: Location for firestore
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the firestore will be created in.
        :param pulumi.Input[str] type: Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        :param pulumi.Input[bool] enable_delete_protection: Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        :param pulumi.Input[bool] enable_point_in_time_recovery: Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        :param pulumi.Input[str] name: The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if enable_delete_protection is not None:
            pulumi.set(__self__, "enable_delete_protection", enable_delete_protection)
        if enable_point_in_time_recovery is not None:
            pulumi.set(__self__, "enable_point_in_time_recovery", enable_point_in_time_recovery)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Input[str]:
        """
        Location for firestore
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the firestore will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="enableDeleteProtection")
    def enable_delete_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        """
        return pulumi.get(self, "enable_delete_protection")

    @enable_delete_protection.setter
    def enable_delete_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_delete_protection", value)

    @property
    @pulumi.getter(name="enablePointInTimeRecovery")
    def enable_point_in_time_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        """
        return pulumi.get(self, "enable_point_in_time_recovery")

    @enable_point_in_time_recovery.setter
    def enable_point_in_time_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_point_in_time_recovery", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GcpFirestoreState:
    def __init__(__self__, *,
                 app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
                 concurrency_mode: Optional[pulumi.Input[str]] = None,
                 earliest_version_time: Optional[pulumi.Input[str]] = None,
                 enable_delete_protection: Optional[pulumi.Input[bool]] = None,
                 enable_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 version_retention_period: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GcpFirestore resources.
        :param pulumi.Input[bool] enable_delete_protection: Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        :param pulumi.Input[bool] enable_point_in_time_recovery: Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        :param pulumi.Input[str] fullname: The full name of the firestore.
        :param pulumi.Input[str] location_id: Location for firestore
        :param pulumi.Input[str] name: The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the firestore will be created in.
        :param pulumi.Input[str] type: Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        if app_engine_integration_mode is not None:
            pulumi.set(__self__, "app_engine_integration_mode", app_engine_integration_mode)
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if earliest_version_time is not None:
            pulumi.set(__self__, "earliest_version_time", earliest_version_time)
        if enable_delete_protection is not None:
            pulumi.set(__self__, "enable_delete_protection", enable_delete_protection)
        if enable_point_in_time_recovery is not None:
            pulumi.set(__self__, "enable_point_in_time_recovery", enable_point_in_time_recovery)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if version_retention_period is not None:
            pulumi.set(__self__, "version_retention_period", version_retention_period)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "app_engine_integration_mode")

    @app_engine_integration_mode.setter
    def app_engine_integration_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_engine_integration_mode", value)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="earliestVersionTime")
    def earliest_version_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "earliest_version_time")

    @earliest_version_time.setter
    def earliest_version_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "earliest_version_time", value)

    @property
    @pulumi.getter(name="enableDeleteProtection")
    def enable_delete_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        """
        return pulumi.get(self, "enable_delete_protection")

    @enable_delete_protection.setter
    def enable_delete_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_delete_protection", value)

    @property
    @pulumi.getter(name="enablePointInTimeRecovery")
    def enable_point_in_time_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        """
        return pulumi.get(self, "enable_point_in_time_recovery")

    @enable_point_in_time_recovery.setter
    def enable_point_in_time_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_point_in_time_recovery", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the firestore.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Location for firestore
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the firestore will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version_retention_period")

    @version_retention_period.setter
    def version_retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_retention_period", value)


class GcpFirestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_delete_protection: Optional[pulumi.Input[bool]] = None,
                 enable_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `GcpFirestore` manages a GCP firestore in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        app = duplocloud.GcpFirestore("app",
            tenant_id=myapp.tenant_id,
            name="firestore-tf-2",
            type="FIRESTORE_NATIVE",
            location_id="us-west2",
            enable_delete_protection=False,
            enable_point_in_time_recovery=False)
        firestore_app = duplocloud.GcpFirestore("firestore-app")
        ```

        ## Import

        Example: Importing an existing GCP Firestore

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the  name of the Firestore

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpFirestore:GcpFirestore firestore-app *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_delete_protection: Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        :param pulumi.Input[bool] enable_point_in_time_recovery: Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        :param pulumi.Input[str] location_id: Location for firestore
        :param pulumi.Input[str] name: The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the firestore will be created in.
        :param pulumi.Input[str] type: Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpFirestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `GcpFirestore` manages a GCP firestore in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        app = duplocloud.GcpFirestore("app",
            tenant_id=myapp.tenant_id,
            name="firestore-tf-2",
            type="FIRESTORE_NATIVE",
            location_id="us-west2",
            enable_delete_protection=False,
            enable_point_in_time_recovery=False)
        firestore_app = duplocloud.GcpFirestore("firestore-app")
        ```

        ## Import

        Example: Importing an existing GCP Firestore

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the  name of the Firestore

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpFirestore:GcpFirestore firestore-app *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpFirestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpFirestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_delete_protection: Optional[pulumi.Input[bool]] = None,
                 enable_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpFirestoreArgs.__new__(GcpFirestoreArgs)

            __props__.__dict__["enable_delete_protection"] = enable_delete_protection
            __props__.__dict__["enable_point_in_time_recovery"] = enable_point_in_time_recovery
            if location_id is None and not opts.urn:
                raise TypeError("Missing required property 'location_id'")
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["app_engine_integration_mode"] = None
            __props__.__dict__["concurrency_mode"] = None
            __props__.__dict__["earliest_version_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["version_retention_period"] = None
        super(GcpFirestore, __self__).__init__(
            'duplocloud:index/gcpFirestore:GcpFirestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
            concurrency_mode: Optional[pulumi.Input[str]] = None,
            earliest_version_time: Optional[pulumi.Input[str]] = None,
            enable_delete_protection: Optional[pulumi.Input[bool]] = None,
            enable_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            location_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            version_retention_period: Optional[pulumi.Input[str]] = None) -> 'GcpFirestore':
        """
        Get an existing GcpFirestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_delete_protection: Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        :param pulumi.Input[bool] enable_point_in_time_recovery: Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        :param pulumi.Input[str] fullname: The full name of the firestore.
        :param pulumi.Input[str] location_id: Location for firestore
        :param pulumi.Input[str] name: The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the firestore will be created in.
        :param pulumi.Input[str] type: Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpFirestoreState.__new__(_GcpFirestoreState)

        __props__.__dict__["app_engine_integration_mode"] = app_engine_integration_mode
        __props__.__dict__["concurrency_mode"] = concurrency_mode
        __props__.__dict__["earliest_version_time"] = earliest_version_time
        __props__.__dict__["enable_delete_protection"] = enable_delete_protection
        __props__.__dict__["enable_point_in_time_recovery"] = enable_point_in_time_recovery
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["version_retention_period"] = version_retention_period
        return GcpFirestore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> pulumi.Output[str]:
        return pulumi.get(self, "app_engine_integration_mode")

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> pulumi.Output[str]:
        return pulumi.get(self, "concurrency_mode")

    @property
    @pulumi.getter(name="earliestVersionTime")
    def earliest_version_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "earliest_version_time")

    @property
    @pulumi.getter(name="enableDeleteProtection")
    def enable_delete_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Delete protection prevents accidental deletion of firestore. Defaults to `false`.
        """
        return pulumi.get(self, "enable_delete_protection")

    @property
    @pulumi.getter(name="enablePointInTimeRecovery")
    def enable_point_in_time_recovery(self) -> pulumi.Output[Optional[bool]]:
        """
        Restores data to a specific moment in time, enhancing data protection and recovery capabilities. Defaults to `false`.
        """
        return pulumi.get(self, "enable_point_in_time_recovery")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the firestore.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        Location for firestore
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the firestore.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the firestore will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Firestore supports type `FIRESTORE_NATIVE` and `DATASTORE_MODE`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> pulumi.Output[str]:
        return pulumi.get(self, "version_retention_period")

