# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GcpHostArgs', 'GcpHost']

@pulumi.input_type
class GcpHostArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[str],
                 friendly_name: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 user_account: pulumi.Input[str],
                 zone: pulumi.Input[str],
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a GcpHost resource.
        :param pulumi.Input[str] capacity: The machine type to create
        :param pulumi.Input[str] friendly_name: The name of the vm.
        :param pulumi.Input[str] image_id: The image from which to initialize this vm
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The email id of the user.
        :param pulumi.Input[str] zone: The zone that the machine should be created in
        :param pulumi.Input[int] accelerator_count: The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        :param pulumi.Input[str] accelerator_type: The accelerator type resource to expose to this instance
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of network tags that can be added to the vm
        :param pulumi.Input[bool] wait_until_ready: Defaults to `true`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "user_account", user_account)
        pulumi.set(__self__, "zone", zone)
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[str]:
        """
        The machine type to create
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Input[str]:
        """
        The name of the vm.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The image from which to initialize this vm
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> pulumi.Input[str]:
        """
        The email id of the user.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        The zone that the machine should be created in
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        The accelerator type resource to expose to this instance
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs assigned to the vm
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network tags that can be added to the vm
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _GcpHostState:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 identity_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GcpHost resources.
        :param pulumi.Input[int] accelerator_count: The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        :param pulumi.Input[str] accelerator_type: The accelerator type resource to expose to this instance
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] capacity: The machine type to create
        :param pulumi.Input[str] friendly_name: The name of the vm.
        :param pulumi.Input[str] fullname: The full name of the vm.
        :param pulumi.Input[str] image_id: The image from which to initialize this vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of network tags that can be added to the vm
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The email id of the user.
        :param pulumi.Input[bool] wait_until_ready: Defaults to `true`.
        :param pulumi.Input[str] zone: The zone that the machine should be created in
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if identity_role is not None:
            pulumi.set(__self__, "identity_role", identity_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        The accelerator type resource to expose to this instance
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to create
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vm.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the vm.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="identityRole")
    def identity_role(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "identity_role")

    @identity_role.setter
    def identity_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_role", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The image from which to initialize this vm
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs assigned to the vm
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network tags that can be added to the vm
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The email id of the user.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone that the machine should be created in
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class GcpHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The GcpHost used to manage or configure virtual machine at gcp

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        host = duplocloud.GcpHost("host",
            tenant_id=myapp.tenant_id,
            friendly_name="tfnewhost",
            capacity="e2-medium",
            zone="us-west2-a",
            agent_platform=0,
            metadata={
                "OsDiskSize": "10",
                "startup_script": "echo \\"Hello from test startup script!\\" > /test.txt\\n",
            },
            tags=["networktag"],
            image_id="projects/{project}/global/images/{image}",
            labels={
                "resource": "label",
            },
            user_account="abc@xyz.com",
            allocated_public_ip=True)
        ```

        ## Import

        Example: Importing an existing AWS host

         - *TENANT_ID* is the tenant GUID

         - *INSTANCE_ID* is the GCP VM instance ID

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpHost:GcpHost myhost v2/subscriptions/*TENANT_ID*/gcpHost/*INSTANCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] accelerator_count: The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        :param pulumi.Input[str] accelerator_type: The accelerator type resource to expose to this instance
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] capacity: The machine type to create
        :param pulumi.Input[str] friendly_name: The name of the vm.
        :param pulumi.Input[str] image_id: The image from which to initialize this vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of network tags that can be added to the vm
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The email id of the user.
        :param pulumi.Input[bool] wait_until_ready: Defaults to `true`.
        :param pulumi.Input[str] zone: The zone that the machine should be created in
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The GcpHost used to manage or configure virtual machine at gcp

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        host = duplocloud.GcpHost("host",
            tenant_id=myapp.tenant_id,
            friendly_name="tfnewhost",
            capacity="e2-medium",
            zone="us-west2-a",
            agent_platform=0,
            metadata={
                "OsDiskSize": "10",
                "startup_script": "echo \\"Hello from test startup script!\\" > /test.txt\\n",
            },
            tags=["networktag"],
            image_id="projects/{project}/global/images/{image}",
            labels={
                "resource": "label",
            },
            user_account="abc@xyz.com",
            allocated_public_ip=True)
        ```

        ## Import

        Example: Importing an existing AWS host

         - *TENANT_ID* is the tenant GUID

         - *INSTANCE_ID* is the GCP VM instance ID

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpHost:GcpHost myhost v2/subscriptions/*TENANT_ID*/gcpHost/*INSTANCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param GcpHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpHostArgs.__new__(GcpHostArgs)

            __props__.__dict__["accelerator_count"] = accelerator_count
            __props__.__dict__["accelerator_type"] = accelerator_type
            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocated_public_ip"] = allocated_public_ip
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            if friendly_name is None and not opts.urn:
                raise TypeError("Missing required property 'friendly_name'")
            __props__.__dict__["friendly_name"] = friendly_name
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if user_account is None and not opts.urn:
                raise TypeError("Missing required property 'user_account'")
            __props__.__dict__["user_account"] = user_account
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["architecture"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["identity_role"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["status"] = None
        super(GcpHost, __self__).__init__(
            'duplocloud:index/gcpHost:GcpHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_count: Optional[pulumi.Input[int]] = None,
            accelerator_type: Optional[pulumi.Input[str]] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocated_public_ip: Optional[pulumi.Input[bool]] = None,
            architecture: Optional[pulumi.Input[str]] = None,
            capacity: Optional[pulumi.Input[str]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            identity_role: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            public_ip_address: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            user_account: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'GcpHost':
        """
        Get an existing GcpHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] accelerator_count: The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        :param pulumi.Input[str] accelerator_type: The accelerator type resource to expose to this instance
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP. Defaults to `false`.
        :param pulumi.Input[str] capacity: The machine type to create
        :param pulumi.Input[str] friendly_name: The name of the vm.
        :param pulumi.Input[str] fullname: The full name of the vm.
        :param pulumi.Input[str] image_id: The image from which to initialize this vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the vm
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of network tags that can be added to the vm
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The email id of the user.
        :param pulumi.Input[bool] wait_until_ready: Defaults to `true`.
        :param pulumi.Input[str] zone: The zone that the machine should be created in
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpHostState.__new__(_GcpHostState)

        __props__.__dict__["accelerator_count"] = accelerator_count
        __props__.__dict__["accelerator_type"] = accelerator_type
        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocated_public_ip"] = allocated_public_ip
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["identity_role"] = identity_role
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user_account"] = user_account
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        __props__.__dict__["zone"] = zone
        return GcpHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of the guest accelerator cards exposed to this instance. Defaults to `0`.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Output[str]:
        """
        The accelerator type resource to expose to this instance
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this host is added to. Defaults to `0`.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allocate a public IP. Defaults to `false`.
        """
        return pulumi.get(self, "allocated_public_ip")

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[str]:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[str]:
        """
        The machine type to create
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[str]:
        """
        The name of the vm.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the vm.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="identityRole")
    def identity_role(self) -> pulumi.Output[str]:
        return pulumi.get(self, "identity_role")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The image from which to initialize this vm
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A set of key/value label pairs assigned to the vm
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Configuration, metadata used when creating the host.\\n\\n*Note: To configure OS disk size OsDiskSize can be specified as Key and its size as value, size value should be atleast 10, Similarly to added start up script one can pass the key as startup_script and startup command as its value*
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[str]:
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        List of network tags that can be added to the vm
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> pulumi.Output[str]:
        """
        The email id of the user.
        """
        return pulumi.get(self, "user_account")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone that the machine should be created in
        """
        return pulumi.get(self, "zone")

