# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpInfraMaintenanceWindowArgs', 'GcpInfraMaintenanceWindow']

@pulumi.input_type
class GcpInfraMaintenanceWindowArgs:
    def __init__(__self__, *,
                 infra_name: pulumi.Input[str],
                 daily_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]] = None,
                 recurring_window: Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']] = None):
        """
        The set of arguments for constructing a GcpInfraMaintenanceWindow resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure where maintenance windows need to be scheduled.
        :param pulumi.Input[str] daily_maintenance_start_time: Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        :param pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]] exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        """
        pulumi.set(__self__, "infra_name", infra_name)
        if daily_maintenance_start_time is not None:
            pulumi.set(__self__, "daily_maintenance_start_time", daily_maintenance_start_time)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if recurring_window is not None:
            pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure where maintenance windows need to be scheduled.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="dailyMaintenanceStartTime")
    def daily_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        """
        return pulumi.get(self, "daily_maintenance_start_time")

    @daily_maintenance_start_time.setter
    def daily_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_maintenance_start_time", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']]:
        return pulumi.get(self, "recurring_window")

    @recurring_window.setter
    def recurring_window(self, value: Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']]):
        pulumi.set(self, "recurring_window", value)


@pulumi.input_type
class _GcpInfraMaintenanceWindowState:
    def __init__(__self__, *,
                 daily_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 recurring_window: Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']] = None):
        """
        Input properties used for looking up and filtering GcpInfraMaintenanceWindow resources.
        :param pulumi.Input[str] daily_maintenance_start_time: Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        :param pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]] exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        :param pulumi.Input[str] infra_name: The name of the infrastructure where maintenance windows need to be scheduled.
        """
        if daily_maintenance_start_time is not None:
            pulumi.set(__self__, "daily_maintenance_start_time", daily_maintenance_start_time)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if recurring_window is not None:
            pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="dailyMaintenanceStartTime")
    def daily_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        """
        return pulumi.get(self, "daily_maintenance_start_time")

    @daily_maintenance_start_time.setter
    def daily_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_maintenance_start_time", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpInfraMaintenanceWindowExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure where maintenance windows need to be scheduled.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']]:
        return pulumi.get(self, "recurring_window")

    @recurring_window.setter
    def recurring_window(self, value: Optional[pulumi.Input['GcpInfraMaintenanceWindowRecurringWindowArgs']]):
        pulumi.set(self, "recurring_window", value)


class GcpInfraMaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpInfraMaintenanceWindowExclusionArgs', 'GcpInfraMaintenanceWindowExclusionArgsDict']]]]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 recurring_window: Optional[pulumi.Input[Union['GcpInfraMaintenanceWindowRecurringWindowArgs', 'GcpInfraMaintenanceWindowRecurringWindowArgsDict']]] = None,
                 __props__=None):
        """
        `GcpInfraMaintenanceWindow` applies maintenance window to an gcp infrastructure

        ## Import

        Example: Importing an existing gcp infra maintenace window resource

         - *INFRANAME* Name of the infrastructure

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpInfraMaintenanceWindow:GcpInfraMaintenanceWindow infra maintenance-window/*INFRANAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] daily_maintenance_start_time: Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpInfraMaintenanceWindowExclusionArgs', 'GcpInfraMaintenanceWindowExclusionArgsDict']]]] exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        :param pulumi.Input[str] infra_name: The name of the infrastructure where maintenance windows need to be scheduled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpInfraMaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `GcpInfraMaintenanceWindow` applies maintenance window to an gcp infrastructure

        ## Import

        Example: Importing an existing gcp infra maintenace window resource

         - *INFRANAME* Name of the infrastructure

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpInfraMaintenanceWindow:GcpInfraMaintenanceWindow infra maintenance-window/*INFRANAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpInfraMaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpInfraMaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpInfraMaintenanceWindowExclusionArgs', 'GcpInfraMaintenanceWindowExclusionArgsDict']]]]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 recurring_window: Optional[pulumi.Input[Union['GcpInfraMaintenanceWindowRecurringWindowArgs', 'GcpInfraMaintenanceWindowRecurringWindowArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpInfraMaintenanceWindowArgs.__new__(GcpInfraMaintenanceWindowArgs)

            __props__.__dict__["daily_maintenance_start_time"] = daily_maintenance_start_time
            __props__.__dict__["exclusions"] = exclusions
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["recurring_window"] = recurring_window
        super(GcpInfraMaintenanceWindow, __self__).__init__(
            'duplocloud:index/gcpInfraMaintenanceWindow:GcpInfraMaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            daily_maintenance_start_time: Optional[pulumi.Input[str]] = None,
            exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpInfraMaintenanceWindowExclusionArgs', 'GcpInfraMaintenanceWindowExclusionArgsDict']]]]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            recurring_window: Optional[pulumi.Input[Union['GcpInfraMaintenanceWindowRecurringWindowArgs', 'GcpInfraMaintenanceWindowRecurringWindowArgsDict']]] = None) -> 'GcpInfraMaintenanceWindow':
        """
        Get an existing GcpInfraMaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] daily_maintenance_start_time: Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpInfraMaintenanceWindowExclusionArgs', 'GcpInfraMaintenanceWindowExclusionArgsDict']]]] exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        :param pulumi.Input[str] infra_name: The name of the infrastructure where maintenance windows need to be scheduled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpInfraMaintenanceWindowState.__new__(_GcpInfraMaintenanceWindowState)

        __props__.__dict__["daily_maintenance_start_time"] = daily_maintenance_start_time
        __props__.__dict__["exclusions"] = exclusions
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["recurring_window"] = recurring_window
        return GcpInfraMaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dailyMaintenanceStartTime")
    def daily_maintenance_start_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time window specified for daily maintenance operations. Specify 'start_time 'in RFC3339 format HH:MM, where HH : [00-23] and MM : [00-59] GMT
        """
        return pulumi.get(self, "daily_maintenance_start_time")

    @property
    @pulumi.getter
    def exclusions(self) -> pulumi.Output[Optional[Sequence['outputs.GcpInfraMaintenanceWindowExclusion']]]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to 20 maintenance exclusions at a time
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure where maintenance windows need to be scheduled.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> pulumi.Output[Optional['outputs.GcpInfraMaintenanceWindowRecurringWindow']]:
        return pulumi.get(self, "recurring_window")

