# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpNodePoolArgs', 'GcpNodePool']

@pulumi.input_type
class GcpNodePoolArgs:
    def __init__(__self__, *,
                 image_type: pulumi.Input[str],
                 machine_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 auto_repair: Optional[pulumi.Input[bool]] = None,
                 auto_upgrade: Optional[pulumi.Input[bool]] = None,
                 disc_size_gb: Optional[pulumi.Input[int]] = None,
                 disc_type: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 is_autoscaling_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_node_config: Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']] = None,
                 location_policy: Optional[pulumi.Input[str]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_logging_config: Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 spot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]] = None,
                 total_max_node_count: Optional[pulumi.Input[int]] = None,
                 total_min_node_count: Optional[pulumi.Input[int]] = None,
                 upgrade_settings: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]] = None):
        """
        The set of arguments for constructing a GcpNodePool resource.
        :param pulumi.Input[str] image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the node pool will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        :param pulumi.Input[str] allocation_tags: Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
               services
        :param pulumi.Input[bool] auto_repair: Whether the nodes will be automatically repaired.
        :param pulumi.Input[bool] auto_upgrade: Whether the nodes will be automatically upgraded.
        :param pulumi.Input[int] disc_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
               default disk size is 100GB.
        :param pulumi.Input[str] disc_type: Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input[int] initial_node_count: The initial node count for the pool
        :param pulumi.Input[bool] is_autoscaling_enabled: Is autoscaling enabled for this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node.
        :param pulumi.Input['GcpNodePoolLinuxNodeConfigArgs'] linux_node_config: Parameters that can be configured on Linux nodes
        :param pulumi.Input[str] location_policy: Update strategy of the node pool.
        :param pulumi.Input[int] max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs assigned to instances in the cluster.
        :param pulumi.Input[int] min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[str] name: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs'] node_pool_logging_config: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the default service account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_labels: Resource labels associated to node pool
        :param pulumi.Input[bool] spot: Spot flag for enabling Spot VM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
               and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param pulumi.Input[int] total_max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[int] total_min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        """
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "zones", zones)
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if disc_size_gb is not None:
            pulumi.set(__self__, "disc_size_gb", disc_size_gb)
        if disc_type is not None:
            pulumi.set(__self__, "disc_type", disc_type)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if is_autoscaling_enabled is not None:
            pulumi.set(__self__, "is_autoscaling_enabled", is_autoscaling_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if location_policy is not None:
            pulumi.set(__self__, "location_policy", location_policy)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_logging_config is not None:
            pulumi.set(__self__, "node_pool_logging_config", node_pool_logging_config)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if resource_labels is not None:
            pulumi.set(__self__, "resource_labels", resource_labels)
        if spot is not None:
            pulumi.set(__self__, "spot", spot)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if total_max_node_count is not None:
            pulumi.set(__self__, "total_max_node_count", total_max_node_count)
        if total_min_node_count is not None:
            pulumi.set(__self__, "total_min_node_count", total_min_node_count)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Input[str]:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[str]:
        """
        The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "zones", value)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]]:
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
        services
        """
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @auto_repair.setter
    def auto_repair(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_repair", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="discSizeGb")
    def disc_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
        default disk size is 100GB.
        """
        return pulumi.get(self, "disc_size_gb")

    @disc_size_gb.setter
    def disc_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disc_size_gb", value)

    @property
    @pulumi.getter(name="discType")
    def disc_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disc_type")

    @disc_type.setter
    def disc_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disc_type", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The initial node count for the pool
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="isAutoscalingEnabled")
    def is_autoscaling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "is_autoscaling_enabled")

    @is_autoscaling_enabled.setter
    def is_autoscaling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_autoscaling_enabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']]:
        """
        Parameters that can be configured on Linux nodes
        """
        return pulumi.get(self, "linux_node_config")

    @linux_node_config.setter
    def linux_node_config(self, value: Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']]):
        pulumi.set(self, "linux_node_config", value)

    @property
    @pulumi.getter(name="locationPolicy")
    def location_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Update strategy of the node pool.
        """
        return pulumi.get(self, "location_policy")

    @location_policy.setter
    def location_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_policy", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The metadata key/value pairs assigned to instances in the cluster.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolLoggingConfig")
    def node_pool_logging_config(self) -> Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "node_pool_logging_config")

    @node_pool_logging_config.setter
    def node_pool_logging_config(self, value: Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']]):
        pulumi.set(self, "node_pool_logging_config", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the default service account.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels associated to node pool
        """
        return pulumi.get(self, "resource_labels")

    @resource_labels.setter
    def resource_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_labels", value)

    @property
    @pulumi.getter
    def spot(self) -> Optional[pulumi.Input[bool]]:
        """
        Spot flag for enabling Spot VM
        """
        return pulumi.get(self, "spot")

    @spot.setter
    def spot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spot", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
        and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]]:
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="totalMaxNodeCount")
    def total_max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "total_max_node_count")

    @total_max_node_count.setter
    def total_max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_max_node_count", value)

    @property
    @pulumi.getter(name="totalMinNodeCount")
    def total_min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "total_min_node_count")

    @total_min_node_count.setter
    def total_min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_min_node_count", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]]:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]]):
        pulumi.set(self, "upgrade_settings", value)


@pulumi.input_type
class _GcpNodePoolState:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 auto_repair: Optional[pulumi.Input[bool]] = None,
                 auto_upgrade: Optional[pulumi.Input[bool]] = None,
                 disc_size_gb: Optional[pulumi.Input[int]] = None,
                 disc_type: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 is_autoscaling_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_node_config: Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']] = None,
                 location_policy: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_logging_config: Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 spot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 total_max_node_count: Optional[pulumi.Input[int]] = None,
                 total_min_node_count: Optional[pulumi.Input[int]] = None,
                 upgrade_settings: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GcpNodePool resources.
        :param pulumi.Input[str] allocation_tags: Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
               services
        :param pulumi.Input[bool] auto_repair: Whether the nodes will be automatically repaired.
        :param pulumi.Input[bool] auto_upgrade: Whether the nodes will be automatically upgraded.
        :param pulumi.Input[int] disc_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
               default disk size is 100GB.
        :param pulumi.Input[str] disc_type: Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input[str] fullname: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used
        :param pulumi.Input[int] initial_node_count: The initial node count for the pool
        :param pulumi.Input[bool] is_autoscaling_enabled: Is autoscaling enabled for this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node.
        :param pulumi.Input['GcpNodePoolLinuxNodeConfigArgs'] linux_node_config: Parameters that can be configured on Linux nodes
        :param pulumi.Input[str] location_policy: Update strategy of the node pool.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        :param pulumi.Input[int] max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs assigned to instances in the cluster.
        :param pulumi.Input[int] min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[str] name: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs'] node_pool_logging_config: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the default service account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_labels: Resource labels associated to node pool
        :param pulumi.Input[bool] spot: Spot flag for enabling Spot VM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
               and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the node pool will be created in.
        :param pulumi.Input[int] total_max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[int] total_min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if allocation_tags is not None:
            pulumi.set(__self__, "allocation_tags", allocation_tags)
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if disc_size_gb is not None:
            pulumi.set(__self__, "disc_size_gb", disc_size_gb)
        if disc_type is not None:
            pulumi.set(__self__, "disc_type", disc_type)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if is_autoscaling_enabled is not None:
            pulumi.set(__self__, "is_autoscaling_enabled", is_autoscaling_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if location_policy is not None:
            pulumi.set(__self__, "location_policy", location_policy)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_logging_config is not None:
            pulumi.set(__self__, "node_pool_logging_config", node_pool_logging_config)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if resource_labels is not None:
            pulumi.set(__self__, "resource_labels", resource_labels)
        if spot is not None:
            pulumi.set(__self__, "spot", spot)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if total_max_node_count is not None:
            pulumi.set(__self__, "total_max_node_count", total_max_node_count)
        if total_min_node_count is not None:
            pulumi.set(__self__, "total_min_node_count", total_min_node_count)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]]:
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> Optional[pulumi.Input[str]]:
        """
        Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
        services
        """
        return pulumi.get(self, "allocation_tags")

    @allocation_tags.setter
    def allocation_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_tags", value)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @auto_repair.setter
    def auto_repair(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_repair", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="discSizeGb")
    def disc_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
        default disk size is 100GB.
        """
        return pulumi.get(self, "disc_size_gb")

    @disc_size_gb.setter
    def disc_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disc_size_gb", value)

    @property
    @pulumi.getter(name="discType")
    def disc_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disc_type")

    @disc_type.setter
    def disc_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disc_type", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The initial node count for the pool
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="isAutoscalingEnabled")
    def is_autoscaling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "is_autoscaling_enabled")

    @is_autoscaling_enabled.setter
    def is_autoscaling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_autoscaling_enabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']]:
        """
        Parameters that can be configured on Linux nodes
        """
        return pulumi.get(self, "linux_node_config")

    @linux_node_config.setter
    def linux_node_config(self, value: Optional[pulumi.Input['GcpNodePoolLinuxNodeConfigArgs']]):
        pulumi.set(self, "linux_node_config", value)

    @property
    @pulumi.getter(name="locationPolicy")
    def location_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Update strategy of the node pool.
        """
        return pulumi.get(self, "location_policy")

    @location_policy.setter
    def location_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_policy", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The metadata key/value pairs assigned to instances in the cluster.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolLoggingConfig")
    def node_pool_logging_config(self) -> Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "node_pool_logging_config")

    @node_pool_logging_config.setter
    def node_pool_logging_config(self, value: Optional[pulumi.Input['GcpNodePoolNodePoolLoggingConfigArgs']]):
        pulumi.set(self, "node_pool_logging_config", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the default service account.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels associated to node pool
        """
        return pulumi.get(self, "resource_labels")

    @resource_labels.setter
    def resource_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_labels", value)

    @property
    @pulumi.getter
    def spot(self) -> Optional[pulumi.Input[bool]]:
        """
        Spot flag for enabling Spot VM
        """
        return pulumi.get(self, "spot")

    @spot.setter
    def spot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spot", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
        and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]]:
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="totalMaxNodeCount")
    def total_max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "total_max_node_count")

    @total_max_node_count.setter
    def total_max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_max_node_count", value)

    @property
    @pulumi.getter(name="totalMinNodeCount")
    def total_min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "total_min_node_count")

    @total_min_node_count.setter
    def total_min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_min_node_count", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]]:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpNodePoolUpgradeSettingArgs']]]]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class GcpNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolAcceleratorArgs', 'GcpNodePoolAcceleratorArgsDict']]]]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 auto_repair: Optional[pulumi.Input[bool]] = None,
                 auto_upgrade: Optional[pulumi.Input[bool]] = None,
                 disc_size_gb: Optional[pulumi.Input[int]] = None,
                 disc_type: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 is_autoscaling_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_node_config: Optional[pulumi.Input[Union['GcpNodePoolLinuxNodeConfigArgs', 'GcpNodePoolLinuxNodeConfigArgsDict']]] = None,
                 location_policy: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_logging_config: Optional[pulumi.Input[Union['GcpNodePoolNodePoolLoggingConfigArgs', 'GcpNodePoolNodePoolLoggingConfigArgsDict']]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 spot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolTaintArgs', 'GcpNodePoolTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 total_max_node_count: Optional[pulumi.Input[int]] = None,
                 total_min_node_count: Optional[pulumi.Input[int]] = None,
                 upgrade_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolUpgradeSettingArgs', 'GcpNodePoolUpgradeSettingArgsDict']]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        `duplocloud_gcp_k8_node_pools` manages a GCP Node Pool in Duplo.

        ## Import

        Example: Importing an existing GCP Node Pool

         - *TENANT_ID* is the tenant GUID

         - *FULLNAME* is the  name of the Node Pool

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpNodePool:GcpNodePool node_pool *TENANT_ID*/*FULLNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_tags: Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
               services
        :param pulumi.Input[bool] auto_repair: Whether the nodes will be automatically repaired.
        :param pulumi.Input[bool] auto_upgrade: Whether the nodes will be automatically upgraded.
        :param pulumi.Input[int] disc_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
               default disk size is 100GB.
        :param pulumi.Input[str] disc_type: Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input[str] image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used
        :param pulumi.Input[int] initial_node_count: The initial node count for the pool
        :param pulumi.Input[bool] is_autoscaling_enabled: Is autoscaling enabled for this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node.
        :param pulumi.Input[Union['GcpNodePoolLinuxNodeConfigArgs', 'GcpNodePoolLinuxNodeConfigArgsDict']] linux_node_config: Parameters that can be configured on Linux nodes
        :param pulumi.Input[str] location_policy: Update strategy of the node pool.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        :param pulumi.Input[int] max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs assigned to instances in the cluster.
        :param pulumi.Input[int] min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[str] name: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[Union['GcpNodePoolNodePoolLoggingConfigArgs', 'GcpNodePoolNodePoolLoggingConfigArgsDict']] node_pool_logging_config: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the default service account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_labels: Resource labels associated to node pool
        :param pulumi.Input[bool] spot: Spot flag for enabling Spot VM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
               and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the node pool will be created in.
        :param pulumi.Input[int] total_max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[int] total_min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolUpgradeSettingArgs', 'GcpNodePoolUpgradeSettingArgsDict']]]] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `duplocloud_gcp_k8_node_pools` manages a GCP Node Pool in Duplo.

        ## Import

        Example: Importing an existing GCP Node Pool

         - *TENANT_ID* is the tenant GUID

         - *FULLNAME* is the  name of the Node Pool

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpNodePool:GcpNodePool node_pool *TENANT_ID*/*FULLNAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolAcceleratorArgs', 'GcpNodePoolAcceleratorArgsDict']]]]] = None,
                 allocation_tags: Optional[pulumi.Input[str]] = None,
                 auto_repair: Optional[pulumi.Input[bool]] = None,
                 auto_upgrade: Optional[pulumi.Input[bool]] = None,
                 disc_size_gb: Optional[pulumi.Input[int]] = None,
                 disc_type: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 is_autoscaling_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_node_config: Optional[pulumi.Input[Union['GcpNodePoolLinuxNodeConfigArgs', 'GcpNodePoolLinuxNodeConfigArgsDict']]] = None,
                 location_policy: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_logging_config: Optional[pulumi.Input[Union['GcpNodePoolNodePoolLoggingConfigArgs', 'GcpNodePoolNodePoolLoggingConfigArgsDict']]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 spot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolTaintArgs', 'GcpNodePoolTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 total_max_node_count: Optional[pulumi.Input[int]] = None,
                 total_min_node_count: Optional[pulumi.Input[int]] = None,
                 upgrade_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolUpgradeSettingArgs', 'GcpNodePoolUpgradeSettingArgsDict']]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpNodePoolArgs.__new__(GcpNodePoolArgs)

            __props__.__dict__["accelerators"] = accelerators
            __props__.__dict__["allocation_tags"] = allocation_tags
            __props__.__dict__["auto_repair"] = auto_repair
            __props__.__dict__["auto_upgrade"] = auto_upgrade
            __props__.__dict__["disc_size_gb"] = disc_size_gb
            __props__.__dict__["disc_type"] = disc_type
            if image_type is None and not opts.urn:
                raise TypeError("Missing required property 'image_type'")
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["initial_node_count"] = initial_node_count
            __props__.__dict__["is_autoscaling_enabled"] = is_autoscaling_enabled
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linux_node_config"] = linux_node_config
            __props__.__dict__["location_policy"] = location_policy
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["max_node_count"] = max_node_count
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["min_node_count"] = min_node_count
            __props__.__dict__["name"] = name
            __props__.__dict__["node_pool_logging_config"] = node_pool_logging_config
            __props__.__dict__["oauth_scopes"] = oauth_scopes
            __props__.__dict__["resource_labels"] = resource_labels
            __props__.__dict__["spot"] = spot
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["total_max_node_count"] = total_max_node_count
            __props__.__dict__["total_min_node_count"] = total_min_node_count
            __props__.__dict__["upgrade_settings"] = upgrade_settings
            if zones is None and not opts.urn:
                raise TypeError("Missing required property 'zones'")
            __props__.__dict__["zones"] = zones
            __props__.__dict__["fullname"] = None
        super(GcpNodePool, __self__).__init__(
            'duplocloud:index/gcpNodePool:GcpNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolAcceleratorArgs', 'GcpNodePoolAcceleratorArgsDict']]]]] = None,
            allocation_tags: Optional[pulumi.Input[str]] = None,
            auto_repair: Optional[pulumi.Input[bool]] = None,
            auto_upgrade: Optional[pulumi.Input[bool]] = None,
            disc_size_gb: Optional[pulumi.Input[int]] = None,
            disc_type: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            initial_node_count: Optional[pulumi.Input[int]] = None,
            is_autoscaling_enabled: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            linux_node_config: Optional[pulumi.Input[Union['GcpNodePoolLinuxNodeConfigArgs', 'GcpNodePoolLinuxNodeConfigArgsDict']]] = None,
            location_policy: Optional[pulumi.Input[str]] = None,
            machine_type: Optional[pulumi.Input[str]] = None,
            max_node_count: Optional[pulumi.Input[int]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            min_node_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_pool_logging_config: Optional[pulumi.Input[Union['GcpNodePoolNodePoolLoggingConfigArgs', 'GcpNodePoolNodePoolLoggingConfigArgsDict']]] = None,
            oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            spot: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolTaintArgs', 'GcpNodePoolTaintArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            total_max_node_count: Optional[pulumi.Input[int]] = None,
            total_min_node_count: Optional[pulumi.Input[int]] = None,
            upgrade_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolUpgradeSettingArgs', 'GcpNodePoolUpgradeSettingArgsDict']]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GcpNodePool':
        """
        Get an existing GcpNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_tags: Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
               services
        :param pulumi.Input[bool] auto_repair: Whether the nodes will be automatically repaired.
        :param pulumi.Input[bool] auto_upgrade: Whether the nodes will be automatically upgraded.
        :param pulumi.Input[int] disc_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
               default disk size is 100GB.
        :param pulumi.Input[str] disc_type: Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input[str] fullname: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used
        :param pulumi.Input[int] initial_node_count: The initial node count for the pool
        :param pulumi.Input[bool] is_autoscaling_enabled: Is autoscaling enabled for this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node.
        :param pulumi.Input[Union['GcpNodePoolLinuxNodeConfigArgs', 'GcpNodePoolLinuxNodeConfigArgsDict']] linux_node_config: Parameters that can be configured on Linux nodes
        :param pulumi.Input[str] location_policy: Update strategy of the node pool.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        :param pulumi.Input[int] max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs assigned to instances in the cluster.
        :param pulumi.Input[int] min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[str] name: The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[Union['GcpNodePoolNodePoolLoggingConfigArgs', 'GcpNodePoolNodePoolLoggingConfigArgsDict']] node_pool_logging_config: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the default service account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_labels: Resource labels associated to node pool
        :param pulumi.Input[bool] spot: Spot flag for enabling Spot VM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
               and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the node pool will be created in.
        :param pulumi.Input[int] total_max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        :param pulumi.Input[int] total_min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpNodePoolUpgradeSettingArgs', 'GcpNodePoolUpgradeSettingArgsDict']]]] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpNodePoolState.__new__(_GcpNodePoolState)

        __props__.__dict__["accelerators"] = accelerators
        __props__.__dict__["allocation_tags"] = allocation_tags
        __props__.__dict__["auto_repair"] = auto_repair
        __props__.__dict__["auto_upgrade"] = auto_upgrade
        __props__.__dict__["disc_size_gb"] = disc_size_gb
        __props__.__dict__["disc_type"] = disc_type
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["initial_node_count"] = initial_node_count
        __props__.__dict__["is_autoscaling_enabled"] = is_autoscaling_enabled
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linux_node_config"] = linux_node_config
        __props__.__dict__["location_policy"] = location_policy
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["max_node_count"] = max_node_count
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["min_node_count"] = min_node_count
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool_logging_config"] = node_pool_logging_config
        __props__.__dict__["oauth_scopes"] = oauth_scopes
        __props__.__dict__["resource_labels"] = resource_labels
        __props__.__dict__["spot"] = spot
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["total_max_node_count"] = total_max_node_count
        __props__.__dict__["total_min_node_count"] = total_min_node_count
        __props__.__dict__["upgrade_settings"] = upgrade_settings
        __props__.__dict__["zones"] = zones
        return GcpNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.GcpNodePoolAccelerator']]]:
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="allocationTags")
    def allocation_tags(self) -> pulumi.Output[Optional[str]]:
        """
        Allocation tag to give to the nodes if specified it would be added as a label and that can be used while creating
        services
        """
        return pulumi.get(self, "allocation_tags")

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> pulumi.Output[bool]:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> pulumi.Output[bool]:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="discSizeGb")
    def disc_size_gb(self) -> pulumi.Output[int]:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the
        default disk size is 100GB.
        """
        return pulumi.get(self, "disc_size_gb")

    @property
    @pulumi.getter(name="discType")
    def disc_type(self) -> pulumi.Output[str]:
        """
        Type of the disk attached to each node If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disc_type")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        The initial node count for the pool
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="isAutoscalingEnabled")
    def is_autoscaling_enabled(self) -> pulumi.Output[bool]:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "is_autoscaling_enabled")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> pulumi.Output['outputs.GcpNodePoolLinuxNodeConfig']:
        """
        Parameters that can be configured on Linux nodes
        """
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="locationPolicy")
    def location_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Update strategy of the node pool.
        """
        return pulumi.get(self, "location_policy")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        The name of a Google Compute Engine machine type. If unspecified, the default machine type is e2-medium.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The metadata key/value pairs assigned to instances in the cluster.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the node pool. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolLoggingConfig")
    def node_pool_logging_config(self) -> pulumi.Output['outputs.GcpNodePoolNodePoolLoggingConfig']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "node_pool_logging_config")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the default service account.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Resource labels associated to node pool
        """
        return pulumi.get(self, "resource_labels")

    @property
    @pulumi.getter
    def spot(self) -> pulumi.Output[Optional[bool]]:
        """
        Spot flag for enabling Spot VM
        """
        return pulumi.get(self, "spot")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls
        and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.GcpNodePoolTaint']]]:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the node pool will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="totalMaxNodeCount")
    def total_max_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "total_max_node_count")

    @property
    @pulumi.getter(name="totalMinNodeCount")
    def total_min_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "total_min_node_count")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> pulumi.Output[Sequence['outputs.GcpNodePoolUpgradeSetting']]:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        return pulumi.get(self, "zones")

