# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpSchedulerJobArgs', 'GcpSchedulerJob']

@pulumi.input_type
class GcpSchedulerJobArgs:
    def __init__(__self__, *,
                 schedule: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 timezone: pulumi.Input[str],
                 app_engine_target: Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']] = None,
                 attempt_deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pubsub_target: Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']] = None):
        """
        The set of arguments for constructing a GcpSchedulerJob resource.
        :param pulumi.Input[str] schedule: The desired schedule, in cron format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the scheduler job will be created in.
        :param pulumi.Input[str] timezone: The timezone used to determine the schedule, in UNIX format
        :param pulumi.Input['GcpSchedulerJobAppEngineTargetArgs'] app_engine_target: Specifies an App Engine target for the scheduler job.
        :param pulumi.Input[str] attempt_deadline: The attempt deadline for the scheduler job.
        :param pulumi.Input[str] description: The description of the scheduler job.
        :param pulumi.Input['GcpSchedulerJobHttpTargetArgs'] http_target: Specifies an HTTP target for the scheduler job.
        :param pulumi.Input[str] name: The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input['GcpSchedulerJobPubsubTargetArgs'] pubsub_target: Specifies a pubsub target for the scheduler job.
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "timezone", timezone)
        if app_engine_target is not None:
            pulumi.set(__self__, "app_engine_target", app_engine_target)
        if attempt_deadline is not None:
            pulumi.set(__self__, "attempt_deadline", attempt_deadline)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http_target is not None:
            pulumi.set(__self__, "http_target", http_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pubsub_target is not None:
            pulumi.set(__self__, "pubsub_target", pubsub_target)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        The desired schedule, in cron format.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the scheduler job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[str]:
        """
        The timezone used to determine the schedule, in UNIX format
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[str]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="appEngineTarget")
    def app_engine_target(self) -> Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']]:
        """
        Specifies an App Engine target for the scheduler job.
        """
        return pulumi.get(self, "app_engine_target")

    @app_engine_target.setter
    def app_engine_target(self, value: Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']]):
        pulumi.set(self, "app_engine_target", value)

    @property
    @pulumi.getter(name="attemptDeadline")
    def attempt_deadline(self) -> Optional[pulumi.Input[str]]:
        """
        The attempt deadline for the scheduler job.
        """
        return pulumi.get(self, "attempt_deadline")

    @attempt_deadline.setter
    def attempt_deadline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attempt_deadline", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the scheduler job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']]:
        """
        Specifies an HTTP target for the scheduler job.
        """
        return pulumi.get(self, "http_target")

    @http_target.setter
    def http_target(self, value: Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']]):
        pulumi.set(self, "http_target", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pubsubTarget")
    def pubsub_target(self) -> Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']]:
        """
        Specifies a pubsub target for the scheduler job.
        """
        return pulumi.get(self, "pubsub_target")

    @pubsub_target.setter
    def pubsub_target(self, value: Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']]):
        pulumi.set(self, "pubsub_target", value)


@pulumi.input_type
class _GcpSchedulerJobState:
    def __init__(__self__, *,
                 app_engine_target: Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']] = None,
                 attempt_deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pubsub_target: Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GcpSchedulerJob resources.
        :param pulumi.Input['GcpSchedulerJobAppEngineTargetArgs'] app_engine_target: Specifies an App Engine target for the scheduler job.
        :param pulumi.Input[str] attempt_deadline: The attempt deadline for the scheduler job.
        :param pulumi.Input[str] description: The description of the scheduler job.
        :param pulumi.Input[str] fullname: The full name of the scheduler job.
        :param pulumi.Input['GcpSchedulerJobHttpTargetArgs'] http_target: Specifies an HTTP target for the scheduler job.
        :param pulumi.Input[str] name: The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input['GcpSchedulerJobPubsubTargetArgs'] pubsub_target: Specifies a pubsub target for the scheduler job.
        :param pulumi.Input[str] schedule: The desired schedule, in cron format.
        :param pulumi.Input[str] self_link: The SelfLink of the scheduler job.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the scheduler job will be created in.
        :param pulumi.Input[str] timezone: The timezone used to determine the schedule, in UNIX format
        """
        if app_engine_target is not None:
            pulumi.set(__self__, "app_engine_target", app_engine_target)
        if attempt_deadline is not None:
            pulumi.set(__self__, "attempt_deadline", attempt_deadline)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if http_target is not None:
            pulumi.set(__self__, "http_target", http_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pubsub_target is not None:
            pulumi.set(__self__, "pubsub_target", pubsub_target)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="appEngineTarget")
    def app_engine_target(self) -> Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']]:
        """
        Specifies an App Engine target for the scheduler job.
        """
        return pulumi.get(self, "app_engine_target")

    @app_engine_target.setter
    def app_engine_target(self, value: Optional[pulumi.Input['GcpSchedulerJobAppEngineTargetArgs']]):
        pulumi.set(self, "app_engine_target", value)

    @property
    @pulumi.getter(name="attemptDeadline")
    def attempt_deadline(self) -> Optional[pulumi.Input[str]]:
        """
        The attempt deadline for the scheduler job.
        """
        return pulumi.get(self, "attempt_deadline")

    @attempt_deadline.setter
    def attempt_deadline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attempt_deadline", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the scheduler job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the scheduler job.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']]:
        """
        Specifies an HTTP target for the scheduler job.
        """
        return pulumi.get(self, "http_target")

    @http_target.setter
    def http_target(self, value: Optional[pulumi.Input['GcpSchedulerJobHttpTargetArgs']]):
        pulumi.set(self, "http_target", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pubsubTarget")
    def pubsub_target(self) -> Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']]:
        """
        Specifies a pubsub target for the scheduler job.
        """
        return pulumi.get(self, "pubsub_target")

    @pubsub_target.setter
    def pubsub_target(self, value: Optional[pulumi.Input['GcpSchedulerJobPubsubTargetArgs']]):
        pulumi.set(self, "pubsub_target", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The desired schedule, in cron format.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The SelfLink of the scheduler job.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the scheduler job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The timezone used to determine the schedule, in UNIX format
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


class GcpSchedulerJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_target: Optional[pulumi.Input[Union['GcpSchedulerJobAppEngineTargetArgs', 'GcpSchedulerJobAppEngineTargetArgsDict']]] = None,
                 attempt_deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input[Union['GcpSchedulerJobHttpTargetArgs', 'GcpSchedulerJobHttpTargetArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pubsub_target: Optional[pulumi.Input[Union['GcpSchedulerJobPubsubTargetArgs', 'GcpSchedulerJobPubsubTargetArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `GcpSchedulerJob` manages a GCP scheduler job in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # A simple scheduler job with an HTTPS target, running at 9 am daily.
        myjob = duplocloud.GcpSchedulerJob("myjob",
            tenant_id=myapp.tenant_id,
            name="myjob",
            schedule="* 9 * * *",
            timezone="America/New_York",
            http_target={
                "method": "GET",
                "uri": "https://www.google.com",
            })
        ```

        ## Import

        Example: Importing an existing GCP scheduler job

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the GCP scheduler job

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpSchedulerJob:GcpSchedulerJob myjob *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GcpSchedulerJobAppEngineTargetArgs', 'GcpSchedulerJobAppEngineTargetArgsDict']] app_engine_target: Specifies an App Engine target for the scheduler job.
        :param pulumi.Input[str] attempt_deadline: The attempt deadline for the scheduler job.
        :param pulumi.Input[str] description: The description of the scheduler job.
        :param pulumi.Input[Union['GcpSchedulerJobHttpTargetArgs', 'GcpSchedulerJobHttpTargetArgsDict']] http_target: Specifies an HTTP target for the scheduler job.
        :param pulumi.Input[str] name: The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Union['GcpSchedulerJobPubsubTargetArgs', 'GcpSchedulerJobPubsubTargetArgsDict']] pubsub_target: Specifies a pubsub target for the scheduler job.
        :param pulumi.Input[str] schedule: The desired schedule, in cron format.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the scheduler job will be created in.
        :param pulumi.Input[str] timezone: The timezone used to determine the schedule, in UNIX format
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpSchedulerJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `GcpSchedulerJob` manages a GCP scheduler job in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # A simple scheduler job with an HTTPS target, running at 9 am daily.
        myjob = duplocloud.GcpSchedulerJob("myjob",
            tenant_id=myapp.tenant_id,
            name="myjob",
            schedule="* 9 * * *",
            timezone="America/New_York",
            http_target={
                "method": "GET",
                "uri": "https://www.google.com",
            })
        ```

        ## Import

        Example: Importing an existing GCP scheduler job

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the GCP scheduler job

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpSchedulerJob:GcpSchedulerJob myjob *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpSchedulerJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpSchedulerJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_target: Optional[pulumi.Input[Union['GcpSchedulerJobAppEngineTargetArgs', 'GcpSchedulerJobAppEngineTargetArgsDict']]] = None,
                 attempt_deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input[Union['GcpSchedulerJobHttpTargetArgs', 'GcpSchedulerJobHttpTargetArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pubsub_target: Optional[pulumi.Input[Union['GcpSchedulerJobPubsubTargetArgs', 'GcpSchedulerJobPubsubTargetArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpSchedulerJobArgs.__new__(GcpSchedulerJobArgs)

            __props__.__dict__["app_engine_target"] = app_engine_target
            __props__.__dict__["attempt_deadline"] = attempt_deadline
            __props__.__dict__["description"] = description
            __props__.__dict__["http_target"] = http_target
            __props__.__dict__["name"] = name
            __props__.__dict__["pubsub_target"] = pubsub_target
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if timezone is None and not opts.urn:
                raise TypeError("Missing required property 'timezone'")
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["fullname"] = None
            __props__.__dict__["self_link"] = None
        super(GcpSchedulerJob, __self__).__init__(
            'duplocloud:index/gcpSchedulerJob:GcpSchedulerJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine_target: Optional[pulumi.Input[Union['GcpSchedulerJobAppEngineTargetArgs', 'GcpSchedulerJobAppEngineTargetArgsDict']]] = None,
            attempt_deadline: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            http_target: Optional[pulumi.Input[Union['GcpSchedulerJobHttpTargetArgs', 'GcpSchedulerJobHttpTargetArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pubsub_target: Optional[pulumi.Input[Union['GcpSchedulerJobPubsubTargetArgs', 'GcpSchedulerJobPubsubTargetArgsDict']]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None) -> 'GcpSchedulerJob':
        """
        Get an existing GcpSchedulerJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GcpSchedulerJobAppEngineTargetArgs', 'GcpSchedulerJobAppEngineTargetArgsDict']] app_engine_target: Specifies an App Engine target for the scheduler job.
        :param pulumi.Input[str] attempt_deadline: The attempt deadline for the scheduler job.
        :param pulumi.Input[str] description: The description of the scheduler job.
        :param pulumi.Input[str] fullname: The full name of the scheduler job.
        :param pulumi.Input[Union['GcpSchedulerJobHttpTargetArgs', 'GcpSchedulerJobHttpTargetArgsDict']] http_target: Specifies an HTTP target for the scheduler job.
        :param pulumi.Input[str] name: The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Union['GcpSchedulerJobPubsubTargetArgs', 'GcpSchedulerJobPubsubTargetArgsDict']] pubsub_target: Specifies a pubsub target for the scheduler job.
        :param pulumi.Input[str] schedule: The desired schedule, in cron format.
        :param pulumi.Input[str] self_link: The SelfLink of the scheduler job.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the scheduler job will be created in.
        :param pulumi.Input[str] timezone: The timezone used to determine the schedule, in UNIX format
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpSchedulerJobState.__new__(_GcpSchedulerJobState)

        __props__.__dict__["app_engine_target"] = app_engine_target
        __props__.__dict__["attempt_deadline"] = attempt_deadline
        __props__.__dict__["description"] = description
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["http_target"] = http_target
        __props__.__dict__["name"] = name
        __props__.__dict__["pubsub_target"] = pubsub_target
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timezone"] = timezone
        return GcpSchedulerJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineTarget")
    def app_engine_target(self) -> pulumi.Output[Optional['outputs.GcpSchedulerJobAppEngineTarget']]:
        """
        Specifies an App Engine target for the scheduler job.
        """
        return pulumi.get(self, "app_engine_target")

    @property
    @pulumi.getter(name="attemptDeadline")
    def attempt_deadline(self) -> pulumi.Output[str]:
        """
        The attempt deadline for the scheduler job.
        """
        return pulumi.get(self, "attempt_deadline")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the scheduler job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the scheduler job.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> pulumi.Output[Optional['outputs.GcpSchedulerJobHttpTarget']]:
        """
        Specifies an HTTP target for the scheduler job.
        """
        return pulumi.get(self, "http_target")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the scheduler job.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pubsubTarget")
    def pubsub_target(self) -> pulumi.Output[Optional['outputs.GcpSchedulerJobPubsubTarget']]:
        """
        Specifies a pubsub target for the scheduler job.
        """
        return pulumi.get(self, "pubsub_target")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[str]:
        """
        The desired schedule, in cron format.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The SelfLink of the scheduler job.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the scheduler job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        The timezone used to determine the schedule, in UNIX format
        """
        return pulumi.get(self, "timezone")

