# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpTenantSecurityRuleArgs', 'GcpTenantSecurityRule']

@pulumi.input_type
class GcpTenantSecurityRuleArgs:
    def __init__(__self__, *,
                 ports_and_protocols: pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]],
                 rule_type: pulumi.Input[str],
                 source_ranges: pulumi.Input[Sequence[pulumi.Input[str]]],
                 target_tenant_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GcpTenantSecurityRule resource.
        :param pulumi.Input[str] rule_type: Specify type of access rule (ALLOW , DENY)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        :param pulumi.Input[str] target_tenant_id: The GUID of the tenant to which security rule need to be applied
        :param pulumi.Input[str] tenant_id: The GUID of the tenant.
        :param pulumi.Input[str] description: The description related to the rule
        :param pulumi.Input[str] name: Specify rule name
        """
        pulumi.set(__self__, "ports_and_protocols", ports_and_protocols)
        pulumi.set(__self__, "rule_type", rule_type)
        pulumi.set(__self__, "source_ranges", source_ranges)
        pulumi.set(__self__, "target_tenant_id", target_tenant_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="portsAndProtocols")
    def ports_and_protocols(self) -> pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]]:
        return pulumi.get(self, "ports_and_protocols")

    @ports_and_protocols.setter
    def ports_and_protocols(self, value: pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]]):
        pulumi.set(self, "ports_and_protocols", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        Specify type of access rule (ALLOW , DENY)
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "source_ranges", value)

    @property
    @pulumi.getter(name="targetTenantId")
    def target_tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant to which security rule need to be applied
        """
        return pulumi.get(self, "target_tenant_id")

    @target_tenant_id.setter
    def target_tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_tenant_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description related to the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GcpTenantSecurityRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 ports_and_protocols: Optional[pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GcpTenantSecurityRule resources.
        :param pulumi.Input[str] description: The description related to the rule
        :param pulumi.Input[str] fullname: Duplocloud prefixed rule name
        :param pulumi.Input[str] name: Specify rule name
        :param pulumi.Input[str] rule_type: Specify type of access rule (ALLOW , DENY)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        :param pulumi.Input[str] target_tenant_id: The GUID of the tenant to which security rule need to be applied
        :param pulumi.Input[str] tenant_id: The GUID of the tenant.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if ports_and_protocols is not None:
            pulumi.set(__self__, "ports_and_protocols", ports_and_protocols)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)
        if source_service_accounts is not None:
            pulumi.set(__self__, "source_service_accounts", source_service_accounts)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        if target_tenant_id is not None:
            pulumi.set(__self__, "target_tenant_id", target_tenant_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description related to the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        Duplocloud prefixed rule name
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="portsAndProtocols")
    def ports_and_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]]]:
        return pulumi.get(self, "ports_and_protocols")

    @ports_and_protocols.setter
    def ports_and_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpTenantSecurityRulePortsAndProtocolArgs']]]]):
        pulumi.set(self, "ports_and_protocols", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify type of access rule (ALLOW , DENY)
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ranges", value)

    @property
    @pulumi.getter(name="sourceServiceAccounts")
    def source_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "source_service_accounts")

    @source_service_accounts.setter
    def source_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_service_accounts", value)

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "source_tags")

    @source_tags.setter
    def source_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_tags", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_service_accounts", value)

    @property
    @pulumi.getter(name="targetTenantId")
    def target_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant to which security rule need to be applied
        """
        return pulumi.get(self, "target_tenant_id")

    @target_tenant_id.setter
    def target_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_tenant_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class GcpTenantSecurityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports_and_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpTenantSecurityRulePortsAndProtocolArgs', 'GcpTenantSecurityRulePortsAndProtocolArgsDict']]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `GcpTenantSecurityRule` applies gcp security rule to  target tenantId

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        trule = duplocloud.GcpTenantSecurityRule("trule",
            tenant_id=myapp.tenant_id,
            name="tenant-rule",
            description="security rule for target tenant",
            ports_and_protocols=[
                {
                    "ports": [
                        "24",
                        "23-89",
                    ],
                    "service_protocol": "tcp",
                },
                {
                    "ports": ["100"],
                    "service_protocol": "udp",
                },
            ],
            source_ranges=["0.0.0.0/32"],
            rule_type="ALLOW",
            target_tenant_id="<target-tenant-id>")
        ```

        ## Import

        Example: Importing an existing GCP storage bucket

         - *TENANT_ID* is the tenant GUID

         - *RULE_NAME* is the  name of the security rule

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpTenantSecurityRule:GcpTenantSecurityRule trule *TENANT_ID*/security-rule/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description related to the rule
        :param pulumi.Input[str] name: Specify rule name
        :param pulumi.Input[str] rule_type: Specify type of access rule (ALLOW , DENY)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        :param pulumi.Input[str] target_tenant_id: The GUID of the tenant to which security rule need to be applied
        :param pulumi.Input[str] tenant_id: The GUID of the tenant.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpTenantSecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `GcpTenantSecurityRule` applies gcp security rule to  target tenantId

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        trule = duplocloud.GcpTenantSecurityRule("trule",
            tenant_id=myapp.tenant_id,
            name="tenant-rule",
            description="security rule for target tenant",
            ports_and_protocols=[
                {
                    "ports": [
                        "24",
                        "23-89",
                    ],
                    "service_protocol": "tcp",
                },
                {
                    "ports": ["100"],
                    "service_protocol": "udp",
                },
            ],
            source_ranges=["0.0.0.0/32"],
            rule_type="ALLOW",
            target_tenant_id="<target-tenant-id>")
        ```

        ## Import

        Example: Importing an existing GCP storage bucket

         - *TENANT_ID* is the tenant GUID

         - *RULE_NAME* is the  name of the security rule

        # 

        ```sh
        $ pulumi import duplocloud:index/gcpTenantSecurityRule:GcpTenantSecurityRule trule *TENANT_ID*/security-rule/*RULE_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param GcpTenantSecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpTenantSecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports_and_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpTenantSecurityRulePortsAndProtocolArgs', 'GcpTenantSecurityRulePortsAndProtocolArgsDict']]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpTenantSecurityRuleArgs.__new__(GcpTenantSecurityRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if ports_and_protocols is None and not opts.urn:
                raise TypeError("Missing required property 'ports_and_protocols'")
            __props__.__dict__["ports_and_protocols"] = ports_and_protocols
            if rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'rule_type'")
            __props__.__dict__["rule_type"] = rule_type
            if source_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'source_ranges'")
            __props__.__dict__["source_ranges"] = source_ranges
            if target_tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_tenant_id'")
            __props__.__dict__["target_tenant_id"] = target_tenant_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["direction"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["network"] = None
            __props__.__dict__["priority"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["source_service_accounts"] = None
            __props__.__dict__["source_tags"] = None
            __props__.__dict__["target_service_accounts"] = None
        super(GcpTenantSecurityRule, __self__).__init__(
            'duplocloud:index/gcpTenantSecurityRule:GcpTenantSecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            ports_and_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpTenantSecurityRulePortsAndProtocolArgs', 'GcpTenantSecurityRulePortsAndProtocolArgsDict']]]]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            rule_type: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target_tenant_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'GcpTenantSecurityRule':
        """
        Get an existing GcpTenantSecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description related to the rule
        :param pulumi.Input[str] fullname: Duplocloud prefixed rule name
        :param pulumi.Input[str] name: Specify rule name
        :param pulumi.Input[str] rule_type: Specify type of access rule (ALLOW , DENY)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        :param pulumi.Input[str] target_tenant_id: The GUID of the tenant to which security rule need to be applied
        :param pulumi.Input[str] tenant_id: The GUID of the tenant.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpTenantSecurityRuleState.__new__(_GcpTenantSecurityRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["kind"] = kind
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["ports_and_protocols"] = ports_and_protocols
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rule_type"] = rule_type
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["source_ranges"] = source_ranges
        __props__.__dict__["source_service_accounts"] = source_service_accounts
        __props__.__dict__["source_tags"] = source_tags
        __props__.__dict__["target_service_accounts"] = target_service_accounts
        __props__.__dict__["target_tenant_id"] = target_tenant_id
        __props__.__dict__["tenant_id"] = tenant_id
        return GcpTenantSecurityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description related to the rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        Duplocloud prefixed rule name
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specify rule name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="portsAndProtocols")
    def ports_and_protocols(self) -> pulumi.Output[Sequence['outputs.GcpTenantSecurityRulePortsAndProtocol']]:
        return pulumi.get(self, "ports_and_protocols")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[str]:
        """
        Specify type of access rule (ALLOW , DENY)
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> pulumi.Output[Sequence[str]]:
        """
        The lists of IPv4 or IPv6 addresses in CIDR format that specify the source of traffic for a firewall rule
        """
        return pulumi.get(self, "source_ranges")

    @property
    @pulumi.getter(name="sourceServiceAccounts")
    def source_service_accounts(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "source_service_accounts")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "source_tags")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "target_service_accounts")

    @property
    @pulumi.getter(name="targetTenantId")
    def target_tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant to which security rule need to be applied
        """
        return pulumi.get(self, "target_tenant_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant.
        """
        return pulumi.get(self, "tenant_id")

