# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAsgProfilesResult',
    'AwaitableGetAsgProfilesResult',
    'get_asg_profiles',
    'get_asg_profiles_output',
]

@pulumi.output_type
class GetAsgProfilesResult:
    """
    A collection of values returned by getAsgProfiles.
    """
    def __init__(__self__, asg_profiles=None, id=None, tenant_id=None):
        if asg_profiles and not isinstance(asg_profiles, list):
            raise TypeError("Expected argument 'asg_profiles' to be a list")
        pulumi.set(__self__, "asg_profiles", asg_profiles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="asgProfiles")
    def asg_profiles(self) -> Sequence['outputs.GetAsgProfilesAsgProfileResult']:
        """
        The list of ASG profiles.
        """
        return pulumi.get(self, "asg_profiles")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant in which to list the ASG profiles.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetAsgProfilesResult(GetAsgProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAsgProfilesResult(
            asg_profiles=self.asg_profiles,
            id=self.id,
            tenant_id=self.tenant_id)


def get_asg_profiles(tenant_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAsgProfilesResult:
    """
    `get_asg_profiles` lists autoscaling group profiles in a Duplo tenant.


    :param str tenant_id: The GUID of the tenant in which to list the ASG profiles.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getAsgProfiles:getAsgProfiles', __args__, opts=opts, typ=GetAsgProfilesResult).value

    return AwaitableGetAsgProfilesResult(
        asg_profiles=pulumi.get(__ret__, 'asg_profiles'),
        id=pulumi.get(__ret__, 'id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_asg_profiles_output(tenant_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAsgProfilesResult]:
    """
    `get_asg_profiles` lists autoscaling group profiles in a Duplo tenant.


    :param str tenant_id: The GUID of the tenant in which to list the ASG profiles.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getAsgProfiles:getAsgProfiles', __args__, opts=opts, typ=GetAsgProfilesResult)
    return __ret__.apply(lambda __response__: GetAsgProfilesResult(
        asg_profiles=pulumi.get(__response__, 'asg_profiles'),
        id=pulumi.get(__response__, 'id'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
