# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAzureAvailabilitySetResult',
    'AwaitableGetAzureAvailabilitySetResult',
    'get_azure_availability_set',
    'get_azure_availability_set_output',
]

@pulumi.output_type
class GetAzureAvailabilitySetResult:
    """
    A collection of values returned by getAzureAvailabilitySet.
    """
    def __init__(__self__, availability_set_id=None, id=None, location=None, name=None, platform_fault_domain_count=None, platform_update_domain_count=None, sku_name=None, tags=None, tenant_id=None, type=None, virtual_machines=None):
        if availability_set_id and not isinstance(availability_set_id, str):
            raise TypeError("Expected argument 'availability_set_id' to be a str")
        pulumi.set(__self__, "availability_set_id", availability_set_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if platform_fault_domain_count and not isinstance(platform_fault_domain_count, int):
            raise TypeError("Expected argument 'platform_fault_domain_count' to be a int")
        pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if platform_update_domain_count and not isinstance(platform_update_domain_count, int):
            raise TypeError("Expected argument 'platform_update_domain_count' to be a int")
        pulumi.set(__self__, "platform_update_domain_count", platform_update_domain_count)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, str):
            raise TypeError("Expected argument 'tags' to be a str")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if virtual_machines and not isinstance(virtual_machines, list):
            raise TypeError("Expected argument 'virtual_machines' to be a list")
        pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> str:
        return pulumi.get(self, "availability_set_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> int:
        return pulumi.get(self, "platform_fault_domain_count")

    @property
    @pulumi.getter(name="platformUpdateDomainCount")
    def platform_update_domain_count(self) -> int:
        return pulumi.get(self, "platform_update_domain_count")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> str:
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter
    def tags(self) -> str:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Sequence['outputs.GetAzureAvailabilitySetVirtualMachineResult']:
        return pulumi.get(self, "virtual_machines")


class AwaitableGetAzureAvailabilitySetResult(GetAzureAvailabilitySetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzureAvailabilitySetResult(
            availability_set_id=self.availability_set_id,
            id=self.id,
            location=self.location,
            name=self.name,
            platform_fault_domain_count=self.platform_fault_domain_count,
            platform_update_domain_count=self.platform_update_domain_count,
            sku_name=self.sku_name,
            tags=self.tags,
            tenant_id=self.tenant_id,
            type=self.type,
            virtual_machines=self.virtual_machines)


def get_azure_availability_set(name: Optional[str] = None,
                               tenant_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzureAvailabilitySetResult:
    """
    `AzureAvailabilitySet` manages a azure availability set in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    st = duplocloud.get_azure_availability_set(tenant_id="tenant id",
        name="availability-set name")
    pulumi.export("out", {
        "availabilitySetId": st.availability_set_id,
    })
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getAzureAvailabilitySet:getAzureAvailabilitySet', __args__, opts=opts, typ=GetAzureAvailabilitySetResult).value

    return AwaitableGetAzureAvailabilitySetResult(
        availability_set_id=pulumi.get(__ret__, 'availability_set_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        platform_fault_domain_count=pulumi.get(__ret__, 'platform_fault_domain_count'),
        platform_update_domain_count=pulumi.get(__ret__, 'platform_update_domain_count'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        type=pulumi.get(__ret__, 'type'),
        virtual_machines=pulumi.get(__ret__, 'virtual_machines'))
def get_azure_availability_set_output(name: Optional[pulumi.Input[str]] = None,
                                      tenant_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAzureAvailabilitySetResult]:
    """
    `AzureAvailabilitySet` manages a azure availability set in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    st = duplocloud.get_azure_availability_set(tenant_id="tenant id",
        name="availability-set name")
    pulumi.export("out", {
        "availabilitySetId": st.availability_set_id,
    })
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getAzureAvailabilitySet:getAzureAvailabilitySet', __args__, opts=opts, typ=GetAzureAvailabilitySetResult)
    return __ret__.apply(lambda __response__: GetAzureAvailabilitySetResult(
        availability_set_id=pulumi.get(__response__, 'availability_set_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        platform_fault_domain_count=pulumi.get(__response__, 'platform_fault_domain_count'),
        platform_update_domain_count=pulumi.get(__response__, 'platform_update_domain_count'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        type=pulumi.get(__response__, 'type'),
        virtual_machines=pulumi.get(__response__, 'virtual_machines')))
